/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtApprovalCancelAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtApprovalCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalCancelRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.PebExtApprovalCancelBusiService;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtApprovalCancelAbilityService"})
public class PebExtApprovalCancelAbilityServiceImpl
implements PebExtApprovalCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalCancelAbilityServiceImpl.class);
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtApprovalCancelBusiService pebExtApprovalCancelBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC:DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC}")
    private String pushFzOrderEvaluateTopic;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TAG:DEAL_PUSH_FZ_ORDER_EVALUATE_TAG}")
    private String pushFzOrderEvaluateTag;
    @Resource(name="dealPushFzOrderEvaluateProvider")
    private ProxyMessageProducer dealPushFzOrderEvaluateProvider;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_UPDATE_ORDER_TOPIC:UOC_UPDATE_ORDER_TOPIC}")
    private String updateTopic;
    @Value(value="${UOC_UPDATE_ORDER_TAG:*}")
    private String updateTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;

    @PostMapping(value={"dealApprovalCancelled"})
    public PebExtApprovalCancelRspBO dealApprovalCancelled(@RequestBody PebExtApprovalCancelReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        this.val(reqBO);
        for (UocPebDealOrderBO orderBO : reqBO.getOrderInfo()) {
            PebExtApprovalCancelReqBO cancelReqBO = new PebExtApprovalCancelReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)cancelReqBO);
            cancelReqBO.setOrderId(orderBO.getOrderId());
            cancelReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            cancelReqBO.setStepId(orderBO.getStepId());
            cancelReqBO.setCancelId(orderBO.getCancelId());
            PebExtApprovalCancelRspBO rspBO = this.pebExtApprovalCancelBusiService.dealApprovalCancelled(cancelReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
                }
            } else {
                return rspBO;
            }
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setObjId(orderBO.getSaleVoucherId());
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            syncReqBO.setOrderId(orderBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)syncReqBO)));
            PebExtSyncUnifyChangeAbilityReqBO changeReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
            changeReqBO.setOrderId(orderBO.getOrderId());
            changeReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
            this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeReqBO);
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            sendNotificationExtAtomReqBO.setOrderId(orderBO.getOrderId());
            sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_CANCEL);
            this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
            PebExtPushFzOrderEvaluateAbilityReqBO evaluateAbilityReqBO = new PebExtPushFzOrderEvaluateAbilityReqBO();
            evaluateAbilityReqBO.setOrderId(orderBO.getOrderId());
            this.dealPushFzOrderEvaluateProvider.send(new ProxyMessage(this.pushFzOrderEvaluateTopic, this.pushFzOrderEvaluateTag, JSONObject.toJSONString((Object)evaluateAbilityReqBO)));
            try {
                if (!this.uocESGConfig.getAbutmentESGYn().booleanValue() || !Objects.nonNull(orderBO.getOrderId())) continue;
                UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                uocOrdZmInfoPO.setOrderId(orderBO.getOrderId());
                if (!Objects.nonNull(uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO)) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) continue;
                UocESGOrderSyncUpdateConsumerVO updateConsumerVO = new UocESGOrderSyncUpdateConsumerVO();
                updateConsumerVO.setOrderId(orderBO.getOrderId());
                updateConsumerVO.setOrderStatus(Integer.valueOf(4));
                this.uocESGSyncMsgProvider.send(new ProxyMessage(this.updateTopic, this.updateTag, JSONObject.toJSONString((Object)updateConsumerVO)));
            }
            catch (Exception exception) {
                log.error("\u4e61\u6751\u632f\u5174\u8ba2\u5355\u53d6\u6d88\u540e\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
            }
        }
        PebExtApprovalCancelRspBO rspBO = new PebExtApprovalCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(PebExtApprovalCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderInfo() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

