/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractSettlementDetailBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.api.PebExtPushContractLedgerChangeAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtContractFileChangeBO;
import com.tydic.uoc.common.ability.bo.PebExtContractInfoBO;
import com.tydic.uoc.common.ability.bo.PebExtContractMainChangeBO;
import com.tydic.uoc.common.ability.bo.PebExtContractOrderChangeBO;
import com.tydic.uoc.common.ability.bo.PebExtContractPayScheduleChangeBO;
import com.tydic.uoc.common.ability.bo.PebExtPushContractLedgerChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushContractLedgerChangeAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.atom.api.PebExtUnifyFileUploadAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileUploadAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileUploadAtomRspBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerChangeBusiService;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerFailBusiService;
import com.tydic.uoc.common.busi.bo.PebExtContractLedgerChangeBusiRspBO;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerChangeBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerFailBusiReqBO;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdItemFlMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAbnormalPO;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PayConfDetailPO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdItemFlPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushContractLedgerChangeAbilityService"})
public class PebExtPushContractLedgerChangeAbilityServiceImpl
implements PebExtPushContractLedgerChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushContractLedgerChangeAbilityServiceImpl.class);
    @Autowired
    private PebExtPushContractLedgerChangeBusiService pebExtPushContractLedgerChangeBusiService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAtomService pebExtUnifyFileUploadAtomService;
    @Autowired
    private PebExtPushContractLedgerFailBusiService pebExtPushContractLedgerFailBusiService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocOrdItemFlMapper uocOrdItemFlMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    private static final Integer SHOULD_PAY_METHOD = 2;
    private static final Integer PRE_PAY_METHOD = 0;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Value(value="${HOME_CODE:156604}")
    private Long homeCode;
    @Value(value="${HOME_NAME:\u672c\u90e8}")
    private String homeName;
    @Value(value="${MARKET_CODE:436}")
    private Long marketCode;
    @Value(value="${MARKET_NAME:\u5e02\u573a\u90e8}")
    private String marketName;

    @PostMapping(value={"dealPushContractLedgerChange"})
    public PebExtPushContractLedgerChangeAbilityRspBO dealPushContractLedgerChange(@RequestBody PebExtPushContractLedgerChangeAbilityReqBO reqBO) {
        this.valid(reqBO);
        PebExtPushContractLedgerChangeAbilityRspBO rspBO = new PebExtPushContractLedgerChangeAbilityRspBO();
        if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE) || reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_ADD)) {
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
            if (cruxMapPO != null && !org.springframework.util.StringUtils.isEmpty((Object)cruxMapPO.getFieldValue19())) {
                if (!reqBO.getOrderId().toString().equals(cruxMapPO.getFieldValue19())) {
                    reqBO.setUpperOrderId(Long.valueOf(cruxMapPO.getFieldValue19()));
                }
                reqBO.setOrderId(Long.valueOf(cruxMapPO.getFieldValue19()));
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (salePO == null) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            try {
                PebExtPushContractLedgerChangeBusiReqBO busiReqBO = this.buildPushOrderData(reqBO, salePO);
                PebExtContractLedgerChangeBusiRspBO busiRspBO = this.pebExtPushContractLedgerChangeBusiService.dealPushContractLedgerChange(busiReqBO);
                return (PebExtPushContractLedgerChangeAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushContractLedgerChangeAbilityRspBO.class);
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355\u53d8\u66f4\u6570\u636e\u5f02\u5e38\uff1a" + e);
                e.printStackTrace();
                PebExtPushContractLedgerFailBusiReqBO failBusiReqBO = new PebExtPushContractLedgerFailBusiReqBO();
                failBusiReqBO.setOrderId(reqBO.getOrderId());
                failBusiReqBO.setPushType(reqBO.getPushType());
                failBusiReqBO.setFailMsg(e.getMessage());
                failBusiReqBO.setOrderNo(salePO.getSaleVoucherNo());
                this.pebExtPushContractLedgerFailBusiService.savePushOrderFailLog(failBusiReqBO);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
        }
        UocOrdContractPO contractPO = new UocOrdContractPO();
        contractPO.setContractId(reqBO.getContractId());
        contractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        contractPO = this.uocOrdContractMapper.selectOne(contractPO);
        if (contractPO == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u5408\u540c\u672a\u63a8\u9001\u81f3\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0,\u65e0\u9700\u63a8\u9001\uff01");
            return rspBO;
        }
        try {
            PebExtPushContractLedgerChangeBusiReqBO busiReqBO = this.buildPushContractDate(reqBO);
            if (busiReqBO == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5f53\u524d\u5408\u540c\u672a\u5339\u914d\u5230\u9700\u63a8\u9001\u53d8\u66f4\u4fe1\u606f,\u65e0\u9700\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\uff01");
                return rspBO;
            }
            PebExtContractLedgerChangeBusiRspBO busiRspBO = this.pebExtPushContractLedgerChangeBusiService.dealPushContractLedgerChange(busiReqBO);
            return (PebExtPushContractLedgerChangeAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushContractLedgerChangeAbilityRspBO.class);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u5408\u540c\u53d8\u66f4\u6570\u636e\u5f02\u5e38\uff1a" + e);
            e.printStackTrace();
            PebExtPushContractLedgerFailBusiReqBO failBusiReqBO = new PebExtPushContractLedgerFailBusiReqBO();
            failBusiReqBO.setOrderId(reqBO.getContractId());
            failBusiReqBO.setPushType(reqBO.getPushType());
            failBusiReqBO.setFailMsg(e.getMessage());
            failBusiReqBO.setOrderNo(reqBO.getChangeNo());
            this.pebExtPushContractLedgerFailBusiService.savePushOrderFailLog(failBusiReqBO);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private PebExtPushContractLedgerChangeBusiReqBO buildPushOrderData(PebExtPushContractLedgerChangeAbilityReqBO reqBO, OrdSalePO salePO) {
        PebExtContractInfoBO contractAmtInfo;
        List ordItemPOS;
        List orderItemList;
        PebExtPushContractLedgerChangeBusiReqBO busiReqBO = new PebExtPushContractLedgerChangeBusiReqBO();
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<Object> payList = new ArrayList();
        PebExtContractOrderChangeBO orderChangeBO = new PebExtContractOrderChangeBO();
        PebExtContractMainChangeBO contractChangeBO = new PebExtContractMainChangeBO();
        UocOrdContractPO contractPO = new UocOrdContractPO();
        if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE)) {
            contractPO.setOrderId(reqBO.getOrderId());
            contractPO = this.uocOrdContractMapper.getModelBy(contractPO);
            if (contractPO == null) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (!contractPO.getPushStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
                throw new FscBusinessException("198888", "\u6539\u8ba2\u5355\u672a\u63a8\u9001\u81f3\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff01");
            }
            if (salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.CANCEL) || salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE)) {
                orderChangeBO.setHANDLE_TYPE("DEL");
            } else {
                orderChangeBO.setHANDLE_TYPE("UPD");
                if (reqBO.getApplyId() != null) {
                    OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
                    ordAfterServicePO.setOrderId(reqBO.getOrderId());
                    ordAfterServicePO.setAfterServId(reqBO.getApplyId());
                    ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
                    if (ordAfterServicePO != null) {
                        contractChangeBO.setEG_CHANGE_NUM(ordAfterServicePO.getAfterServCode());
                    } else {
                        OrdAbnormalPO ordAbnormalPO = new OrdAbnormalPO();
                        ordAbnormalPO.setAbnormalVoucherId(reqBO.getApplyId());
                        ordAbnormalPO.setOrderId(reqBO.getOrderId());
                        ordAbnormalPO = this.ordAbnormalMapper.getModelBy(ordAbnormalPO);
                        if (ordAbnormalPO != null) {
                            contractChangeBO.setEG_CHANGE_NUM(ordAbnormalPO.getAbnormalVoucherNo());
                        }
                    }
                }
            }
            busiReqBO.setApplyId(reqBO.getApplyId());
        } else {
            contractPO.setVrContractNo(reqBO.getVrContractNo());
            contractPO.setContractId(reqBO.getContractId());
            contractPO.setContractNo(reqBO.getContractNo());
            orderChangeBO.setHANDLE_TYPE("ADD");
            busiReqBO.setVrContractNo(reqBO.getVrContractNo());
            busiReqBO.setContractId(reqBO.getContractId());
            busiReqBO.setContractNo(reqBO.getContractNo());
            busiReqBO.setContractName(reqBO.getContractName());
            busiReqBO.setUnifyContractType(reqBO.getUnifyContractType());
            busiReqBO.setOrderSource(salePO.getOrderSource());
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setOrderId(reqBO.getOrderId());
        cruxMapPO.setObjId(reqBO.getOrderId());
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
        if (cruxMapPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        if (orderPO.getOrderType().equals(PebExtConstant.OrderType.FL)) {
            orderItemList = this.ordItemMapper.getSumFlAmt(itemPO);
            if (reqBO.getUpperOrderId() != null) {
                orderItemList = this.ordItemMapper.getSumFlChildOrderAmt(itemPO);
            }
        } else {
            orderItemList = this.ordItemMapper.getSumOrderAmt(itemPO);
            if (reqBO.getUpperOrderId() != null) {
                orderItemList = this.ordItemMapper.getSumChildOrderAmt(itemPO);
            }
        }
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        PebExtContractInfoBO orderAmtInfo = this.calculationAmt(orderItemList, null);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (zmInfoPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (zmInfoPO.getIsPushErp() == null) {
            zmInfoPO.setIsPushErp(Integer.valueOf(0));
        }
        if (orderPO.getOrderType().equals(PebExtConstant.OrderType.FL)) {
            UocOrdItemFlPO flPO = new UocOrdItemFlPO();
            flPO.setOrderId(reqBO.getOrderId());
            List ordItemFlPOS = this.uocOrdItemFlMapper.selectByCondition(flPO);
            if (CollectionUtils.isEmpty((Collection)ordItemFlPOS)) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u798f\u5229\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            UmcEnterpriseOrgQryDetailAbilityReqBO detailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            detailAbilityReqBO.setOrgIdWeb(Long.valueOf(((UocOrdItemFlPO)ordItemFlPOS.get(0)).getExt5()));
            UmcEnterpriseOrgQryDetailAbilityRspBO detailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(detailAbilityReqBO);
            if (!detailAbilityRspBO.getRespCode().equals("0000") || detailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5931\u8d25\u6216\u673a\u6784\u4e0d\u5b58\u5728\uff01" + detailAbilityRspBO.getRespDesc());
            }
            if (StringUtils.isEmpty((CharSequence)detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
                throw new UocProBusinessException("8888", "\u91c7\u8d2d\u5355\u4f4derp\u673a\u6784\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode())) {
                throw new UocProBusinessException("8888", "\u91c7\u8d2d\u5355\u4f4d\u673a\u6784\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            zmInfoPO.setBuynerErpNo(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
            zmInfoPO.setBuynerName(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgName());
            zmInfoPO.setBuynerNo(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode());
        }
        PebExtUnifySettlePersonQryAbilityRspBO personQryAbilityRspBO = this.qryPersonInfo(zmInfoPO.getErpUserName());
        orderChangeBO.setORG_ID(Long.valueOf(zmInfoPO.getBuynerErpNo()));
        orderChangeBO.setORG_NAME(zmInfoPO.getBuynerName());
        if (reqBO.getVrContractNo() == null && reqBO.getContractNo() != null && "2".equals(reqBO.getPushTypeWealth())) {
            ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
            contractDetailQueryAbilityReqBO.setContractId(reqBO.getContractId());
            ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
            log.info("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)contractDetailQueryAbilityRspBO));
            if (contractDetailQueryAbilityRspBO.getContractId() != null) {
                if (this.operationOrgCode.equals(contractDetailQueryAbilityRspBO.getBuyerNo())) {
                    orderChangeBO.setORG_ID(this.homeCode);
                    orderChangeBO.setORG_NAME(this.homeName);
                } else if (this.operationOrgCode.equals(contractDetailQueryAbilityRspBO.getSupplierCode())) {
                    orderChangeBO.setORG_ID(this.marketCode);
                    orderChangeBO.setORG_NAME(this.marketName);
                }
            }
        }
        orderChangeBO.setUSER_ID(((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getUSER_ID());
        orderChangeBO.setCREATED_BY(((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getPERSON_ID());
        orderChangeBO.setPO_AMOUNT(orderAmtInfo.getAmt());
        orderChangeBO.setAMOUNT_NOTTAX(orderAmtInfo.getUntaxAmt());
        orderChangeBO.setTAX_AMOUNT(orderAmtInfo.getTaxAmt());
        orderChangeBO.setIS_ERP(this.getDicCodeValue("PEB_UNIFY_PUSH_ERP_STATUS", zmInfoPO.getIsPushErp().toString()));
        if (!org.springframework.util.StringUtils.isEmpty((Object)cruxMapPO.getFieldValue22())) {
            orderChangeBO.setPO_HEADER_ID(Long.valueOf(cruxMapPO.getFieldValue22()));
        }
        orderChangeBO.setPO_NUMBER(salePO.getSaleVoucherNo());
        if (orderAmtInfo.getTaxRate() != null) {
            orderChangeBO.setTAX_RATE(orderAmtInfo.getTaxRate());
            try {
                Long taxId = Long.valueOf(this.getDicCodeValue("PEB_UNIFY_TAX_RATE", orderAmtInfo.getTaxRate().toString()));
                orderChangeBO.setTAX_RATE_ID(taxId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("8888", "\u83b7\u53d6\u7a0e\u7387id\u8f6c\u5316\u5f02\u5e38\uff0c\u7a0e\u7387\uff1a" + orderAmtInfo.getTaxRate() + " " + e);
            }
        }
        if (orderChangeBO.getHANDLE_TYPE().equals("ADD")) {
            payList = this.buildPayInfo(reqBO.getOrderId(), orderChangeBO, reqBO.getPushTypeWealth(), salePO);
        }
        BigDecimal contractAmt = BigDecimal.ZERO;
        BigDecimal contractUnTaxAmt = BigDecimal.ZERO;
        BigDecimal contractTaxRate = null;
        if (contractPO.getContractId() != null) {
            ordItemPOS = this.ordItemMapper.getSumOrderAmtByAgreementId(contractPO.getContractId().toString(), reqBO.getBuynerNo());
            contractAmtInfo = this.calculationAmt(ordItemPOS, orderChangeBO);
            contractAmt = contractAmtInfo.getAmt();
            contractUnTaxAmt = contractAmtInfo.getUntaxAmt();
            contractTaxRate = contractAmtInfo.getTaxRate();
        } else if (orderPO.getOrderType().equals(PebExtConstant.OrderType.TH)) {
            ordItemPOS = this.ordItemMapper.getSumOrderAmtByContractNo(contractPO.getVrContractNo());
            contractAmtInfo = this.calculationAmt(ordItemPOS, orderChangeBO);
            contractAmt = contractAmtInfo.getAmt();
            contractUnTaxAmt = contractAmtInfo.getUntaxAmt();
            contractTaxRate = contractAmtInfo.getTaxRate();
        } else if (orderPO.getOrderType().equals(PebExtConstant.OrderType.FL)) {
            ordItemPOS = this.ordItemMapper.getSumFlOrderAmtByContractNo(contractPO.getVrContractNo());
            contractAmtInfo = this.calculationAmt(ordItemPOS, orderChangeBO);
            contractAmt = contractAmtInfo.getAmt();
            contractUnTaxAmt = contractAmtInfo.getUntaxAmt();
            contractTaxRate = contractAmtInfo.getTaxRate();
        } else if (!orderChangeBO.getHANDLE_TYPE().equals("DEL")) {
            contractAmt = orderAmtInfo.getAmt();
            contractUnTaxAmt = orderAmtInfo.getUntaxAmt();
            contractTaxRate = orderChangeBO.getTAX_RATE();
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)contractPO.getContractNo())) {
            contractChangeBO.setCONTRACT_NUM(contractPO.getContractNo());
        } else {
            contractChangeBO.setCONTRACT_NUM(contractPO.getVrContractNo());
        }
        contractChangeBO.setN_AMOUNT_NOTAX(contractUnTaxAmt);
        contractChangeBO.setN_CONTRACT_AMOUNT(contractAmt);
        contractChangeBO.setN_TAX_AMOUNT(contractAmt.subtract(contractUnTaxAmt));
        contractChangeBO.setORG_ID(orderChangeBO.getORG_ID());
        contractChangeBO.setORG_NAME(orderChangeBO.getORG_NAME());
        contractChangeBO.setCOM_CODE(((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getCOM_CODE());
        contractChangeBO.setCHG_TYPE("ORDER");
        if (contractTaxRate != null) {
            contractChangeBO.setN_TAX_RATE(contractTaxRate);
            try {
                Long taxId = Long.valueOf(this.getDicCodeValue("PEB_UNIFY_TAX_RATE", contractTaxRate.toString()));
                contractChangeBO.setN_TAX_RATE_ID(taxId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("8888", "\u83b7\u53d6\u7a0e\u7387id\u8f6c\u5316\u5f02\u5e38\uff0c\u7a0e\u7387\uff1a" + contractTaxRate);
            }
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)contractChangeBO);
        jsonObject.put("poLine", Collections.singletonList(orderChangeBO));
        jsonObject.put("payline", payList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(encryptionAbilityRspBO.getRespCode(), "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        busiReqBO.setPushType(reqBO.getPushType());
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setToken(personQryAbilityRspBO.getToken());
        busiReqBO.setOrderNo(salePO.getSaleVoucherNo());
        busiReqBO.setReqData(jsonArray.toJSONString());
        busiReqBO.setApplyNo(contractChangeBO.getEG_CHANGE_NUM());
        busiReqBO.setBuynerNo(reqBO.getBuynerNo());
        busiReqBO.setParseData(encryptionAbilityRspBO.getData());
        if (orderPO.getUpperOrderId() != null) {
            busiReqBO.setUpperOrderId(orderPO.getUpperOrderId().toString());
        }
        return busiReqBO;
    }

    private PebExtContractInfoBO calculationAmt(List<OrdItemPO> ordItemPOS, PebExtContractOrderChangeBO orderChangeBO) {
        PebExtContractInfoBO contractInfoBO = new PebExtContractInfoBO();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalUnTaxAmt = BigDecimal.ZERO;
        if (ordItemPOS.size() == 1) {
            BigDecimal taxRate = new BigDecimal(ordItemPOS.get(0).getTax().toString());
            contractInfoBO.setTaxRate(taxRate);
        }
        for (OrdItemPO ordItemPO : ordItemPOS) {
            BigDecimal taxRate = new BigDecimal(ordItemPO.getTax().toString());
            totalAmt = totalAmt.add(ordItemPO.getTotalSaleAmount());
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                totalUnTaxAmt = totalUnTaxAmt.add(ordItemPO.getTotalSaleAmount());
                continue;
            }
            totalUnTaxAmt = totalUnTaxAmt.add(this.calUntaxAmt(ordItemPO.getTotalSaleAmount(), taxRate.divide(new BigDecimal(100)), 2));
        }
        if (orderChangeBO != null && orderChangeBO.getHANDLE_TYPE().equals("ADD")) {
            totalAmt = totalAmt.add(orderChangeBO.getPO_AMOUNT());
            totalUnTaxAmt = totalUnTaxAmt.add(orderChangeBO.getAMOUNT_NOTTAX());
            if (contractInfoBO.getTaxRate() != null && !contractInfoBO.getTaxRate().equals(orderChangeBO.getTAX_RATE())) {
                contractInfoBO.setTaxRate(null);
            }
        }
        contractInfoBO.setAmt(totalAmt);
        contractInfoBO.setUntaxAmt(totalUnTaxAmt);
        contractInfoBO.setTaxAmt(totalAmt.subtract(totalUnTaxAmt));
        return contractInfoBO;
    }

    private void valid(PebExtPushContractLedgerChangeAbilityReqBO reqBO) {
        if (reqBO.getPushType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u63a8\u9001\u7c7b\u578b[pushType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE) || reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_ADD)) {
            if (reqBO.getOrderId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            if (reqBO.getContractId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u5408\u540cid[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getApplyId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u53d8\u66f4id[applyId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private BigDecimal calUntaxAmt(BigDecimal amt, BigDecimal taxRate, Integer SCALE) {
        return amt.divide(BigDecimal.ONE.add(taxRate), (int)SCALE, 4);
    }

    private String getDicCodeValue(String pCode, String code) {
        SelectSingleDictReqBO selectSingleDictReqBO = new SelectSingleDictReqBO();
        selectSingleDictReqBO.setPcode(pCode);
        selectSingleDictReqBO.setCode(code);
        SelectSingleDictRspBO selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (ObjectUtils.isEmpty((Object)selectSingleDictRspBO.getDicDictionarys())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u4e3a\u7a7a\uff01");
        }
        return selectSingleDictRspBO.getDicDictionarys().getDescrip();
    }

    private PebExtPushContractLedgerChangeBusiReqBO buildPushContractDate(PebExtPushContractLedgerChangeAbilityReqBO reqBO) {
        ContractDetailQueryAbilityReqBO historyQueryReqBO = new ContractDetailQueryAbilityReqBO();
        historyQueryReqBO.setContractId(reqBO.getContractId());
        historyQueryReqBO.setUpdateApplyId(reqBO.getApplyId());
        ContractDetailQueryAbilityRspBO contractHistoryRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(historyQueryReqBO);
        if (contractHistoryRspBO.getContractId() == null) {
            throw new UocProBusinessException(contractHistoryRspBO.getCode(), "\u67e5\u8be2\u5408\u540c\u5386\u53f2\u4fe1\u606f\u5931\u8d25\uff1a" + contractHistoryRspBO.getMessage());
        }
        ContractDetailQueryAbilityReqBO contractQueryReqBO = new ContractDetailQueryAbilityReqBO();
        contractQueryReqBO.setContractId(reqBO.getContractId());
        ContractDetailQueryAbilityRspBO contractDetailRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractQueryReqBO);
        if (contractDetailRspBO.getContractId() == null) {
            throw new UocProBusinessException(contractDetailRspBO.getCode(), "\u67e5\u8be2\u5408\u540c\u5386\u53f2\u4fe1\u606f\u5931\u8d25\uff1a" + contractDetailRspBO.getMessage());
        }
        boolean isChange = false;
        PebExtContractMainChangeBO contractChangeBO = new PebExtContractMainChangeBO();
        if (!contractHistoryRspBO.getSupplierPhone().equals(contractDetailRspBO.getSupplierPhone())) {
            contractChangeBO.setN_CONTACT_MODE(contractDetailRspBO.getSupplierPhone());
            isChange = true;
        }
        if (!contractHistoryRspBO.getSupplierBankName().equals(contractDetailRspBO.getSupplierBankName())) {
            contractChangeBO.setN_BANK_NAME(contractDetailRspBO.getSupplierBankName());
            isChange = true;
        }
        if (!contractHistoryRspBO.getSupplierAccount().equals(contractDetailRspBO.getSupplierAccount())) {
            contractChangeBO.setN_BANK_ACC(contractDetailRspBO.getSupplierAccount());
            isChange = true;
        }
        if (!contractHistoryRspBO.getContractName().equals(contractDetailRspBO.getContractName())) {
            contractChangeBO.setN_CONTRACT_NAME(contractDetailRspBO.getContractName());
            isChange = true;
        }
        boolean isFileChange = false;
        List historyFileList = contractHistoryRspBO.getAccessoryList();
        Map<String, String> historyFileMap = historyFileList.stream().collect(Collectors.toMap(ContractAccessoryBO::getAcceessoryUrl, ContractAccessoryBO::getAcceessoryName));
        for (ContractAccessoryBO accessoryBO : contractDetailRspBO.getAccessoryList()) {
            String fileName = historyFileMap.get(accessoryBO.getAcceessoryUrl());
            if (fileName == null) {
                isFileChange = true;
                isChange = true;
                continue;
            }
            historyFileMap.remove(accessoryBO.getAcceessoryUrl());
        }
        if (!isFileChange && historyFileMap.size() > 0) {
            isFileChange = true;
            isChange = true;
        }
        List<Object> fileChangeList = new ArrayList();
        if (isFileChange) {
            fileChangeList = this.dealFileUpload(contractDetailRspBO);
        }
        if (!isChange) {
            return null;
        }
        contractChangeBO.setCONTRACT_NUM(contractDetailRspBO.getContractCode());
        contractChangeBO.setEG_CHANGE_NUM(reqBO.getChangeNo());
        contractChangeBO.setCHG_TYPE("CONTRACT");
        contractChangeBO.setN_SIGN_DATE(DateUtil.dateToStr((Date)contractDetailRspBO.getContractSignDate()));
        contractChangeBO.setSTATUS("Y");
        UocOrdContractPO contractPO = new UocOrdContractPO();
        contractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        contractPO.setContractId(reqBO.getContractId());
        contractPO = this.uocOrdContractMapper.selectOne(contractPO);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(contractPO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        PebExtUnifySettlePersonQryAbilityRspBO personQryAbilityRspBO = this.qryPersonInfo(zmInfoPO.getErpUserName());
        contractChangeBO.setCOM_CODE(((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getCOM_CODE());
        if (!org.springframework.util.StringUtils.isEmpty((Object)zmInfoPO.getBuynerErpNo())) {
            contractChangeBO.setORG_ID(Long.valueOf(zmInfoPO.getBuynerErpNo()));
        }
        contractChangeBO.setORG_NAME(zmInfoPO.getBuynerName());
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)contractChangeBO);
        jsonObject.put("fileList", fileChangeList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(encryptionAbilityRspBO.getRespCode(), "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        PebExtPushContractLedgerChangeBusiReqBO busiReqBO = new PebExtPushContractLedgerChangeBusiReqBO();
        busiReqBO.setToken(personQryAbilityRspBO.getToken());
        busiReqBO.setPushType(reqBO.getPushType());
        busiReqBO.setOrderId(reqBO.getContractId());
        busiReqBO.setOrderNo(contractDetailRspBO.getContractCode());
        busiReqBO.setApplyId(reqBO.getApplyId());
        busiReqBO.setReqData(jsonArray.toJSONString());
        busiReqBO.setParseData(encryptionAbilityRspBO.getData());
        return busiReqBO;
    }

    private List<PebExtContractFileChangeBO> dealFileUpload(ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO) {
        ArrayList<PebExtContractFileChangeBO> fileList = new ArrayList<PebExtContractFileChangeBO>();
        for (ContractAccessoryBO accessoryBO : contractDetailQueryAbilityRspBO.getAccessoryList()) {
            PebExtUnifyFileUploadAtomReqBO atomReqBO = new PebExtUnifyFileUploadAtomReqBO();
            atomReqBO.setFileName(accessoryBO.getAcceessoryName());
            atomReqBO.setFileUrl(accessoryBO.getAcceessoryUrl());
            PebExtUnifyFileUploadAtomRspBO atomRspBO = this.pebExtUnifyFileUploadAtomService.dealFileUpload(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            PebExtContractFileChangeBO fileBO = new PebExtContractFileChangeBO();
            fileBO.setDOC_NAME(atomRspBO.getFileName());
            fileBO.setDOC_SIZE(atomRspBO.getSize());
            fileBO.setFILE_URL(atomRspBO.getUrl());
            fileBO.setLAST_UPDATE_DATE(atomRspBO.getDate());
            fileBO.setUPLOAD_TIME(atomRspBO.getDate());
            fileBO.setDOC_FORMAT(atomRspBO.getFileName().substring(atomRspBO.getFileName().lastIndexOf(".") + 1));
            fileBO.setUSER_NAME(contractDetailQueryAbilityRspBO.getCreateUserName());
            fileBO.setDOC_TYPE("8011");
            fileBO.setUUID("zjht");
            fileBO.setEG_BILL_NUM(contractDetailQueryAbilityRspBO.getContractNo());
            fileList.add(fileBO);
        }
        return fileList;
    }

    private List<PebExtContractPayScheduleChangeBO> buildPayInfo(Long orderId, PebExtContractOrderChangeBO orderChangeBO, String pushTypeWealth, OrdSalePO salePO) {
        BigDecimal warranty = BigDecimal.ZERO;
        ArrayList<PebExtContractPayScheduleChangeBO> payList = new ArrayList<PebExtContractPayScheduleChangeBO>();
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setOrderId(orderId);
        payConfPO.setUserType(UocCoreConstant.UserType.PUR);
        List confPOS = this.ordPayConfMapper.selectByCondition(payConfPO);
        if (CollectionUtils.isEmpty((Collection)confPOS)) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u914d\u7f6e\u4fe1\u606f");
        }
        payConfPO = (OrdPayConfPO)confPOS.get(0);
        PayConfDetailPO payConfDetailPO = new PayConfDetailPO();
        payConfDetailPO.setPayConfId(payConfPO.getId());
        List detailPOS = this.payConfDetailMapper.selectByCondition(payConfDetailPO);
        if (!CollectionUtils.isEmpty((Collection)detailPOS)) {
            for (PayConfDetailPO detailPO : detailPOS) {
                if ("2".equals(pushTypeWealth) && !UocCoreConstant.PayNode.CREATE.equals(detailPO.getPayNode())) continue;
                if (detailPO.getPayType() == 1) {
                    warranty = warranty.add(detailPO.getPayPercent());
                }
                PebExtContractPayScheduleChangeBO payScheduleBO = new PebExtContractPayScheduleChangeBO();
                payScheduleBO.setORG_ID(orderChangeBO.getORG_ID());
                payScheduleBO.setORG_NAME(orderChangeBO.getORG_NAME());
                payScheduleBO.setPAY_SCAL(detailPO.getPayPercent());
                payScheduleBO.setUSER_ID(orderChangeBO.getUSER_ID());
                payScheduleBO.setPAY_AMOUNT(orderChangeBO.getPO_AMOUNT().multiply(payScheduleBO.getPAY_SCAL()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                payScheduleBO.setHANDLE_TYPE(orderChangeBO.getHANDLE_TYPE());
                payScheduleBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", detailPO.getPayType().toString()));
                if (detailPO.getPayDays() != null) {
                    payScheduleBO.setMONTH(new BigDecimal(detailPO.getPayDays()).divide(new BigDecimal(30), 2, RoundingMode.HALF_UP));
                } else {
                    payScheduleBO.setMONTH(new BigDecimal("1"));
                }
                payScheduleBO.setEG_CONTRACT_NUM(salePO.getSaleVoucherNo());
                payList.add(payScheduleBO);
            }
        } else if (payConfPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PERIOD)) {
            PebExtContractPayScheduleChangeBO payScheduleBO = new PebExtContractPayScheduleChangeBO();
            payScheduleBO.setORG_ID(orderChangeBO.getORG_ID());
            payScheduleBO.setORG_NAME(orderChangeBO.getORG_NAME());
            payScheduleBO.setPAY_SCAL(new BigDecimal(100));
            payScheduleBO.setUSER_ID(orderChangeBO.getUSER_ID());
            payScheduleBO.setHANDLE_TYPE(orderChangeBO.getHANDLE_TYPE());
            payScheduleBO.setPAY_AMOUNT(orderChangeBO.getPO_AMOUNT());
            if (payConfPO.getPayNodeRule().equals(FscConstants.MerchantPayNodeRule.SIGN)) {
                payScheduleBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", SHOULD_PAY_METHOD.toString()));
            } else {
                payScheduleBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", PRE_PAY_METHOD.toString()));
            }
            if (payConfPO.getPayRule().equals(FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE)) {
                if (payConfPO.getPaymentDays() != null) {
                    payScheduleBO.setMONTH(new BigDecimal(payConfPO.getPaymentDays()).divide(new BigDecimal(30), 2, RoundingMode.HALF_UP));
                } else {
                    payScheduleBO.setMONTH(new BigDecimal("1"));
                }
            } else if (payConfPO.getPayAccountDay() != null) {
                payScheduleBO.setMONTH(new BigDecimal(payConfPO.getPayAccountDay()).divide(new BigDecimal(30), 2, RoundingMode.HALF_UP));
            } else {
                payScheduleBO.setMONTH(new BigDecimal("1"));
            }
            payScheduleBO.setEG_CONTRACT_NUM(salePO.getSaleVoucherNo());
            payList.add(payScheduleBO);
        } else if (payConfPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PREP) || payConfPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_ADVANCE) || payConfPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_OVERDRAFT) || payConfPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_ADVANCE_OVERDRAFT)) {
            PebExtContractPayScheduleChangeBO payScheduleBO = new PebExtContractPayScheduleChangeBO();
            payScheduleBO.setORG_ID(orderChangeBO.getORG_ID());
            payScheduleBO.setORG_NAME(orderChangeBO.getORG_NAME());
            payScheduleBO.setPAY_SCAL(new BigDecimal(100));
            payScheduleBO.setUSER_ID(orderChangeBO.getUSER_ID());
            payScheduleBO.setHANDLE_TYPE(orderChangeBO.getHANDLE_TYPE());
            payScheduleBO.setPAY_AMOUNT(orderChangeBO.getPO_AMOUNT());
            payScheduleBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", PRE_PAY_METHOD.toString()));
            payScheduleBO.setEG_CONTRACT_NUM(salePO.getSaleVoucherNo());
            payList.add(payScheduleBO);
        }
        return payList;
    }

    private List<PebExtContractPayScheduleChangeBO> checkPayChange(ContractDetailQueryAbilityRspBO contractHistory, ContractDetailQueryAbilityRspBO contractDetail, boolean isChange) {
        ArrayList<PebExtContractPayScheduleChangeBO> payChangeList = new ArrayList<PebExtContractPayScheduleChangeBO>();
        if (!contractHistory.getPayType().equals(contractDetail.getPayType())) {
            if (contractDetail.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PHASE)) {
                for (ContractSettlementDetailBo settlementDetailBo : contractDetail.getSettlementDetailBos()) {
                    if (settlementDetailBo.getExtField1().equals("1") || settlementDetailBo.getMoneyType() == 0) continue;
                    PebExtContractPayScheduleChangeBO payScheduleChangeBO = new PebExtContractPayScheduleChangeBO();
                    payScheduleChangeBO.setHANDLE_TYPE("ADD");
                    payScheduleChangeBO.setPAY_SCAL(settlementDetailBo.getPayPercent());
                    payScheduleChangeBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", settlementDetailBo.getMoneyType().toString()));
                    payScheduleChangeBO.setMONTH(new BigDecimal(settlementDetailBo.getDays()).divide(new BigDecimal(30), 2));
                    payChangeList.add(payScheduleChangeBO);
                }
            } else if (contractDetail.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PERIOD)) {
                PebExtContractPayScheduleChangeBO payScheduleChangeBO = new PebExtContractPayScheduleChangeBO();
                payScheduleChangeBO.setHANDLE_TYPE("ADD");
                payScheduleChangeBO.setPAY_SCAL(new BigDecimal(100));
            }
        }
        return payChangeList;
    }

    private PebExtUnifySettlePersonQryAbilityRspBO qryPersonInfo(String userName) {
        PebExtUnifySettleTokenQryAbilityReqBO abilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        abilityReqBO.setUserId(userName);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(abilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(tokenQryAbilityRspBO.getRespCode(), tokenQryAbilityRspBO.getRespDesc());
        }
        PebExtUnifySettlePersonQryAbilityReqBO personQryAbilityReqBO = new PebExtUnifySettlePersonQryAbilityReqBO();
        personQryAbilityReqBO.setToken(tokenQryAbilityRspBO.getData());
        personQryAbilityReqBO.setUSER_NAME(userName);
        PebExtUnifySettlePersonQryAbilityRspBO personQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonInfo(personQryAbilityReqBO);
        if (!personQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(personQryAbilityRspBO.getRespCode(), personQryAbilityRspBO.getRespDesc());
        }
        personQryAbilityRspBO.setToken(tokenQryAbilityRspBO.getData());
        return personQryAbilityRspBO;
    }
}

