/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.common.ability.api.PebExtPushWarehouseShipAbilityService;
import com.tydic.uoc.common.ability.api.UocShipDetailsQueryAbilityService;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderWarehouseInfoBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryRspBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseShipBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipBusiRspBO;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrderPO;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushWarehouseShipAbilityService"})
public class PebExtPushWarehouseShipAbilityServiceImpl
implements PebExtPushWarehouseShipAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseShipAbilityServiceImpl.class);
    @Autowired
    private UocShipDetailsQueryAbilityService uocShipDetailsQueryAbilityService;
    @Autowired
    private PebExtPushWarehouseShipBusiService pebExtPushWarehouseShipBusiService;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    private static final String sign = "sign";

    @PostMapping(value={"dealPushWarehouseShip"})
    public PebExtPushWarehouseShipAbilityRspBO dealPushWarehouseShip(@RequestBody PebExtPushWarehouseShipAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getShipVoucherId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[shipVoucherId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UocShipDetailsQueryReqBO uocShipDetailsQueryReqBO = (UocShipDetailsQueryReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), UocShipDetailsQueryReqBO.class);
        UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.uocShipDetailsQueryAbilityService.getUocShipDetailsQuery(uocShipDetailsQueryReqBO);
        if (!"0000".equals(uocShipDetailsQueryRspBO.getRespCode())) {
            return (PebExtPushWarehouseShipAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)uocShipDetailsQueryRspBO), PebExtPushWarehouseShipAbilityRspBO.class);
        }
        try {
            return this.pushWarehouseShip(reqBO, uocShipDetailsQueryRspBO);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355\u6570\u636e\u5f02\u5e38\uff1a" + e);
            e.printStackTrace();
            PebExtPushWarehouseShipAbilityRspBO rspBO = new PebExtPushWarehouseShipAbilityRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    public PebExtPushWarehouseShipAbilityRspBO pushWarehouseShip(PebExtPushWarehouseShipAbilityReqBO reqBO, UocShipDetailsQueryRspBO rspBO) {
        PebExtPushWarehouseShipBusiReqBO busiReqBO = new PebExtPushWarehouseShipBusiReqBO();
        UocOrdShipRspBO ordShipRspBO = rspBO.getOrdShipRspBO();
        List ordShipItemRspBOList = rspBO.getOrdShipItemRspBOList();
        UocOrderWarehouseInfoBO warehouseInfo = ordShipRspBO.getWarehouseInfo();
        DicDictionaryBO warehouseCodeBO = this.dicDictionaryService.selectdictionaryByCodeAndCode(warehouseInfo.getSupplierId().toString(), "UOC_ECOM_WAREHOUSE_CODE");
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        PebExtPushWarehouseShipBO pebExtPushWarehouseShipBO = new PebExtPushWarehouseShipBO();
        pebExtPushWarehouseShipBO.setWarehouseId(warehouseCodeBO.getDescrip());
        pebExtPushWarehouseShipBO.setShipId(ordShipRspBO.getShipVoucherId());
        pebExtPushWarehouseShipBO.setThirdOrder(orderPO.getUpperOrderId() == null ? ordShipRspBO.getOrderId() : orderPO.getUpperOrderId());
        pebExtPushWarehouseShipBO.setSendorderId(ordShipRspBO.getPackageId());
        pebExtPushWarehouseShipBO.setCarrier(ordShipRspBO.getShipCompanyName());
        pebExtPushWarehouseShipBO.setWaybillNum(ordShipRspBO.getShipId());
        ArrayList<PebExtPushWarehouseShipItemBO> skuInfos = new ArrayList<PebExtPushWarehouseShipItemBO>();
        for (UocOrdShipItemRspBO item : ordShipItemRspBOList) {
            PebExtPushWarehouseShipItemBO pebExtPushWarehouseShipItemBO = new PebExtPushWarehouseShipItemBO();
            pebExtPushWarehouseShipItemBO.setShipItemId(item.getShipItemId());
            pebExtPushWarehouseShipItemBO.setMaterialCode(item.getSkuMaterialId());
            pebExtPushWarehouseShipItemBO.setMaterialName(item.getSkuMaterialName());
            pebExtPushWarehouseShipItemBO.setSkuName(item.getSkuName());
            pebExtPushWarehouseShipItemBO.setExtSkuId(item.getSkuExtSkuId());
            pebExtPushWarehouseShipItemBO.setSendNum(Integer.valueOf(item.getSendCount().intValue()));
            pebExtPushWarehouseShipItemBO.setUnitName(item.getUnitName());
            if (StringUtils.isEmpty((Object)item.getSpec())) {
                pebExtPushWarehouseShipItemBO.setSpec(item.getModel());
                pebExtPushWarehouseShipItemBO.setModel(item.getModel());
            } else if (StringUtils.isEmpty((Object)item.getModel())) {
                pebExtPushWarehouseShipItemBO.setSpec(item.getSpec());
                pebExtPushWarehouseShipItemBO.setModel(item.getSpec());
            } else {
                pebExtPushWarehouseShipItemBO.setSpec(item.getSpec());
                pebExtPushWarehouseShipItemBO.setModel(item.getModel());
            }
            pebExtPushWarehouseShipItemBO.setPrice(new BigDecimal(item.getPurchasePrice()).divide(new BigDecimal(10000)).setScale(2, 4));
            skuInfos.add(pebExtPushWarehouseShipItemBO);
        }
        pebExtPushWarehouseShipBO.setSkuInfos(skuInfos);
        this.sign(pebExtPushWarehouseShipBO);
        busiReqBO.setSupplierId(warehouseInfo.getSupplierId());
        busiReqBO.setReqData(JSONObject.toJSONString((Object)pebExtPushWarehouseShipBO));
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        PebExtPushWarehouseShipBusiRspBO busiRspBO = this.pebExtPushWarehouseShipBusiService.dealPushWarehouseShip(busiReqBO);
        return (PebExtPushWarehouseShipAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushWarehouseShipAbilityRspBO.class);
    }

    private void sign(PebExtPushWarehouseShipBO pebExtPushWarehouseShipBO) {
        Field[] fields;
        StringBuilder signStr = new StringBuilder();
        String key = this.warehouseSignKey;
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)pebExtPushWarehouseShipBO));
        Class<?> reqObj = pebExtPushWarehouseShipBO.getClass();
        for (Field field : fields = reqObj.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals(sign) || "skuInfos".equals(name)) continue;
            signStr.append(name);
            String value = jsonObject.getString(name);
            signStr.append(value);
        }
        signStr.append("skuInfos");
        signStr.append(JSONObject.toJSONString((Object)pebExtPushWarehouseShipBO.getSkuInfos()));
        log.error("skuInfos:" + JSONObject.toJSONString((Object)pebExtPushWarehouseShipBO.getSkuInfos()));
        log.error("\u7535\u5546\u8ba2\u5355\u63d0\u4ea4\u52a0\u7b7e\u53c2\u6570\uff1a" + signStr.toString());
        String sign = MD5Util.MD5Encode((String)(signStr.toString() + key), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + key), (String)"");
        pebExtPushWarehouseShipBO.setSign(sign);
    }
}

