/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityRspBO;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.UocOrdContractPO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService"})
public class PebExtSyncUnifyChangeAbilityServiceImpl
implements PebExtSyncUnifyChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtSyncUnifyChangeAbilityServiceImpl.class);
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Resource(name="uocDealPushContractOrderChangeProvider")
    private ProxyMessageProducer uocDealPushContractOrderChangeProvider;
    @Value(value="${UOC_DEAL_PUSH_CONTRACT_ORDER_CHANGE_TOPIC:UOC_DEAL_PUSH_CONTRACT_ORDER_CHANGE_TOPIC}")
    private String pushContractOrderChangeTopic;
    @Value(value="${UOC_DEAL_PUSH_CONTRACT_ORDER_CHANGE_TAG:UOC_DEAL_PUSH_CONTRACT_ORDER_CHANGE_TAG}")
    private String pushContractOrderChangeTag;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @PostMapping(value={"syncPushUnifyOrderChange"})
    public PebExtSyncUnifyChangeAbilityRspBO syncPushUnifyOrderChange(@RequestBody PebExtSyncUnifyChangeAbilityReqBO reqBO) {
        log.info("\u540c\u6b65\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355\u53d8\u66f4\u5165\u53c2{}", (Object)JSON.toJSONString((Object)reqBO));
        if (reqBO.getOrderId() == null && reqBO.getContractId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u8ba2\u5355id[orderId]\u548c\u5408\u540cid[contractId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPushType() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u7c7b\u578b[pushType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getApplyId() == null) {
            reqBO.setApplyId(Long.valueOf(this.sequence.nextId()));
        }
        UocOrdContractPO ordContractPO = new UocOrdContractPO();
        ordContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE)) {
            ordContractPO.setOrderId(reqBO.getOrderId());
            ordContractPO = this.uocOrdContractMapper.getModelBy(ordContractPO);
            if (ordContractPO != null) {
                this.uocDealPushContractOrderChangeProvider.send(new ProxyMessage(this.pushContractOrderChangeTopic, this.pushContractOrderChangeTag, JSONObject.toJSONString((Object)reqBO)));
            }
        } else {
            ordContractPO.setContractId(reqBO.getContractId());
            ordContractPO = this.uocOrdContractMapper.getModelBy(ordContractPO);
            if (ordContractPO != null) {
                reqBO.setOrderId(ordContractPO.getOrderId());
                this.uocDealPushContractOrderChangeProvider.send(new ProxyMessage(this.pushContractOrderChangeTopic, this.pushContractOrderChangeTag, JSONObject.toJSONString((Object)reqBO)));
            }
        }
        PebExtSyncUnifyChangeAbilityRspBO rspBO = new PebExtSyncUnifyChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

