/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtUpdateAbnormalRefundFlagBusiService;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService"})
public class PebExtUpdateAbnormalRefundFlagAbilityServiceImpl
implements PebExtUpdateAbnormalRefundFlagAbilityService {
    @Autowired
    private PebExtUpdateAbnormalRefundFlagBusiService pebExtUpdateAbnormalRefundFlagBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;

    @PostMapping(value={"updateAbnormalFlag"})
    public PebExtUpdateAbnormalRefundFlagRspBO updateAbnormalFlag(@RequestBody PebExtUpdateAbnormalRefundFlagReqBO reqBO) {
        this.valid(reqBO);
        PebExtUpdateAbnormalRefundFlagRspBO refundFlagRspBO = this.pebExtUpdateAbnormalRefundFlagBusiService.updateAbnormalFlag(reqBO);
        if (refundFlagRspBO.getRespCode().equals("0000")) {
            this.syncAbnormal(reqBO);
        }
        return refundFlagRspBO;
    }

    private void syncAbnormal(PebExtUpdateAbnormalRefundFlagReqBO reqBO) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        for (Long abnormalId : reqBO.getAbnormalMap().keySet()) {
            pebOrdIdxSyncReqBO.setOrderId((Long)reqBO.getAbnormalMap().get(abnormalId));
            pebOrdIdxSyncReqBO.setObjId(abnormalId);
            pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
            this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
        }
    }

    private void valid(PebExtUpdateAbnormalRefundFlagReqBO reqBO) {
        if (reqBO.getReceiveType() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[receiveType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundFlag() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[refundFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)reqBO.getAbnormalMap())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[abnormalMap]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

