/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushContractLedgerAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveRspBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.comb.api.UocPebApproveCombService;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService"})
public class UocApprovalOrderAbilityServiceImpl
implements UocApprovalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocApprovalOrderAbilityServiceImpl.class);
    @Autowired
    private UocPebApproveCombService uocPebApproveCombService;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TOPIC:DEAL_PUSH_CONTRACT_ORDER_TOPIC}")
    private String pushContractOrderTopic;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TAG:DEAL_PUSH_CONTRACT_ORDER_TAG}")
    private String pushContractOrderTag;
    @Resource(name="dealPushContractOrderProvider")
    private ProxyMessageProducer pushContractOrderProvider;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC:DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC}")
    private String pushFzOrderEvaluateTopic;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TAG:DEAL_PUSH_FZ_ORDER_EVALUATE_TAG}")
    private String pushFzOrderEvaluateTag;
    @Resource(name="dealPushFzOrderEvaluateProvider")
    private ProxyMessageProducer dealPushFzOrderEvaluateProvider;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC:DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC}")
    private String pushWarehouseOrderSubmitTopic;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TAG:DEAL_WAREHOUSE_ORDER_SUBMIT_TAG}")
    private String pushWarehouseOrderSubmitTag;
    @Resource(name="dealPushWarehouseOrderSubmitProvider")
    private ProxyMessageProducer dealPushWarehouseOrderSubmitProvider;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoCombService uocTodoCombService;

    @PostMapping(value={"dealApprovalOrder"})
    public UocApprovalOrderRspBO dealApprovalOrder(@RequestBody UocApprovalOrderReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealDesc())) {
            if ("1".equals(reqBO.getFlag())) {
                reqBO.setDealDesc("\u540c\u610f");
            } else {
                reqBO.setDealDesc("\u62d2\u7edd");
            }
        }
        UocApprovalOrderRspBO rspBO = new UocApprovalOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        for (UocPebDealOrderBO orderBO : reqBO.getOrderInfo()) {
            String stationId = null;
            try {
                stationId = this.uocTodoCombService.getNextStationId(orderBO.getSaleVoucherId(), UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5f53\u524d\u5ba1\u6279\u4eba\u5c97\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            }
            UocPebApproveReqBO approveReqBO = new UocPebApproveReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approveReqBO);
            approveReqBO.setFlag(reqBO.getFlag());
            approveReqBO.setOrderId(orderBO.getOrderId());
            approveReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            approveReqBO.setDealDesc(reqBO.getDealDesc());
            approveReqBO.setDealReason(reqBO.getDealDesc());
            approveReqBO.setStepId(orderBO.getStepId());
            UocPebApproveRspBO approveRspBO = this.uocPebApproveCombService.dealPebApprove(approveReqBO);
            if (!"0000".equals(approveRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)approveRspBO, (Object)rspBO);
                return rspBO;
            }
            if (approveRspBO.getFinish().booleanValue() && "1".equals(reqBO.getFlag())) {
                PebExtPushFzOrderEvaluateAbilityReqBO evaluateAbilityReqBO = new PebExtPushFzOrderEvaluateAbilityReqBO();
                evaluateAbilityReqBO.setOrderId(orderBO.getOrderId());
                this.dealPushFzOrderEvaluateProvider.send(new ProxyMessage(this.pushFzOrderEvaluateTopic, this.pushFzOrderEvaluateTag, JSONObject.toJSONString((Object)evaluateAbilityReqBO)));
                UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
                warehousePO.setOrderId(orderBO.getOrderId());
                warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
                if (warehousePO != null) {
                    PebExtWarehouseOrderSubmitAbilityReqBO submitAbilityReqBO = new PebExtWarehouseOrderSubmitAbilityReqBO();
                    submitAbilityReqBO.setOrderId(orderBO.getOrderId());
                    this.dealPushWarehouseOrderSubmitProvider.send(new ProxyMessage(this.pushWarehouseOrderSubmitTopic, this.pushWarehouseOrderSubmitTag, JSONObject.toJSONString((Object)submitAbilityReqBO)));
                }
                OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
                cruxMapPO.setOrderId(orderBO.getOrderId());
                cruxMapPO.setObjId(orderBO.getOrderId());
                cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
                cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
                UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
                zmInfoPO.setOrderId(orderBO.getOrderId());
                zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
                if (cruxMapPO != null && !StringUtils.isEmpty((CharSequence)cruxMapPO.getFieldValue10()) && !cruxMapPO.getFieldValue10().equals("0") && zmInfoPO.getIsPushErp() != null && zmInfoPO.getIsPushErp() == 0) {
                    PebExtPushContractLedgerAbilityReqBO abilityReqBO = new PebExtPushContractLedgerAbilityReqBO();
                    abilityReqBO.setOrderId(orderBO.getOrderId());
                    abilityReqBO.setPushType(cruxMapPO.getFieldValue10());
                    if (cruxMapPO.getFieldValue10().equals("2")) {
                        OrdSalePO salePO = new OrdSalePO();
                        salePO.setOrderId(orderBO.getOrderId());
                        salePO = this.ordSaleMapper.getModelBy(salePO);
                        if (salePO != null && salePO.getModelSettle() == 2) {
                            this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                        }
                    } else {
                        this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                    }
                }
            }
            this.pushTodoWait(orderBO, reqBO, approveRspBO.getFinish(), stationId);
        }
        return rspBO;
    }

    private void pushTodoWait(UocPebDealOrderBO orderBO, UocApprovalOrderReqBO reqBO, Boolean finsh, String stationId) {
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(5000L);
                PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
                uocTodoBO.setOrderId(orderBO.getOrderId());
                uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
                uocTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
                uocTodoBO.setOperatorId(reqBO.getUserId() + "");
                uocTodoBO.setOperatorNo(reqBO.getUsername());
                uocTodoBO.setOperatorName(reqBO.getName());
                uocTodoBO.setOrgId((long)reqBO.getOrgId());
                uocTodoBO.setFinishTime(new Date());
                uocTodoBO.setFinishYn(finsh);
                uocTodoBO.setAuditRemark(reqBO.getDealDesc());
                uocTodoBO.setAuditStatus("1".equals(reqBO.getFlag()));
                uocTodoBO.setStationId(stationId);
                log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
                this.uocPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)uocTodoBO)));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
            }
        });
    }
}

