/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocDealOrderPayStatusAbilityService;
import com.tydic.uoc.common.ability.bo.UocDealOrderPayStatusReqBO;
import com.tydic.uoc.common.ability.bo.UocDealOrderPayStatusRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocDealOrderPayStatusBusiService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocDealOrderPayStatusAbilityService"})
public class UocDealOrderPayStatusAbilityServiceImpl
implements UocDealOrderPayStatusAbilityService {
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private UocDealOrderPayStatusBusiService uocDealOrderPayStatusBusiService;

    @PostMapping(value={"dealStatus"})
    public UocDealOrderPayStatusRspBO dealStatus(@RequestBody UocDealOrderPayStatusReqBO reqBO) {
        this.validateArgs(reqBO);
        UocDealOrderPayStatusRspBO rspBO = this.uocDealOrderPayStatusBusiService.dealStatus(reqBO);
        this.syncSale(reqBO, reqBO.getObjId());
        return rspBO;
    }

    private void validateArgs(UocDealOrderPayStatusReqBO reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserType())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[userType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[objId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncSale(UocDealOrderPayStatusReqBO reqBo, Long SaleVoucherId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        pebOrdIdxSyncReqBO.setObjId(SaleVoucherId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }
}

