/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.UocOrderPayConfQueryAbilityService;
import com.tydic.uoc.common.ability.bo.OrdPayConfRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderPayConfQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderPayConfQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.PayConfDetailPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderPayConfQueryAbilityService"})
public class UocOrderPayConfQueryAbilityServiceImpl
implements UocOrderPayConfQueryAbilityService {
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    @PostMapping(value={"getOrderPayConf"})
    public UocOrderPayConfQueryRspBO getOrderPayConf(@RequestBody UocOrderPayConfQueryReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2[orderIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserType() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2[userType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocOrderPayConfQueryRspBO rspBO = new UocOrderPayConfQueryRspBO();
        OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
        ordPayConfPO.setOrderId((Long)reqBO.getOrderIdList().get(0));
        ordPayConfPO.setUserType(reqBO.getUserType());
        List list = this.ordPayConfMapper.selectByCondition(ordPayConfPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ordPayConfPO = (OrdPayConfPO)list.get(0);
            rspBO.setOrdPayConfRspBO((OrdPayConfRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)ordPayConfPO), OrdPayConfRspBO.class));
            rspBO.setPayType(ordPayConfPO.getPayType());
            SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
            dictReqBO.setCode(rspBO.getPayType() + "");
            dictReqBO.setPcode("PAY_TYPE");
            SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                rspBO.setPayTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
            if (UocCoreConstant.PayType.PAY_TYPE_PHASE.equals(ordPayConfPO.getPayType())) {
                Map<String, String> payNodePayTypeMap = this.dicDictionaryService.getValueByCode("PAY_NODE_PAY_TYPE");
                PayConfDetailPO payConfDetailPO = new PayConfDetailPO();
                payConfDetailPO.setPayConfId(ordPayConfPO.getId());
                List detailList = this.payConfDetailMapper.selectByCondition(payConfDetailPO);
                ArrayList<UocPhasePayListBO> phasePayList = new ArrayList<UocPhasePayListBO>();
                OrdItemPO ordItemPO = this.ordItemMapper.getListStatistics(reqBO.getOrderIdList());
                if (!CollectionUtils.isEmpty((Collection)detailList)) {
                    for (PayConfDetailPO po : detailList) {
                        String payTypeStr = "";
                        if (payNodePayTypeMap != null && payNodePayTypeMap.get(po.getPayType().toString()) != null) {
                            payTypeStr = payNodePayTypeMap.get(po.getPayType().toString()) + "-";
                        }
                        UocPhasePayListBO uocPhasePayListBO = new UocPhasePayListBO();
                        uocPhasePayListBO.setNodeName(payTypeStr + po.getExt1());
                        uocPhasePayListBO.setNodePayCycle(po.getPayDays() + "");
                        uocPhasePayListBO.setNodePayRatio(po.getPayPercent());
                        BigDecimal amount = reqBO.getUserType() == 2 ? ordItemPO.getTotalPurchaseAmount() : ordItemPO.getTotalSaleAmount();
                        uocPhasePayListBO.setNodePayFee(po.getPayPercent().multiply(amount).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                        phasePayList.add(uocPhasePayListBO);
                    }
                } else {
                    UocPhasePayListBO uocPhasePayListBO;
                    if (ordPayConfPO.getPrePaySup() != null) {
                        uocPhasePayListBO = new UocPhasePayListBO();
                        uocPhasePayListBO.setNodeName("\u4e0b\u5355\u9884\u4ed8");
                        uocPhasePayListBO.setNodePayCycle("");
                        uocPhasePayListBO.setNodePayRatio(ordPayConfPO.getPrePaySup());
                        uocPhasePayListBO.setNodePayFee(MoneyUtil.l4B((Long)ordPayConfPO.getPrePayedFee()));
                        phasePayList.add(uocPhasePayListBO);
                    }
                    if (ordPayConfPO.getVerPaySup() != null) {
                        uocPhasePayListBO = new UocPhasePayListBO();
                        uocPhasePayListBO.setNodeName("\u5230\u8d27\u9884\u4ed8");
                        uocPhasePayListBO.setNodePayCycle("");
                        uocPhasePayListBO.setNodePayRatio(ordPayConfPO.getVerPaySup());
                        uocPhasePayListBO.setNodePayFee(MoneyUtil.l4B((Long)ordPayConfPO.getVerPayFee()));
                        phasePayList.add(uocPhasePayListBO);
                    }
                    if (ordPayConfPO.getPilPaySup() != null) {
                        uocPhasePayListBO = new UocPhasePayListBO();
                        uocPhasePayListBO.setNodeName("\u9a8c\u6536\u5165\u5e93");
                        uocPhasePayListBO.setNodePayCycle("");
                        uocPhasePayListBO.setNodePayRatio(ordPayConfPO.getPilPaySup());
                        uocPhasePayListBO.setNodePayFee(MoneyUtil.l4B((Long)ordPayConfPO.getPilPayFee()));
                        phasePayList.add(uocPhasePayListBO);
                    }
                    if (ordPayConfPO.getQuaPaySup() != null) {
                        uocPhasePayListBO = new UocPhasePayListBO();
                        uocPhasePayListBO.setNodeName("\u9a8c\u6536\u5165\u5e93");
                        uocPhasePayListBO.setNodePayCycle("");
                        uocPhasePayListBO.setNodePayRatio(ordPayConfPO.getQuaPaySup());
                        uocPhasePayListBO.setNodePayFee(MoneyUtil.l4B((Long)ordPayConfPO.getQuaPayFee()));
                        phasePayList.add(uocPhasePayListBO);
                    }
                }
                rspBO.setPhasePayList(phasePayList);
            } else if (UocCoreConstant.PayType.PAY_TYPE_PERIOD.equals(ordPayConfPO.getPayType())) {
                String payDesc = "";
                if (ordPayConfPO.getPayRule() == 1) {
                    payDesc = payDesc + "\u9700\u8981\u5728\u6bcf\u6708" + ordPayConfPO.getPayAccountDay() + "\u65e5\u5185\u7ed3\u7b97";
                } else if (ordPayConfPO.getPayRule() == 2) {
                    if (ordPayConfPO.getPayNodeRule() == 1) {
                        payDesc = payDesc + "\u9700\u8981\u5728\u8ba2\u5355\u6536\u7968";
                    } else if (ordPayConfPO.getPayNodeRule() == 2) {
                        payDesc = payDesc + "\u9700\u8981\u5728\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
                    } else if (ordPayConfPO.getPayNodeRule() == 3) {
                        payDesc = payDesc + "\u9700\u8981\u5728\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
                    }
                    payDesc = payDesc + ordPayConfPO.getPaymentDays() + "\u5929\u5185\u7ed3\u7b97";
                }
                rspBO.setExpectSettleDay(payDesc);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

