/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocOrderRelUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocOrderRelUpdateBusiService;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderRelUpdateAbilityService"})
public class UocOrderRelUpdateAbilityServiceImpl
implements UocOrderRelUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRelUpdateAbilityServiceImpl.class);
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private UocOrderRelUpdateBusiService uocOrderRelUpdateBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdInspectionMapper ordInspectionMapper;

    @PostMapping(value={"dealRelUpdate"})
    public UocOrderRelUpdateRspBo dealRelUpdate(@RequestBody UocOrderRelUpdateReqBo reqBo) {
        this.validateArgs(reqBo);
        UocOrderRelUpdateRspBo rspBo = this.uocOrderRelUpdateBusiService.dealRelUpdate(reqBo);
        if (UocConstant.SETTLE_TYPE.FSC_ORDER.equals(reqBo.getSettleType())) {
            this.syncInspection(reqBo.getOrderId(), reqBo.getInspectionVoucherId());
        } else if (UocConstant.SETTLE_TYPE.ORDER.equals(reqBo.getSettleType())) {
            this.syncSale(reqBo, reqBo.getInspectionVoucherId());
        }
        return rspBo;
    }

    @PostMapping(value={"dealRefundUpdate"})
    public UocOrderRefundUpdateRspBo dealRefundUpdate(@RequestBody UocOrderRefundUpdateReqBo reqBo) {
        UocOrderRefundUpdateRspBo rspBo;
        block7: {
            block6: {
                if (reqBo.getRelId() == null) {
                    throw new UocProBusinessException("8888", "\u5165\u53c2[relId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (reqBo.getSettleType() == null) {
                    throw new UocProBusinessException("8888", "\u5165\u53c2[settleType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (reqBo.getRelStatus() == null) {
                    throw new UocProBusinessException("8888", "\u5165\u53c2[relStatus]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)reqBo.getAcceptOrderIds())) {
                    throw new UocProBusinessException("8888", "\u5165\u53c2[acceptOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                rspBo = this.uocOrderRelUpdateBusiService.dealRefundUpdate(reqBo);
                if (!UocConstant.SETTLE_TYPE.FSC_ORDER.equals(reqBo.getSettleType()) || CollectionUtils.isEmpty((Map)rspBo.getSettleMap())) break block6;
                for (Long acceptOrderId : rspBo.getSettleMap().keySet()) {
                    this.syncInspection((Long)rspBo.getSettleMap().get(acceptOrderId), acceptOrderId);
                }
                break block7;
            }
            if (!UocConstant.SETTLE_TYPE.ORDER.equals(reqBo.getSettleType()) || CollectionUtils.isEmpty((Map)rspBo.getSettleMap())) break block7;
            for (Long acceptOrderId : rspBo.getSettleMap().keySet()) {
                this.syncSale((Long)rspBo.getSettleMap().get(acceptOrderId), acceptOrderId);
            }
        }
        return rspBo;
    }

    private void validateArgs(UocOrderRelUpdateReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelType())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[relType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelState())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[relState]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncInspection(Long orderId, Long objId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(objId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }

    private void syncSale(UocOrderRelUpdateReqBo reqBo, Long SaleVoucherId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        pebOrdIdxSyncReqBO.setObjId(SaleVoucherId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }

    private void syncSale(Long orderId, Long SaleVoucherId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(SaleVoucherId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }
}

