/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProOrderPaymentAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebApproveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentMergeAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentMergeAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentMergeBO;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.api.UocProOrderPaymentBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdFscShouldPayPo;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderPaymentAbilityService"})
public class UocProOrderPaymentAbilityServiceImpl
implements UocProOrderPaymentAbilityService {
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocProOrderPaymentBusiService uocProOrderPaymentBusiService;
    @Autowired
    private UocOrdFscShouldPayMapper ordFscShouldPayMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;

    @PostMapping(value={"dealPay"})
    public UocProOrderPaymentAbilityRspBo dealPay(@RequestBody UocProOrderPaymentAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        UocProOrderPaymentAbilityRspBo rspBo = (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.success(UocProOrderPaymentAbilityRspBo.class);
        OrdSalePO qryOrderPo = new OrdSalePO();
        qryOrderPo.setOrderId(reqBo.getOrderId());
        OrdSalePO saleRspBO = this.ordSaleMapper.getModelBy(qryOrderPo);
        if (saleRspBO == null) {
            throw new UocProBusinessException("104003", "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728(" + reqBo.getOrderId() + ")");
        }
        Integer saleState = saleRspBO.getSaleState();
        if (!UocConstant.SALE_ORDER_STATUS.PAYING.equals(saleState)) {
            return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + reqBo.getOrderId() + ")\u4e0d\u6ee1\u8db3\u652f\u4ed8\u6761\u4ef6"), UocProOrderPaymentAbilityRspBo.class);
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
            return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + reqBo.getOrderId() + ")\u5df2\u652f\u4ed8\u6210\u529f\u4e86"), UocProOrderPaymentAbilityRspBo.class);
        }
        reqBo.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        UocProOrderPaymentAbilityRspBo uocProOrderPaymentAbilityRspBo = this.uocProOrderPaymentBusiService.dealPay(reqBo);
        if (!"0000".equals(uocProOrderPaymentAbilityRspBo.getRespCode())) {
            return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)uocProOrderPaymentAbilityRspBo.getRespDesc(), UocProOrderPaymentAbilityRspBo.class);
        }
        if (uocProOrderPaymentAbilityRspBo.getIsRunPay().booleanValue()) {
            if ("2".equals(saleRspBO.getOrderSource())) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setOrderId(saleRspBO.getOrderId());
                submitReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
                UocPebPreOrderSubmitRspBO submit = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                if (!"0000".equals(submit.getRespCode())) {
                    return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u7535\u5546\u8ba2\u5355\u5931\u8d25" + submit.getRespDesc()), UocProOrderPaymentAbilityRspBo.class);
                }
            }
        } else {
            UocOrdFscShouldPayPo ordFscShouldPayPo = new UocOrdFscShouldPayPo();
            ordFscShouldPayPo.setOrderId(reqBo.getOrderId());
            ordFscShouldPayPo.setObjectType(Integer.valueOf(5));
            ordFscShouldPayPo.setShouldPayType(UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE);
            OrderPO orderPO = this.orderMapper.getModelById(reqBo.getOrderId().longValue());
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(reqBo.getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (PebExtConstant.OrderType.GC.equals(orderPO.getOrderType())) {
                OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderPO.getOrderId().longValue());
                ordFscShouldPayPo.setPayerId(stakeholderPO.getCompanyId());
            } else {
                ordFscShouldPayPo.setPayerId(Long.valueOf(zmInfoPO.getExt3()));
            }
            ordFscShouldPayPo = this.ordFscShouldPayMapper.getModelBy(ordFscShouldPayPo);
            if (null != ordFscShouldPayPo && (null == ordFscShouldPayPo.getIsPayCompleted() || 1 != ordFscShouldPayPo.getIsPayCompleted())) {
                rspBo.setFscShouldPayId(ordFscShouldPayPo.getFscShouldPayId());
                try {
                    rspBo.setShouldPayMoney(MoneyUtils.Long2BigDecimal((Long)ordFscShouldPayPo.getShouldPayFee()));
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            }
        }
        this.syncSale(saleRspBO);
        return rspBo;
    }

    private void cancel(UocPebApproveReqBO reqBO, String desc, String fail) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(reqBO.getOrderId());
        cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        cancelReqBO.setCancelDesc(desc);
        cancelReqBO.setCancelReason(desc);
        cancelReqBO.setFailCode(fail);
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "0");
        cancelReqBO.setVariables(map);
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("104040", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25" + rspBO.getRespDesc());
        }
    }

    private void validateArg(UocProOrderPaymentAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104003", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104003", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncSale(OrdSalePO saleRspBO) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(saleRspBO.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(saleRspBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }

    @PostMapping(value={"dealMergePay"})
    public UocProOrderPaymentMergeAbilityRspBo dealMergePay(@RequestBody UocProOrderPaymentMergeAbilityReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u8ba2\u5355id\u96c6\u5408[orderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getShouldPayAmount() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5408\u5e76\u652f\u4ed8\u91d1\u989d[shouldPayAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderIdList(reqBo.getOrderIds());
        salePO.setMergeOrderId(reqBo.getMergeOrderId());
        List list = this.ordSaleMapper.getList(salePO);
        if (list.size() != reqBo.getOrderIds().size()) {
            throw new UocProBusinessException("104003", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        UocProOrderPaymentMergeAbilityRspBo rspBo = (UocProOrderPaymentMergeAbilityRspBo)UocProRspBoUtil.success(UocProOrderPaymentMergeAbilityRspBo.class);
        for (OrdSalePO ordSalePO : list) {
            Integer saleState = ordSalePO.getSaleState();
            if (!UocConstant.SALE_ORDER_STATUS.PAYING.equals(saleState)) {
                return (UocProOrderPaymentMergeAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + ordSalePO.getSaleVoucherNo() + ")\u4e0d\u6ee1\u8db3\u652f\u4ed8\u6761\u4ef6"), UocProOrderPaymentMergeAbilityRspBo.class);
            }
            if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
                return (UocProOrderPaymentMergeAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + ordSalePO.getSaleVoucherNo() + ")\u5df2\u652f\u4ed8\u6210\u529f\u4e86"), UocProOrderPaymentMergeAbilityRspBo.class);
            }
            UocProOrderPaymentAbilityReqBo paymentAbilityReqBo = new UocProOrderPaymentAbilityReqBo();
            paymentAbilityReqBo.setOrderId(ordSalePO.getOrderId());
            paymentAbilityReqBo.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            UocProOrderPaymentAbilityRspBo uocProOrderPaymentAbilityRspBo = this.uocProOrderPaymentBusiService.dealPay(paymentAbilityReqBo);
            if ("0000".equals(uocProOrderPaymentAbilityRspBo.getRespCode())) continue;
            return (UocProOrderPaymentMergeAbilityRspBo)UocProRspBoUtil.failed((String)uocProOrderPaymentAbilityRspBo.getRespDesc(), UocProOrderPaymentMergeAbilityRspBo.class);
        }
        UocOrdFscShouldPayPo ordFscShouldPayPo = new UocOrdFscShouldPayPo();
        ordFscShouldPayPo.setOrderIdList(reqBo.getOrderIds());
        ordFscShouldPayPo.setObjectType(Integer.valueOf(5));
        ordFscShouldPayPo.setShouldPayType(UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE);
        List shouldPayList = this.ordFscShouldPayMapper.getList(ordFscShouldPayPo);
        BigDecimal payAmount = BigDecimal.ZERO;
        ArrayList<UocProOrderPaymentMergeBO> paymentMergeList = new ArrayList<UocProOrderPaymentMergeBO>();
        for (UocOrdFscShouldPayPo uocOrdFscShouldPayPo : shouldPayList) {
            UocProOrderPaymentMergeBO mergeBO = new UocProOrderPaymentMergeBO();
            if (null == uocOrdFscShouldPayPo.getIsPayCompleted() || 1 != uocOrdFscShouldPayPo.getIsPayCompleted()) {
                mergeBO.setFscShouldPayId(uocOrdFscShouldPayPo.getFscShouldPayId());
                try {
                    mergeBO.setShouldPayMoney(MoneyUtils.Long2BigDecimal((Long)uocOrdFscShouldPayPo.getShouldPayFee()));
                    payAmount = payAmount.add(mergeBO.getShouldPayMoney());
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            }
            paymentMergeList.add(mergeBO);
        }
        if (payAmount.compareTo(reqBo.getShouldPayAmount()) != 0) {
            throw new UocProBusinessException("104003", "\u524d\u540e\u7aef\u91d1\u989d\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
        }
        rspBo.setPaymentMergeList(paymentMergeList);
        return rspBo;
    }
}

