/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocSyncFscOrderRelUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocSyncFscOrderRelUpdateReqBO;
import com.tydic.uoc.common.ability.bo.UocSyncFscOrderRelUpdateRspBO;
import com.tydic.uoc.common.busi.api.UocSyncFscOrderRelUpdateBusiService;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocSyncFscOrderRelUpdateAbilityService"})
public class UocSyncFscOrderRelUpdateAbilityServiceImpl
implements UocSyncFscOrderRelUpdateAbilityService {
    @Autowired
    private UocSyncFscOrderRelUpdateBusiService uocSyncFscOrderRelUpdateBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdInspectionMapper ordInspectionMapper;

    @PostMapping(value={"dealRelUpdate"})
    public UocSyncFscOrderRelUpdateRspBO dealRelUpdate(@RequestBody UocSyncFscOrderRelUpdateReqBO reqBo) {
        this.val(reqBo);
        UocSyncFscOrderRelUpdateRspBO uocSyncFscOrderRelUpdateRspBO = this.uocSyncFscOrderRelUpdateBusiService.dealRelUpdate(reqBo);
        List uocOrderRelUpdateReqBos = reqBo.getUocOrderRelUpdateReqBos();
        for (UocOrderRelUpdateReqBo bo : uocOrderRelUpdateReqBos) {
            if (UocConstant.SETTLE_TYPE.FSC_ORDER.equals(bo.getSettleType())) {
                this.syncInspection(bo.getOrderId(), bo.getInspectionVoucherId());
                continue;
            }
            if (!UocConstant.SETTLE_TYPE.ORDER.equals(bo.getSettleType())) continue;
            this.syncSale(bo, bo.getInspectionVoucherId());
        }
        return uocSyncFscOrderRelUpdateRspBO;
    }

    private void syncInspection(Long orderId, Long objId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(objId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }

    private void val(UocSyncFscOrderRelUpdateReqBO reqBO) {
        List uocOrderRelUpdateReqBos = reqBO.getUocOrderRelUpdateReqBos();
        if (null == reqBO.getRelId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010UocSyncFscOrderRelUpdateReqBO RelId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UocOrderRelUpdateReqBo bo : uocOrderRelUpdateReqBos) {
            if (null == bo) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010UocOrderRelUpdateReqBo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getRelId()) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010getRelId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getInspectionVoucherId()) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010getInspectionVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getOrderId()) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010getOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Objects.nonNull(bo.getRelState())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010RelState\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Objects.nonNull(bo.getRelType())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010getRelType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.nonNull(bo.getSettleType())) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010getSettleType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncSale(UocOrderRelUpdateReqBo reqBo, Long SaleVoucherId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        pebOrdIdxSyncReqBO.setObjId(SaleVoucherId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }
}

