/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.UocPebOrderDelieveredRejectAbilityService;
import com.tydic.uoc.common.ability.api.UocWarehouseSyncShipStatusAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipStatusAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectRspBO;
import com.tydic.uoc.common.ability.bo.UocWarehouseFileBO;
import com.tydic.uoc.common.ability.bo.UocWarehouseSyncShipStatusAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocWarehouseSyncShipStatusAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocWarehouseSyncShipStatusBusiService;
import com.tydic.uoc.common.busi.bo.UocWarehouseSyncShipStatusBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocWarehouseSyncShipStatusBusiRspBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocWarehouseSyncShipStatusAbilityService"})
public class UocWarehouseSyncShipStatusAbilityServiceImpl
implements UocWarehouseSyncShipStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocWarehouseSyncShipStatusAbilityServiceImpl.class);
    @Autowired
    private UocWarehouseSyncShipStatusBusiService uocWarehouseSyncShipStatusBusiService;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private UocPebOrderDelieveredRejectAbilityService uocPebOrderDelieveredRejectAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    private static final String serialVersionUID = "serialVersionUID";
    private static final String sign = "sign";
    private static final String status = "status";
    private static final String files = "files";
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${DEAL_WAREHOUSE_SHIP_STATUS_TOPIC:DEAL_WAREHOUSE_SHIP_STATUS_TOPIC}")
    private String shipStatusTopic;
    @Value(value="${DEAL_WAREHOUSE_SHIP_STATUS_TAG:DEAL_WAREHOUSE_SHIP_STATUS_TAG}")
    private String shipStatusTag;
    @Resource(name="dealPushWarehouseShipStatusProvider")
    private ProxyMessageProducer dealPushWarehouseShipStatusProvider;
    private static final Integer WAREHOUSE_STATUS_SYNC_IN = 1;
    private static final Integer WAREHOUSE_STATUS_SYNC_ERROR = 9;
    private static final Integer WAREHOUSE_STATUS_SYNC_OUT = 2;
    private static final Integer WAREHOUSE_STATUS_SYNC_ARRIVE = 3;
    private static final Integer WAREHOUSE_STATUS_SYNC_FILE = 4;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @PostMapping(value={"dealSyncShipStatus"})
    public UocWarehouseSyncShipStatusAbilityRspBO dealSyncShipStatus(@RequestBody UocWarehouseSyncShipStatusAbilityReqBO reqBO) {
        this.validParam(reqBO);
        UocOrdWarehouseLogPO pushLog = new UocOrdWarehouseLogPO();
        pushLog.setId(Long.valueOf(this.sequence.nextId()));
        pushLog.setShipVoucherId(reqBO.getShipId());
        if (WAREHOUSE_STATUS_SYNC_IN.equals(reqBO.getStatus())) {
            pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_IN_STATUS);
        } else if (WAREHOUSE_STATUS_SYNC_ERROR.equals(reqBO.getStatus())) {
            pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_IN_ABNORMAL);
        } else if (WAREHOUSE_STATUS_SYNC_FILE.equals(reqBO.getStatus())) {
            pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_UPLOAD_STATUS);
        } else if (WAREHOUSE_STATUS_SYNC_OUT.equals(reqBO.getStatus())) {
            pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_OUT_STATUS);
        } else if (WAREHOUSE_STATUS_SYNC_ARRIVE.equals(reqBO.getStatus())) {
            pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_SIGN_STATUS);
        }
        pushLog.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLog.setReqData(JSONObject.toJSONString((Object)reqBO));
        pushLog.setCreateTime(new Date());
        try {
            this.generateSign(reqBO);
            OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBO.getShipId().longValue());
            if (ordShipPO == null) {
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u6570\u636e\uff01");
            }
            pushLog.setOrderId(ordShipPO.getOrderId());
            if (WAREHOUSE_STATUS_SYNC_IN.equals(reqBO.getStatus())) {
                if ("3201".equals(ordShipPO.getShipStatus())) {
                    UocWarehouseSyncShipStatusAbilityRspBO rspBO = new UocWarehouseSyncShipStatusAbilityRspBO();
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                if (!("1202".equals(ordShipPO.getShipStatus()) || "1203".equals(ordShipPO.getShipStatus()) || "3204".equals(ordShipPO.getShipStatus()))) {
                    throw new UocProBusinessException("8888", "\u53d1\u8d27\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u5165\u5e93");
                }
                if ("1202".equals(ordShipPO.getShipStatus())) {
                    this.dealExecutePebOrderDelieveredReject(ordShipPO);
                }
            } else if (WAREHOUSE_STATUS_SYNC_ERROR.equals(reqBO.getStatus())) {
                if ("3204".equals(ordShipPO.getShipStatus())) {
                    UocWarehouseSyncShipStatusAbilityRspBO rspBO = new UocWarehouseSyncShipStatusAbilityRspBO();
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                if ("1202".equals(ordShipPO.getShipStatus())) {
                    this.dealExecutePebOrderDelieveredReject(ordShipPO);
                }
            } else if (WAREHOUSE_STATUS_SYNC_OUT.equals(reqBO.getStatus())) {
                if ("3202".equals(ordShipPO.getShipStatus())) {
                    UocWarehouseSyncShipStatusAbilityRspBO rspBO = new UocWarehouseSyncShipStatusAbilityRspBO();
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
            } else if (WAREHOUSE_STATUS_SYNC_ARRIVE.equals(reqBO.getStatus()) && "3203".equals(ordShipPO.getShipStatus())) {
                UocWarehouseSyncShipStatusAbilityRspBO rspBO = new UocWarehouseSyncShipStatusAbilityRspBO();
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
        }
        catch (Exception e) {
            pushLog.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            pushLog.setRespData(e.getMessage());
            this.uocOrdWarehouseLogMapper.insert(pushLog);
            throw new UocProBusinessException("8888", e.getMessage());
        }
        UocWarehouseSyncShipStatusBusiReqBO busiReqBO = (UocWarehouseSyncShipStatusBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UocWarehouseSyncShipStatusBusiReqBO.class);
        UocWarehouseSyncShipStatusBusiRspBO busiRspBO = this.uocWarehouseSyncShipStatusBusiService.dealSyncShipStatus(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            pushLog.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            pushLog.setRespData(JSON.toJSONString((Object)((Object)busiRspBO)));
            this.uocOrdWarehouseLogMapper.insert(pushLog);
            throw new UocProBusinessException("8888", busiRspBO.getRespDesc());
        }
        this.uocOrdWarehouseLogMapper.insert(pushLog);
        this.sendMq(busiReqBO, busiRspBO);
        return (UocWarehouseSyncShipStatusAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UocWarehouseSyncShipStatusAbilityRspBO.class);
    }

    private void dealExecutePebOrderDelieveredReject(OrdShipPO ordShipPO) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(ordShipPO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        UocPebOrderDelieveredRejectReqBO uocPebOrderDelieveredRejectReqBO = new UocPebOrderDelieveredRejectReqBO();
        uocPebOrderDelieveredRejectReqBO.setExtOrderId(ordShipPO.getPackageId());
        uocPebOrderDelieveredRejectReqBO.setPackageId(ordShipPO.getPackageId());
        uocPebOrderDelieveredRejectReqBO.setSupplierId(Long.valueOf(ordStakeholderPO.getSupNo()));
        uocPebOrderDelieveredRejectReqBO.setStatus(Integer.valueOf(1));
        uocPebOrderDelieveredRejectReqBO.setOrderId(ordShipPO.getOrderId());
        UocPebOrderDelieveredRejectRspBO uocPebOrderDelieveredRejectRspBO = this.uocPebOrderDelieveredRejectAbilityService.executePebOrderDelieveredReject(uocPebOrderDelieveredRejectReqBO);
        if (!"0000".equals(uocPebOrderDelieveredRejectRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u53d1\u8d27\u5355\u672a\u5165\u5e93\uff0c\u7535\u5546\u59a5\u6295\u5931\u8d25");
        }
    }

    private void validParam(UocWarehouseSyncShipStatusAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getStatus() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[status]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDealTime())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[dealTime]\u4e3a\u7a7a");
        }
        if (reqBO.getStatus() == 4 && CollectionUtils.isEmpty((Collection)reqBO.getFiles())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[files]\u4e3a\u7a7a");
        }
    }

    private void generateSign(UocWarehouseSyncShipStatusAbilityReqBO reqBO) {
        String[] paramOrder = new String[]{"shipId", status, "dealTime", files};
        String[] inAbnormalOrder = new String[]{"shipId", "dealTime", "remark", files};
        List<String> paramOrderList = WAREHOUSE_STATUS_SYNC_ERROR.equals(reqBO.getStatus()) ? Arrays.asList(inAbnormalOrder) : Arrays.asList(paramOrder);
        StringBuilder signStr = new StringBuilder();
        String key = this.warehouseSignKey;
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO));
        for (String param : paramOrderList) {
            String value;
            if (param.equals(files) && reqBO.getStatus() != 4 && reqBO.getStatus() != 9) {
                signStr.append(param);
                value = "null";
                signStr.append(value);
                continue;
            }
            signStr.append(param);
            value = jsonObject.getString(param);
            signStr.append(value);
        }
        log.error("\u7535\u5546\u8ba2\u5355\u63d0\u4ea4\u52a0\u7b7e\u52a0\u5bc6\u524d\u53c2\u6570\uff1a" + signStr);
        String sign = MD5Util.MD5Encode((String)(signStr.toString() + key), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + key), (String)"");
        log.error("\u7535\u5546\u8ba2\u5355\u63d0\u4ea4\u52a0\u7b7e\u53c2\u6570\uff1a" + sign);
        if (!reqBO.getSign().equals(sign)) {
            throw new UocProBusinessException("8888", "\u7b7e\u540d\u6838\u9a8c\u5931\u8d25\uff01");
        }
    }

    private void sendMq(UocWarehouseSyncShipStatusBusiReqBO reqBO, UocWarehouseSyncShipStatusBusiRspBO rspBO) {
        UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
        UocPebOrdIdxSyncReqBO shipOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getShipVoucherId(), UocConstant.OBJ_TYPE.SHIP);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)shipOrdIdxSyncReqBO)));
        if (rspBO.getSubmitStatus() == 1 || rspBO.getSubmitStatus() == 2 || rspBO.getSubmitStatus() == 3 || rspBO.getSubmitStatus() == 4) {
            PebExtPushWarehouseShipStatusAbilityReqBO shipStatusSyncReqBO = new PebExtPushWarehouseShipStatusAbilityReqBO();
            shipStatusSyncReqBO.setOrderId(rspBO.getOrderId());
            shipStatusSyncReqBO.setShipVoucherId(rspBO.getShipVoucherId());
            shipStatusSyncReqBO.setSubmitTime(rspBO.getSubmitTime());
            shipStatusSyncReqBO.setSubmitStatus(rspBO.getSubmitStatus());
            if (!CollectionUtils.isEmpty(reqBO.getFiles())) {
                List submitUrl = reqBO.getFiles().stream().map(UocWarehouseFileBO::getFileUrl).collect(Collectors.toList());
                shipStatusSyncReqBO.setSubmitUrl(submitUrl);
            }
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.shipStatusTopic, this.shipStatusTag, JSON.toJSONString((Object)shipStatusSyncReqBO)));
        }
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType);
        return ordIdxSyncReqBO;
    }
}

