/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfCommodityListsAbilityService;
import com.tydic.uoc.busibase.busi.bo.CommodityAndSkusDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.CommodityImageBO;
import com.tydic.uoc.busibase.busi.bo.CommodityInfoListsReqBO;
import com.tydic.uoc.busibase.busi.bo.CommodityInfoListsRspBO;
import com.tydic.uoc.busibase.busi.bo.QryCommodityDetailListReqBO;
import com.tydic.uoc.busibase.busi.bo.QrySkusDetailListReqBO;
import com.tydic.uoc.busibase.busi.bo.SkuDetailListInfoBO;
import com.tydic.uoc.busibase.busi.bo.SkuInfoImageBO;
import com.tydic.uoc.busibase.busi.bo.SkuInfoPriceBO;
import com.tydic.uoc.busibase.busi.bo.SkuSpecBO;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.SaleOrderInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.SalePecOrderItemIntfceBO;
import com.tydic.uoc.common.ability.bo.SkuInfoRspBO;
import com.tydic.uoc.common.atom.api.PebExtQrySkuInfoAndPriceAtomService;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceReqBO;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceRspBO;
import com.tydic.uoc.common.atom.bo.PebExtSaleOrderInfoIntfceReqBO;
import com.tydic.uoc.common.atom.bo.SaleOrderItemIntfceBO;
import com.tydic.uoc.common.atom.bo.UocPebQrySkuInfoAndPriceReqBO;
import com.tydic.uoc.common.utils.ElUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="pebExtQrySkuInfoAndPriceAtomService")
public class PebExtQrySkuInfoAndPriceAtomServiceImpl
implements PebExtQrySkuInfoAndPriceAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebExtQrySkuInfoAndPriceAtomServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private PebIntfCommodityListsAbilityService pebIntfCommodityListsAbilityService;
    private static final String SKU = "SKU";
    private static final String SPU = "SPU";
    private static final String NUM = "NUM";
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;

    @Override
    public PebExtQrySkuInfoAndPriceRspBO qrySkuInfoAndPrice(PebExtQrySkuInfoAndPriceReqBO reqBO) {
        List<PebExtSaleOrderInfoIntfceReqBO> saleOrderInfoList = reqBO.getSaleOrderInfoList();
        LinkedList<Map<Long, Object>> skuInfoMapList = new LinkedList<Map<Long, Object>>();
        for (PebExtSaleOrderInfoIntfceReqBO saleOrderInfoReqBO : saleOrderInfoList) {
            List<SaleOrderItemIntfceBO> saleOrderItemList = saleOrderInfoReqBO.getSaleOrderItemList();
            HashSet<Long> supplierShopIds = new HashSet<Long>();
            for (SaleOrderItemIntfceBO aSaleOrderItemList : saleOrderItemList) {
                supplierShopIds.add(aSaleOrderItemList.getSupplierShopId());
            }
            HashMap<Long, Map<String, Long[]>> skuInfo = new HashMap<Long, Map<String, Long[]>>();
            HashMap<Long, Map<Long, BigDecimal>> skuNum = new HashMap<Long, Map<Long, BigDecimal>>();
            for (Long supplierShopId : supplierShopIds) {
                Long[] skuIds = new Long[saleOrderItemList.size()];
                Long[] spuIds = new Long[saleOrderItemList.size()];
                HashMap<Long, BigDecimal> num = new HashMap<Long, BigDecimal>(saleOrderItemList.size());
                for (int i = 0; i < saleOrderItemList.size(); ++i) {
                    if (!saleOrderItemList.get(i).getSupplierShopId().equals(supplierShopId)) continue;
                    skuIds[i] = Long.valueOf(saleOrderItemList.get(i).getSkuId());
                    spuIds[i] = saleOrderItemList.get(i).getSpuId();
                    if (reqBO.getUseCount() == null || !reqBO.getUseCount().booleanValue()) continue;
                    num.put(Long.valueOf(saleOrderItemList.get(i).getSkuId()), saleOrderItemList.get(i).getCount());
                }
                HashMap<String, Long[]> map = new HashMap<String, Long[]>();
                map.put(SKU, skuIds);
                map.put(SPU, spuIds);
                skuNum.put(supplierShopId, num);
                skuInfo.put(supplierShopId, map);
            }
            CommodityInfoListsRspBO infoListsRspBO = this.getSpu(skuInfo, skuNum, reqBO);
            List<SkuDetailListInfoBO> results = this.getSkuList(infoListsRspBO);
            Long goodsSupplierId = saleOrderInfoReqBO.getGoodsSupplierId();
            if (!(saleOrderInfoReqBO.getCheckPrice() != null && !saleOrderInfoReqBO.getCheckPrice().booleanValue() || PecConstant.GOODSUPPLIER_SUNING.equals(saleOrderInfoReqBO.getGoodsSupplierId()) || PebExtConstant.OrderType.DA.equals(reqBO.getOrderType()))) {
                this.comparsrionJd(saleOrderItemList, results);
            }
            this.skuInfos(skuInfoMapList, infoListsRspBO, goodsSupplierId, saleOrderInfoReqBO.getAgrId(), reqBO);
        }
        PebExtQrySkuInfoAndPriceRspBO skuInfoAndPriceRspBO = new PebExtQrySkuInfoAndPriceRspBO();
        skuInfoAndPriceRspBO.setSkuInfoMapList(skuInfoMapList);
        skuInfoAndPriceRspBO.setRespCode("0000");
        skuInfoAndPriceRspBO.setRespDesc("\u6210\u529f");
        return skuInfoAndPriceRspBO;
    }

    private void validateParams(UocPebQrySkuInfoAndPriceReqBO uocPebQrySkuInfoAndPriceReqBO) {
        List<SaleOrderInfoIntfceReqBO> saleOrderInfoList = uocPebQrySkuInfoAndPriceReqBO.getSaleOrderInfoList();
        if (CollectionUtils.isEmpty(saleOrderInfoList)) {
            throw new UocProBusinessException("100002", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u8ba2\u5355\u96c6\u5408\u3010saleOrderInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SaleOrderInfoIntfceReqBO saleOrderInfoReqBO : saleOrderInfoList) {
            if (saleOrderInfoReqBO.getGoodsSupplierId() == null) {
                throw new UocProBusinessException("100002", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u8ba2\u5355\u96c6\u5408\u4e0b\u4f9b\u5e94\u5546id\u3010goodsSupplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List saleOrderItemList = saleOrderInfoReqBO.getSaleOrderItemList();
            if (CollectionUtils.isEmpty((Collection)saleOrderItemList)) {
                throw new UocProBusinessException("100002", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u8ba2\u5355\u96c6\u5408\u4e0b\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u3010saleOrderItemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (SalePecOrderItemIntfceBO saleOrderItemBO : saleOrderItemList) {
                if (saleOrderItemBO.getSkuId() == null) {
                    throw new UocProBusinessException("100002", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u8ba2\u5355\u96c6\u5408\u7684\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u4e0b\u5546\u54c1id\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (saleOrderItemBO.getSkuSalePrice() != null) continue;
                throw new UocProBusinessException("100002", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u8ba2\u5355\u96c6\u5408\u7684\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u4e0b\u5546\u54c1\u4ef7\u683c\u3010skuSalePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private CommodityInfoListsRspBO getSpu(Map<Long, Map<String, Long[]>> skuInfo, Map<Long, Map<Long, BigDecimal>> skuNum, PebExtQrySkuInfoAndPriceReqBO reqBO) {
        Set<Long> keys = skuInfo.keySet();
        ArrayList<QrySkusDetailListReqBO> detailListReqBOS = new ArrayList<QrySkusDetailListReqBO>();
        ArrayList<QryCommodityDetailListReqBO> commodityDetailListReqBOS = new ArrayList<QryCommodityDetailListReqBO>();
        for (Long key : keys) {
            QrySkusDetailListReqBO qrySkusDetailListReqBO = new QrySkusDetailListReqBO();
            qrySkusDetailListReqBO.setSupplierShopId(key);
            qrySkusDetailListReqBO.setSkuId(skuInfo.get(key).get(SKU));
            if (reqBO.getUseCount() != null && reqBO.getUseCount().booleanValue()) {
                qrySkusDetailListReqBO.setSkuInfo(skuNum.get(key));
            }
            detailListReqBOS.add(qrySkusDetailListReqBO);
            QryCommodityDetailListReqBO listReqBO = new QryCommodityDetailListReqBO();
            listReqBO.setCommodityId(skuInfo.get(key).get(SPU));
            listReqBO.setSupplierShopId(key);
            commodityDetailListReqBOS.add(listReqBO);
        }
        CommodityInfoListsReqBO uccCommodityInfoListsReqBO = new CommodityInfoListsReqBO();
        uccCommodityInfoListsReqBO.setSkusDetailListReqBOS(detailListReqBOS);
        uccCommodityInfoListsReqBO.setCommodityDetailListReqBOS(commodityDetailListReqBOS);
        uccCommodityInfoListsReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
        uccCommodityInfoListsReqBO.setParentOrgIdIn(reqBO.getParentOrgIdIn());
        uccCommodityInfoListsReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        uccCommodityInfoListsReqBO.setCity(reqBO.getCity());
        uccCommodityInfoListsReqBO.setCounty(reqBO.getCounty());
        uccCommodityInfoListsReqBO.setProvince(reqBO.getProvince());
        uccCommodityInfoListsReqBO.setTown(reqBO.getTown());
        uccCommodityInfoListsReqBO.setCompanyId(reqBO.getCompanyId());
        uccCommodityInfoListsReqBO.setIsprofess(reqBO.getIsprofess());
        uccCommodityInfoListsReqBO.setPsDiscountRate(reqBO.getPsDiscountRate());
        log.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccCommodityInfoListsReqBO));
        CommodityInfoListsRspBO rspBO = this.pebIntfCommodityListsAbilityService.queryCommodityListsInfo(uccCommodityInfoListsReqBO);
        log.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
        if (CollectionUtils.isEmpty((Collection)rspBO.getUccCommodityAndSkusDetailRspBOS())) {
            throw new UocProBusinessException("101004", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u8c03\u7528\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u670d\u52a1  \u65e0\u8fd4\u56de\u7ed3\u679c");
        }
        return rspBO;
    }

    private List<SkuDetailListInfoBO> getSkuList(CommodityInfoListsRspBO rspBO) {
        ArrayList<SkuDetailListInfoBO> list = new ArrayList<SkuDetailListInfoBO>();
        for (CommodityAndSkusDetailRspBO detailRspBO : rspBO.getUccCommodityAndSkusDetailRspBOS()) {
            List listInfoBOS = detailRspBO.getUccSkusDetailBO().getUccSkuDetailListInfoBOList();
            if (CollectionUtils.isEmpty((Collection)listInfoBOS)) continue;
            list.addAll(listInfoBOS);
        }
        return list;
    }

    private void comparsrionJd(List<SaleOrderItemIntfceBO> saleOrderItemList, List<SkuDetailListInfoBO> results) {
        HashSet<Long> skuList = new HashSet<Long>();
        HashSet<String> purList = new HashSet<String>();
        for (SaleOrderItemIntfceBO saleOrderItemBO : saleOrderItemList) {
            for (SkuDetailListInfoBO skuInfoRsp : results) {
                SkuInfoPriceBO priceBo = skuInfoRsp.getSkuInfoPrice();
                if (!saleOrderItemBO.getSkuId().equals(String.valueOf(skuInfoRsp.getSkuId()))) continue;
                BigDecimal skuSalePrice = saleOrderItemBO.getSkuSalePrice();
                BigDecimal salePrice = null;
                try {
                    salePrice = ElUtils.Long2bigDecimalMoney(priceBo.getSalePrice());
                }
                catch (Exception e) {
                    throw new UocProBusinessException("8888", "\u6821\u9a8c\u4ef7\u683c\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                if (skuSalePrice == null || salePrice == null) continue;
                if (skuSalePrice.compareTo(salePrice) != 0) {
                    if (this.isDebugEnabled.booleanValue()) {
                        log.debug("\u5546\u54c1[" + skuInfoRsp.getSkuId() + "]\u548c\u7535\u5546\u9500\u552e\u4ef7\u4e0d\u4e00\u81f4,\u5165\u53c2\u4ef7\u683c:" + skuSalePrice + " \u67e5\u8be2\u7684\u4ef7\u683c:" + salePrice);
                    }
                    skuList.add(skuInfoRsp.getSkuId());
                }
                if (salePrice.compareTo(ElUtils.Long2bigDecimalMoney(priceBo.getAgreementPrice())) >= 0) continue;
                purList.add(skuInfoRsp.getExtSkuId());
            }
        }
        if (!skuList.isEmpty()) {
            throw new UocProBusinessException("101004", "\u5546\u54c1\u7f16\u7801\u4e3a" + ((Object)skuList).toString() + "\u7684\u5546\u54c1\u4ef7\u683c\u5df2\u53d8\u5316\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u4ee5\u514d\u8bef\u4e70; \u7cfb\u7edf\u6b63\u5728\u81ea\u52a8\u66f4\u65b0\u4ef7\u683c\uff0c\u8bf7\u8fd4\u56de\u8d2d\u7269\u8f66\u786e\u8ba4\u66f4\u65b0\u540e\u7684\u5546\u54c1\u4ef7\u683c\u548c\u8ba2\u5355\u91d1\u989d\uff0c\u518d\u6b21\u63d0\u4ea4\u8ba2\u5355\uff01");
        }
        if (purList.size() > 0) {
            throw new UocProBusinessException("101004", "\u5546\u54c1\u7f16\u7801\u4e3a" + ((Object)purList).toString() + "\u7684\u5546\u54c1\u4ef7\u683c\u5df2\u53d8\u5316\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u4ee5\u514d\u8bef\u4e70; \u7cfb\u7edf\u6b63\u5728\u81ea\u52a8\u66f4\u65b0\u4ef7\u683c\uff0c\u8bf7\u8fd4\u56de\u8d2d\u7269\u8f66\u786e\u8ba4\u66f4\u65b0\u540e\u7684\u5546\u54c1\u4ef7\u683c\u548c\u8ba2\u5355\u91d1\u989d\uff0c\u518d\u6b21\u63d0\u4ea4\u8ba2\u5355\uff01");
        }
    }

    private void skuInfos(List<Map<Long, Object>> skuInfoMapList, CommodityInfoListsRspBO rspBO, Long goodsSupplierId, Long agrId, PebExtQrySkuInfoAndPriceReqBO reqBO) {
        HashMap<Long, SkuInfoRspBO> map = new HashMap<Long, SkuInfoRspBO>(15);
        for (CommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO : rspBO.getUccCommodityAndSkusDetailRspBOS()) {
            if (CollectionUtils.isEmpty((Collection)uccCommodityAndSkusDetailRspBO.getUccSkusDetailBO().getUccSkuDetailListInfoBOList())) continue;
            for (SkuDetailListInfoBO detail : uccCommodityAndSkusDetailRspBO.getUccSkusDetailBO().getUccSkuDetailListInfoBOList()) {
                SkuInfoRspBO skuInfo = new SkuInfoRspBO();
                skuInfo.setInSupplier(uccCommodityAndSkusDetailRspBO.getInSupplier());
                this.sku(detail, skuInfo, uccCommodityAndSkusDetailRspBO, goodsSupplierId, reqBO);
                LinkedList<CommodityAttrRspBO> commodityAttrList = new LinkedList<CommodityAttrRspBO>();
                if (!CollectionUtils.isEmpty((Collection)detail.getSkuSpec())) {
                    for (SkuSpecBO spuSpecBo : detail.getSkuSpec()) {
                        CommodityAttrRspBO commodityAttrRsp = new CommodityAttrRspBO();
                        commodityAttrRsp.setSkuCommodityPropGrpId(spuSpecBo.getCommodityPropGrpId());
                        commodityAttrRsp.setSkuCommoditySpecId(spuSpecBo.getSkuSpecId());
                        commodityAttrRsp.setSkuPropName(spuSpecBo.getPropName());
                        commodityAttrRsp.setSkuPropShowName(spuSpecBo.getPropShowName());
                        commodityAttrRsp.setSkuPropValue(spuSpecBo.getPropValue());
                        commodityAttrRsp.setSkuPropValueListId(spuSpecBo.getPropValueListId());
                        commodityAttrList.add(commodityAttrRsp);
                    }
                }
                skuInfo.setItemId(uccCommodityAndSkusDetailRspBO.getExtSkuId());
                skuInfo.setCommodityAttrList(commodityAttrList);
                skuInfo.setAgrId(agrId);
                skuInfo.setRejectAllow(uccCommodityAndSkusDetailRspBO.getRejectAllow());
                skuInfo.setRejectAllowDate(uccCommodityAndSkusDetailRspBO.getRejectAllowDate());
                skuInfo.setExchangeAllow(uccCommodityAndSkusDetailRspBO.getExchangeAllow());
                skuInfo.setExchangeAllowDate(uccCommodityAndSkusDetailRspBO.getExchangeAllowDate());
                skuInfo.setMaintainAllow(uccCommodityAndSkusDetailRspBO.getMaintainAllow());
                skuInfo.setMaintainAllowDate(uccCommodityAndSkusDetailRspBO.getMaintainAllowDate());
                map.put(detail.getSkuId(), skuInfo);
            }
        }
        skuInfoMapList.add(map);
    }

    private void sku(SkuDetailListInfoBO skuInfomationBo, SkuInfoRspBO out, CommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO, Long goodsSupplierId, PebExtQrySkuInfoAndPriceReqBO reqBO) {
        Integer agr;
        log.error("create sku reqBO:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        log.error("create sku skuInfomationBo:{}", (Object)JSON.toJSONString((Object)skuInfomationBo));
        SkuInfoPriceBO price = skuInfomationBo.getSkuInfoPrice();
        if (skuInfomationBo.getSkuStock() != null) {
            out.setSoldNumber(skuInfomationBo.getSkuStock().getStockNum());
        }
        if ((agr = Integer.valueOf(3)).equals(skuInfomationBo.getSkuSource())) {
            out.setTechnicalParam(skuInfomationBo.getTechnicalParam());
            out.setPartNo(skuInfomationBo.getPartNo());
        } else {
            out.setTechnicalParam(skuInfomationBo.getPartNo());
            out.setPartNo(skuInfomationBo.getTechnicalParam());
        }
        out.setMaterialRemark(skuInfomationBo.getMaterialRemark());
        out.setSourceAssort(skuInfomationBo.getSourceAssort());
        out.setContractId(skuInfomationBo.getContactId());
        out.setManufacturer(skuInfomationBo.getManufacturer());
        out.setTechnicalParameters(skuInfomationBo.getTechnicalParameter());
        out.setDomestic(skuInfomationBo.getOriginTypeDesc());
        out.setStorageAge(skuInfomationBo.getStockAge());
        out.setAgreementDetailsId(skuInfomationBo.getAgreementDetailsId());
        out.setTaxCode(skuInfomationBo.getTaxCode());
        out.setSupplierShopId(skuInfomationBo.getSupplierShopId());
        out.setAddCoefficient(skuInfomationBo.getAddCoefficient() == null ? BigDecimal.ZERO : skuInfomationBo.getAddCoefficient());
        out.setSupplierShopName(skuInfomationBo.getShopName());
        out.setServenRejectAllow(uccCommodityAndSkusDetailRspBO.getServenRejectAllow());
        out.setServenRejectAllowDesc(uccCommodityAndSkusDetailRspBO.getServenRejectAllowDesc());
        out.setSkuId(skuInfomationBo.getSkuId() + "");
        out.setSpuId(skuInfomationBo.getCommodityId());
        out.setSkuName(skuInfomationBo.getSkuName());
        out.setSkuSupplierId(goodsSupplierId);
        out.setSkuSupplierName(uccCommodityAndSkusDetailRspBO.getVendorName());
        out.setSkuMaterialId(skuInfomationBo.getMaterialId());
        out.setSkuExtSkuId(skuInfomationBo.getExtSkuId());
        out.setSkuUpcCode(skuInfomationBo.getSkuCode());
        out.setSkuCommodityTypeId(skuInfomationBo.getCommodityTypeId());
        out.setSkuLocation(skuInfomationBo.getSkuSource());
        out.setIsFactoryShip(skuInfomationBo.getIsFactoryShip());
        PebExtQrySkuInfoAndPriceAtomServiceImpl.setSkuMainPicUrl(out, skuInfomationBo, uccCommodityAndSkusDetailRspBO);
        out.setSkuStatus(skuInfomationBo.getSkuStatus());
        out.setSkuBrandName(skuInfomationBo.getBrandName());
        out.setSkuIsSupplierAgreement(skuInfomationBo.getIsSupplierAgreement());
        out.setSkuMarketPrice(ElUtils.Long2bigDecimal(price.getMarketPrice()));
        out.setSkuMemberPrice(ElUtils.Long2bigDecimal(price.getMemberPrice1()));
        if (PebExtConstant.OrderType.DA.equals(reqBO.getOrderType())) {
            out.setSkuSalePrice(ElUtils.Long2bigDecimal(price.getAgreementPrice()));
        } else {
            out.setSkuSalePrice(ElUtils.Long2bigDecimal(price.getSalePrice()));
        }
        out.setSkuAgreementPrice(ElUtils.Long2bigDecimal(price.getAgreementPrice()));
        out.setSkuCurrencyType(price.getCurrencyType() + "");
        if (StringUtils.isBlank((CharSequence)skuInfomationBo.getSalesUnitName())) {
            throw new UocProBusinessException("101004", "\u7535\u5546\u7f16\u7801\u4e3a" + skuInfomationBo.getExtSkuId() + "\u9500\u552e\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\uff01");
        }
        out.setMeasureName(skuInfomationBo.getSalesUnitName());
        out.setSettlementUnit(skuInfomationBo.getSettlementUnit());
        out.setSalesUnitRate(skuInfomationBo.getSalesUnitRate());
        out.setExtShopId(uccCommodityAndSkusDetailRspBO.getExtShopId());
        out.setExtShopName(uccCommodityAndSkusDetailRspBO.getExtShopName());
        out.setModel(skuInfomationBo.getModel());
        out.setSpec(skuInfomationBo.getSpec());
        out.setTexture(skuInfomationBo.getTexture());
        out.setFigure(skuInfomationBo.getFigure());
        out.setSupplierId(skuInfomationBo.getSupplierId());
        out.setSupplierName(skuInfomationBo.getSupplierName());
        out.setContact(uccCommodityAndSkusDetailRspBO.getContact());
        out.setRelPhone(uccCommodityAndSkusDetailRspBO.getRelPhone());
        out.setSelfSkuSupplierName(uccCommodityAndSkusDetailRspBO.getVendorName());
        out.setDeliveryTimePeriod(skuInfomationBo.getDeliveryTimePeriod());
        out.setTax(Long.valueOf(skuInfomationBo.getRate().longValue()));
        if (StringUtils.isBlank((CharSequence)skuInfomationBo.getPreDeliverDay())) {
            out.setArrivalTime(this.maxShipTime);
        } else {
            out.setArrivalTime(skuInfomationBo.getPreDeliverDay());
        }
        log.error("create sku out:{}", (Object)JSON.toJSONString((Object)out));
    }

    private static void setSkuMainPicUrl(SkuInfoRspBO out, SkuDetailListInfoBO skuInfomationBo, CommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO) {
        List list = skuInfomationBo.getSkuImags();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SkuInfoImageBO imageBo : list) {
                if (imageBo.getCommodityPicType() == null || !imageBo.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                out.setSkuMainPicUrl(imageBo.getSkuPicUrl());
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)out.getSkuMainPicUrl())) {
            List commdImageInfo = uccCommodityAndSkusDetailRspBO.getCommdImageInfo();
            if (CollectionUtils.isEmpty((Collection)commdImageInfo)) {
                return;
            }
            for (CommodityImageBO imageBo : commdImageInfo) {
                if (imageBo.getCommodityPicType() == null || !imageBo.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                out.setSkuMainPicUrl(imageBo.getCommodityPicUrl());
                break;
            }
        }
    }
}

