/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebExtPushWarehouseShipAbilityService;
import com.tydic.uoc.common.atom.api.UocCoreExtFieldInAtomService;
import com.tydic.uoc.common.atom.api.UocCoreOrderShipAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.CommonCenterFieldValueBO;
import com.tydic.uoc.common.atom.bo.ShipCruxFieldBO;
import com.tydic.uoc.common.atom.bo.ShipExtFieldBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrdSkuImeiReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipItemReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdSkuImeiMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdSkuImeiPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreOrderShipAtomService")
public class UocCoreOrderShipAtomServiceImpl
implements UocCoreOrderShipAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreOrderShipAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSkuImeiMapper ordSkuImeiMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private PebExtPushWarehouseShipAbilityService pebExtPushWarehouseShipAbilityService;

    @Override
    public UocCoreOrderShipRspBO dealCoreOrderShip(UocCoreOrderShipReqBO uocCoreOrderShipReqBO) {
        this.validataParams(uocCoreOrderShipReqBO);
        UocCoreOrderShipRspBO rspBO = new UocCoreOrderShipRspBO();
        OrdShipPO ordShipPo = new OrdShipPO();
        BeanUtils.copyProperties((Object)((Object)uocCoreOrderShipReqBO), (Object)ordShipPo);
        ordShipPo.setShipVoucherId(Long.valueOf(this.sequence.nextId()));
        if (uocCoreOrderShipReqBO.getIsStartProcess().booleanValue()) {
            UocProcessStartRspBO run = this.startProcess(ordShipPo.getShipVoucherId(), ordShipPo.getOrderId(), uocCoreOrderShipReqBO.getProcKey(), uocCoreOrderShipReqBO.getSubmit());
            ordShipPo.setShipStatus(run.getStepId());
            ordShipPo.setShipTime(new Date());
        }
        try {
            int insertResult = this.ordShipMapper.insert(ordShipPo);
            if (insertResult == 0) {
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u53d1\u8d27\u5355\u5165\u5e93\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("101059");
            rspBO.setRespDesc("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u65f6\u6570\u636e\u5e93\u5f02\u5e38!");
            log.error("\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25", (Throwable)e);
            return rspBO;
        }
        List<UocCoreShipItemReqBO> shipItemBOList = uocCoreOrderShipReqBO.getShipItemList();
        for (UocCoreShipItemReqBO shipItemBO : shipItemBOList) {
            OrdShipItemPO ordShipItemPo = new OrdShipItemPO();
            BeanUtils.copyProperties((Object)((Object)shipItemBO), (Object)ordShipItemPo);
            ordShipItemPo.setShipVoucherId(ordShipPo.getShipVoucherId());
            ordShipItemPo.setShipItemId(Long.valueOf(this.sequence.nextId()));
            ordShipItemPo.setRhCount(BigDecimal.ZERO);
            this.judgeCount(ordShipItemPo);
            try {
                int inserResult = this.ordShipItemMapper.insert(ordShipItemPo);
                if (inserResult == 0) {
                    throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
                }
            }
            catch (Exception e) {
                if (this.isDebugEnabled) {
                    log.debug("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                }
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty(shipItemBO.getOrdSkuImeiList())) {
                ArrayList<OrdSkuImeiPO> skuImeiPoList = new ArrayList<OrdSkuImeiPO>();
                for (UocCoreOrdSkuImeiReqBO ordSkuImeiRspBO : shipItemBO.getOrdSkuImeiList()) {
                    OrdSkuImeiPO ordSkuImeiPo = new OrdSkuImeiPO();
                    BeanUtils.copyProperties((Object)((Object)ordSkuImeiRspBO), (Object)ordSkuImeiPo);
                    ordSkuImeiPo.setShipItemId(ordShipItemPo.getShipItemId());
                    ordSkuImeiPo.setOrderId(ordShipItemPo.getOrderId());
                    ordSkuImeiPo.setOrdItemId(ordShipItemPo.getOrdItemId());
                    ordSkuImeiPo.setId(Long.valueOf(this.sequence.nextId()));
                    skuImeiPoList.add(ordSkuImeiPo);
                }
                this.ordSkuImeiMapper.insertBatch(skuImeiPoList);
            }
            OrdItemPO ordItemModel = new OrdItemPO();
            ordItemModel.setOrderId(uocCoreOrderShipReqBO.getOrderId());
            ordItemModel.setOrdItemId(shipItemBO.getOrdItemId());
            try {
                ordItemModel.setSendCount(shipItemBO.getSendCount());
                int updateResult = this.ordItemMapper.updateCounts(ordItemModel);
                if (updateResult != 0) continue;
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + shipItemBO.getOrdItemId() + "]\u53d1\u8d27\u6570\u91cf\u5931\u8d25");
            }
            catch (Exception e) {
                if (this.isDebugEnabled) {
                    log.debug("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u6216\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u53d1\u8d27\u6570\u91cf\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                }
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u6216\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u53d1\u8d27\u6570\u91cf\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        if (uocCoreOrderShipReqBO.getCruxFieldList() != null || uocCoreOrderShipReqBO.getExtFieldList() != null) {
            UocCoreExtFieldInRspBO uocCoreExtFieldInRspBO;
            UocCoreExtFieldInReqBO uocCoreExtFieldInReqBO = new UocCoreExtFieldInReqBO();
            uocCoreExtFieldInReqBO.setObjId(ordShipPo.getShipVoucherId());
            uocCoreExtFieldInReqBO.setObjType(Integer.valueOf("3"));
            uocCoreExtFieldInReqBO.setOrderId(uocCoreOrderShipReqBO.getOrderId());
            if (uocCoreOrderShipReqBO.getCruxFieldList() != null) {
                ArrayList<CommonCenterFieldValueBO> cruxFieldValueBOList = new ArrayList<CommonCenterFieldValueBO>();
                for (ShipCruxFieldBO shipCruxFieldBO : uocCoreOrderShipReqBO.getCruxFieldList()) {
                    CommonCenterFieldValueBO cruxFieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)shipCruxFieldBO, (Object)cruxFieldValueBO);
                    cruxFieldValueBOList.add(cruxFieldValueBO);
                }
                uocCoreExtFieldInReqBO.setCruFieldList(cruxFieldValueBOList);
            }
            if (uocCoreOrderShipReqBO.getExtFieldList() != null) {
                ArrayList<CommonCenterFieldValueBO> extFieldValueBOList = new ArrayList<CommonCenterFieldValueBO>();
                for (ShipExtFieldBO shipExtFieldBO : uocCoreOrderShipReqBO.getExtFieldList()) {
                    CommonCenterFieldValueBO extFieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)shipExtFieldBO, (Object)extFieldValueBO);
                    extFieldValueBOList.add(extFieldValueBO);
                }
                uocCoreExtFieldInReqBO.setExtFieldList(extFieldValueBOList);
            }
            if (!"0000".equals((uocCoreExtFieldInRspBO = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(uocCoreExtFieldInReqBO)).getRespCode())) {
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + uocCoreExtFieldInRspBO.getRespDesc());
            }
        }
        rspBO.setShipVoucherId(ordShipPo.getShipVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u53d1\u8d27\u5355\u3001\u53d1\u8d27\u5355\u660e\u7ec6\u6210\u529f");
        return rspBO;
    }

    private void validataParams(UocCoreOrderShipReqBO uocCoreOrderShipReqBO) {
        if (uocCoreOrderShipReqBO.getOrderId() == null || uocCoreOrderShipReqBO.getOrderId() == 0L) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)uocCoreOrderShipReqBO.getShipStatus())) {
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u72b6\u6001[shipStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uocCoreOrderShipReqBO.getShipItemList() == null || uocCoreOrderShipReqBO.getShipItemList().isEmpty()) {
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868[shipItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCoreShipItemReqBO uocCoreShipItemReqBO : uocCoreOrderShipReqBO.getShipItemList()) {
            if (uocCoreShipItemReqBO.getOrdItemId() == null || uocCoreShipItemReqBO.getOrdItemId() == 0L) {
                throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u9500\u552e\u8ba2\u5355\u660e\u7ec6ID[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uocCoreShipItemReqBO.getOrderId() != null && uocCoreShipItemReqBO.getOrderId() != 0L) continue;
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocProcessStartRspBO startProcess(Long objId, Long orderId, String procKey, String submit) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        if (StringUtils.isNotBlank((CharSequence)procKey)) {
            processStartReqBO.setProcDefKey(procKey);
        } else {
            processStartReqBO.setProcDefKey("status_of_invoice");
        }
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        processStartReqBO.setOrderId(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        if (StringUtils.isNotBlank((CharSequence)submit)) {
            map.put("submit", submit);
        }
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101059", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO.toString() + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
        return processStartRspBO;
    }

    private void judgeCount(OrdShipItemPO ordShipItemPO) {
        if (null == ordShipItemPO.getSendCount()) {
            ordShipItemPO.setSendCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getArriveCount()) {
            ordShipItemPO.setArriveCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getRefuseCount()) {
            ordShipItemPO.setRefuseCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getReturnCount()) {
            ordShipItemPO.setReturnCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getAcceptanceCount()) {
            ordShipItemPO.setAcceptanceCount(new BigDecimal(0));
        }
    }
}

