/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocProDicValueConstants;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocProInspectionConfigAtomService;
import com.tydic.uoc.common.atom.bo.UocProQryCommodityTypeReqBo;
import com.tydic.uoc.common.atom.bo.UocProQryCommodityTypeRspBo;
import com.tydic.uoc.common.atom.bo.UocProQryInspectionConfigReqBo;
import com.tydic.uoc.common.atom.bo.UocProQryInspectionConfigRspBo;
import com.tydic.uoc.common.atom.bo.UocProQrySkuInspectionConfigRspBo;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.UocConfInspectionMapper;
import com.tydic.uoc.dao.UocConfInspectionUseMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.UocConfInspectionPo;
import com.tydic.uoc.po.UocConfInspectionUsePo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocProInspectionConfigAtomServiceImpl
implements UocProInspectionConfigAtomService {
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private UocConfInspectionMapper uocConfInspectionMapper;
    @Autowired
    private UocConfInspectionUseMapper uocConfInspectionUseMapper;

    @Override
    public UocProQryCommodityTypeRspBo qryCommodityTypes(UocProQryCommodityTypeReqBo reqBo) {
        this.validateQryCommodityArgs(reqBo);
        UocProQryCommodityTypeRspBo rspBo = (UocProQryCommodityTypeRspBo)UocProRspBoUtil.success(UocProQryCommodityTypeRspBo.class);
        OrdGoodsPO qryPo = new OrdGoodsPO();
        qryPo.setOrdItemIdList(reqBo.getOrdItems());
        qryPo.setOrderId(reqBo.getOrderId());
        List list = this.ordGoodsMapper.getList(qryPo);
        Map<Long, String> ordItemMap = list.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, po -> po.getSkuCommodityTypeId().toString()));
        rspBo.setCommodityTypes(ordItemMap);
        return rspBo;
    }

    @Override
    public UocProQryInspectionConfigRspBo qryInspection(UocProQryInspectionConfigReqBo reqBo) {
        List uocConfInspectionPos;
        Integer busiType = reqBo.getBusiType();
        UocProQryInspectionConfigRspBo rspBo = (UocProQryInspectionConfigRspBo)UocProRspBoUtil.success(UocProQryInspectionConfigRspBo.class);
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        rspBo.setCommodityTypes(retMap);
        UocConfInspectionUsePo useConfig = this.uocConfInspectionUseMapper.selectByPrimaryKey(busiType);
        if (useConfig == null) {
            return rspBo;
        }
        Integer inspectionType = useConfig.getInspectionType();
        UocConfInspectionPo qryPo = new UocConfInspectionPo();
        qryPo.setInspectionType(inspectionType);
        List<String> commodityTypes = reqBo.getCommodityTypes();
        qryPo.setBusiType(busiType);
        if (!ObjectUtil.isEmpty(commodityTypes) && UocProDicValueConstants.INSPECTION_TYPE_COMMODITY.equals(inspectionType)) {
            qryPo.setCommodityTypes(commodityTypes);
        }
        if (ObjectUtil.isEmpty((Object)(uocConfInspectionPos = this.uocConfInspectionMapper.qryList(qryPo)))) {
            return rspBo;
        }
        if (UocProDicValueConstants.INSPECTION_TYPE_ALL.equals(inspectionType)) {
            Integer excessPercent = ((UocConfInspectionPo)uocConfInspectionPos.get(0)).getExcessPercent();
            for (String commodityType : commodityTypes) {
                retMap.put(commodityType, excessPercent);
            }
        } else {
            rspBo.setCommodityTypes(uocConfInspectionPos.stream().collect(Collectors.toMap(UocConfInspectionPo::getCommodityType, UocConfInspectionPo::getExcessPercent)));
        }
        return rspBo;
    }

    @Override
    public UocProQrySkuInspectionConfigRspBo qrySkuInspections(UocProQryCommodityTypeReqBo reqBo) {
        UocProQrySkuInspectionConfigRspBo rspBo = (UocProQrySkuInspectionConfigRspBo)UocProRspBoUtil.success(UocProQrySkuInspectionConfigRspBo.class);
        if (PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_STORE.equals(reqBo.getBusiType()) || PecConstant.ORDER_SOURCE.INQUIRY_PRICE_A_SINGLE_PURCHASE.equals(reqBo.getBusiType())) {
            return rspBo;
        }
        UocProQryCommodityTypeRspBo qryCommodityTypeRspBo = this.qryCommodityTypes(reqBo);
        if (!"0000".equals(qryCommodityTypeRspBo.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u5931\u8d25\uff1a" + qryCommodityTypeRspBo.getRespDesc());
        }
        Map<Long, String> commodityTypes = qryCommodityTypeRspBo.getCommodityTypes();
        UocProQryInspectionConfigReqBo qryInspectReq = new UocProQryInspectionConfigReqBo();
        qryInspectReq.setBusiType(reqBo.getBusiType());
        qryInspectReq.setCommodityTypes(new ArrayList<String>(commodityTypes.values()));
        UocProQryInspectionConfigRspBo uocProQryInspectionConfigRspBo = this.qryInspection(qryInspectReq);
        if (!"0000".equals(uocProQryInspectionConfigRspBo.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u5546\u54c1\u8d85\u9a8c\u914d\u7f6e\u5931\u8d25\uff1a" + uocProQryInspectionConfigRspBo.getRespDesc());
        }
        Map<String, Integer> commodityInspections = uocProQryInspectionConfigRspBo.getCommodityTypes();
        List<Long> ordItems = reqBo.getOrdItems();
        for (Long ordItem : ordItems) {
            Integer inspectExpress = commodityInspections.get(commodityTypes.get(ordItem));
            inspectExpress = inspectExpress == null ? 0 : inspectExpress;
            rspBo.getCommodityTypes().put(ordItem, inspectExpress);
        }
        return rspBo;
    }

    private void validateQryCommodityArgs(UocProQryCommodityTypeReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("101062", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("101062", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

