/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseShipAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseShipBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipBusiRspBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushWarehouseShipBusiServiceImpl
implements PebExtPushWarehouseShipBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseShipBusiServiceImpl.class);
    @Autowired
    private PebExtPushWarehouseShipAtomService pebExtPushWarehouseShipAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @Override
    public PebExtPushWarehouseShipBusiRspBO dealPushWarehouseShip(PebExtPushWarehouseShipBusiReqBO reqBO) {
        PebExtPushWarehouseShipBusiRspBO rspBO = new PebExtPushWarehouseShipBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getShipVoucherId());
        pushLogPO.setType(UocConstant.WarehousePushType.SHIP_ORDER);
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLogPO = this.uocOrdWarehouseLogMapper.getModelBy(pushLogPO);
        if (pushLogPO != null) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        this.dealPush(reqBO, rspBO);
        return rspBO;
    }

    private void dealPush(PebExtPushWarehouseShipBusiReqBO reqBO, PebExtPushWarehouseShipBusiRspBO rspBO) {
        UocOrdWarehouseLogPO pushLogPO = this.buildPushLog(reqBO, reqBO.getReqData());
        PebExtPushWarehouseShipAtomReqBO atomReqBO = new PebExtPushWarehouseShipAtomReqBO();
        atomReqBO.setData(reqBO.getReqData());
        atomReqBO.setSupplierId(reqBO.getSupplierId());
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        PebExtPushWarehouseShipAtomRspBO atomRspBO = this.pebExtPushWarehouseShipAtomService.pushWarehouseShip(atomReqBO);
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO.setShipVoucherId(reqBO.getShipVoucherId());
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            ordShipPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        } else {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            ordShipPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        }
        this.ordShipMapper.updateById(ordShipPO);
        pushLogPO.setRespData(atomRspBO.getRspData());
        this.uocOrdWarehouseLogMapper.insert(pushLogPO);
    }

    private UocOrdWarehouseLogPO buildPushLog(PebExtPushWarehouseShipBusiReqBO reqBO, String reqData) {
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getShipVoucherId());
        pushLogPO.setReqData(JSONObject.toJSONString((Object)reqData));
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setType(UocConstant.WarehousePushType.SHIP_ORDER);
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        pushLogPO.setReqData(reqData);
        return pushLogPO;
    }
}

