/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryAbilityService;
import com.tydic.uoc.busibase.busi.bo.MemDetailInfoBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryReqBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.PebSmRhDetailReqBO;
import com.tydic.uoc.common.ability.bo.PebSmRhDetailRspBO;
import com.tydic.uoc.common.busi.api.PebSmRhDetailBusiService;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdErpLogMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdInterLogPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebSmRhDetailBusiServiceImpl
implements PebSmRhDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebSmRhDetailBusiServiceImpl.class);
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${SUPPLIER_JD_ID}")
    private String jdId;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${uoc.erp.rh.url:http://}")
    private String rhUrl;
    @Autowired
    private OrdErpLogMapper ordErpLogMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;

    @Override
    public PebSmRhDetailRspBO dealSmRh(PebSmRhDetailReqBO reqBO) {
        OrdItemPO itemPO;
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        MemDetailQueryReqBO umc = new MemDetailQueryReqBO();
        umc.setUserIdWeb(reqBO.getUserId());
        MemDetailQueryRspBO rspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(umc);
        if (rspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        MemDetailInfoBO memDetailInfoBO = rspBO.getUmcMemDetailInfoAbilityRspBO();
        UmcMemDetailQueryAbilityReqBO abilityReqBO = new UmcMemDetailQueryAbilityReqBO();
        abilityReqBO.setTreePath(memDetailInfoBO.getOrgTreePath());
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        boolean ispPorder = false;
        List list = null;
        OrdCruxMapPO cruxMapPO = null;
        if (orderPO.getUpperOrderId() != null) {
            cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(orderPO.getUpperOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
            if (cruxMapPO != null) {
                ispPorder = true;
                salePO = new OrdSalePO();
                salePO.setOrderId(orderPO.getUpperOrderId());
                salePO = this.ordSaleMapper.getModelBy(salePO);
                itemPO = new OrdItemPO();
                itemPO.setOrderId(orderPO.getUpperOrderId());
                list = this.ordItemMapper.getItemIds(itemPO);
            }
        }
        if (cruxMapPO == null) {
            cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(orderPO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
            itemPO = new OrdItemPO();
            itemPO.setOrderId(orderPO.getOrderId());
            list = this.ordItemMapper.getItemIds(itemPO);
        }
        int i = 0;
        HashMap<Long, String> num = new HashMap<Long, String>();
        for (OrdItemPO itemPO2 : list) {
            num.put(itemPO2.getOrdItemId(), ++i + "");
        }
        Map<String, List<OrdItemRspBO>> map = reqBO.getItemInfo().stream().collect(Collectors.groupingBy(OrdItemRspBO::getRealOrganizationId));
        JSONObject erp = new JSONObject();
        JSONArray array = new JSONArray();
        StringBuilder remark = new StringBuilder();
        erp.put("REC_INFO", (Object)array);
        erp.put("PBATCH_ID", (Object)(this.idUtil.nextId() + ""));
        for (String key : map.keySet()) {
            Integer headerId = (Integer)this.cacheService.get("UOC_RH_HEADER_ID");
            if (headerId == null) {
                headerId = 1;
                this.cacheService.set("UOC_RH_HEADER_ID", (Object)1);
            } else {
                this.cacheService.set("UOC_RH_HEADER_ID", (Object)(headerId + 1));
            }
            JSONObject header = new JSONObject();
            header.put("HEADER_ID", (Object)(headerId + ""));
            header.put("DOC_NUM", (Object)("YG" + headerId));
            remark.append(",").append(header.getString("DOC_NUM")).append(",");
            header.put("VENDOR_NUMBER", (Object)zmInfoPO.getSupplierErpNo());
            header.put("VENDOR_NAME", (Object)zmInfoPO.getSupplierName());
            header.put("ORGANIZATION_ID", (Object)key);
            header.put("CREATED_BY_ID", (Object)memDetailInfoBO.getAgentAccount());
            header.put("MAKER_ID", (Object)memDetailInfoBO.getAgentAccount());
            header.put("MAKER_NAME", (Object)reqBO.getName());
            header.put("CREATED_USER_NAME", (Object)memDetailInfoBO.getAgentAccount());
            header.put("MAKER_DATE", (Object)DateUtils.dateToStrLong((Date)new Date()));
            header.put("UPDATED_USER_NAME", (Object)memDetailInfoBO.getAgentAccount());
            header.put("ORG_ID", (Object)zmInfoPO.getBuynerErpNo());
            header.put("RECEIPT_DATE", (Object)DateUtils.dateToStrLong((Date)new Date()));
            header.put("PROCESS_TYPE", (Object)"ONLINE");
            header.put("TYPE", (Object)"SJQS");
            header.put("BATCH_NAME", (Object)String.valueOf(headerId));
            JSONArray items = new JSONArray();
            for (OrdItemRspBO ordItemRspBO : map.get(key)) {
                JSONObject mat = new JSONObject();
                Integer lineId = (Integer)this.cacheService.get("UOC_RH_LINE_ID");
                if (lineId == null) {
                    lineId = 1;
                    this.cacheService.set("UOC_RH_LINE_ID", (Object)1);
                } else {
                    this.cacheService.set("UOC_RH_LINE_ID", (Object)(lineId + 1));
                }
                mat.put("LINE_ID", (Object)(lineId + ""));
                mat.put("ITEM_NO", (Object)ordItemRspBO.getSkuMaterialId());
                mat.put("ITEM_DESC", (Object)ordItemRspBO.getExtField2());
                mat.put("UOM", (Object)ordItemRspBO.getUnitName());
                mat.put("QUANTITY", (Object)(ordItemRspBO.getRhCount() + ""));
                mat.put("SUBINV_CODE", (Object)ordItemRspBO.getSubinvCode());
                mat.put("LOCATOR_ID", (Object)ordItemRspBO.getLocatorId());
                mat.put("LOCATOR_CODE", (Object)ordItemRspBO.getLocatorCode());
                BigDecimal tax = new BigDecimal((float)ordItemRspBO.getTax().longValue() / 100.0f + "");
                BigDecimal nakePrice = ordItemRspBO.getSaleDecimalPrice().divide(tax.add(BigDecimal.ONE), 8, 4);
                BigDecimal tatol = nakePrice.multiply(ordItemRspBO.getRhCount()).setScale(2, 4);
                mat.put("UNIT_PRICE", (Object)(nakePrice + ""));
                mat.put("AMOUNT", (Object)(tatol + ""));
                mat.put("BASE_UNIT_PRICE", (Object)(nakePrice + ""));
                mat.put("BASE_AMOUNT", (Object)(tatol + ""));
                mat.put("PO_NUMBER", (Object)salePO.getSaleVoucherNo());
                mat.put("PO_HEADER_ID", (Object)cruxMapPO.getFieldValue22());
                if (ispPorder) {
                    mat.put("PO_LINE_NUM", num.get(Long.valueOf(ordItemRspBO.getLmOrderId())));
                    mat.put("LINE_ATTRIBUTE4", (Object)(ordItemRspBO.getLmOrderId() + ""));
                } else {
                    mat.put("PO_LINE_NUM", num.get(ordItemRspBO.getOrdItemId()));
                    mat.put("LINE_ATTRIBUTE4", (Object)(String.valueOf(ordItemRspBO.getOrdItemId()) + ""));
                }
                mat.put("SERIAL_NUMBER_CONTROL_CODE", (Object)"1");
                mat.put("LOT_CONTROL_CODE", (Object)"1");
                mat.put("SHIP_TO_LOCATION_ID", (Object)zmInfoPO.getConsigneeId());
                mat.put("SHIP_TO_LOCATION_CODE", (Object)zmInfoPO.getConsignee());
                items.add((Object)mat);
            }
            header.put("REC_LINE_INFO", (Object)items);
            array.add((Object)header);
        }
        log.error("\u5165\u5e93\u53c2\u6570\uff1a" + erp.toJSONString());
        String strResult = HttpUtil.doPost(this.rhUrl, erp.toJSONString());
        log.error("\u5165\u5e93\u51fa\u6570\uff1a" + strResult);
        if (strResult == null) {
            throw new UocProBusinessException("8888", "\u8c03\u7528erp\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        JSONObject result = JSONObject.parseObject((String)strResult);
        PebSmRhDetailRspBO detailRspBO = new PebSmRhDetailRspBO();
        if (!"S000A000".equals(result.getString("ERP_STATUS"))) {
            this.saveLog(reqBO.getOrderId(), strResult, erp.toJSONString(), "ERP_RH", "8888", "", UocConstant.OBJ_TYPE.SALE);
            detailRspBO.setRespCode("8888");
            detailRspBO.setRespDesc(result.getString("ERP_MSG"));
            return detailRspBO;
        }
        this.saveLog(reqBO.getOrderId(), strResult, erp.toJSONString(), "ERP_RH", "0000", "", UocConstant.OBJ_TYPE.SALE);
        detailRspBO.setRespCode("0000");
        detailRspBO.setRespDesc("\u6210\u529f");
        detailRspBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        this.saveAccessory(reqBO, reqBO.getOrderId(), remark.toString());
        return detailRspBO;
    }

    private void saveAccessory(PebSmRhDetailReqBO reqBO, Long orderId, String remark) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (OrdAccessoryRspBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.RH);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark(remark);
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void saveLog(Long orderId, String out, String in, String interCode, String code, String detail, Integer objType) {
        OrdInterLogPO logBO = new OrdInterLogPO();
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(interCode);
        logBO.setInterSn("1");
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setId(Long.valueOf(this.idUtil.nextId()));
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(code);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setObjType(objType);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        logBO.setErrDetail(detail);
        try {
            this.ordErpLogMapper.insert(logBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

