/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.umc.general.ability.api.UmcQryWaitDoneConfigListAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryWaitDoneConfigListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryWaitDoneConfigListAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcWaitDoneConfigBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.ability.enums.TodoWaitTypeEnum;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebTodoPushWaitBusiServiceImpl
implements PebTodoPushWaitBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebTodoPushWaitBusiServiceImpl.class);
    @Autowired
    private UmcQryWaitDoneConfigListAbilityService umcQryWaitDoneConfigListAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    private static final String SYSTEM_CODE = "1";
    private static final String CENTER_CODE = "order";
    private static final Integer PAGE_SIZE = 999;

    @Override
    public PebTodoPushWaitBusiRspBO pushTodoWait(PebTodoPushWaitBusiReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        reqBO.setSaleVoucherNo(ordSalePO.getSaleVoucherNo());
        reqBO.setObjType(StringUtils.isNotBlank((String)reqBO.getBusiCode()) ? UocConstant.APPROVAL_OBJ_TYPE.ACTPEB008 : UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        if (StringUtils.isBlank((String)reqBO.getBusiCode())) {
            if ("2".equals(ordSalePO.getOrderSource())) {
                reqBO.setBusiCode(TodoWaitTypeEnum.EC_TYPE.getCode());
                reqBO.setExt2(ordSalePO.getSaleVoucherNo().split("-")[0]);
                reqBO.setExt3("2");
            }
            if (SYSTEM_CODE.equals(ordSalePO.getOrderSource())) {
                reqBO.setBusiCode(TodoWaitTypeEnum.AGR_TYPE.getCode());
            }
            if ("3".equals(ordSalePO.getOrderSource())) {
                reqBO.setBusiCode(TodoWaitTypeEnum.CAI_TYPE.getCode());
                reqBO.setExt3("13");
            }
            if ("4".equals(ordSalePO.getOrderSource())) {
                reqBO.setBusiCode(TodoWaitTypeEnum.CON_TYPE.getCode());
            }
        }
        this.qryWaitDoneConfig(reqBO);
        if (ApproveTypeEnum.COMMIT_APPROVE.getCode().equals(reqBO.getApproveType())) {
            this.addWaitDone(reqBO);
        } else if (ApproveTypeEnum.APPROVE.getCode().equals(reqBO.getApproveType())) {
            this.addAlreadyDone(reqBO);
            this.cancelWaitDone(reqBO);
            if (Objects.nonNull(reqBO.getFinishYn()) && !reqBO.getFinishYn().booleanValue()) {
                this.addWaitDone(reqBO);
            }
        } else {
            this.cancelWaitDone(reqBO);
        }
        return new PebTodoPushWaitBusiRspBO();
    }

    private void qryWaitDoneConfig(PebTodoPushWaitBusiReqBO reqBO) {
        UmcQryWaitDoneConfigListAbilityReqBO umcQryWaitDoneConfigListAbilityReqBO = new UmcQryWaitDoneConfigListAbilityReqBO();
        umcQryWaitDoneConfigListAbilityReqBO.setCenter(CENTER_CODE);
        umcQryWaitDoneConfigListAbilityReqBO.setPageSize(PAGE_SIZE);
        UmcQryWaitDoneConfigListAbilityRspBO umcQryWaitDoneConfigListAbilityRspBO = this.umcQryWaitDoneConfigListAbilityService.qryWaitDoneList(umcQryWaitDoneConfigListAbilityReqBO);
        if (!"0000".equals(umcQryWaitDoneConfigListAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(umcQryWaitDoneConfigListAbilityRspBO.getRespDesc());
        }
        List umcWaitDoneConfigBOS = umcQryWaitDoneConfigListAbilityRspBO.getRows();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)umcWaitDoneConfigBOS)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01center:order");
        }
        Map<String, String> waitDoneConfigMap = umcWaitDoneConfigBOS.stream().collect(Collectors.toMap(UmcWaitDoneConfigBO::getItemCode, UmcWaitDoneConfigBO::getItemName, (k1, k2) -> k1));
        if (!waitDoneConfigMap.containsKey(reqBO.getBusiCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01item_code:" + reqBO.getBusiCode());
        }
        reqBO.setBusiName(waitDoneConfigMap.get(reqBO.getBusiCode()));
    }

    private void addWaitDone(PebTodoPushWaitBusiReqBO uocTodoBO) {
        TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
        todoAddWaitDoneAbilityReqBO.setCenterCode(CENTER_CODE);
        todoAddWaitDoneAbilityReqBO.setBusiCode(uocTodoBO.getBusiCode());
        todoAddWaitDoneAbilityReqBO.setBusiName(uocTodoBO.getBusiName());
        todoAddWaitDoneAbilityReqBO.setSystemCode(SYSTEM_CODE);
        todoAddWaitDoneAbilityReqBO.setOperatorId(uocTodoBO.getOperatorId());
        todoAddWaitDoneAbilityReqBO.setOperatorName(uocTodoBO.getOperatorName());
        todoAddWaitDoneAbilityReqBO.setExt1(uocTodoBO.getSaleVoucherNo());
        if (StringUtils.isNotBlank((String)uocTodoBO.getExt2())) {
            todoAddWaitDoneAbilityReqBO.setExt2(uocTodoBO.getExt2());
        }
        uocTodoBO.setNextStationId(this.uocTodoCombService.getNextStationId(uocTodoBO.getSaleVoucherId(), uocTodoBO.getObjType()));
        List<UserBO> userBOList = this.uocTodoCombService.qryDealApprovalPersons(uocTodoBO.getNextStationId(), uocTodoBO.getOrgId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(userBOList)) {
            throw new ZTBusinessException("\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u5f85\u5ba1\u6279\u7528\u6237" + uocTodoBO.getSaleVoucherId());
        }
        ArrayList waitDoneList = new ArrayList();
        userBOList.forEach(e -> {
            TodoAddWaitDoneAbilityParamBO paramBO = new TodoAddWaitDoneAbilityParamBO();
            paramBO.setObjId(uocTodoBO.getSaleVoucherId() + "");
            paramBO.setObjNo(uocTodoBO.getSaleVoucherNo());
            paramBO.setHandleUserNo(e.getLoginName());
            paramBO.setHandleUserName(e.getName());
            waitDoneList.add(paramBO);
        });
        todoAddWaitDoneAbilityReqBO.setWaitDoneList(waitDoneList);
        log.info("\u65b0\u589e\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
        TodoAddWaitDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
        log.info("\u65b0\u589e\u5f85\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)todoRspBO));
        if (Objects.isNull(todoRspBO)) {
            log.error("\u65b0\u589e\u5f85\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
        }
    }

    private void addAlreadyDone(PebTodoPushWaitBusiReqBO uocTodoBO) {
        TodoAddAlreadyDoneAbilityReqBO todoReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoReqBO.setCenterCode(CENTER_CODE);
        todoReqBO.setBusiCode(uocTodoBO.getBusiCode());
        todoReqBO.setOperatorId(uocTodoBO.getOperatorId());
        todoReqBO.setOperatorName(uocTodoBO.getOperatorName());
        todoReqBO.setHandleUserNo(uocTodoBO.getOperatorNo());
        TodoAddAlreadyDoneAbilityParamBO todoParamBO = new TodoAddAlreadyDoneAbilityParamBO();
        todoParamBO.setObjId(uocTodoBO.getSaleVoucherId() + "");
        todoParamBO.setAuditStatus(uocTodoBO.getAuditStatus());
        todoParamBO.setAuditRemark(uocTodoBO.getAuditRemark());
        todoParamBO.setFinishYn(uocTodoBO.getFinishYn());
        todoParamBO.setFinishTime(uocTodoBO.getFinishTime());
        todoReqBO.setDoneList(Collections.singletonList(todoParamBO));
        log.info("\u65b0\u589e\u5df2\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoReqBO));
        TodoAddAlreadyDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoReqBO);
        log.info("\u65b0\u589e\u5df2\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)todoRspBO));
        if (Objects.isNull(todoRspBO)) {
            log.error("\u65b0\u589e\u5df2\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
        }
        if (!"0000".equals(todoRspBO.getRespCode())) {
            log.error("\u65b0\u589e\u5df2\u529e\u5931\u8d25\uff01" + todoRspBO.getRespDesc());
        }
    }

    public Long getNextStationId(PebTodoPushWaitBusiReqBO reqBO) {
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setObjId(String.valueOf(reqBO.getSaleVoucherId()));
        uacQryAuditLogReqBO.setObjType(Integer.valueOf(2));
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u5ba1\u6279\u6570\u636e" + reqBO.getSaleVoucherId());
        }
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        String nextStationId = ((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0)).getNextStationId();
        return Long.parseLong(nextStationId);
    }

    private void cancelWaitDone(PebTodoPushWaitBusiReqBO uocTodoBO) {
        List<UserBO> userBOList;
        if (uocTodoBO.getStationId() == null) {
            uocTodoBO.setStationId(this.uocTodoCombService.getNextStationId(uocTodoBO.getSaleVoucherId(), uocTodoBO.getObjType()));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(userBOList = this.uocTodoCombService.qryDealApprovalPersons(uocTodoBO.getStationId(), uocTodoBO.getOrgId()))) {
            log.error("UocTodoConsumer: \u6839\u636e\u5c97\u4f4d\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u4eba\u5458\u4fe1\u606f\uff1a\u5c97\u4f4d\u7f16\u7801\uff1a{}\uff0c \u673a\u6784\u7f16\u7801\uff1a{}", (Object)uocTodoBO.getNextStationId(), (Object)uocTodoBO.getOrgId());
        }
        TodoCancelWaitDoneAbilityReqBO todoReqBO = new TodoCancelWaitDoneAbilityReqBO();
        todoReqBO.setCenterCode(CENTER_CODE);
        todoReqBO.setBusiCode(uocTodoBO.getBusiCode());
        todoReqBO.setOperatorId(uocTodoBO.getOperatorId());
        todoReqBO.setOperatorName(uocTodoBO.getOperatorName());
        ArrayList cancelList = new ArrayList();
        userBOList.forEach(e -> {
            if (Objects.nonNull(uocTodoBO.getOperatorNo()) && uocTodoBO.getOperatorNo().equals(e.getLoginName())) {
                return;
            }
            TodoCancelWaitDoneAbilityParamBO paramBO = new TodoCancelWaitDoneAbilityParamBO();
            paramBO.setObjId(uocTodoBO.getSaleVoucherId() + "");
            paramBO.setHandleUserNo(e.getLoginName());
            cancelList.add(paramBO);
        });
        todoReqBO.setCancelList(cancelList);
        log.info("\u53d6\u6d88\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoReqBO));
        TodoCancelWaitDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.cancelWaitDone(todoReqBO);
        log.info("\u53d6\u6d88\u5f85\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)todoRspBO));
        if (Objects.isNull(todoRspBO)) {
            log.error("\u53d6\u6d88\u5f85\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
        }
        if (!"0000".equals(todoRspBO.getRespCode())) {
            log.error("\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff01" + todoRspBO.getRespDesc());
        }
    }

    private List<UserBO> qryDealApprovalPersons(Long stationId, Long orgId) {
        if (Objects.nonNull(stationId)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(stationId);
            dycStationOrgSelectUserNameReqBO.setOrgIdWeb(orgId);
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                return dycStationOrgSelectUserNameRspBO.getUserList();
            }
        }
        return new ArrayList<UserBO>();
    }
}

