/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.UocBigOrderAutoCreateBusiService;
import com.tydic.uoc.common.busi.bo.UocBigOrderAutoCreateBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocBigOrderAutoCreateBusiRspBO;
import com.tydic.uoc.dao.UocBigConfigMapper;
import com.tydic.uoc.dao.UocBigOrderMapper;
import com.tydic.uoc.po.UocBigConfigPO;
import com.tydic.uoc.po.UocBigOrderPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocBigOrderAutoCreateBusiServiceImpl
implements UocBigOrderAutoCreateBusiService {
    @Autowired
    private UocBigConfigMapper uocBigConfigMapper;
    @Value(value="${uoc.big.max:2000}")
    private Integer maxSize;
    @Autowired
    private UocBigOrderMapper uocBigOrderMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public UocBigOrderAutoCreateBusiRspBO createBigOrderAuto(UocBigOrderAutoCreateBusiReqBO reqBO) {
        Date createTimeStart = null;
        Date createTimeEnd = null;
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        UocBigConfigPO uocBigConfigPO = new UocBigConfigPO();
        uocBigConfigPO.setMergePushDay(Integer.valueOf(calendar.get(5)));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        createTimeEnd = calendar.getTime();
        calendar.add(2, -1);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        createTimeStart = calendar.getTime();
        uocBigConfigPO.setCreateTimeStart(createTimeStart);
        uocBigConfigPO.setCreateTimeEnd(createTimeEnd);
        uocBigConfigPO.setMergePushType(UocConstant.MergePushType.AUTO);
        List uocBigConfigPOList = this.uocBigConfigMapper.getList(uocBigConfigPO);
        ArrayList<UocBigOrderPO> uocBigOrderPOList = new ArrayList<UocBigOrderPO>();
        ArrayList<PebDealOrderBO> sale = new ArrayList<PebDealOrderBO>();
        if (!CollectionUtils.isEmpty((Collection)uocBigConfigPOList)) {
            for (UocBigConfigPO configPO : uocBigConfigPOList) {
                PebDealOrderBO orderBO = new PebDealOrderBO();
                orderBO.setOrderId(configPO.getOrderId());
                orderBO.setSaleVoucherId(configPO.getSaleId());
                sale.add(orderBO);
            }
            Map<Long, List<UocBigConfigPO>> vendorSiteMap = uocBigConfigPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getVendorSiteId));
            for (Long vendorSiteId : vendorSiteMap.keySet()) {
                List<UocBigConfigPO> vendorSiteBigConfigPOList = vendorSiteMap.get(vendorSiteId);
                Map<String, List<UocBigConfigPO>> buynerMap = vendorSiteBigConfigPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getBuynerNo));
                for (String buynerNo : buynerMap.keySet()) {
                    List<UocBigConfigPO> bigConfigPOList = buynerMap.get(buynerNo);
                    Map<Integer, List<UocBigConfigPO>> ruleMap = bigConfigPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getMergePushRule));
                    for (Integer rule : ruleMap.keySet()) {
                        List<UocBigConfigPO> configPOList = ruleMap.get(rule);
                        if (UocConstant.MergePushRule.BUYNER.equals(rule)) {
                            this.dealCreateAuto(configPOList, uocBigOrderPOList);
                            continue;
                        }
                        if (UocConstant.MergePushRule.PUR_COMPANY.equals(rule)) {
                            Map<Long, List<UocBigConfigPO>> purCompanyMap = configPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getPurCompanyId));
                            for (Long purCompanyId : purCompanyMap.keySet()) {
                                this.dealCreateAuto(purCompanyMap.get(purCompanyId), uocBigOrderPOList);
                            }
                            continue;
                        }
                        if (UocConstant.MergePushRule.CREATE_PEOPLE.equals(rule)) {
                            Map<String, List<UocBigConfigPO>> createPeopleMap = configPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getCreateOperNo));
                            for (String createOperNo : createPeopleMap.keySet()) {
                                this.dealCreateAuto(createPeopleMap.get(createOperNo), uocBigOrderPOList);
                            }
                            continue;
                        }
                        if (!UocConstant.MergePushRule.COST_CENTER.equals(rule)) continue;
                        Map<String, List<UocBigConfigPO>> costCenterMap = configPOList.stream().collect(Collectors.groupingBy(UocBigConfigPO::getExt1));
                        for (String costCenter : costCenterMap.keySet()) {
                            this.dealCreateAuto(costCenterMap.get(costCenter), uocBigOrderPOList);
                        }
                    }
                }
            }
        }
        UocBigOrderAutoCreateBusiRspBO rspBO = new UocBigOrderAutoCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setUocBigOrderPOList(uocBigOrderPOList);
        rspBO.setSale(sale);
        return rspBO;
    }

    private void dealCreateAuto(List<UocBigConfigPO> uocBigConfigPOList, List<UocBigOrderPO> uocBigOrderPOList) {
        ArrayList<UocBigConfigPO> zqList = new ArrayList<UocBigConfigPO>();
        ArrayList<UocBigConfigPO> fzqList = new ArrayList<UocBigConfigPO>();
        int zqcCount = 0;
        int fzqCount = 0;
        for (UocBigConfigPO uocBigConfigPO : uocBigConfigPOList) {
            if ("2".equals(uocBigConfigPO.getPayType().toString())) {
                if ((zqcCount += uocBigConfigPO.getItemCount().intValue()) > this.maxSize) {
                    this.build(uocBigOrderPOList, zqList);
                    zqcCount = 0;
                    zqList.clear();
                    zqList.add(uocBigConfigPO);
                    continue;
                }
                zqList.add(uocBigConfigPO);
                continue;
            }
            if ((fzqCount += uocBigConfigPO.getItemCount().intValue()) > this.maxSize) {
                this.build(uocBigOrderPOList, fzqList);
                zqcCount = 0;
                fzqList.clear();
                fzqList.add(uocBigConfigPO);
                continue;
            }
            fzqList.add(uocBigConfigPO);
        }
        if (!CollectionUtils.isEmpty(zqList)) {
            this.build(uocBigOrderPOList, zqList);
        }
        if (!CollectionUtils.isEmpty(fzqList)) {
            this.build(uocBigOrderPOList, fzqList);
        }
        if (!CollectionUtils.isEmpty(uocBigOrderPOList)) {
            this.uocBigOrderMapper.insertBatch(uocBigOrderPOList);
        }
    }

    private void build(List<UocBigOrderPO> uocBigOrderPOList, List<UocBigConfigPO> list) {
        UocBigOrderPO uocBigOrderPO = new UocBigOrderPO();
        uocBigOrderPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey("SALE_ORDER_NO");
        getBo.setBuynerNo(list.get(0).getBuynerNo());
        getBo.setOrderSource("99");
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102107", voucherNoRsp.getRespDesc());
        }
        uocBigOrderPO.setOrderNo(voucherNoRsp.getVoucherNo());
        uocBigOrderPO.setBuynerNo(list.get(0).getBuynerNo());
        uocBigOrderPO.setBuynerName(list.get(0).getBuynerName());
        uocBigOrderPO.setBuynerErpNo(list.get(0).getBuynerErpNo());
        uocBigOrderPO.setOrderCount(Integer.valueOf(list.size()));
        uocBigOrderPO.setPushStatus(PebExtConstant.NO);
        uocBigOrderPO.setCreateTime(new Date());
        uocBigOrderPO.setCreateName("\u7cfb\u7edf\u81ea\u52a8");
        uocBigOrderPO.setExt1(PebExtConstant.NO.toString());
        uocBigOrderPO.setExt2(PebExtConstant.NO.toString());
        uocBigOrderPOList.add(uocBigOrderPO);
        for (UocBigConfigPO bigConfigPO : list) {
            bigConfigPO.setBigOrderId(uocBigOrderPO.getId());
            bigConfigPO.setBigOrderNo(uocBigOrderPO.getOrderNo());
        }
        this.uocBigConfigMapper.updateBatch(list);
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        System.out.println(calendar.get(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        System.out.println(calendar.getTime());
        calendar.add(2, -1);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        System.out.println(calendar.getTime());
        System.out.println(calendar.get(5));
    }
}

