/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateRspBo;
import com.tydic.uoc.common.busi.api.UocOrderRelUpdateBusiService;
import com.tydic.uoc.dao.UocOrderRelItemMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.UocOrderRelItemPO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocOrderRelUpdateBusiServiceImpl
implements UocOrderRelUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRelUpdateBusiServiceImpl.class);
    @Autowired
    private UocOrderRelMapper orderRelMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UocOrderRelItemMapper uocOrderRelItemMapper;
    private static final String DEL_FLAG = "1";

    @Override
    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        UocOrderRelUpdateRspBo rspBo = new UocOrderRelUpdateRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
        uocOrderRelPO.setOrderId(reqBo.getOrderId());
        uocOrderRelPO.setInspectionOrderId(reqBo.getInspectionVoucherId());
        uocOrderRelPO.setRelType(reqBo.getRelType());
        uocOrderRelPO.setSettleType(reqBo.getSettleType());
        UocOrderRelPO modelBy = null;
        if (null != reqBo.getRelId()) {
            uocOrderRelPO.setRelId(reqBo.getRelId().toString());
            modelBy = this.orderRelMapper.getModelBy(uocOrderRelPO);
        } else if (null != reqBo.getRelState() && 2 == reqBo.getRelState()) {
            uocOrderRelPO.setRelStatus(reqBo.getRelState());
            modelBy = this.orderRelMapper.getModelByRelIdNull(uocOrderRelPO);
            if (null != modelBy) {
                reqBo.setDelFlag(DEL_FLAG);
            }
        } else {
            modelBy = this.orderRelMapper.getModelBy(uocOrderRelPO);
        }
        if (modelBy == null) {
            long id = this.orderGenerateIdUtil.nextId();
            uocOrderRelPO.setId(Long.valueOf(id));
            if (null != reqBo.getRelId()) {
                uocOrderRelPO.setRelId(String.valueOf(reqBo.getRelId()));
            }
            uocOrderRelPO.setRelStatus(reqBo.getRelState());
            this.orderRelMapper.insert(uocOrderRelPO);
        } else if (DEL_FLAG.equals(reqBo.getDelFlag())) {
            this.orderRelMapper.deleteById(modelBy.getId());
        } else {
            if (null != reqBo.getRelId()) {
                modelBy.setRelId(String.valueOf(reqBo.getRelId()));
            }
            modelBy.setRelStatus(reqBo.getRelState());
            this.orderRelMapper.updateById(modelBy);
        }
        UocOrderRelItemPO deletePo = new UocOrderRelItemPO();
        deletePo.setOrderRelId(modelBy == null ? uocOrderRelPO.getId() : modelBy.getId());
        if (null != deletePo.getOrderRelId()) {
            this.uocOrderRelItemMapper.deleteByOrderRelId(deletePo);
        }
        List uocOrderRelItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getUocOrderRelItemBos()), UocOrderRelItemPO.class);
        for (UocOrderRelItemPO po : uocOrderRelItemPOS) {
            po.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            po.setOrderRelId(modelBy == null ? uocOrderRelPO.getId() : modelBy.getId());
        }
        if (!CollectionUtils.isEmpty((Collection)uocOrderRelItemPOS)) {
            this.uocOrderRelItemMapper.insertBatch(uocOrderRelItemPOS);
        }
        return rspBo;
    }

    @Override
    public UocOrderRefundUpdateRspBo dealRefundUpdate(UocOrderRefundUpdateReqBo reqBo) {
        UocOrderRelPO orderRelPO = new UocOrderRelPO();
        orderRelPO.setRelId(reqBo.getRelId().toString());
        orderRelPO.setInspectionOrderIds(reqBo.getAcceptOrderIds());
        List list = this.orderRelMapper.getList(orderRelPO);
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        HashMap<Long, Long> settleMap = new HashMap<Long, Long>(list.size());
        for (UocOrderRelPO uocOrderRelPO : list) {
            if (!uocOrderRelPO.getRelId().equals(reqBo.getRelId().toString())) continue;
            ids.add(uocOrderRelPO.getId());
            settleMap.put(uocOrderRelPO.getInspectionOrderId(), uocOrderRelPO.getOrderId());
        }
        if (CollectionUtils.isEmpty(ids)) {
            throw new UocProBusinessException("198888", "\u67e5\u8be2\u5173\u8054\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        UocOrderRelPO updateRelPo = new UocOrderRelPO();
        updateRelPo.setIds(ids);
        updateRelPo.setRelStatus(reqBo.getRelStatus());
        this.orderRelMapper.updateByIds(updateRelPo);
        UocOrderRelItemPO updateItemPo = new UocOrderRelItemPO();
        updateItemPo.setOrderRelIds(ids);
        int itemCount = this.uocOrderRelItemMapper.deleteByOrderRelIds(updateItemPo);
        if (itemCount < 0) {
            throw new UocProBusinessException("8888", "\u5220\u9664\u5173\u8054\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        UocOrderRefundUpdateRspBo rspBo = new UocOrderRefundUpdateRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setSettleMap(settleMap);
        return rspBo;
    }
}

