/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.bo.ChildSaleOrderBO;
import com.tydic.uoc.busibase.busi.bo.OrderSkuVO;
import com.tydic.uoc.common.atom.api.UocCoreGetOrderIdAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreGetOrderIdRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.busi.api.UocPebCreateOrdByOrdSplitBusiService;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrdByOrdSplitBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrdByOrdSplitBusiRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemEwMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdPromotionMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleCouponMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdSkuImeiMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocBigConfigMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdItemFlMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsGiftPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemEwPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdPromotionPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSaleCouponPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdSkuImeiPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocBigConfigPO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdItemFlPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uocPebCreateOrdByOrdSplitCombService")
public class UocPebCreateOrdByOrdSplitBusiServiceImpl
implements UocPebCreateOrdByOrdSplitBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocPebCreateOrdByOrdSplitBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private UocCoreGetOrderIdAtomService uocCoreGetOrderIdAtomService;
    private OrderMapper orderMapper;
    private OrdSaleMapper ordSaleMapper;
    private OrdPurchaseMapper ordPurchaseMapper;
    private OrdItemMapper ordItemMapper;
    private OrdGoodsMapper ordGoodsMapper;
    private OrdCruxMapMapper ordCruxMapMapper;
    private OrdExtMapMapper ordExtMapMapper;
    private OrdAccessoryMapper ordAccessoryMapper;
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    private OrdInvoiceMapper ordInvoiceMapper;
    private OrdStakeholderMapper ordStakeholderMapper;
    private OrdSaleCouponMapper ordSaleCouponMapper;
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    private OrdPromotionMapper ordPromotionMapper;
    private OrdGoodsGiftMapper ordGoodsGiftMapper;
    private OrdItemMapMapper ordItemMapMapper;
    private OrdShipItemMapper ordShipItemMapper;
    private OrdSkuImeiMapper ordSkuImeiMapper;
    private OrdItemEwMapper ordItemEwMapper;
    private UocStartProcessAtomService uocStartProcessAtomService;
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdItemFlMapper uocOrdItemFlMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private UocBigConfigMapper uocBigConfigMapper;

    @Autowired
    public UocPebCreateOrdByOrdSplitBusiServiceImpl(OrderMapper orderMapper, OrdSaleMapper ordSaleMapper, OrdPurchaseMapper ordPurchaseMapper, OrdCruxMapMapper ordCruxMapMapper, OrdItemMapper ordItemMapper, OrdGoodsMapper ordGoodsMapper, UocCoreGetOrderIdAtomService uocCoreGetOrderIdAtomService, OrdExtMapMapper ordExtMapMapper, OrdAccessoryMapper ordAccessoryMapper, OrdLogisticsRelaMapper ordLogisticsRelaMapper, OrdInvoiceMapper ordInvoiceMapper, OrdStakeholderMapper ordStakeholderMapper, OrdSaleCouponMapper ordSaleCouponMapper, OrdPurchaseItemMapper ordPurchaseItemMapper, OrdPromotionMapper ordPromotionMapper, OrdGoodsGiftMapper ordGoodsGiftMapper, OrdItemMapMapper ordItemMapMapper, OrdShipItemMapper ordShipItemMapper, OrdSkuImeiMapper ordSkuImeiMapper, OrdItemEwMapper ordItemEwMapper, UocStartProcessAtomService uocStartProcessAtomService, UocRunProcessAtomService uocRunProcessAtomService) {
        this.orderMapper = orderMapper;
        this.ordSaleMapper = ordSaleMapper;
        this.ordPurchaseMapper = ordPurchaseMapper;
        this.ordItemMapper = ordItemMapper;
        this.ordGoodsMapper = ordGoodsMapper;
        this.uocCoreGetOrderIdAtomService = uocCoreGetOrderIdAtomService;
        this.ordCruxMapMapper = ordCruxMapMapper;
        this.ordExtMapMapper = ordExtMapMapper;
        this.ordAccessoryMapper = ordAccessoryMapper;
        this.ordLogisticsRelaMapper = ordLogisticsRelaMapper;
        this.ordInvoiceMapper = ordInvoiceMapper;
        this.ordStakeholderMapper = ordStakeholderMapper;
        this.ordSaleCouponMapper = ordSaleCouponMapper;
        this.ordPurchaseItemMapper = ordPurchaseItemMapper;
        this.ordPromotionMapper = ordPromotionMapper;
        this.ordGoodsGiftMapper = ordGoodsGiftMapper;
        this.ordItemMapMapper = ordItemMapMapper;
        this.ordShipItemMapper = ordShipItemMapper;
        this.ordSkuImeiMapper = ordSkuImeiMapper;
        this.ordItemEwMapper = ordItemEwMapper;
        this.uocStartProcessAtomService = uocStartProcessAtomService;
        this.uocRunProcessAtomService = uocRunProcessAtomService;
    }

    @Override
    public UocPebCreateOrdByOrdSplitBusiRspBO createOrder(UocPebCreateOrdByOrdSplitBusiReqBO uocPebCreateOrdByOrdSplitCombReqBO) {
        UocPebCreateOrdByOrdSplitBusiRspBO rspBO = new UocPebCreateOrdByOrdSplitBusiRspBO();
        Long newOrderId = this.sequence.nextId();
        this.createOrderByChildOrder(newOrderId, uocPebCreateOrdByOrdSplitCombReqBO);
        Long pOrderId = uocPebCreateOrdByOrdSplitCombReqBO.getOrderId();
        OrdSalePO ordSalePO = this.createSaleAndPurchaseByChildOrder(newOrderId, uocPebCreateOrdByOrdSplitCombReqBO);
        this.queryIndex(ordSalePO, uocPebCreateOrdByOrdSplitCombReqBO.getChildSaleOrderRspBO().getOrderId());
        this.cruxMap(pOrderId, newOrderId, uocPebCreateOrdByOrdSplitCombReqBO.getChildSaleOrderRspBO().getOrderId(), ordSalePO.getSaleVoucherId());
        this.extMap(pOrderId, newOrderId);
        this.payConfig(pOrderId, newOrderId, ordSalePO);
        this.accessory(pOrderId, newOrderId);
        this.invoice(pOrderId, newOrderId);
        this.stakeholder(pOrderId, newOrderId);
        this.coupon(pOrderId, newOrderId, ordSalePO);
        this.createOrdItemByChildOrder(newOrderId, uocPebCreateOrdByOrdSplitCombReqBO, ordSalePO);
        this.unifyContractInfo(pOrderId, newOrderId, ordSalePO);
        try {
            OrderPO orderModel = new OrderPO();
            orderModel.setOrderId(pOrderId);
            orderModel.setOrderState(UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER);
            int n = this.orderMapper.updateById(orderModel);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102087", "\u62c6\u5355\u5931\u8d25:\u5220\u9664\u7236\u8ba2\u5355\u5f02\u5e38!");
        }
        this.task(pOrderId);
        rspBO.setOrderId(newOrderId);
        rspBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        rspBO.setSaleVoucherNO(ordSalePO.getSaleVoucherNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5b50\u8ba2\u5355\u521b\u5efa\u6210\u529f");
        this.insertSplitReasonAndMark(uocPebCreateOrdByOrdSplitCombReqBO.getOrderId(), uocPebCreateOrdByOrdSplitCombReqBO.getSaleId());
        return rspBO;
    }

    private void unifyContractInfo(Long pOrderId, Long newOrderId, OrdSalePO ordSalePO) {
        UocOrdContractPO contractPO = new UocOrdContractPO();
        contractPO.setOrderId(pOrderId);
        contractPO = this.uocOrdContractMapper.getModelBy(contractPO);
        if (contractPO != null) {
            contractPO.setId(Long.valueOf(this.sequence.nextId()));
            contractPO.setSaleVoucherNo(ordSalePO.getSaleVoucherNo());
            contractPO.setOrderId(newOrderId);
            contractPO.setExt2(pOrderId.toString());
            this.uocOrdContractMapper.insert(contractPO);
        }
    }

    private UocCoreGetOrderIdRspBO getNewOrderId() {
        UocCoreGetOrderIdRspBO uocCoreGetOrderIdRspBO = this.uocCoreGetOrderIdAtomService.queryCoreGetOrderId();
        if (!"0000".equals(uocCoreGetOrderIdRspBO.getRespCode())) {
            throw new UocProBusinessException("102087", "\u83b7\u53d6\u8ba2\u5355ID\u5931\u8d25!" + uocCoreGetOrderIdRspBO.getRespDesc());
        }
        return uocCoreGetOrderIdRspBO;
    }

    private void queryIndex(OrdSalePO ordSalePO, String outOrderId) {
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setObjId(ordSalePO.getSaleVoucherId());
        indexPO.setOrderId(ordSalePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setOrderSystem(UocConstant.OBJ_TYPE.SALE.toString());
        indexPO.setOutOrderNo(outOrderId);
        indexPO.setId(Long.valueOf(this.sequence.nextId()));
        this.ordQueryIndexMapper.insert(indexPO);
    }

    private void createOrderByChildOrder(Long newOrderId, UocPebCreateOrdByOrdSplitBusiReqBO createOrdByOrdSplitCombReqBO) {
        ChildSaleOrderBO childSaleOrderRspBO = createOrdByOrdSplitCombReqBO.getChildSaleOrderRspBO();
        Long totalFee = 0L;
        try {
            totalFee = MoneyUtils.BigDecimal2Long((BigDecimal)childSaleOrderRspBO.getOrderPrice());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        OrderPO orderModel = new OrderPO();
        orderModel.setOrderId(createOrdByOrdSplitCombReqBO.getOrderId());
        OrderPO orderPO = this.orderMapper.getModelBy(orderModel);
        Long oldOrderId = orderPO.getOrderId();
        orderPO.setOrderId(newOrderId);
        orderPO.setOrderNo(String.valueOf(newOrderId));
        orderPO.setTotalSaleFee(totalFee);
        orderPO.setTotalPurchaseFee(totalFee);
        orderPO.setOrderState(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED);
        orderPO.setUpperOrderId(oldOrderId);
        orderPO.setProPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
        int insertResult = this.orderMapper.splitInsert(orderPO);
    }

    private OrdSalePO createSaleAndPurchaseByChildOrder(Long newOrderId, UocPebCreateOrdByOrdSplitBusiReqBO createOrdByOrdSplitCombReqBO) {
        OrdSalePO ordsalePO;
        ChildSaleOrderBO childSaleOrderRspBO = createOrdByOrdSplitCombReqBO.getChildSaleOrderRspBO();
        Long totalFee = null;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = MoneyUtils.BigDecimal2Long((BigDecimal)childSaleOrderRspBO.getOrderPrice());
            if (totalFee == null) {
                totalFee = 0L;
            }
            if ((baseFreight = MoneyUtils.BigDecimal2Long((BigDecimal)childSaleOrderRspBO.getBaseFreight())) == null) {
                baseFreight = 0L;
            }
            if ((freight = MoneyUtils.BigDecimal2Long((BigDecimal)childSaleOrderRspBO.getFreight())) == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        Long ordSaleId = this.sequence.nextId();
        Long purchaseId = this.sequence.nextId();
        Long contactId = this.sequence.nextId();
        UocProcessStartRspBO saleRsp = this.startProcess(newOrderId, UocConstant.OBJ_TYPE.SALE, ordSaleId, "UOC", "sales_order_sub_order_status", null);
        UocProcessStartRspBO purchaseRspBO = this.startProcess(newOrderId, UocConstant.OBJ_TYPE.SALE, purchaseId, "UOC", "sales_order_sub_order_status", null);
        try {
            OrdSalePO ordSaleModel = new OrdSalePO();
            ordSaleModel.setOrderId(createOrdByOrdSplitCombReqBO.getOrderId());
            ordsalePO = this.ordSaleMapper.getModelBy(ordSaleModel);
            if (ordsalePO == null) {
                throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            Long pOrderId = ordsalePO.getOrderId();
            Long oldCid = ordsalePO.getContactId();
            ordsalePO.setOrderId(newOrderId);
            ordsalePO.setSaleVoucherId(ordSaleId);
            ordsalePO.setSaleVoucherNo(this.biuldNo(ordsalePO.getSaleVoucherNo(), createOrdByOrdSplitCombReqBO.getCount()));
            ordsalePO.setPurchaseVoucherId(purchaseId);
            ordsalePO.setSaleFee(totalFee);
            ordsalePO.setPurchaseFee(totalFee);
            ordsalePO.setBaseTransFee(baseFreight);
            ordsalePO.setRemoteTransFee(freight);
            ordsalePO.setTotalTransFee(Long.valueOf(baseFreight + freight));
            ordsalePO.setSaleState(Integer.valueOf(Integer.parseInt(saleRsp.getStepId())));
            ordsalePO.setContactId(contactId);
            this.ordSaleMapper.insert(ordsalePO);
            this.logisticsRela(pOrderId, newOrderId, contactId, oldCid);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        try {
            OrdPurchasePO ordPurchaseModel = new OrdPurchasePO();
            ordPurchaseModel.setOrderId(createOrdByOrdSplitCombReqBO.getOrderId());
            OrdPurchasePO purchasePO = this.ordPurchaseMapper.getModelBy(ordPurchaseModel);
            if (purchasePO != null) {
                String purchaseVoucherNo = ordsalePO.getSaleVoucherNo().replace("ZH", "ZHCG");
                purchasePO.setOrderId(newOrderId);
                purchasePO.setSaleVoucherId(ordSaleId);
                purchasePO.setPurchaseVoucherId(purchaseId);
                purchasePO.setPurchaseVoucherNo(purchaseVoucherNo);
                purchasePO.setSaleFee(totalFee);
                purchasePO.setPurchaseFee(totalFee);
                purchasePO.setBaseTransFee(baseFreight);
                purchasePO.setRemoteTransFee(freight);
                purchasePO.setTotalTransFee(Long.valueOf(baseFreight + freight));
                purchasePO.setPurchaseState(Integer.valueOf(Integer.parseInt(purchaseRspBO.getStepId())));
                purchasePO.setSaleState(Integer.valueOf(Integer.parseInt(saleRsp.getStepId())));
                purchasePO.setContactId(contactId);
                this.ordPurchaseMapper.insert(purchasePO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        return ordsalePO;
    }

    private String biuldNo(String no, int num) {
        OrdSalePO salePO = new OrdSalePO();
        String saleVoucherNo = no + "-" + num;
        salePO.setSaleVoucherNo(saleVoucherNo);
        int count = this.ordSaleMapper.getCheckBy(salePO);
        if (count > 0) {
            saleVoucherNo = this.biuldNo(no, ++num);
        }
        return saleVoucherNo;
    }

    private void updateOrdSaleContactId(OrdSalePO ordSalePO, Long contactId) {
        OrdSalePO ordSaleModel = new OrdSalePO();
        ordSaleModel.setOrderId(ordSalePO.getOrderId());
        ordSaleModel.setContactId(contactId);
        try {
            int n = this.ordSaleMapper.updateById(ordSaleModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u66f4\u65b0\u7236\u8ba2\u5355\u5173\u8054ID\u5f02\u5e38");
        }
    }

    private void cruxMap(Long pOrderId, Long orderId, String outOrderId, Long saleVoucherId) {
        OrdCruxMapPO cruxMapModel = new OrdCruxMapPO();
        cruxMapModel.setOrderId(pOrderId);
        try {
            List list = this.ordCruxMapMapper.getList(cruxMapModel);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            for (OrdCruxMapPO cruxMapPO : list) {
                if (UocConstant.OBJ_TYPE.SALE.equals(cruxMapPO.getObjType())) {
                    cruxMapPO.setOrderId(orderId);
                    cruxMapPO.setId(Long.valueOf(this.sequence.nextId()));
                    cruxMapPO.setFieldValue1(outOrderId);
                    cruxMapPO.setObjId(saleVoucherId);
                    continue;
                }
                if (!UocConstant.OBJ_TYPE.ORDER.equals(cruxMapPO.getObjType())) continue;
                cruxMapPO.setOrderId(orderId);
                cruxMapPO.setId(Long.valueOf(this.sequence.nextId()));
                cruxMapPO.setObjId(orderId);
            }
            this.ordCruxMapMapper.insertBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u5355\u636e\u5173\u952e\u5c5e\u6027\u6269\u5c55\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void payConfig(Long pOrderId, Long newOrderId, OrdSalePO ordSalePO) {
        OrdSalePO pSale = new OrdSalePO();
        pSale.setOrderId(pOrderId);
        pSale = this.ordSaleMapper.getModelBy(pSale);
        OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
        ordPayConfPO.setOrderId(pOrderId);
        List list = this.ordPayConfMapper.selectByCondition(ordPayConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (OrdPayConfPO uocOrdPayConfPO : list) {
            try {
                uocOrdPayConfPO.setId(Long.valueOf(this.sequence.nextId()));
                uocOrdPayConfPO.setOrderId(newOrderId);
                if (uocOrdPayConfPO.getPrePayFee() != null && uocOrdPayConfPO.getPrePayFee() != 0L) {
                    BigDecimal preFee = new BigDecimal(ordSalePO.getSaleFee()).divide(new BigDecimal(pSale.getSaleFee()), 2, 0).multiply(MoneyUtils.Long2BigDecimal((Long)uocOrdPayConfPO.getPrePayFee())).setScale(2, 0);
                    preFee = preFee.multiply(new BigDecimal(10000));
                    uocOrdPayConfPO.setPrePayFee(Long.valueOf(preFee.longValue()));
                }
                this.ordPayConfMapper.insert(uocOrdPayConfPO);
            }
            catch (Exception exception) {}
        }
    }

    private void extMap(Long pOrderId, Long orderId) {
        OrdExtMapPO ordExtMapModel = new OrdExtMapPO();
        ordExtMapModel.setOrderId(pOrderId);
        ordExtMapModel.setObjType(UocConstant.OBJ_TYPE.ORDER);
        try {
            List extMapList = this.ordExtMapMapper.getList(ordExtMapModel);
            if (!CollectionUtils.isEmpty((Collection)extMapList)) {
                ArrayList<OrdExtMapPO> poList = new ArrayList<OrdExtMapPO>();
                for (OrdExtMapPO po : extMapList) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrderId(orderId);
                    po.setObjId(orderId);
                    poList.add(po);
                }
                this.ordExtMapMapper.insertBatch(poList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u5355\u636e\u6269\u5c55\u5c5e\u6027\u8868\u6570\u636e\u51fa\u9519");
        }
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(pOrderId);
        mapPO.setObjType(UocCoreConstant.OBJ_TYPE.CONDITION);
        try {
            List extMapList = this.ordExtMapMapper.getList(mapPO);
            if (!CollectionUtils.isEmpty((Collection)extMapList)) {
                ArrayList<OrdExtMapPO> poList = new ArrayList<OrdExtMapPO>();
                for (OrdExtMapPO po : extMapList) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrderId(orderId);
                    po.setObjId(orderId);
                    poList.add(po);
                }
                this.ordExtMapMapper.insertBatch(poList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u5355\u636e\u6269\u5c55\u5c5e\u6027\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void accessory(Long pOrderId, Long orderId) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(pOrderId);
        try {
            List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
            if (!CollectionUtils.isEmpty((Collection)ordAccessoryPOList)) {
                ArrayList<OrdAccessoryPO> accessoryPOS = new ArrayList<OrdAccessoryPO>();
                for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                    accessoryPO.setOrderId(orderId);
                    accessoryPO.setId(Long.valueOf(this.sequence.nextId()));
                    accessoryPO.setCreateTime(new Date());
                    if (accessoryPO.getObjectType().equals(UocConstant.OBJ_TYPE.ORDER)) {
                        accessoryPO.setObjectId(orderId);
                    }
                    accessoryPOS.add(accessoryPO);
                }
                this.ordAccessoryMapper.insertBatch(accessoryPOS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u9644\u4ef6\u4fe1\u606f\u6570\u636e\u51fa\u9519");
        }
    }

    private void logisticsRela(Long pOrderId, Long orderId, Long contactId, Long oldCid) {
        OrdLogisticsRelaPO logisticsRela = new OrdLogisticsRelaPO();
        logisticsRela.setOrderId(pOrderId);
        logisticsRela.setContactId(oldCid);
        try {
            OrdLogisticsRelaPO logisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRela);
            if (logisticsRelaPO != null) {
                logisticsRelaPO.setContactId(contactId);
                logisticsRelaPO.setOrderId(orderId);
                this.ordLogisticsRelaMapper.insert(logisticsRelaPO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u7269\u6d41\u8054\u7cfb\u4eba\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void invoice(Long pOrderId, Long orderId) {
        OrdInvoicePO invoicePO = new OrdInvoicePO();
        invoicePO.setOrderId(pOrderId);
        try {
            OrdInvoicePO ordInvoicePO = this.ordInvoiceMapper.getModelByPO(invoicePO);
            if (ordInvoicePO != null) {
                ordInvoicePO.setId(Long.valueOf(this.sequence.nextId()));
                ordInvoicePO.setOrderId(orderId);
                this.ordInvoiceMapper.insert(ordInvoicePO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void stakeholder(Long pOrderId, Long orderId) {
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(pOrderId.longValue());
            if (ordStakeholderPO != null) {
                ordStakeholderPO.setOrderId(orderId);
                this.ordStakeholderMapper.insert(ordStakeholderPO);
            }
            OrdStateChgLogPO logPO = new OrdStateChgLogPO();
            logPO.setOrderId(pOrderId);
            List logPOS = this.ordStateChgLogMapper.getList(logPO);
            if (!CollectionUtils.isEmpty((Collection)logPOS)) {
                for (OrdStateChgLogPO po : logPOS) {
                    po.setOrderId(orderId);
                    po.setId(Long.valueOf(this.sequence.nextId()));
                }
                this.ordStateChgLogMapper.insertBatch(logPOS);
            }
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(pOrderId);
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (zmInfoPO != null) {
                zmInfoPO.setOrderId(orderId);
                this.uocOrdZmInfoMapper.insert(zmInfoPO);
            }
            UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
            warehousePO.setOrderId(pOrderId);
            warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
            if (warehousePO != null) {
                warehousePO.setOrderId(orderId);
                this.uocOrdWarehouseMapper.insert(warehousePO);
            }
            UocBigConfigPO configPO = new UocBigConfigPO();
            configPO.setOrderId(pOrderId);
            configPO = this.uocBigConfigMapper.selectOne(configPO);
            if (configPO != null) {
                configPO.setOrderId(orderId);
                this.uocBigConfigMapper.insert(configPO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void coupon(Long pOrderId, Long orderId, OrdSalePO salePO) {
        try {
            OrdSaleCouponPO couponPO = new OrdSaleCouponPO();
            couponPO.setOrderId(pOrderId);
            List couponPOS = this.ordSaleCouponMapper.getList(couponPO);
            if (!CollectionUtils.isEmpty((Collection)couponPOS)) {
                ArrayList<OrdSaleCouponPO> saveDate = new ArrayList<OrdSaleCouponPO>();
                for (OrdSaleCouponPO po : couponPOS) {
                    po.setOrderId(orderId);
                    po.setSaleVoucherId(salePO.getSaleVoucherId());
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    saveDate.add(po);
                }
                this.ordSaleCouponMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u4f18\u60e0\u52b5\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void createOrdItemByChildOrder(Long newOrderId, UocPebCreateOrdByOrdSplitBusiReqBO createOrdByOrdSplitCombReqBO, OrdSalePO ordSalePO) {
        Long pOrderId = createOrdByOrdSplitCombReqBO.getOrderId();
        ChildSaleOrderBO childSaleOrderRspBO = createOrdByOrdSplitCombReqBO.getChildSaleOrderRspBO();
        List extSkus = childSaleOrderRspBO.getSku();
        OrdGoodsPO ordGoodsModel = new OrdGoodsPO();
        ordGoodsModel.setOrderId(pOrderId);
        Integer gifi = 2;
        Integer file = 1;
        try {
            ArrayList<OrdGoodsPO> existOrdGoodPOs = new ArrayList<OrdGoodsPO>();
            List ordGoodsPOS = this.ordGoodsMapper.getList(ordGoodsModel);
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (OrdGoodsPO ordGoodsPO : ordGoodsPOS) {
                for (OrderSkuVO orderSaleItemRspBO : extSkus) {
                    if (!orderSaleItemRspBO.getSkuId().equals(ordGoodsPO.getSkuExtSkuId()) || (gifi.equals(ordGoodsPO.getType()) || file.equals(ordGoodsPO.getType())) && BigDecimal.ZERO.compareTo(ordGoodsPO.getPrice()) == 0) continue;
                    count.put(orderSaleItemRspBO.getSkuId(), orderSaleItemRspBO.getNum());
                    ordGoodsPO.setNum(orderSaleItemRspBO.getNum());
                    ordGoodsPO.setType(orderSaleItemRspBO.getType());
                    ordGoodsPO.setPrice(orderSaleItemRspBO.getPrice());
                    existOrdGoodPOs.add(ordGoodsPO);
                }
            }
            if (existOrdGoodPOs.isEmpty()) {
                throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u672a\u67e5\u8be2\u5916\u90e8\u5b50\u8ba2\u5355\u5546\u54c1\u5bf9\u5e94\u7684\u5185\u90e8\u5546\u54c1\u4fe1\u606f");
            }
            String type = null;
            long saleFee = 0L;
            long purFee = 0L;
            BigDecimal z = BigDecimal.ZERO;
            long payId = this.sequence.nextId();
            for (OrdGoodsPO ordGoodsPO : existOrdGoodPOs) {
                Long ordItemId = this.sequence.nextId();
                Long purchaseItemId = this.sequence.nextId();
                OrdItemPO ordItemModel = new OrdItemPO();
                ordItemModel.setOrderId(ordGoodsPO.getOrderId());
                ordItemModel.setSkuId(ordGoodsPO.getSkuId());
                ordItemModel.setOrdItemId(ordGoodsPO.getOrdItemId());
                OrdItemPO ordItemPO = this.ordItemMapper.getModelBy(ordItemModel);
                type = ordItemPO.getUsedCompany();
                Long oldOrdItemId = ordItemPO.getOrdItemId();
                ordItemPO.setLmOrderId(ordItemPO.getOrdItemId().toString());
                ordItemPO.setOrdItemId(ordItemId);
                ordItemPO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
                ordItemPO.setOrderId(newOrderId);
                ordItemPO.setPurchaseVoucherId(ordSalePO.getPurchaseVoucherId());
                if (ordGoodsPO.getNum() != null && ordGoodsPO.getNum() != 0) {
                    if (ordItemPO.getPlanItemId() != null) {
                        int last;
                        Integer num = (Integer)count.get(ordGoodsPO.getSkuExtSkuId());
                        if (num == 0 || (last = ordItemPO.getPurchaseCount().intValue() - ordItemPO.getSendCount().intValue()) == 0) continue;
                        if (num < last) {
                            ordItemPO.setPurchaseCount(new BigDecimal(num));
                            ordItemPO.setTotalSaleFee(Long.valueOf((long)num.intValue() * ordItemPO.getSalePrice()));
                            ordItemPO.setTotalPurchaseFee(Long.valueOf((long)num.intValue() * ordItemPO.getPurchasePrice()));
                            count.put(ordGoodsPO.getSkuExtSkuId(), 0);
                            ordItemModel.setSendCount(new BigDecimal(num));
                        } else {
                            ordItemPO.setPurchaseCount(new BigDecimal(last));
                            ordItemPO.setTotalSaleFee(Long.valueOf((long)last * ordItemPO.getSalePrice()));
                            ordItemPO.setTotalPurchaseFee(Long.valueOf((long)last * ordItemPO.getPurchasePrice()));
                            count.put(ordGoodsPO.getSkuExtSkuId(), num - last);
                            ordItemModel.setSendCount(new BigDecimal(last));
                        }
                        this.ordItemMapper.updateCounts(ordItemModel);
                        ordItemModel.setSendCount(null);
                        ordItemModel = this.ordItemMapper.getModelBy(ordItemModel);
                        if (ordItemModel.getSendCount().compareTo(ordItemModel.getPurchaseCount()) > 0) {
                            throw new UocProBusinessException("102087", ordItemModel.getOrdItemId() + "\u7684\u91c7\u8d2d\u6570\u91cf\u5927\u4e8e\u5df2\u62c6\u5355\u7684\u6570\u91cf");
                        }
                    } else {
                        ordItemPO.setPurchaseCount(new BigDecimal(ordGoodsPO.getNum()));
                        ordItemPO.setTotalSaleFee(Long.valueOf((long)ordGoodsPO.getNum().intValue() * ordItemPO.getSalePrice()));
                        ordItemPO.setTotalPurchaseFee(Long.valueOf((long)ordGoodsPO.getNum().intValue() * ordItemPO.getPurchasePrice()));
                    }
                }
                ordItemPO.setTotalPurchaseDecimalPrice(ordItemPO.getPurchaseCount().multiply(ordItemPO.getSaleDecimalPrice()));
                ordItemPO.setTotalPurchaseDecimalPrice(ordItemPO.getPurchaseCount().multiply(ordItemPO.getPurchaseDecimalPrice()));
                saleFee += ordItemPO.getTotalSaleFee().longValue();
                purFee += ordItemPO.getTotalPurchaseFee().longValue();
                UocOrdItemFlPO flPO = new UocOrdItemFlPO();
                flPO.setOrderId(pOrderId);
                flPO.setOrdItemId(oldOrdItemId);
                List list = this.uocOrdItemFlMapper.selectByCondition(flPO);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    ArrayList<UocOrdItemFlPO> saveDate = new ArrayList<UocOrdItemFlPO>();
                    if (ordItemPO.getIntegralFee() == null) {
                        ordItemPO.setIntegralFee(Long.valueOf(0L));
                    }
                    if (ordItemPO.getArriveCount() == null) {
                        ordItemPO.setArriveCount(BigDecimal.ZERO);
                    }
                    UocOrdItemFlPO po = (UocOrdItemFlPO)list.get(0);
                    if (MoneyUtil.l2B((Long)ordItemPO.getIntegralFee()).subtract(ordItemPO.getArriveCount()).compareTo(po.getFee()) >= 0) {
                        po.setFee(po.getFee());
                    } else {
                        po.setFee(MoneyUtil.l2B((Long)ordItemPO.getIntegralFee()).subtract(ordItemPO.getArriveCount()));
                    }
                    if (ordItemPO.getTotalSaleDecimalPrice().compareTo(po.getFee()) < 0) {
                        po.setFee(ordItemPO.getTotalSaleDecimalPrice());
                    }
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(ordItemId);
                    po.setOrderId(newOrderId);
                    z = z.add(po.getFee());
                    saveDate.add(po);
                    OrdItemPO up = new OrdItemPO();
                    up.setOrdItemId(oldOrdItemId);
                    up.setArriveCount(po.getFee());
                    this.ordItemMapper.updateCounts(up);
                    this.uocOrdItemFlMapper.insertBatch(saveDate);
                    ordItemPO.setIntegralFee(Long.valueOf(z.multiply(new BigDecimal("10000")).longValue()));
                    ordItemPO.setUsedIntegral(ordItemPO.getIntegralFee());
                }
                ordItemPO.setArriveCount(BigDecimal.ZERO);
                ordItemPO.setExtField5("0");
                this.ordItemMapper.insert(ordItemPO);
                try {
                    OrdPayItemPO payItemPO = new OrdPayItemPO();
                    payItemPO.setPayItemId(Long.valueOf(this.sequence.nextId()));
                    payItemPO.setPayVoucherId(Long.valueOf(payId));
                    payItemPO.setOrdItemId(ordItemPO.getOrdItemId());
                    payItemPO.setPayObjId(ordItemPO.getOrdItemId());
                    payItemPO.setPayObjType(Integer.valueOf(1));
                    payItemPO.setOrderId(ordSalePO.getOrderId());
                    payItemPO.setPayCount(ordItemPO.getPurchaseCount());
                    payItemPO.setPurchaseCount(ordItemPO.getPurchaseCount());
                    payItemPO.setUnitName(ordItemPO.getUnitName());
                    payItemPO.setSalePrice(ordItemPO.getSalePrice());
                    payItemPO.setPurchasePrice(ordItemPO.getPurchasePrice());
                    payItemPO.setCurrencyType("0");
                    payItemPO.setTotalFee(ordItemPO.getTotalSaleFee());
                    payItemPO.setPayFee(ordItemPO.getTotalSaleFee());
                    payItemPO.setReduceFee(Long.valueOf(0L));
                    this.ordPayItemMapper.insert(payItemPO);
                }
                catch (Exception e) {
                    LOGGER.error("\u652f\u4ed8\u660e\u7ec6\u9519\u8bef" + e);
                }
                OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
                BeanUtils.copyProperties((Object)ordItemPO, (Object)purchaseItemPO);
                purchaseItemPO.setPurchaseItemId(purchaseItemId);
                purchaseItemPO.setOrderItemId(ordItemId);
                this.ordPurchaseItemMapper.insert(purchaseItemPO);
                this.promotion(pOrderId, newOrderId, oldOrdItemId, ordItemId);
                this.goodsGif(pOrderId, newOrderId, oldOrdItemId, ordItemId, purchaseItemId);
                this.itemMap(pOrderId, newOrderId, oldOrdItemId, ordItemId, purchaseItemId, ordSalePO);
                this.itemEw(pOrderId, newOrderId, oldOrdItemId, ordItemId, purchaseItemId);
                ordGoodsPO.setGoodsItemId(Long.valueOf(this.sequence.nextId()));
                ordGoodsPO.setOrderId(newOrderId);
                ordGoodsPO.setOrdItemId(ordItemId);
                ordGoodsPO.setPurchaseItemId(purchaseItemId);
                this.ordGoodsMapper.insert(ordGoodsPO);
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            salePO.setOrderId(newOrderId);
            salePO.setSaleFee(Long.valueOf(saleFee));
            salePO.setPurchaseFee(Long.valueOf(purFee));
            salePO.setTotalIntegralFee(Long.valueOf(z.multiply(new BigDecimal("10000")).longValue()));
            salePO.setTotalUsedIntegral(salePO.getTotalIntegralFee());
            OrdPayPO payPO = new OrdPayPO();
            payPO.setOrderId(pOrderId);
            payPO.setObjId(createOrdByOrdSplitCombReqBO.getSaleId());
            payPO.setObjType(UocConstant.OBJ_TYPE.SALE);
            List list = this.ordPayMapper.getList(payPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                payPO = (OrdPayPO)list.get(0);
                payPO.setPayVoucherId(Long.valueOf(payId));
                payPO.setOrderId(ordSalePO.getOrderId());
                payPO.setPayVoucherNo(ordSalePO.getOrderId().toString());
                payPO.setObjId(ordSalePO.getSaleVoucherId());
                payPO.setTotalFee(Long.valueOf(saleFee));
                payPO.setPayFee(Long.valueOf(saleFee));
                this.ordPayMapper.insert(payPO);
            }
            this.ordSaleMapper.updateById(salePO);
            if (StringUtils.isNotBlank((String)type)) {
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setFieldCode("vendorOrderType");
                extMapPO.setOrderId(ordSalePO.getOrderId());
                extMapPO.setObjId(ordSalePO.getSaleVoucherId());
                extMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
                extMapPO.setFieldName("\u4f9b\u5e94\u5546\u8ba2\u5355\u7c7b\u522b");
                extMapPO.setFieldValue(type);
                extMapPO.setId(Long.valueOf(this.sequence.nextId()));
                this.ordExtMapMapper.insert(extMapPO);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38" + e);
            throw new UocProBusinessException("102087", "\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38:\u521b\u5efa\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38" + e.getMessage());
        }
    }

    private void promotion(Long pOrderId, Long orderId, Long oldItemId, Long itemId) {
        OrdPromotionPO promotionPO = new OrdPromotionPO();
        promotionPO.setOrderId(pOrderId);
        promotionPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordPromotionMapper.getList(promotionPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdPromotionPO> saveDate = new ArrayList<OrdPromotionPO>();
                for (OrdPromotionPO po : pos) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    saveDate.add(po);
                }
                this.ordPromotionMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6 \u8ba2\u5355\u4f18\u60e0\u6d3b\u52a8\u8bb0\u5f55\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void goodsGif(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdGoodsGiftPO goodsGiftPO = new OrdGoodsGiftPO();
        goodsGiftPO.setOrderId(pOrderId);
        goodsGiftPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordGoodsGiftMapper.getList(goodsGiftPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdGoodsGiftPO> saveDate = new ArrayList<OrdGoodsGiftPO>();
                for (OrdGoodsGiftPO po : pos) {
                    po.setGiftId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordGoodsGiftMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8d60\u54c1\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void shipItem(Long pOrderId, Long orderId, Long oldItemId, Long itemId) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(pOrderId);
        ordShipItemPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordShipItemMapper.getList(ordShipItemPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                for (OrdShipItemPO po : pos) {
                    Long id = po.getShipItemId();
                    po.setShipItemId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    this.ordShipItemMapper.insert(po);
                    this.skuImei(pOrderId, orderId, itemId, oldItemId, id, po.getShipItemId());
                }
            } else {
                this.skuImei(pOrderId, orderId, itemId, oldItemId, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u53d1\u8d27\u660e\u7ec6\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void skuImei(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long shipId, Long oldShipId) {
        OrdSkuImeiPO ordSkuImeiPO = new OrdSkuImeiPO();
        ordSkuImeiPO.setOrderId(pOrderId);
        ordSkuImeiPO.setOrdItemId(oldItemId);
        ordSkuImeiPO.setShipItemId(oldShipId);
        try {
            List pos = this.ordSkuImeiMapper.getList(ordSkuImeiPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdSkuImeiPO> saveDate = new ArrayList<OrdSkuImeiPO>();
                for (OrdSkuImeiPO po : pos) {
                    po.setShipItemId(shipId);
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    saveDate.add(po);
                }
                this.ordSkuImeiMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u53d1\u8d27\u660e\u7ec6\u5546\u54c1\u4e32\u7801\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void itemMap(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId, OrdSalePO salePO) {
        OrdItemMapPO itemMapPO = new OrdItemMapPO();
        itemMapPO.setOrderId(pOrderId);
        itemMapPO.setOrderItemId(oldItemId);
        try {
            List pos = this.ordItemMapMapper.getList(itemMapPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdItemMapPO> saveDate = new ArrayList<OrdItemMapPO>();
                for (OrdItemMapPO po : pos) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrderItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordItemMapMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u9500\u552e\u660e\u7ec6\u6269\u5c55\u5c5e\u6027\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void itemEw(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdItemEwPO ordItemEwPO = new OrdItemEwPO();
        ordItemEwPO.setOrderId(pOrderId);
        ordItemEwPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordItemEwMapper.getList(ordItemEwPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdItemEwPO> saveDate = new ArrayList<OrdItemEwPO>();
                for (OrdItemEwPO po : pos) {
                    po.setEwVoucherId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordItemEwMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void task(Long pOrderId) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(pOrderId);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(pOrderId);
        try {
            orderPO = this.orderMapper.getModelBy(orderPO);
            salePO = this.ordSaleMapper.getModelBy(salePO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102087", "\u67e5\u8be2\u7236\u9500\u552e\u5355\u5931\u8d25");
        }
        this.run(salePO, orderPO);
    }

    private void insertSplitReasonAndMark(Long orderId, Long saleId) {
        ArrayList<OrdExtMapPO> ordExtMapPOList = new ArrayList<OrdExtMapPO>();
        OrdExtMapPO ordExtMapSplitReasonModel = new OrdExtMapPO();
        ordExtMapSplitReasonModel.setObjId(saleId);
        ordExtMapSplitReasonModel.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        ordExtMapSplitReasonModel.setOrderId(orderId);
        ordExtMapSplitReasonModel.setFieldCode("splitReason");
        ordExtMapSplitReasonModel.setFieldName("\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u62c6\u5355\u539f\u56e0");
        ordExtMapSplitReasonModel.setFieldValue("\u5c06\u5916\u90e8\u8ba2\u5355\u62c6\u6210\u5b50\u8ba2\u5355");
        ordExtMapPOList.add(ordExtMapSplitReasonModel);
        OrdExtMapPO ordExtMapSplitMarkModel = new OrdExtMapPO();
        ordExtMapSplitMarkModel.setObjId(saleId);
        ordExtMapSplitMarkModel.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        ordExtMapSplitMarkModel.setOrderId(orderId);
        ordExtMapSplitMarkModel.setFieldCode("splitMark");
        ordExtMapSplitMarkModel.setFieldName("\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u62c6\u5355\u6807\u8bc6");
        ordExtMapSplitMarkModel.setFieldValue("1");
        ordExtMapPOList.add(ordExtMapSplitMarkModel);
        try {
            for (OrdExtMapPO ordExtMapPO : ordExtMapPOList) {
                ordExtMapPO.setId(Long.valueOf(this.sequence.nextId()));
                int insertResult = this.ordExtMapMapper.insert(ordExtMapPO);
                if (insertResult != 0) continue;
                throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u65b0\u589e\u9500\u552e\u8ba2\u5355\u6269\u5c55\u5b57\u6bb5\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u65b0\u589e\u9500\u552e\u8ba2\u5355\u6269\u5c55\u5b57\u6bb5\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            }
            throw new UocProBusinessException("102087", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u65b0\u589e\u9500\u552e\u8ba2\u5355\u6269\u5c55\u5b57\u6bb5\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private void run(OrdSalePO salePO, OrderPO orderPO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(salePO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(salePO.getOrderId());
        processRunReqBO.setOperId(orderPO.getCreateOperId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("splitFlag", "1");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102087", "\u62c6\u5355\u7236\u9500\u552e\u5355\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private UocProcessStartRspBO startProcess(Long orderId, Integer objType, Long objId, String sysCode, String procKey, Map<String, Object> map) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefKey(procKey);
        processStartReqBO.setSysCode(sysCode);
        processStartReqBO.setOrderId(orderId);
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(objType);
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new UocProBusinessException("102087", "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25!" + uocProcessStartRspBO.getRespDesc());
        }
        return uocProcessStartRspBO;
    }
}

