/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocSyncFscOrderRelUpdateReqBO;
import com.tydic.uoc.common.ability.bo.UocSyncFscOrderRelUpdateRspBO;
import com.tydic.uoc.common.busi.api.UocSyncFscOrderRelUpdateBusiService;
import com.tydic.uoc.dao.UocOrderRelItemMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.UocOrderRelItemPO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocSyncFscOrderRelUpdateBusiServiceImpl
implements UocSyncFscOrderRelUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocSyncFscOrderRelUpdateBusiServiceImpl.class);
    @Autowired
    private UocOrderRelMapper orderRelMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UocOrderRelItemMapper uocOrderRelItemMapper;
    private static final String DEL_FLAG = "1";
    private static final String Add_FLAG = "0";
    private static final Integer DEALTYPE = 2;

    @Override
    public UocSyncFscOrderRelUpdateRspBO dealRelUpdate(UocSyncFscOrderRelUpdateReqBO reqBo) {
        UocSyncFscOrderRelUpdateRspBO rspBO = new UocSyncFscOrderRelUpdateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List uocOrderRelUpdateReqBos = reqBo.getUocOrderRelUpdateReqBos();
        ArrayList<UocOrderRelUpdateReqBo> deleteList = new ArrayList<UocOrderRelUpdateReqBo>();
        ArrayList<UocOrderRelUpdateReqBo> addList = new ArrayList<UocOrderRelUpdateReqBo>();
        ArrayList<UocOrderRelUpdateReqBo> updateList = new ArrayList<UocOrderRelUpdateReqBo>();
        for (UocOrderRelUpdateReqBo bo : uocOrderRelUpdateReqBos) {
            if (DEL_FLAG.equals(bo.getDelFlag())) {
                deleteList.add(bo);
                continue;
            }
            if (Add_FLAG.equals(bo.getDelFlag())) {
                addList.add(bo);
                continue;
            }
            updateList.add(bo);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.addRel(addList);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            this.deleteRelAndRelItem(reqBo, deleteList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.updateRelAndRelItem(reqBo, updateList);
        }
        return rspBO;
    }

    private void updateRelAndRelItem(UocSyncFscOrderRelUpdateReqBO reqBo, List<UocOrderRelUpdateReqBo> updateList) {
        ArrayList uocOrderRelItemPOS = new ArrayList();
        ArrayList<UocOrderRelPO> uocOrderRelPOS = new ArrayList<UocOrderRelPO>();
        for (UocOrderRelUpdateReqBo bo : updateList) {
            UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
            uocOrderRelPO.setRelId(Convert.toStr((Object)bo.getRelId()));
            uocOrderRelPO.setOrderId(bo.getOrderId());
            uocOrderRelPO.setInspectionOrderId(bo.getInspectionVoucherId());
            uocOrderRelPO.setRelStatus(bo.getRelState());
            uocOrderRelPOS.add(uocOrderRelPO);
        }
        int i = this.orderRelMapper.updateOrderRelBatch(uocOrderRelPOS);
        if (i != uocOrderRelPOS.size()) {
            throw new UocProBusinessException("8888", "\u540c\u6b65\u8ba2\u5355\u6570\u636e\u4fee\u6539\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        if (null != reqBo.getDealType() && DEALTYPE.equals(reqBo.getDealType())) {
            List listToUpDate;
            List deleteOrderIds = updateList.stream().map(UocOrderRelUpdateReqBo::getOrderId).collect(Collectors.toList());
            List deleteInspectionVoucherIdS = updateList.stream().map(UocOrderRelUpdateReqBo::getInspectionVoucherId).collect(Collectors.toList());
            UocOrderRelPO qryUpdatePo = new UocOrderRelPO();
            qryUpdatePo.setRelId(Convert.toStr((Object)reqBo.getRelId()));
            qryUpdatePo.setOrderIds(deleteOrderIds);
            qryUpdatePo.setInspectionOrderIds(deleteInspectionVoucherIdS);
            if (!(null == qryUpdatePo.getRelId() || CollectionUtils.isEmpty((Collection)qryUpdatePo.getOrderIds()) || CollectionUtils.isEmpty((Collection)qryUpdatePo.getInspectionOrderIds()) || CollectionUtils.isEmpty((Collection)(listToUpDate = this.orderRelMapper.getListToDelete(qryUpdatePo))))) {
                List updateIds = listToUpDate.stream().map(UocOrderRelPO::getId).collect(Collectors.toList());
                UocOrderRelItemPO deleteItemPo = new UocOrderRelItemPO();
                deleteItemPo.setOrderRelIds(updateIds);
                this.uocOrderRelItemMapper.deleteByOrderRelIds(deleteItemPo);
                log.debug("\u5220\u9664\u7684id\u4e3a{}", updateIds);
                listToUpDate.forEach(e -> {
                    List addList = updateList.stream().filter(bo -> Objects.equals(bo.getRelId(), Convert.toLong((Object)e.getRelId())) && Objects.equals(bo.getInspectionVoucherId(), e.getInspectionOrderId()) && Objects.equals(bo.getOrderId(), e.getOrderId())).collect(Collectors.toList());
                    UocOrderRelUpdateReqBo uocOrderRelUpdateReqBo = (UocOrderRelUpdateReqBo)addList.get(0);
                    if (null != uocOrderRelUpdateReqBo && 0 != uocOrderRelUpdateReqBo.getRelState() && !DEL_FLAG.equals(uocOrderRelUpdateReqBo.getDelFlag())) {
                        List uocOrderRelItemPOS1 = JSONObject.parseArray((String)JSON.toJSONString((Object)uocOrderRelUpdateReqBo.getUocOrderRelItemBos()), UocOrderRelItemPO.class);
                        for (UocOrderRelItemPO po : uocOrderRelItemPOS1) {
                            po.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                            po.setOrderRelId(e.getId());
                            po.setRelId(uocOrderRelUpdateReqBo.getRelId());
                        }
                        uocOrderRelItemPOS.addAll(uocOrderRelItemPOS1);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(uocOrderRelItemPOS)) {
                this.uocOrderRelItemMapper.insertBatch(uocOrderRelItemPOS);
            }
        }
    }

    private void deleteRelAndRelItem(UocSyncFscOrderRelUpdateReqBO reqBo, List<UocOrderRelUpdateReqBo> deleteList) {
        List listToDelete;
        List deleteOrderIds = deleteList.stream().map(UocOrderRelUpdateReqBo::getOrderId).collect(Collectors.toList());
        List deleteInspectionVoucherIdS = deleteList.stream().map(UocOrderRelUpdateReqBo::getInspectionVoucherId).collect(Collectors.toList());
        UocOrderRelPO qryDeleteRelPo = new UocOrderRelPO();
        qryDeleteRelPo.setRelId(Convert.toStr((Object)reqBo.getRelId()));
        qryDeleteRelPo.setOrderIds(deleteOrderIds);
        qryDeleteRelPo.setInspectionOrderIds(deleteInspectionVoucherIdS);
        if (!(null == qryDeleteRelPo.getRelId() || CollectionUtils.isEmpty((Collection)qryDeleteRelPo.getOrderIds()) || CollectionUtils.isEmpty((Collection)qryDeleteRelPo.getInspectionOrderIds()) || CollectionUtils.isEmpty((Collection)(listToDelete = this.orderRelMapper.getListToDelete(qryDeleteRelPo))))) {
            List deleteIds = listToDelete.stream().map(UocOrderRelPO::getId).collect(Collectors.toList());
            UocOrderRelPO deleteRelPo = new UocOrderRelPO();
            deleteRelPo.setIds(deleteIds);
            deleteRelPo.setRelStatus(Integer.valueOf(0));
            if (!CollectionUtils.isEmpty((Collection)deleteRelPo.getIds())) {
                this.orderRelMapper.updateByIds(deleteRelPo);
                UocOrderRelItemPO deleteItemPo = new UocOrderRelItemPO();
                deleteItemPo.setOrderRelIds(deleteRelPo.getIds());
                this.uocOrderRelItemMapper.deleteByOrderRelIds(deleteItemPo);
                log.debug("\u5220\u9664\u7684id\u4e3a{}", (Object)deleteRelPo.getIds());
            }
        }
    }

    private void addRel(List<UocOrderRelUpdateReqBo> addList) {
        ArrayList addPoList = new ArrayList();
        ArrayList uocOrderRelItemPOS = new ArrayList();
        addList.forEach(e -> {
            UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
            uocOrderRelPO.setOrderId(e.getOrderId());
            uocOrderRelPO.setInspectionOrderId(e.getInspectionVoucherId());
            uocOrderRelPO.setRelType(e.getRelType());
            uocOrderRelPO.setSettleType(e.getSettleType());
            uocOrderRelPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            if (null != e.getRelId()) {
                uocOrderRelPO.setRelId(String.valueOf(e.getRelId()));
            }
            uocOrderRelPO.setRelStatus(e.getRelState());
            addPoList.add(uocOrderRelPO);
            List uocOrderRelItemPOS1 = JSONObject.parseArray((String)JSON.toJSONString((Object)e.getUocOrderRelItemBos()), UocOrderRelItemPO.class);
            for (UocOrderRelItemPO po : uocOrderRelItemPOS1) {
                po.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                po.setOrderRelId(uocOrderRelPO.getId());
            }
            uocOrderRelItemPOS.addAll(uocOrderRelItemPOS1);
        });
        log.debug("\u65b0\u589erel\u8868\u6570\u636e\u4e3a{}", addPoList);
        log.debug("\u65b0\u589erelItem\u8868\u6570\u636e\u4e3a{}", uocOrderRelItemPOS);
        this.uocOrderRelItemMapper.insertBatch(uocOrderRelItemPOS);
        this.orderRelMapper.insertBatch(addPoList);
    }
}

