/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.atom.api.PebUpdateSaveContractLineAtomService;
import com.tydic.uoc.common.atom.bo.PebUpdateSaveContractLineAtomReqBO;
import com.tydic.uoc.common.busi.api.PebOrderDeliveryBusiService;
import com.tydic.uoc.common.comb.api.PebOrderDeliveryCombService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebOrderDeliveryCombServiceImpl
implements PebOrderDeliveryCombService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderDeliveryCombServiceImpl.class);
    @Autowired
    private PebOrderDeliveryBusiService pebOrderDeliveryBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_UPDATE_ORDER_TOPIC:UOC_UPDATE_ORDER_TOPIC}")
    private String updateTopic;
    @Value(value="${UOC_UPDATE_ORDER_TAG:*}")
    private String updateTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private PebUpdateSaveContractLineAtomService pebUpdateSaveContractLineAtomService;

    @Override
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(PebOrderDeliveryAbilityReqBO pebOrderDeliveryAbilityReqBO) {
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = this.pebOrderDeliveryBusiService.dealPebOrderDelivery(pebOrderDeliveryAbilityReqBO);
        if (!"0000".equals(pebOrderDeliveryAbilityRspBO.getRespCode())) {
            return pebOrderDeliveryAbilityRspBO;
        }
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(pebOrderDeliveryAbilityReqBO.getSaleVoucherId());
        reqBO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
        UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
        idxSyncReqBO.setObjId(pebOrderDeliveryAbilityRspBO.getShipVoucherId());
        idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        try {
            if (this.uocESGConfig.getAbutmentESGYn().booleanValue()) {
                UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                uocOrdZmInfoPO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
                uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
                if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                    UocESGOrderSyncUpdateConsumerVO updateConsumerVO = new UocESGOrderSyncUpdateConsumerVO();
                    updateConsumerVO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
                    updateConsumerVO.setOrderStatus(Integer.valueOf(2));
                    this.uocESGSyncMsgProvider.send(new ProxyMessage(this.updateTopic, this.updateTag, JSONObject.toJSONString((Object)updateConsumerVO)));
                }
            }
        }
        catch (Exception exception) {
            log.error("\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
        }
        return pebOrderDeliveryAbilityRspBO;
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealUpdateDelivery(PebOrderDeliveryAbilityReqBO pebOrderDeliveryAbilityReqBO) {
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setShipVoucherId(pebOrderDeliveryAbilityReqBO.getShipVoucherId());
        shipPO = this.ordShipMapper.getModelBy(shipPO);
        if (shipPO == null) {
            throw new UocProBusinessException("102033", "\u53d1\u8d27\u5355\u4e3a\u7a7a");
        }
        if (!"2207".equals(shipPO.getShipStatus()) && !PebExtConstant.YES.equals(pebOrderDeliveryAbilityReqBO.getIsFile())) {
            UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
            idxSyncReqBO.setObjId(pebOrderDeliveryAbilityReqBO.getShipVoucherId());
            idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            idxSyncReqBO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
            throw new UocProBusinessException("102033", "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4");
        }
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = this.pebOrderDeliveryBusiService.dealUpdateDelivery(pebOrderDeliveryAbilityReqBO);
        if (!"0000".equals(pebOrderDeliveryAbilityRspBO.getRespCode())) {
            return pebOrderDeliveryAbilityRspBO;
        }
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(pebOrderDeliveryAbilityReqBO.getSaleVoucherId());
        reqBO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
        UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
        idxSyncReqBO.setObjId(pebOrderDeliveryAbilityReqBO.getShipVoucherId());
        idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        return pebOrderDeliveryAbilityRspBO;
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealPurDelivery(PebOrderDeliveryAbilityReqBO pebOrderDeliveryAbilityReqBO) {
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = this.pebOrderDeliveryBusiService.dealPurDelivery(pebOrderDeliveryAbilityReqBO);
        if (!"0000".equals(pebOrderDeliveryAbilityRspBO.getRespCode())) {
            return pebOrderDeliveryAbilityRspBO;
        }
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
        reqBO.setObjId(pebOrderDeliveryAbilityReqBO.getSaleVoucherId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
        UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
        idxSyncReqBO.setObjId(pebOrderDeliveryAbilityRspBO.getShipVoucherId());
        idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        if (pebOrderDeliveryAbilityReqBO.getConfirm() != null && pebOrderDeliveryAbilityReqBO.getConfirm().equals(PebExtConstant.NO)) {
            PebExtSyncUnifyChangeAbilityReqBO changeAbilityReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
            changeAbilityReqBO.setOrderId(reqBO.getOrderId());
            changeAbilityReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
            this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeAbilityReqBO);
        }
        PebUpdateSaveContractLineAtomReqBO atomReqBO = new PebUpdateSaveContractLineAtomReqBO();
        atomReqBO.setOrderId(pebOrderDeliveryAbilityReqBO.getOrderId());
        this.pebUpdateSaveContractLineAtomService.updateSaveContractLine(atomReqBO);
        return pebOrderDeliveryAbilityRspBO;
    }
}

