/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.enums.PebCommonStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.ZoneSupplierConfirmChangeReqBO;
import com.tydic.uoc.common.ability.bo.ZoneSupplierConfirmChangeRspBO;
import com.tydic.uoc.common.atom.api.UocSendNotificationExtAtomService;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.common.comb.api.UocGeneralCirculationCombService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdZmInfoTempMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdZmInfoTempPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocGeneralCirculationCombServiceImpl
implements UocGeneralCirculationCombService {
    @Autowired
    private UocGeneralCirculationBusiService uocGeneralCirculationBusiService;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private UocOrdZmInfoTempMapper uocOrdZmInfoTempMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UocSendNotificationExtAtomService uocSendNotificationExtAtomService;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = this.uocGeneralCirculationBusiService.dealGeneralCirculation(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        if (rspBO.getAuto().booleanValue() && reqBO.getActionCode().equals("ACTPEB019")) {
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB020");
            circulationReqBO.setObjId(reqBO.getObjId());
            circulationReqBO.setOrderId(reqBO.getOrderId());
            circulationReqBO.setObjType(reqBO.getObjType());
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)((Object)circulationReqBO))));
        }
        return rspBO;
    }

    @Override
    public ZoneSupplierConfirmChangeRspBO supplierConfirmChange(ZoneSupplierConfirmChangeReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setChangeOrderId(reqBO.getTempId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("102111", "\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u5355\u4fe1\u606f\uff01");
        }
        if (!UocConstant.SALE_ORDER_STATUS.CONFIRM_CHANGE.equals(ordSalePO.getChangeSaleState())) {
            throw new UocProBusinessException("102111", "\u53d8\u66f4\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u5f53\u524d\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u4f9b\u5e94\u5546\u786e\u8ba4\uff01");
        }
        if (PebCommonStatus.YES.getCode().equals(reqBO.getConfirmResult())) {
            ordSalePO.setChangeSaleState(UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL);
            this.audit(reqBO, ordSalePO);
        } else {
            ordSalePO.setChangeSaleState(UocConstant.SALE_ORDER_STATUS.REJECT_PENDING);
            this.ordSaleMapper.updateById(ordSalePO);
        }
        ZoneSupplierConfirmChangeRspBO rspBO = new ZoneSupplierConfirmChangeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void audit(ZoneSupplierConfirmChangeReqBO reqBO, OrdSalePO salePO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        UocOrdZmInfoTempPO zmInfoTempPO = this.uocOrdZmInfoTempMapper.queryById(reqBO.getTempId());
        if (Objects.nonNull(zmInfoTempPO)) {
            if (StringUtils.isNotBlank((CharSequence)zmInfoTempPO.getExt1())) {
                noTaskAuditCreateReqBO.setProcDefKey(zmInfoTempPO.getExt1());
            }
            HashMap<String, Object> ows = new HashMap<String, Object>();
            ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoTempPO.getMaterialCategory()));
            try {
                ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)salePO.getSaleFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            noTaskAuditCreateReqBO.setVariables(ows);
            noTaskAuditCreateReqBO.setCreateOperId(zmInfoTempPO.getCreateId());
            noTaskAuditCreateReqBO.setCreateOperName(zmInfoTempPO.getCreateName());
            noTaskAuditCreateReqBO.setCreateOperDept(zmInfoTempPO.getCreateOrgName());
        }
        if (Objects.isNull(noTaskAuditCreateReqBO.getProcDefKey())) {
            noTaskAuditCreateReqBO.setMenuId("M001103");
        }
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (Objects.isNull(noTaskAuditCreateReqBO.getCreateOperId())) {
            noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        }
        if (Objects.isNull(noTaskAuditCreateReqBO.getCreateOperName())) {
            noTaskAuditCreateReqBO.setCreateOperId(reqBO.getUsername());
        }
        if (Objects.isNull(noTaskAuditCreateReqBO.getCreateOperDept())) {
            noTaskAuditCreateReqBO.setCreateOperId(reqBO.getOrgName());
        }
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setUsername(noTaskAuditCreateReqBO.getCreateOperId());
        infoReqBO.setCreateOperId(noTaskAuditCreateReqBO.getCreateOperName());
        infoReqBO.setRemark("\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u53d1\u8d77\u5ba1\u6279");
        infoReqBO.setOrderId(reqBO.getOrderId());
        infoReqBO.setObjType(UocConstant.OBJ_TYPE.CHANGE);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.OBJ_TYPE.CHANGE);
        approvalObjBO.setObjId(String.valueOf(reqBO.getTempId()));
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102029", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
        sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
        sendNotificationExtAtomReqBO.setApprovalObjType(UocConstant.OBJ_TYPE.CHANGE);
        sendNotificationExtAtomReqBO.setOrderId(salePO.getOrderId());
        sendNotificationExtAtomReqBO.setOrderCode(salePO.getSaleVoucherNo());
        this.uocSendNotificationExtAtomService.sendOrderNotification(sendNotificationExtAtomReqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setChangeSaleState(UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL);
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setTbOrderId(uacNoTaskAuditCreateRspBO.getStepId());
        this.ordSaleMapper.updateById(ordSalePO);
    }
}

