/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.authority.busi.bo.StationWebBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.UocPebApproveBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebApproveCombService;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebApproveCombService")
public class UocPebApproveCombServiceImpl
implements UocPebApproveCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebApproveCombServiceImpl.class);
    @Autowired
    private UocPebApproveBusiService uocPebApproveBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Value(value="${PUSH_ERP_ORDER_TOPIC:PUSH_ERP_ORDER_TOPIC}")
    private String pushErpTopic;
    @Value(value="${PUSH_ERP_ORDER_TOPIC:*}")
    private String pushErpTag;
    @Resource(name="pushErpOrderOrderProvider")
    private ProxyMessageProducer pushErpOrderOrderProvider;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${SUPPLIER_JD_ID}")
    private String jdId;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;

    @Override
    public UocPebApproveRspBO dealPebApprove(UocPebApproveReqBO reqBO) {
        UocPebApproveRspBO rsp = new UocPebApproveRspBO();
        this.validateParam(reqBO);
        ArrayList<Long> taskList = new ArrayList<Long>();
        List umcStationsListWebExt = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), StationWebBO.class);
        for (StationWebBO webBO : umcStationsListWebExt) {
            taskList.add(webBO.getStationId());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setTaskList(taskList);
        salePO.setOrderId(reqBO.getOrderId());
        int count = this.ordSaleMapper.getAuditCount(salePO);
        if (count == 0) {
            this.uocPebOrdIdxSync(reqBO.getOrderId(), reqBO.getSaleVoucherId());
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u60a8\u6ca1\u6709\u8be5\u8ba2\u5355\u7684\u5ba1\u6279\u6743\u9650");
            return rsp;
        }
        UocPebApproveBusiReqBO approveBusiReqBO = new UocPebApproveBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)approveBusiReqBO));
        UocPebApproveBusiRspBO busiRspBO = this.uocPebApproveBusiService.dealPebApprove(approveBusiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new UocProBusinessException("103008", busiRspBO.getRespDesc());
        }
        if (busiRspBO.getFinish().booleanValue()) {
            if ("1".equals(reqBO.getFlag())) {
                if (busiRspBO.getPay() == null) {
                    String str = this.submit(reqBO);
                    if (StringUtils.isBlank((CharSequence)str)) {
                        rsp.setPass(Boolean.valueOf(true));
                    } else {
                        rsp.setPass(Boolean.valueOf(false));
                        rsp.setRemark(str);
                    }
                    rsp.setPass(Boolean.valueOf(true));
                } else {
                    rsp.setPass(Boolean.valueOf(true));
                }
            } else {
                this.cancel(reqBO, "\u8ba2\u5355\u5ba1\u6279\u4e0d\u901a\u8fc7", null);
            }
        }
        SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
        sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
        sendNotificationExtAtomReqBO.setOrderId(reqBO.getOrderId());
        sendNotificationExtAtomReqBO.setFinish(busiRspBO.getFinish());
        sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_AUDIT);
        if ("1".equals(reqBO.getFlag())) {
            sendNotificationExtAtomReqBO.setAuditResult(0);
        } else {
            sendNotificationExtAtomReqBO.setAuditResult(1);
        }
        this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
        this.uocPebOrdIdxSync(busiRspBO.getOrderId(), busiRspBO.getSaleId());
        rsp.setFinish(busiRspBO.getFinish());
        rsp.setRespCode("0000");
        if ("1".equals(reqBO.getFlag())) {
            rsp.setRespDesc("\u5ba1\u6279\u901a\u8fc7\u6210\u529f\uff01");
        } else {
            rsp.setRespDesc("\u5ba1\u6279\u9a73\u56de\u6210\u529f\uff01");
        }
        return rsp;
    }

    private String submit(UocPebApproveReqBO busiReqBO) {
        try {
            UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
            submitReqBO.setSaleVoucherId(busiReqBO.getSaleVoucherId());
            submitReqBO.setOrderId(busiReqBO.getOrderId());
            submitReqBO.setUserId(busiReqBO.getUserId());
            submitReqBO.setUsername(busiReqBO.getUsername());
            this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
            OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
            ordStakeholderPO.setOrderId(busiReqBO.getOrderId());
            ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
            PebDealOrderBO orderBO = new PebDealOrderBO();
            orderBO.setPushOrderId(busiReqBO.getOrderId());
            this.pushErpOrderOrderProvider.send(new ProxyMessage(this.pushErpTopic, this.pushErpTag, JSONObject.toJSONString((Object)orderBO)));
        }
        catch (Exception e) {
            throw new UocProBusinessException("103008", "\u5ba1\u6279\u65f6\u67e5\u8be2\u662f\u5426\u662f\u9884\u5b9a\u5355\u5931\u8d25" + e.getMessage());
        }
        return null;
    }

    private void cancel(UocPebApproveReqBO reqBO, String desc, String fail) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(reqBO.getOrderId());
        cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelReqBO.setCancelOperId(String.valueOf(reqBO.getUsername()));
        cancelReqBO.setCancelDesc(desc);
        cancelReqBO.setCancelReason(desc);
        cancelReqBO.setFailCode(fail);
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "0");
        cancelReqBO.setVariables(map);
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103008", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25" + rspBO.getRespDesc());
        }
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
    }

    private void validateParam(UocPebApproveReqBO combReqBO) {
        if (null == combReqBO) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010SaleVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)combReqBO.getFlag())) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010Flag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getUserId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010UserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)combReqBO.getDealDesc())) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5ba1\u6279\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void uocPebOrdIdxSync(Long orderId, Long saleId) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(saleId);
        reqBO.setOrderId(orderId);
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }
}

