/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocPebExtRetailerNoticeShipBusiService;
import com.tydic.uoc.common.comb.api.UocPebExtRetailerNoticeShipCombService;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebExtRetailerNoticeShipCombService")
public class UocPebExtRetailerNoticeShipCombServiceImpl
implements UocPebExtRetailerNoticeShipCombService {
    @Autowired
    private UocPebExtRetailerNoticeShipBusiService uocPebExtRetailerNoticeShipBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TOPIC:DEAL_WAREHOUSE_SHIP_TOPIC}")
    private String pushWarehouseShipTopic;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TAG:DEAL_WAREHOUSE_SHIP_TAG}")
    private String pushWarehouseShipTag;
    @Resource(name="dealPushWarehouseShipProvider")
    private ProxyMessageProducer dealPushWarehouseShipProvider;

    @Override
    public UocPebExtRetailerNoticeShipRspBO executeUpdateOrCreateShip(UocPebExtRetailerNoticeShipReqBO reqBO) {
        UocPebExtRetailerNoticeShipRspBO rspBO = this.uocPebExtRetailerNoticeShipBusiService.dealExecuteUpdateOrCreateShip(reqBO);
        UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
        UocPebOrdIdxSyncReqBO shipOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getShipVoucherId(), UocConstant.OBJ_TYPE.SHIP);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)shipOrdIdxSyncReqBO)));
        if (rspBO.getOrderId() != null) {
            UocOrdWarehousePO uocOrdWarehousePO = new UocOrdWarehousePO();
            uocOrdWarehousePO.setOrderId(rspBO.getOrderId());
            uocOrdWarehousePO = this.uocOrdWarehouseMapper.getModelBy(uocOrdWarehousePO);
            if (uocOrdWarehousePO != null && uocOrdWarehousePO.getWarehouseId() != null) {
                OrdShipPO ordShipPO = new OrdShipPO();
                ordShipPO.setShipVoucherId(rspBO.getShipVoucherId());
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
                if (!UocCoreConstant.PUSH_STATUS.SUCCESS.equals(ordShipPO.getPushStatus())) {
                    PebExtPushWarehouseShipAbilityReqBO warehouseShipAbilityReqBO = new PebExtPushWarehouseShipAbilityReqBO();
                    warehouseShipAbilityReqBO.setOrderId(rspBO.getOrderId());
                    warehouseShipAbilityReqBO.setShipVoucherId(rspBO.getShipVoucherId());
                    this.dealPushWarehouseShipProvider.send(new ProxyMessage(this.pushWarehouseShipTopic, this.pushWarehouseShipTag, JSON.toJSONString((Object)warehouseShipAbilityReqBO)));
                }
            }
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103002", "\u901a\u8fc7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO) + "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\u539f\u56e0\uff1a" + rspBO.getRespDesc());
        }
        return rspBO;
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType);
        return ordIdxSyncReqBO;
    }
}

