/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.ppc.ability.api.PlanDiversionManualSyncAbilityService;
import com.tydic.ppc.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.busi.api.UocPebOrderCancellationBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationReqBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationRspBO;
import com.tydic.uoc.common.comb.api.UocPebOrderCancellationCombService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocPebOrderCancellationCombServiceImpl
implements UocPebOrderCancellationCombService {
    @Autowired
    private UocPebOrderCancellationBusiService uocPebOrderCancellationBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Autowired
    private PlanDiversionManualSyncAbilityService planDiversionManualSyncAbilityService;

    @Override
    public UocPebOrderCancellationRspBO dealPebOrderCancellation(UocPebOrderCancellationReqBO reqBO) {
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
        }
        Long saleId = reqBO.getSaleVoucherId();
        UocPebOrderCancellationRspBO rspBO = this.uocPebOrderCancellationBusiService.dealPebOrderCancellation(reqBO);
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(saleId);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        if (!CollectionUtils.isEmpty(rspBO.getPlanIds())) {
            PlanDiversionSyncReqBO planDiversionSyncReqBO = new PlanDiversionSyncReqBO();
            planDiversionSyncReqBO.setPlanIds(rspBO.getPlanIds());
            this.planDiversionManualSyncAbilityService.manualSyncPlanDiversion(planDiversionSyncReqBO);
        }
        return rspBO;
    }
}

