/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.tydic.uac.exception.BusinessException;
import com.tydic.uoc.base.bo.ImportField;
import com.tydic.uoc.common.utils.ExcelUtils;
import com.tydic.uoc.common.utils.HttpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class BatchImportUtils<T> {
    public static final String IMP_RESULT_STR = "impResult";
    public static final String IMP_REMARK_STR = "impRemark";
    public static final String EXCEPTION_ERROR_CODE = "8888";
    public static final String REQUIRED_ERROR_CODE = "0001";
    public static final String FORMAT_ERROR_CODE = "0002";
    public static final String VALUE_ERROR_CODE = "0003";
    public static final String SUCCESS = "0";
    public static final String FAILED = "1";
    private Class<T> tClass;
    private List<String> title;
    private List<List<String>> data;
    private List<Map<String, Object>> importDataMaps;

    public List<Map<String, Object>> getImportDataMaps() {
        return this.importDataMaps;
    }

    public List<String> getTitle() {
        return this.title;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public BatchImportUtils(List<String> title, List<List<String>> data, Class<T> tClass) {
        this.title = title;
        this.data = data;
        this.tClass = tClass;
        this.importDataMaps = new ArrayList<Map<String, Object>>();
    }

    public void processExcelData() {
        HashMap<Integer, String> dateMapIndex = new HashMap<Integer, String>();
        Field[] fields = this.tClass.getDeclaredFields();
        block2: for (Field field : fields) {
            ImportField annotation;
            if (field.getName().equals("serialVersionUID") || (annotation = field.getAnnotation(ImportField.class)) == null) continue;
            int index = annotation.index();
            String mapping = annotation.mapping();
            if (index != 0) {
                dateMapIndex.put(index, field.getName());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)mapping)) continue;
            for (int i = 0; i < this.title.size(); ++i) {
                if (!this.title.get(i).equals(mapping.trim()) && !this.title.get(i).equals(mapping)) continue;
                dateMapIndex.put(i, field.getName());
                continue block2;
            }
        }
        if (dateMapIndex.size() == 0) {
            return;
        }
        for (List list : this.data) {
            boolean errMsgFlag = false;
            String errCode = "";
            HashMap dataMap = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                String content = (String)list.get(i);
                if ("null".equals(content)) {
                    content = "";
                }
                try {
                    Field field = this.tClass.getDeclaredField((String)dateMapIndex.get(i));
                    ImportField annotation = field.getAnnotation(ImportField.class);
                    if (annotation != null) {
                        Pattern pattern;
                        if (annotation.isMustFill() && StringUtils.isBlank((CharSequence)content)) {
                            errMsgFlag = true;
                            errCode = REQUIRED_ERROR_CODE;
                        }
                        if (!StringUtils.isBlank((CharSequence)annotation.reg()) && !(pattern = Pattern.compile(annotation.reg())).matcher(content).matches()) {
                            errMsgFlag = true;
                            errCode = FORMAT_ERROR_CODE;
                        }
                        if (annotation.valueMap().length > 0 && !annotation.valueMap()[0].equals("") && !Arrays.toString(annotation.valueMap()).contains(content)) {
                            errMsgFlag = true;
                            errCode = VALUE_ERROR_CODE;
                        }
                        field.setAccessible(true);
                        if (StringUtils.isBlank((CharSequence)content)) continue;
                        dataMap.put(dateMapIndex.get(i), content);
                        dataMap.put(IMP_RESULT_STR, SUCCESS);
                        dataMap.put(IMP_REMARK_STR, " ");
                    }
                    if (!errMsgFlag || StringUtils.isBlank((CharSequence)content)) continue;
                    dataMap.put(dateMapIndex.get(i), content);
                    dataMap.put(IMP_RESULT_STR, FAILED);
                    dataMap.put(IMP_REMARK_STR, errCode);
                    continue;
                }
                catch (Exception e) {
                    if (StringUtils.isBlank((CharSequence)content)) continue;
                    dataMap.put(dateMapIndex.get(i), content);
                    dataMap.put(IMP_RESULT_STR, FAILED);
                    dataMap.put(IMP_REMARK_STR, "8888:" + e.toString());
                }
            }
            if (dataMap.keySet().size() <= 0) continue;
            this.importDataMaps.add(dataMap);
        }
    }

    private void setFieldValueType(Class declaringClass, Field field, Object obj, String content, ImportField annotation) throws Exception {
        if (declaringClass.equals(Long.class)) {
            field.set(obj, Long.valueOf(content));
        } else if (declaringClass.equals(String.class)) {
            field.set(obj, String.valueOf(content));
        } else if (declaringClass.equals(Integer.class)) {
            field.set(obj, Integer.valueOf(content));
        } else if (declaringClass.equals(Byte.class)) {
            field.set(obj, Byte.valueOf(content));
        } else if (declaringClass.equals(Double.class)) {
            field.set(obj, Double.valueOf(content));
        } else if (declaringClass.equals(Date.class)) {
            SimpleDateFormat simpleDateFormatter = new SimpleDateFormat(annotation.format());
            field.set(obj, simpleDateFormatter.parse(content));
        } else if (declaringClass.equals(BigDecimal.class)) {
            field.set(obj, new BigDecimal(content));
        } else {
            field.set(obj, null);
        }
    }

    private void setMethodValue(Method[] methods, String objName, Object objValue) {
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.equals("set" + objName.substring(0, 1).toUpperCase() + objName.substring(1))) continue;
            try {
                method.invoke(objValue, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void batchImport(String url, int titleRow, int dataRow, int maxSize) {
        if (this.data == null || this.title == null) {
            return;
        }
        try {
            String fileName = "content_" + UUID.randomUUID().toString() + ".xlsx";
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + fileName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(url, file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            BatchImportUtils.getExcelDateByImport((MultipartFile)multipartFile, this.data, this.title, titleRow, dataRow);
            int flag = 0;
            for (String s : this.title) {
                if (!"\u660e\u7ec6id".equals(s)) continue;
                ++flag;
            }
            if (flag == 1) {
                this.title.remove("\u660e\u7ec6id");
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(this.title)) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(this.data)) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (maxSize != -1 && this.data.size() > maxSize) {
            throw new BusinessException(EXCEPTION_ERROR_CODE, "\u6587\u4ef6\u5185\u5bb9\u6700\u591a" + maxSize + "\u884c\u6570\u636e\uff01");
        }
        this.processExcelData();
    }

    private static void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, int titleRow, int dataRow) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < titleRow) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == titleRow) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < dataRow) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str.trim());
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(EXCEPTION_ERROR_CODE, e.getMessage());
        }
    }
}

