/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.EncryptUtil;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileBatchUploadAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileUploadAtomReqBO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(500000).setSocketTimeout(500000).setConnectTimeout(500000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("stamp", EncryptUtil.getStamp());
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u63a5\u53e3\u62a5\u9519" + ex);
        }
        return result;
    }

    public static String doPost(String url, String body, Map<String, String> headerMap) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setSocketTimeout(5000).setConnectTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            for (String key : headerMap.keySet()) {
                httpPost.setHeader(key, headerMap.get(key));
            }
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("stamp", EncryptUtil.getStamp());
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUpload(String actionUrl, PebExtUnifyFileUploadAtomReqBO reqBO) throws IOException {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        String result = null;
        String boundary = "--------------4585696313564699";
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("filename", new StringBody(reqBO.getFileName(), Charset.forName("UTF-8")));
        mapParam.put("file", new FileBody(reqBO.getFile()));
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        for (Map.Entry param : mapParam.entrySet()) {
            multipartEntityBuilder.addPart((String)param.getKey(), (ContentBody)param.getValue()).setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
        multipartEntityBuilder.setBoundary(boundary);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                System.out.println("--------------------------------------");
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
                System.out.println("--------------------------------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUploadBatch(String actionUrl, PebExtUnifyFileBatchUploadAtomReqBO reqBO) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        String result = null;
        String boundary = "--------------4585696313564699";
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        for (PebExtUnifyFileUploadBO pebExtUnifyFileUploadBO : reqBO.getFileList()) {
            multipartEntityBuilder.addPart("files", (ContentBody)new FileBody(pebExtUnifyFileUploadBO.getFile())).setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        multipartEntityBuilder.setBoundary(boundary);
        multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String doPost(String url, String body, String token) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000).setSocketTimeout(3000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("auth-token", token);
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static String doGet(String url) {
        String result = null;
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpGet.setConfig(requestConfig);
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static boolean httpDownload(String httpUpUrl, String saveFile) {
        int byteread = 0;
        URL url = null;
        try {
            url = new URL(httpUpUrl);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream inStream = conn.getInputStream();
            FileOutputStream fs = new FileOutputStream(saveFile);
            byte[] buffer = new byte[1204];
            while ((byteread = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.flush();
            fs.close();
            inStream.close();
            if (conn != null) {
                conn.disconnect();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(String fileName) {
        File directory = new File(".");
        String operSystem = System.getProperties().getProperty("os.name");
        try {
            String filePath = operSystem.indexOf("Windows") > 0 ? directory.getCanonicalPath() + "\\" + fileName : directory.getCanonicalPath() + "/" + fileName;
            File file = new File(filePath);
            if (!file.exists()) {
                System.out.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + filePath + "\u4e0d\u5b58\u5728\uff01");
                return false;
            }
            if (file.isFile()) {
                if (file.delete()) {
                    System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u6210\u529f\uff01");
                    return true;
                }
                System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u5931\u8d25\uff01");
                return false;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

