/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListReqBO;
import com.tydic.uoc.common.busi.bo.UocSearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class UocBuildEsQryChangeSqlUtil {
    public String buildQryChangeOrderEsSql(UocEsQryOrderListReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(reqBO.getChangeTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getChangeTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"changeTaskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getChangeApproveIdList())) {
                for (String changeApprove : reqBO.getChangeApproveIdList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"changeApproveIdList", (String[])new String[]{changeApprove}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getChangeTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"changeTaskUserIdList", (String[])new String[]{reqBO.getChangeTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getChangeApproveIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String priceApprover : reqBO.getChangeApproveIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"changeApproveIdList", (String[])new String[]{priceApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getChangeTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"changeTaskUserIdList", (String[])new String[]{reqBO.getChangeTaskUserId()}));
        }
        if (Objects.nonNull(reqBO.getOrderChangeYn()) && reqBO.getOrderChangeYn().booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"changeOrderId"));
        }
        if (Objects.nonNull(reqBO.getChangeAuditTimeStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"changeAuditTimeStart");
            rangeQueryBuilder.gte((Object)reqBO.getChangeAuditTimeStart());
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (Objects.nonNull(reqBO.getChangeAuditTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"changeAuditTimeEnd");
            rangeQueryBuilder.lte((Object)reqBO.getChangeAuditTimeEnd());
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getChangeOrderId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeOrderId", (Object)reqBO.getChangeOrderId()));
        }
        if (reqBO.getChangeSaleState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeSaleState", (Object)reqBO.getChangeSaleState()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getChangeSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"changeSaleState", reqBO.getChangeSaleStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateQuery())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateQuery()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditResult())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"auditResult", (String)reqBO.getAuditResult()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBuynerNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"buynerNo.keyword", (String)("*" + reqBO.getBuynerNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBuynerName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"buynerName.keyword", (String)("*" + reqBO.getBuynerName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSupplierNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplierNo.keyword", (String)("*" + reqBO.getSupplierNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCreateCompanyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"companyName.keyword", (String)("*" + reqBO.getCreateCompanyName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCompanyNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"companyNo.keyword", (String)("*" + reqBO.getCompanyNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCreateOperNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperNo.keyword", (String)("*" + reqBO.getCreateOperNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialId.keyword", (String)("*" + reqBO.getSkuMaterialId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialName.keyword", (String)("*" + reqBO.getSkuMaterialName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialTypeId.keyword", (String)("*" + reqBO.getSkuMaterialTypeId() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPurCompanyId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purCompanyId", reqBO.getPurCompanyId()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPurCompanyNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purCompanyNo.keyword", (String)("*" + reqBO.getPurCompanyNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPurCompanyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purCompanyName.keyword", (String)("*" + reqBO.getPurCompanyName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlaAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"plaAgreementCode.keyword", (String)("*" + reqBO.getPlaAgreementCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"protocolName", (Object)reqBO.getProtocolName()));
        }
        if (null != reqBO.getIndividuallyPayType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"individuallyPayType", (Object)reqBO.getIndividuallyPayType()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planItemNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderStage())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderStage", (String)reqBO.getOrderStage()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPurType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purType.keyword", (String)reqBO.getPurType()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payStatus", (String)reqBO.getPayStatus()));
        }
        if (reqBO.getIsPushErp() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"erpStatus", (Object)reqBO.getIsPushErp()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrganizationIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"organizationId", reqBO.getOrganizationIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrganizationName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"organizationName.keyword", (String)("*" + reqBO.getOrganizationName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getIsNegotiatingPrice())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isNegotiatingPrice", (Object)reqBO.getIsNegotiatingPrice()));
        }
        SortOrder order = SortOrder.DESC;
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty(reqBO.getChangeSaleStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("changeSaleState");
                List<Integer> changeStateList = new ArrayList<Integer>(reqBO.getChangeSaleStateList());
                changeStateList = changeStateList.stream().distinct().collect(Collectors.toList());
                agg.size(changeStateList.size());
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (10000 < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)10000);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        queryJson.put("query", (Object)JSON.parseObject((String)uocSearchEsSQLRspBO.getBoolQueryBuilder().toString()));
        queryJson.put("sort", (Object)JSON.parseArray((String)uocSearchEsSQLRspBO.getSortQuery().toString()));
        return queryJson.toJSONString();
    }
}

