/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcQuerySupplierDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.PebExtPushFzOrderEvaluateAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateBO;
import com.tydic.uoc.common.ability.bo.PebExtPushFzOrderEvaluateItemBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushFzOrderEvaluateBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushFzOrderEvaluateBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushFzOrderEvaluateBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushFzOrderEvaluateAbilityService"})
public class PebExtPushFzOrderEvaluateAbilityServiceImpl
implements PebExtPushFzOrderEvaluateAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private PebExtPushFzOrderEvaluateBusiService pebExtPushFzOrderEvaluateBusiService;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private UmcQuerySupplierDetailAbilityService umcQuerySupplierDetailAbilityService;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${ORDER_EVALUATE_BASE_URL:http://172.16.8.99/#/index}")
    private String orderEvaluateBaseUrl;

    @FscDuplicateCommitLimit
    @PostMapping(value={"pushFzOrderEvaluate"})
    public PebExtPushFzOrderEvaluateAbilityRspBO pushFzOrderEvaluate(@RequestBody PebExtPushFzOrderEvaluateAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            throw new UocProBusinessException("8888", "\u6839\u636e\u5165\u53c2orderId[" + reqBO.getOrderId() + "]\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.CANCEL) || salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE)) {
            if (zmInfoPO.getEvaluatePushStatus() == null || zmInfoPO.getEvaluatePushStatus().equals(UocCoreConstant.PUSH_STATUS.FAIL)) {
                return new PebExtPushFzOrderEvaluateAbilityRspBO();
            }
            if (zmInfoPO.getEvaluateCancelStatus() != null && zmInfoPO.getEvaluateCancelStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
                return new PebExtPushFzOrderEvaluateAbilityRspBO();
            }
        } else if (zmInfoPO.getEvaluatePushStatus() != null && zmInfoPO.getEvaluatePushStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
            throw new UocProBusinessException("8888", "\u5df2\u63a8\u9001\u975e\u62db\u8bc4\u4ef7\u53d6\u6d88\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (orderPO.getOrderType().equals(PebExtConstant.OrderType.FL) || orderPO.getOrderType().equals(PebExtConstant.OrderType.GC) || salePO.getOrderSource().equals("2")) {
            return new PebExtPushFzOrderEvaluateAbilityRspBO();
        }
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(reqBO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        if (ordStakeholderPO.getSupNo().equals(this.operationSupId)) {
            PebExtPushFzOrderEvaluateAbilityRspBO rspBO = new PebExtPushFzOrderEvaluateAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u8ba2\u5355\u4f9b\u8d27\u65b9\u662f\u5f00\u53d1\u516c\u53f8,\u4e0d\u9700\u63a8\u9001!");
        }
        PebExtPushFzOrderEvaluateBO evaluateBO = new PebExtPushFzOrderEvaluateBO();
        evaluateBO.setDycOrderId(salePO.getOrderId() + "");
        evaluateBO.setOrderCode(salePO.getSaleVoucherNo());
        evaluateBO.setOrderNum(salePO.getSaleVoucherNo());
        evaluateBO.setOrderName(orderPO.getOrderName());
        evaluateBO.setCreateTime(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
        OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
        ordStateChgLogPO.setOrderId(reqBO.getOrderId());
        ordStateChgLogPO.setOldState(UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT);
        ordStateChgLogPO.setOrderBy("chg_time desc");
        List logPOS = this.ordStateChgLogMapper.getList(ordStateChgLogPO);
        if (!CollectionUtils.isEmpty((Collection)logPOS)) {
            evaluateBO.setCheckDate(DateUtils.dateToStrLong((Date)((OrdStateChgLogPO)logPOS.get(0)).getChgTime()));
        }
        if (salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.CANCEL) || salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE)) {
            evaluateBO.setStatus(UocConstant.EvaluateOrderStatus.CANCEL);
        } else {
            evaluateBO.setStatus(UocConstant.EvaluateOrderStatus.AUDIT_PASS);
        }
        evaluateBO.setBuyerNo(zmInfoPO.getBuynerNo());
        evaluateBO.setBuyerName(zmInfoPO.getBuynerName());
        UmcQuerySupplierDetailAbilityReqBO supplierDetailAbilityReqBO = new UmcQuerySupplierDetailAbilityReqBO();
        supplierDetailAbilityReqBO.setSupplierId(Long.valueOf(ordStakeholderPO.getSupNo()));
        UmcQuerySupplierDetailAbilityRspBO umcQuerySupplierDetailAbilityRspBO = this.umcQuerySupplierDetailAbilityService.querySupplierDetail(supplierDetailAbilityReqBO);
        if (!umcQuerySupplierDetailAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(umcQuerySupplierDetailAbilityRspBO.getRespCode(), "\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u5931\u8d25:" + umcQuerySupplierDetailAbilityRspBO.getRespDesc());
        }
        if (umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a:" + umcQuerySupplierDetailAbilityRspBO.getRespDesc());
        }
        evaluateBO.setSupplierCode(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getSupplierCode());
        evaluateBO.setSupplierId(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getOrgCode());
        evaluateBO.setSupplierName(umcQuerySupplierDetailAbilityRspBO.getSupplierDetailBO().getOrgName());
        if (zmInfoPO.getVendorSiteId() != null) {
            evaluateBO.setAddressId(zmInfoPO.getVendorSiteId() + "");
        }
        evaluateBO.setShortAddress(zmInfoPO.getVendorSiteName());
        evaluateBO.setCurrency(zmInfoPO.getCurrency());
        if (!StringUtils.isEmpty((Object)zmInfoPO.getExchangeRate())) {
            evaluateBO.setExchangeRate(new BigDecimal(zmInfoPO.getExchangeRate()));
        }
        evaluateBO.setPurchaseCode(zmInfoPO.getPurCompanyNo());
        evaluateBO.setPurchaseName(zmInfoPO.getPurCompanyName());
        evaluateBO.setSignerEmployeeNumber(ordStakeholderPO.getPurLogName());
        evaluateBO.setSignerName(ordStakeholderPO.getPurPlaceOrderName());
        evaluateBO.setModelSettle(salePO.getModelSettle());
        OrdAgreementPO agreementPO = new OrdAgreementPO();
        agreementPO.setOrderId(reqBO.getOrderId());
        List agreementPOS = this.ordAgreementMapper.selectByCondition(agreementPO);
        if (salePO.getOrderSource().equals("1")) {
            if (salePO.getModelSettle().equals(UocCoreConstant.TradeMode.TRADE_MODEL)) {
                evaluateBO.setUrl(this.orderEvaluateBaseUrl + "/agrOrderMenuDeatil?type=1&tableType=2&PDFId=&showType=1&planitemId=1&orderId=" + salePO.getOrderId() + "&saleVoucherId=" + salePO.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=" + ((OrdAgreementPO)agreementPOS.get(0)).getAgreementId());
            } else {
                evaluateBO.setUrl(this.orderEvaluateBaseUrl + "/agrOrderMenuDeatil?type=11&tableType=2&PDFId=2&showType=11&planitemId=1&orderId=" + salePO.getOrderId() + "&saleVoucherId=" + salePO.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=" + ((OrdAgreementPO)agreementPOS.get(0)).getAgreementId());
            }
        } else if (salePO.getOrderSource().equals("2")) {
            evaluateBO.setUrl(this.orderEvaluateBaseUrl + "/orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo=" + salePO.getSaleVoucherNo() + "&upperOrderId=" + orderPO.getUpperOrderId() + "&orderId=" + salePO.getOrderId() + "&saleVoucherId=" + salePO.getSaleVoucherId());
        } else if (salePO.getOrderSource().equals("3")) {
            evaluateBO.setUrl(this.orderEvaluateBaseUrl + "/agrOrderMenuDeatil?type=11&tableType=2&PDFId=2&showType=11&planitemId=1&orderId=" + salePO.getOrderId() + "&saleVoucherId=" + salePO.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=");
        } else {
            evaluateBO.setUrl(this.orderEvaluateBaseUrl + "/contractOrderMenuDeatil?orderId=" + salePO.getOrderId() + "&saleVoucherId=" + salePO.getSaleVoucherId() + "&createType=&auditStatus=1");
        }
        if (!StringUtils.isEmpty((Object)salePO.getExt2()) && !StringUtils.isEmpty((Object)((OrdAgreementPO)agreementPOS.get(0)).getContactId())) {
            ContractDetailQueryAbilityReqBO abilityReqBO = new ContractDetailQueryAbilityReqBO();
            abilityReqBO.setContractId(Long.valueOf(((OrdAgreementPO)agreementPOS.get(0)).getContactId()));
            ContractDetailQueryAbilityRspBO abilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(abilityReqBO);
            if (StringUtils.isEmpty((Object)abilityRspBO.getContractId())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff1a" + abilityRspBO.getMessage());
            }
            if (abilityRspBO.getContractType() != null) {
                String pactType = this.getDicCodeValue("PEB_FZ_PACT_TYPE", abilityRspBO.getContractType().toString());
                evaluateBO.setPactType(pactType);
            }
            if (abilityRspBO.getPurchaseType() != null) {
                String purchaseWay = this.getDicCodeValue("PEB_FZ_PURCHASE_WAY", abilityRspBO.getPurchaseType().toString());
                evaluateBO.setPurchaseWay(purchaseWay);
            }
        }
        List<PebExtPushFzOrderEvaluateItemBO> itemList = this.buildItemInfo(evaluateBO, salePO);
        evaluateBO.setOrderItem(itemList);
        PebExtPushFzOrderEvaluateBusiReqBO busiReqBO = new PebExtPushFzOrderEvaluateBusiReqBO();
        busiReqBO.setOrderId(salePO.getOrderId());
        busiReqBO.setOrderNo(salePO.getSaleVoucherNo());
        busiReqBO.setEvaluateBO(evaluateBO);
        PebExtPushFzOrderEvaluateBusiRspBO busiRspBO = this.pebExtPushFzOrderEvaluateBusiService.dealPushOrderEvaluate(busiReqBO);
        this.sendMq(salePO);
        return (PebExtPushFzOrderEvaluateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushFzOrderEvaluateAbilityRspBO.class);
    }

    private void sendMq(OrdSalePO salePO) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(salePO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }

    private List<PebExtPushFzOrderEvaluateItemBO> buildItemInfo(PebExtPushFzOrderEvaluateBO evaluateBO, OrdSalePO salePO) {
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(salePO.getOrderId());
        List goods = this.ordGoodsMapper.getList(goodsPO);
        Map<Long, OrdGoodsPO> goodsMap = goods.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, e -> e, (k, v) -> k));
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(salePO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        ArrayList<PebExtPushFzOrderEvaluateItemBO> itemList = new ArrayList<PebExtPushFzOrderEvaluateItemBO>(list.size());
        for (OrdItemPO ordItemPO : list) {
            PebExtPushFzOrderEvaluateItemBO itemBO = new PebExtPushFzOrderEvaluateItemBO();
            itemBO.setId(ordItemPO.getOrdItemId() + "");
            itemBO.setAgreementCode(evaluateBO.getOrderCode());
            OrdGoodsPO ordGoodsPO = goodsMap.get(ordItemPO.getOrdItemId());
            itemBO.setGoodsCode(ordGoodsPO.getSkuMaterialId());
            itemBO.setGoodsDesc(ordItemPO.getExtField2());
            itemBO.setStatisticUnit(ordItemPO.getUnitName());
            itemBO.setAmount(ordItemPO.getPurchaseCount());
            itemBO.setTaxPrice(MoneyUtil.l4B((Long)ordItemPO.getSalePrice()));
            itemBO.setContainTaxAmount(MoneyUtil.l4B((Long)ordItemPO.getTotalSaleFee()).setScale(2, RoundingMode.HALF_UP));
            if (ordItemPO.getTax() == null) {
                throw new UocProBusinessException("8888", "\u660e\u7ec6\u884c" + ordItemPO.getOrdItemId() + "\u7a0e\u7387\u4e3a\u7a7a\uff01");
            }
            itemBO.setTaxRate(ordItemPO.getTax());
            BigDecimal callTaxRate = BigDecimal.ONE.add(new BigDecimal(ordItemPO.getTax()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            itemBO.setNoTaxPrice(itemBO.getTaxPrice().divide(callTaxRate, 6, RoundingMode.HALF_UP));
            itemBO.setNoTaxAmount(itemBO.getContainTaxAmount().divide(callTaxRate, 2, RoundingMode.HALF_UP));
            itemBO.setTaxAmount(itemBO.getContainTaxAmount().subtract(itemBO.getNoTaxAmount()));
            itemBO.setDeliveryGoodsDate(salePO.getGiveTime());
            itemBO.setCreateOutUserId(evaluateBO.getSignerEmployeeNumber());
            itemBO.setCreateTime(evaluateBO.getCreateTime());
            if (ordItemPO.getPlanId() != null) {
                itemBO.setPlanItemId(ordItemPO.getPlanId() + "");
            }
            itemBO.setGoodTypeId(null);
            itemBO.setFirmId(evaluateBO.getSupplierId());
            itemList.add(itemBO);
        }
        return itemList;
    }

    private String getDicCodeValue(String pCode, String code) {
        SelectSingleDictReqBO selectSingleDictReqBO = new SelectSingleDictReqBO();
        selectSingleDictReqBO.setPcode(pCode);
        selectSingleDictReqBO.setCode(code);
        SelectSingleDictRspBO selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (ObjectUtils.isEmpty((Object)selectSingleDictRspBO.getDicDictionarys())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u4e3a\u7a7a\uff01");
        }
        return selectSingleDictRspBO.getDicDictionarys().getDescrip();
    }

    @PostMapping(value={"pushFzOrderEvaluateBatch"})
    public PebExtPushFzOrderEvaluateAbilityRspBO pushFzOrderEvaluateBatch(@RequestBody PebExtPushFzOrderEvaluateAbilityReqBO reqBO) {
        StringBuilder sb = new StringBuilder();
        for (Long orderId : reqBO.getOrderIds()) {
            reqBO.setOrderId(orderId);
            PebExtPushFzOrderEvaluateAbilityRspBO rspBO = this.pushFzOrderEvaluate(reqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u8ba2\u5355[").append(orderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        PebExtPushFzOrderEvaluateAbilityRspBO rspBO = new PebExtPushFzOrderEvaluateAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }
}

