/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.common.ability.api.PebExtPushWarehouseAfsCancelAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsCancelAbilityRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseAfsBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsBusiRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushWarehouseAfsCancelAbilityService"})
public class PebExtPushWarehouseAfsCancelAbilityServiceImpl
implements PebExtPushWarehouseAfsCancelAbilityService {
    @Autowired
    private PebExtPushWarehouseAfsBusiService pebExtPushWarehouseAfsBusiService;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;

    @PostMapping(value={"dealPushWarehouseAfsCancel"})
    public PebExtPushWarehouseAfsCancelAbilityRspBO dealPushWarehouseAfsCancel(@RequestBody PebExtPushWarehouseAfsCancelAbilityReqBO reqBO) {
        this.valid(reqBO);
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            return new PebExtPushWarehouseAfsCancelAbilityRspBO();
        }
        OrdAfterServicePO afterServicePO = new OrdAfterServicePO();
        afterServicePO.setOrderId(reqBO.getOrderId());
        afterServicePO.setAfterServId(reqBO.getAfterServId());
        afterServicePO = this.ordAfterServiceMapper.getModelBy(afterServicePO);
        if (afterServicePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\uff01");
        }
        String warehouseId = this.getEcomWarehouseCode(warehousePO.getSupplierId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("warehouseId", (Object)warehouseId);
        jsonObject.put("afsOrderId", (Object)afterServicePO.getAfterServId());
        String signStr = "warehouseId" + warehouseId + "afsOrderId" + afterServicePO.getAfterServId();
        String sign = MD5Util.MD5Encode((String)(signStr + this.warehouseSignKey), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + this.warehouseSignKey), (String)"");
        jsonObject.put("sign", (Object)sign);
        PebExtPushWarehouseAfsBusiReqBO busiReqBO = new PebExtPushWarehouseAfsBusiReqBO();
        busiReqBO.setAfterServId(reqBO.getAfterServId());
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setSupplierId(warehousePO.getSupplierId());
        busiReqBO.setJsonObject(jsonObject);
        PebExtPushWarehouseAfsBusiRspBO busiRspBO = this.pebExtPushWarehouseAfsBusiService.dealPushWarehouseAfsCancel(busiReqBO);
        return (PebExtPushWarehouseAfsCancelAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushWarehouseAfsCancelAbilityRspBO.class);
    }

    private void valid(PebExtPushWarehouseAfsCancelAbilityReqBO reqBO) {
        if (reqBO.getAfterServId() == null) {
            throw new UocProBusinessException("8888", "\u552e\u540e\u670d\u52a1\u5355id[afterServId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }
}

