/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.PebExtPushWarehouseAfsOrderAbilityService;
import com.tydic.uoc.common.ability.bo.OrdAsItemRspBOOld;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsOrderAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsOrderItemBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseAfsOrderBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsOrderBusiRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushWarehouseAfsOrderAbilityService"})
public class PebExtPushWarehouseAfsOrderAbilityServiceImpl
implements PebExtPushWarehouseAfsOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseAfsOrderAbilityServiceImpl.class);
    @Autowired
    private PebExtPushWarehouseAfsOrderBusiService pebExtPushWarehouseAfsOrderBusiService;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    private static final String sign = "sign";
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Value(value="${WAREHOUSE_ORDER_SPECIAL_SUP:100060}")
    private String warehouseOrderSpecialSup;
    @Value(value="${SUPPLIER_JD_ID}")
    private String supplierJdId;

    @PostMapping(value={"dealPushWarehouseAfsOrder"})
    public PebExtPushWarehouseAfsOrderAbilityRspBO dealPushWarehouseAfsOrder(@RequestBody PebExtPushWarehouseAfsOrderAbilityReqBO reqBO) {
        this.valid(reqBO);
        OrdAfterServicePO afterServicePO = new OrdAfterServicePO();
        afterServicePO.setOrderId(reqBO.getOrderId());
        afterServicePO.setAfterServId(reqBO.getAfterServId());
        afterServicePO = this.ordAfterServiceMapper.getModelBy(afterServicePO);
        if (afterServicePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u552e\u540e\u670d\u52a1\u5355\u4fe1\u606f\uff01");
        }
        if (afterServicePO.getWarehouseServState() != null && !afterServicePO.getWarehouseServState().equals(UocConstant.WarehouseServState.PUSH_FAIL)) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u72b6\u6001\u5141\u8bb8\u63a8\u9001\u81f3\u4f01\u914d\u4ed3\uff01");
        }
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4f01\u914d\u4ed3\u4fe1\u606f\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        PebExtPushWarehouseAfsOrderBO warehouseAfsOrderBO = new PebExtPushWarehouseAfsOrderBO();
        warehouseAfsOrderBO.setWarehouseId(this.getEcomWarehouseCode(warehousePO.getSupplierId()));
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (orderPO.getUpperOrderId() != null) {
            OrdSalePO sale = new OrdSalePO();
            sale.setOrderId(orderPO.getUpperOrderId());
            sale = this.ordSaleMapper.getModelBy(sale);
            warehouseAfsOrderBO.setThirdOrder(orderPO.getUpperOrderId());
            warehouseAfsOrderBO.setThirdOrderNo(sale.getSaleVoucherNo());
        } else {
            warehouseAfsOrderBO.setThirdOrder(orderPO.getOrderId());
            warehouseAfsOrderBO.setThirdOrderNo(salePO.getSaleVoucherNo());
        }
        warehouseAfsOrderBO.setAfsOrderId(afterServicePO.getAfterServId());
        warehouseAfsOrderBO.setServiceType(afterServicePO.getServType());
        this.buildPickUpInfo(afterServicePO, warehouseAfsOrderBO, warehousePO);
        this.buildTakeContactInfo(afterServicePO, warehouseAfsOrderBO, warehousePO);
        this.buildAfsItemInfo(reqBO, warehouseAfsOrderBO, orderPO, warehousePO.getSupplierId());
        if (StringUtils.isEmpty((Object)warehouseAfsOrderBO.getReceiptmobile())) {
            warehouseAfsOrderBO.setReceiptmobile(warehouseAfsOrderBO.getSender());
            warehouseAfsOrderBO.setRecipient(warehouseAfsOrderBO.getSendmobile());
        }
        this.sign(warehouseAfsOrderBO);
        PebExtPushWarehouseAfsOrderBusiReqBO busiReqBO = new PebExtPushWarehouseAfsOrderBusiReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setSupplierId(warehousePO.getSupplierId());
        busiReqBO.setAfterServId(afterServicePO.getAfterServId());
        busiReqBO.setWarehouseAfsOrderBO(warehouseAfsOrderBO);
        PebExtPushWarehouseAfsOrderBusiRspBO busiRspBO = this.pebExtPushWarehouseAfsOrderBusiService.dealPushWarehouseAfsOrder(busiReqBO);
        return (PebExtPushWarehouseAfsOrderAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushWarehouseAfsOrderAbilityRspBO.class);
    }

    private void sign(PebExtPushWarehouseAfsOrderBO warehouseAfsOrderBO) {
        Field[] fields;
        StringBuffer signStr = new StringBuffer();
        String key = this.warehouseSignKey;
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)warehouseAfsOrderBO), (Feature[])new Feature[]{Feature.OrderedField});
        Class<?> reqObj = warehouseAfsOrderBO.getClass();
        for (Field field : fields = reqObj.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals(sign)) continue;
            signStr.append(name);
            String value = jsonObject.getString(name);
            signStr.append(value);
        }
        log.error("\u4f01\u914d\u4ed3\u552e\u540e\u52a0\u7b7e\u53c2\u6570\uff1a" + signStr.toString());
        String sign = MD5Util.MD5Encode((String)(signStr.toString() + key), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + key), (String)"");
        warehouseAfsOrderBO.setSign(sign);
    }

    private void buildAfsItemInfo(PebExtPushWarehouseAfsOrderAbilityReqBO reqBO, PebExtPushWarehouseAfsOrderBO warehouseAfsOrderBO, OrderPO orderPO, Long supplierId) {
        OrdAsItemPO ordAsItemPO = new OrdAsItemPO();
        ordAsItemPO.setAfterServId(reqBO.getAfterServId());
        List ordAsItemRspBOOldList = this.ordAsItemMapper.getItemAndSku(ordAsItemPO);
        Map<Object, Object> itemMap = new HashMap();
        if (orderPO.getUpperOrderId() != null) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(orderPO.getUpperOrderId());
            List itemList = this.ordItemMapper.getList(ordItemPO);
            itemMap = itemList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, OrdItemPO::getLmOrderId));
        }
        ArrayList<PebExtPushWarehouseAfsOrderItemBO> skuInfos = new ArrayList<PebExtPushWarehouseAfsOrderItemBO>(ordAsItemRspBOOldList.size());
        for (OrdAsItemRspBOOld ordAsItem : ordAsItemRspBOOldList) {
            PebExtPushWarehouseAfsOrderItemBO afsOrderItemBO = new PebExtPushWarehouseAfsOrderItemBO();
            if (orderPO.getUpperOrderId() != null) {
                afsOrderItemBO.setItemId(Long.valueOf((String)itemMap.get(ordAsItem.getOrdItemId())));
            } else {
                afsOrderItemBO.setItemId(ordAsItem.getOrdItemId());
            }
            afsOrderItemBO.setMaterialCode(ordAsItem.getSkuMaterialId());
            afsOrderItemBO.setMaterialName(ordAsItem.getSkuMaterialName());
            afsOrderItemBO.setSkuName(ordAsItem.getSkuName());
            afsOrderItemBO.setExtSkuId(ordAsItem.getExtSkuId());
            afsOrderItemBO.setAfsNum(Integer.valueOf(ordAsItem.getReturnCount().intValue()));
            afsOrderItemBO.setUnitName(ordAsItem.getUnitName());
            afsOrderItemBO.setSpec(ordAsItem.getSpec());
            afsOrderItemBO.setModel(ordAsItem.getModel());
            if (this.warehouseOrderSpecialSup.contains(supplierId.toString())) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afsOrderItemBO.getSpec())) {
                    afsOrderItemBO.setSpec(afsOrderItemBO.getModel());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afsOrderItemBO.getModel())) {
                    afsOrderItemBO.setModel(afsOrderItemBO.getSpec());
                }
            }
            afsOrderItemBO.setPrice(MoneyUtil.l2B((Long)ordAsItem.getSalePrice()).setScale(2, 4));
            skuInfos.add(afsOrderItemBO);
        }
        warehouseAfsOrderBO.setSkuInfos(skuInfos);
    }

    private void buildTakeContactInfo(OrdAfterServicePO afterServicePO, PebExtPushWarehouseAfsOrderBO warehouseAfsOrderBO, UocOrdWarehousePO warehousePO) {
        if (afterServicePO.getTakeContactId() != null) {
            OrdLogisticsRelaPO logisticsRelaPO = new OrdLogisticsRelaPO();
            logisticsRelaPO.setOrderId(afterServicePO.getOrderId());
            logisticsRelaPO.setContactId(afterServicePO.getTakeContactId());
            logisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRelaPO);
            if (logisticsRelaPO != null) {
                warehouseAfsOrderBO.setRecipient(logisticsRelaPO.getContactName());
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactProvinceId())) {
                    warehouseAfsOrderBO.setReceiptprovince(Integer.valueOf(logisticsRelaPO.getContactProvinceId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactCityId())) {
                    warehouseAfsOrderBO.setReceiptcity(Integer.valueOf(logisticsRelaPO.getContactCityId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactCountyId())) {
                    warehouseAfsOrderBO.setReceiptcounty(Integer.valueOf(logisticsRelaPO.getContactCountyId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactTownId())) {
                    warehouseAfsOrderBO.setReceipttown(Integer.valueOf(logisticsRelaPO.getContactTownId()));
                }
                warehouseAfsOrderBO.setReceiptprovinceName(logisticsRelaPO.getContactProvinceName());
                warehouseAfsOrderBO.setReceiptcityName(logisticsRelaPO.getContactCityName());
                warehouseAfsOrderBO.setReceiptcountyName(logisticsRelaPO.getContactCountyName());
                warehouseAfsOrderBO.setReceipttownName(logisticsRelaPO.getContactTown());
                if (warehousePO.getSupplierId().toString().equals(this.supplierJdId)) {
                    String address = logisticsRelaPO.getContactProvinceName() + logisticsRelaPO.getContactCityName() + logisticsRelaPO.getContactCountyName();
                    if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactTown())) {
                        address = address + logisticsRelaPO.getContactTown();
                    }
                    address = address + logisticsRelaPO.getContactAddress();
                    warehouseAfsOrderBO.setReceiptaddress(address);
                } else {
                    warehouseAfsOrderBO.setReceiptaddress(logisticsRelaPO.getContactAddress());
                }
                warehouseAfsOrderBO.setReceiptmobile(logisticsRelaPO.getContactMobile());
            }
        }
    }

    private void buildPickUpInfo(OrdAfterServicePO afterServicePO, PebExtPushWarehouseAfsOrderBO warehouseAfsOrderBO, UocOrdWarehousePO warehousePO) {
        if (null != afterServicePO.getPickupContactId() || null != afterServicePO.getPickwareContactId()) {
            OrdLogisticsRelaPO logisticsRelaPO = new OrdLogisticsRelaPO();
            Long pickupContactId = afterServicePO.getPickupContactId() != null ? afterServicePO.getPickupContactId() : afterServicePO.getPickwareContactId();
            logisticsRelaPO.setContactId(pickupContactId);
            logisticsRelaPO.setOrderId(afterServicePO.getOrderId());
            logisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRelaPO);
            if (null != logisticsRelaPO) {
                warehouseAfsOrderBO.setSender(logisticsRelaPO.getContactName());
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactProvinceId())) {
                    warehouseAfsOrderBO.setSendprovince(Integer.valueOf(logisticsRelaPO.getContactProvinceId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactCityId())) {
                    warehouseAfsOrderBO.setSendcity(Integer.valueOf(logisticsRelaPO.getContactCityId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactCountyId())) {
                    warehouseAfsOrderBO.setSendcounty(Integer.valueOf(logisticsRelaPO.getContactCountyId()));
                }
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactTownId())) {
                    warehouseAfsOrderBO.setSendtown(Integer.valueOf(logisticsRelaPO.getContactTownId()));
                }
                warehouseAfsOrderBO.setSendprovinceName(logisticsRelaPO.getContactProvinceName());
                warehouseAfsOrderBO.setSendcityName(logisticsRelaPO.getContactCityName());
                warehouseAfsOrderBO.setSendcountyName(logisticsRelaPO.getContactCountyName());
                warehouseAfsOrderBO.setSendtownName(logisticsRelaPO.getContactTown());
                String address = logisticsRelaPO.getContactProvinceName() + logisticsRelaPO.getContactCityName() + logisticsRelaPO.getContactCountyName();
                if (!StringUtils.isEmpty((Object)logisticsRelaPO.getContactTown())) {
                    address = address + logisticsRelaPO.getContactTown();
                }
                address = address + logisticsRelaPO.getContactAddress();
                if (warehousePO.getSupplierId().toString().equals(this.supplierJdId)) {
                    warehouseAfsOrderBO.setSendtownaddress(address);
                } else {
                    warehouseAfsOrderBO.setSendtownaddress(logisticsRelaPO.getContactAddress());
                }
                warehouseAfsOrderBO.setSendmobile(logisticsRelaPO.getContactMobile());
            }
        }
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }

    private void valid(PebExtPushWarehouseAfsOrderAbilityReqBO reqBO) {
        if (reqBO.getAfterServId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[afterServId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

