/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.ability.api.FscOrderDetailInAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderDetailInAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderDetailInAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfQryInOrderService;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderData;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderLine;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderRspBO;
import com.tydic.uoc.common.ability.api.PebInOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdZmInfoBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipItemReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebSaleOrderConfirmShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPebShipArrivalConfirmReqBO;
import com.tydic.uoc.common.ability.bo.UocSaleOrderAbilityRspBO;
import com.tydic.uoc.common.atom.api.PebSyncHtArriveAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomReqBO;
import com.tydic.uoc.common.busi.api.PebInOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderAcceptReqBO;
import com.tydic.uoc.common.comb.api.UocPebOrderAcceptCombService;
import com.tydic.uoc.common.comb.api.UocPebSaleOrderAllConfirmCombService;
import com.tydic.uoc.common.comb.api.UocPebShipArrivalConfirmCombService;
import com.tydic.uoc.dao.ConfirmMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocBigOrderMapper;
import com.tydic.uoc.dao.UocOrdRhInfoMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.ConfirmPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocBigOrderPO;
import com.tydic.uoc.po.UocOrdRhInfoPO;
import com.tydic.uoc.po.UocOrdRhItemPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebInOrderAbilityService"})
public class PebInOrderAbilityServiceImpl
implements PebInOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebInOrderAbilityServiceImpl.class);
    @Autowired
    private PebIntfQryInOrderService pebIntfQryInOrderService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebInOrderBusiService pebInOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocOrdRhInfoMapper uocOrdRhInfoMapper;
    @Autowired
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocPebSaleOrderAllConfirmCombService uocPebSaleOrderAllConfirmCombService;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocPebOrderAcceptCombService uocPebOrderAcceptCombService;
    @Autowired
    private UocPebShipArrivalConfirmCombService uocPebShipArrivalConfirmCombService;
    @Autowired
    private FscOrderDetailInAbilityService fscOrderDetailInAbilityService;
    @Autowired
    private ConfirmMapper confirmMapper;
    @Autowired
    private UocBigOrderMapper uocBigOrderMapper;
    private static final int PAGE_SIZE = 200;
    @Autowired
    private PebSyncHtArriveAtomService pebSyncHtArriveAtomService;

    @PostMapping(value={"qrySaleOrderInfo"})
    public List<UocSaleOrderAbilityRspBO> qrySaleOrderInfo(@RequestBody PebInOrderReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderIdList(reqBO.getOrderIds());
        List ordSalePOList = this.ordSaleMapper.getList(ordSalePO);
        List<UocSaleOrderAbilityRspBO> uocSaleOrderAbilityRspBOS = ordSalePOList.stream().map(a -> {
            UocSaleOrderAbilityRspBO rspBO = new UocSaleOrderAbilityRspBO();
            rspBO.setOrderId(a.getOrderId());
            rspBO.setPurchaseFeeMoney(Objects.nonNull(a.getPurchaseFee()) ? a.getPurchaseFee().toString() : null);
            rspBO.setPurchaseFeeMoneyIntegral(Objects.nonNull(a.getTotalIntegralFee()) ? a.getTotalIntegralFee().toString() : null);
            rspBO.setSaleFeeMoney(Objects.nonNull(a.getSaleFee()) ? a.getSaleFee().toString() : null);
            return rspBO;
        }).collect(Collectors.toList());
        return uocSaleOrderAbilityRspBOS;
    }

    @PostMapping(value={"dealInOrder"})
    public PebInOrderRspBO dealInOrder(@RequestBody PebInOrderReqBO reqBO) {
        OrdSalePO salePO;
        ArrayList<PebIntfQryInOrderData> data;
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        PebIntfQryInOrderReqBO orderReqBO = new PebIntfQryInOrderReqBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderNo())) {
            data = new ArrayList<PebIntfQryInOrderData>();
            for (String orderNo : reqBO.getOrderNo()) {
                salePO = new OrdSalePO();
                salePO.setSaleVoucherNo(orderNo);
                salePO = this.ordSaleMapper.getModelBy(salePO);
                if (salePO == null) continue;
                UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
                zmInfoPO.setOrderId(salePO.getOrderId());
                zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
                PebIntfQryInOrderData orderData = new PebIntfQryInOrderData();
                orderData.setORG_ID(zmInfoPO.getBuynerErpNo());
                orderData.setPO_NUM(orderNo);
                data.add(orderData);
                orderReqBO.setP_PO_NUMS(data);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getBigOrderNo())) {
            data = new ArrayList();
            for (String orderNo : reqBO.getBigOrderNo()) {
                salePO = new UocBigOrderPO();
                salePO.setOrderNo(orderNo);
                salePO = this.uocBigOrderMapper.selectOne((UocBigOrderPO)salePO);
                if (salePO == null) continue;
                PebIntfQryInOrderData orderData = new PebIntfQryInOrderData();
                orderData.setORG_ID(salePO.getBuynerErpNo());
                orderData.setPO_NUM(orderNo);
                data.add(orderData);
            }
            orderReqBO.setP_PO_NUMS(data);
        } else {
            orderReqBO.setP_DATE_F(DateUtils.dateToStrLong((Date)reqBO.getStart()));
            orderReqBO.setP_DATE_T(DateUtils.dateToStrLong((Date)reqBO.getEnd()));
            data = new ArrayList();
            PebIntfQryInOrderData orderData = new PebIntfQryInOrderData();
            orderData.setORG_ID("");
            orderData.setPO_NUM("");
            data.add(orderData);
            orderReqBO.setP_PO_NUMS(data);
        }
        PebIntfQryInOrderRspBO orderRspBO = this.pebIntfQryInOrderService.qryErpInOrder(orderReqBO);
        if (!"0000".equals(orderRspBO.getRespCode())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getOrderNo()) && !PebExtConstant.YES.equals(reqBO.getIsTask())) {
                this.pebInOrderBusiService.dealInOrderFail(reqBO);
            }
            throw new UocProBusinessException(orderRspBO.getRespCode(), "erp\u67e5\u8be2\u5165\u5e93\u5355:" + orderRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)orderRspBO.getLines())) {
            return rspBO;
        }
        HashMap<Long, UocOrdSaleRspBO> map = new HashMap<Long, UocOrdSaleRspBO>();
        HashMap<Long, UocOrdSaleRspBO> dzcs = new HashMap<Long, UocOrdSaleRspBO>();
        HashMap<Long, UocOrdSaleRspBO> pDzcs = new HashMap<Long, UocOrdSaleRspBO>();
        for (PebIntfQryInOrderLine line : orderRspBO.getLines()) {
            UocOrdRhItemBO itemBO = new UocOrdRhItemBO();
            BeanUtils.copyProperties((Object)line, (Object)itemBO);
            PebInOrderReqBO busi = new PebInOrderReqBO();
            busi.setLine(itemBO);
            Object salePO2 = new OrdSalePO();
            salePO2.setSaleVoucherNo(line.getPoNum());
            salePO2 = this.ordSaleMapper.getModelBy((OrdSalePO)salePO2);
            if (salePO2 == null) continue;
            busi.setOrderId(salePO2.getOrderId());
            busi.setSource(salePO2.getOrderSource());
            busi.setStatus(salePO2.getSaleState());
            PebInOrderRspBO inOrderRspBO = this.pebInOrderBusiService.dealInOrder(busi);
            if (Objects.nonNull(inOrderRspBO) && "101079".equals(inOrderRspBO.getRespCode())) {
                this.checkArrive(salePO2.getOrderId(), line.getOrdItemId());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)inOrderRspBO.getSaleRspBOS())) {
                for (UocOrdSaleRspBO saleRspBO : inOrderRspBO.getSaleRspBOS()) {
                    if (!UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(salePO2.getOrderSource())) {
                        map.put(salePO2.getOrderId(), saleRspBO);
                        continue;
                    }
                    if (UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(salePO2.getSaleState())) {
                        pDzcs.put(salePO2.getOrderId(), saleRspBO);
                        continue;
                    }
                    dzcs.put(salePO2.getOrderId(), saleRspBO);
                }
            }
            try {
                if (!"0000".equals(inOrderRspBO.getRespCode()) || "\u5165\u5e93\u5355\u4ee5\u5165\u5e93".equals(inOrderRspBO.getRespDesc())) continue;
                FscOrderDetailInAbilityReqBO fscOrderDetailInAbilityReqBO = new FscOrderDetailInAbilityReqBO();
                fscOrderDetailInAbilityReqBO.setOrderId(salePO2.getOrderId());
                fscOrderDetailInAbilityReqBO.setOrdItemId(line.getOrdItemId());
                fscOrderDetailInAbilityReqBO.setParentTransactionId(line.getParentTransactionId());
                fscOrderDetailInAbilityReqBO.setPoHeaderId(line.getPoHeaderId());
                fscOrderDetailInAbilityReqBO.setPoLineId(line.getExt1());
                fscOrderDetailInAbilityReqBO.setPoNum(line.getPoNum());
                fscOrderDetailInAbilityReqBO.setQuantity(line.getQuantity());
                fscOrderDetailInAbilityReqBO.setTransactionDate(line.getTransactionDate());
                fscOrderDetailInAbilityReqBO.setTransactionType(line.getTransactionType());
                fscOrderDetailInAbilityReqBO.setLINE_LOCATION_ID(line.getLineLocationId());
                fscOrderDetailInAbilityReqBO.setRecvAddressCode(line.getDeliverToLocationId());
                fscOrderDetailInAbilityReqBO.setRecvAddressName(line.getLocationCode());
                fscOrderDetailInAbilityReqBO.setDistributeSubjectCode(line.getConcatenatedSegments());
                fscOrderDetailInAbilityReqBO.setDistributeSubjectName(line.getCodeCombinationDesc());
                fscOrderDetailInAbilityReqBO.setReceiveNum(line.getLineNum());
                fscOrderDetailInAbilityReqBO.setReceiptNum(line.getReceiptNum());
                fscOrderDetailInAbilityReqBO.setShipToOrgId(line.getShipToOrgId());
                FscOrderDetailInAbilityRspBO fscOrderDetailInAbilityRspBO = this.fscOrderDetailInAbilityService.dealOrderDetailIn(fscOrderDetailInAbilityReqBO);
                if (fscOrderDetailInAbilityRspBO.getRespCode().equals("0000")) continue;
                log.error("\u63a8\u9001\u7ed3\u7b97\u5165\u5e93\u4fe1\u606f\u5904\u7406\u5f02\u5e38\uff01" + fscOrderDetailInAbilityRspBO.getRespDesc());
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u7ed3\u7b97\u5165\u5e93\u4fe1\u606f\u5904\u7406\u5f02\u5e38\uff01" + e);
            }
        }
        for (Long orderId : pDzcs.keySet()) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(orderId);
            List list = this.orderMapper.getBuyPorder(orderPO);
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            for (UocOrdSaleRspBO orderPO1 : list) {
                dzcs.put(orderPO1.getOrderId(), orderPO1);
            }
        }
        for (Long orderId : dzcs.keySet()) {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(orderId);
            List ordItemPOS = this.ordItemMapper.getList(itemPO);
            boolean flag = true;
            for (OrdItemPO ordItemPO : ordItemPOS) {
                BigDecimal last = ordItemPO.getPurchaseCount().subtract(ordItemPO.getRefuseCount()).subtract(ordItemPO.getReturnCount());
                BigDecimal rh = BigDecimal.ZERO;
                if (StringUtils.isNotBlank((CharSequence)ordItemPO.getExtField5())) {
                    rh = new BigDecimal(ordItemPO.getExtField5());
                }
                if (last.compareTo(rh) <= 0) continue;
                flag = false;
                break;
            }
            if (flag) {
                UocPebShipArrivalConfirmReqBO confirmReqBO = new UocPebShipArrivalConfirmReqBO();
                confirmReqBO.setInOrder(PebExtConstant.YES);
                confirmReqBO.setOperId("999");
                confirmReqBO.setUsername("\u7cfb\u7edf");
                confirmReqBO.setOrderId(orderId);
                this.uocPebShipArrivalConfirmCombService.dealShipArrivalConfirm(confirmReqBO);
                continue;
            }
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(((UocOrdSaleRspBO)dzcs.get(orderId)).getSaleVoucherId());
            ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            ordIdxSyncReqBO.setOrderId(orderId);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
        }
        for (Long orderId : map.keySet()) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO;
            PebInOrderReqBO busi = new PebInOrderReqBO();
            busi.setOrderId(orderId);
            PebInOrderRspBO inOrderRspBO = this.pebInOrderBusiService.dealInOrderShip(busi);
            if (CollectionUtils.isNotEmpty((Collection)inOrderRspBO.getShipId())) {
                ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(((UocOrdSaleRspBO)map.get(orderId)).getSaleVoucherId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(orderId);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                for (Long objId : inOrderRspBO.getShipId()) {
                    ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    ordIdxSyncReqBO.setObjId(objId);
                    ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                    ordIdxSyncReqBO.setOrderId(orderId);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                }
            } else {
                ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(((UocOrdSaleRspBO)map.get(orderId)).getSaleVoucherId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(orderId);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
            }
            if (CollectionUtils.isEmpty((Collection)inOrderRspBO.getConfirmIdList())) continue;
            this.syncHt(inOrderRspBO.getConfirmIdList());
        }
        return rspBO;
    }

    private PebInOrderRspBO checkArrive(Long orderId, Long ordItemId) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrdItemId(ordItemId);
        ordItemPO.setOrderId(orderId);
        ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
        if (Objects.nonNull(ordItemPO) && Objects.nonNull(ordItemPO.getExtField5()) && new BigDecimal(ordItemPO.getExtField5()).compareTo(ordItemPO.getArriveCount()) > 0) {
            PebInOrderReqBO busi = new PebInOrderReqBO();
            busi.setOrderId(orderId);
            rspBO = this.pebInOrderBusiService.dealInOrderShip(busi);
            rspBO.setSupplementaryYn(Boolean.TRUE);
            if (CollectionUtils.isNotEmpty((Collection)rspBO.getShipId())) {
                UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(rspBO.getSaleId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(orderId);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                for (Long objId : rspBO.getShipId()) {
                    ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    ordIdxSyncReqBO.setObjId(objId);
                    ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                    ordIdxSyncReqBO.setOrderId(orderId);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getConfirmIdList())) {
            this.syncHt(rspBO.getConfirmIdList());
        }
        rspBO.setSupplementaryYn(Boolean.FALSE);
        return rspBO;
    }

    @PostMapping(value={"dealAccEstroe"})
    public PebInOrderRspBO dealAccEstroe(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        Integer accCount = this.ordSaleMapper.getEstoreAccCount(new OrdSalePO());
        if (Objects.isNull(accCount) || 0 == accCount) {
            return rspBO;
        }
        long totalPage = accCount % 200 == 0 ? (long)(accCount / 200) : (long)(accCount / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        int total = (int)totalPage;
        ArrayList getEstoreAcc = new ArrayList();
        for (int page = total; page >= 1; --page) {
            pageBO.setPageNo(page);
            getEstoreAcc.addAll(this.ordSaleMapper.getEstoreAcc(new OrdSalePO(), pageBO));
        }
        if (CollectionUtils.isEmpty(getEstoreAcc)) {
            return rspBO;
        }
        for (OrdSalePO salePO : getEstoreAcc) {
            try {
                OrderPO orderPO;
                OrdItemPO ordItemPO = new OrdItemPO();
                ordItemPO.setOrderId(salePO.getOrderId());
                List itemPOS = this.ordItemMapper.getList(ordItemPO);
                boolean flag = true;
                for (OrdItemPO itemPO : itemPOS) {
                    BigDecimal count;
                    if (StringUtils.isBlank((CharSequence)itemPO.getExtField5())) {
                        itemPO.setExtField5("0");
                    }
                    if ((count = itemPO.getPurchaseCount().subtract(itemPO.getRefuseCount()).subtract(itemPO.getReturnCount())).compareTo(new BigDecimal(itemPO.getExtField5())) <= 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                UocOrdRhInfoPO infoPO = new UocOrdRhInfoPO();
                infoPO.setExt1("DELIVER");
                infoPO.setOrderId(salePO.getOrderId());
                List list = this.uocOrdRhInfoMapper.selectByCondition(infoPO);
                if (CollectionUtils.isEmpty((Collection)list) && (orderPO = this.orderMapper.getModelById(salePO.getOrderId().longValue())).getUpperOrderId() != null) {
                    infoPO.setExt1("DELIVER");
                    infoPO.setOrderId(orderPO.getUpperOrderId());
                    list = this.uocOrdRhInfoMapper.selectByCondition(infoPO);
                }
                StringBuilder ext = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    UocOrdRhInfoPO po = (UocOrdRhInfoPO)list.get(i);
                    ext.append(po.getReceiptNum());
                    if (i == list.size() - 1) continue;
                    ext.append(",");
                }
                UocPebSaleOrderConfirmShipReqBO shipReqBO = new UocPebSaleOrderConfirmShipReqBO();
                shipReqBO.setExt1(ext.toString());
                shipReqBO.setIsSync(Boolean.valueOf(true));
                shipReqBO.setOrderId(salePO.getOrderId());
                OrderPO orderPO2 = this.orderMapper.getModelById(salePO.getOrderId().longValue());
                shipReqBO.setOperId(orderPO2.getCreateOperId());
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    shipReqBO.setName(((UocOrdRhInfoPO)list.get(0)).getFullName());
                    shipReqBO.setCreationDate(((UocOrdRhInfoPO)list.get(0)).getCreationDate());
                } else {
                    shipReqBO.setName("\u7cfb\u7edf\u5165\u5e93");
                }
                try {
                    this.uocPebSaleOrderAllConfirmCombService.dealUocPebSaleOrderConfirm(shipReqBO);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                log.error("\u7535\u5546\u5b9a\u65f6\u5165\u5e93\u62a5\u9519\uff1a" + e);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"dealAccZone"})
    public PebInOrderRspBO dealAccZone(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setLastUpdateDate(new Date(System.currentTimeMillis() - 300000L));
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        Integer count = this.uocOrdRhInfoMapper.getAccCount(uocOrdRhInfoPO);
        if (Objects.isNull(count) || 0 == count) {
            return rspBO;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        ArrayList rhInfoPOS = new ArrayList();
        int total = (int)totalPage;
        for (int page = 1; page <= total; ++page) {
            pageBO.setPageNo(page);
            rhInfoPOS.addAll(this.uocOrdRhInfoMapper.getAcc(uocOrdRhInfoPO, pageBO));
        }
        if (CollectionUtils.isEmpty(rhInfoPOS)) {
            return rspBO;
        }
        for (UocOrdRhInfoPO infoPO : rhInfoPOS) {
            UocOrdRhItemPO rhItemPO = new UocOrdRhItemPO();
            rhItemPO.setExt2(infoPO.getId().toString());
            rhItemPO.setAccStatus(Integer.valueOf(0));
            List list = this.uocOrdRhItemMapper.selectByCondition(rhItemPO);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setOrderId(infoPO.getOrderId());
            List shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
            if (CollectionUtils.isEmpty((Collection)shipItemPOS)) continue;
            try {
                this.accZone(list, shipItemPOS, infoPO);
            }
            catch (Exception e) {
                log.error("\u4e13\u533a\u5165\u5e93\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff1a" + e);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"dealAccContract"})
    public PebInOrderRspBO dealAccContract(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setLastUpdateDate(new Date(System.currentTimeMillis() - 300000L));
        List rhInfoPOS = this.uocOrdRhInfoMapper.getContractAcc(uocOrdRhInfoPO);
        if (CollectionUtils.isEmpty((Collection)rhInfoPOS)) {
            return rspBO;
        }
        for (UocOrdRhInfoPO infoPO : rhInfoPOS) {
            UocOrdRhItemPO rhItemPO = new UocOrdRhItemPO();
            rhItemPO.setExt2(infoPO.getId().toString());
            rhItemPO.setAccStatus(Integer.valueOf(0));
            List list = this.uocOrdRhItemMapper.selectByCondition(rhItemPO);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setOrderId(infoPO.getOrderId());
            List shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
            if (CollectionUtils.isEmpty((Collection)shipItemPOS)) continue;
            try {
                this.accZone(list, shipItemPOS, infoPO);
            }
            catch (Exception e) {
                log.error("\u4e13\u533a\u5165\u5e93\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff1a" + e);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"dealInOrderShip"})
    public PebInOrderRspBO dealInOrderShip(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO inOrderRspBO = new PebInOrderRspBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderIds())) {
            for (Long id : reqBO.getOrderIds()) {
                reqBO.setOrderId(id);
                inOrderRspBO = this.ship(reqBO);
            }
        } else {
            inOrderRspBO = this.ship(reqBO);
        }
        return inOrderRspBO;
    }

    private PebInOrderRspBO ship(PebInOrderReqBO reqBO) {
        PebInOrderRspBO inOrderRspBO = this.pebInOrderBusiService.dealInOrderShip(reqBO);
        if (CollectionUtils.isNotEmpty((Collection)inOrderRspBO.getShipId())) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(inOrderRspBO.getSaleId());
            ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
            for (Long objId : inOrderRspBO.getShipId()) {
                ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(objId);
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)inOrderRspBO.getConfirmIdList())) {
            this.syncHt(inOrderRspBO.getConfirmIdList());
        }
        return inOrderRspBO;
    }

    private void accZone(List<UocOrdRhItemPO> list, List<OrdShipItemPO> uShips, UocOrdRhInfoPO infoPO) {
        boolean bl;
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        ArrayList<Long> updateIds = new ArrayList<Long>();
        Long zid = null;
        for (UocOrdRhItemPO uocOrdRhItemPO : list) {
            zid = Long.valueOf(uocOrdRhItemPO.getExt2());
            updateIds.add(uocOrdRhItemPO.getId());
            BigDecimal bigDecimal = (BigDecimal)map.get(uocOrdRhItemPO.getOrdItemId());
            if (bigDecimal == null) {
                map.put(uocOrdRhItemPO.getOrdItemId(), uocOrdRhItemPO.getQuantity());
                continue;
            }
            BigDecimal bigDecimal2 = bigDecimal.add(uocOrdRhItemPO.getQuantity());
            map.put(uocOrdRhItemPO.getOrdItemId(), bigDecimal2);
        }
        ArrayList<UocPebArrRegisterShipItemReqBO> uocPebArrRegisterShipItemReqBOList = new ArrayList<UocPebArrRegisterShipItemReqBO>();
        for (OrdShipItemPO ordShipItemPO : uShips) {
            UocPebArrRegisterShipItemReqBO registerShipItemReqBO;
            OrdShipItemPO ordShipItemPO2;
            PebInOrderRspBO inOrderRspBO;
            BigDecimal canAcc;
            BigDecimal count = (BigDecimal)map.get(ordShipItemPO.getOrdItemId());
            if (count == null || count.compareTo(BigDecimal.ZERO) == 0 || (canAcc = ordShipItemPO.getArriveCount().subtract(ordShipItemPO.getReturnCount()).subtract(ordShipItemPO.getAcceptanceCount())).compareTo(BigDecimal.ZERO) == 0 && (Boolean.FALSE.equals((inOrderRspBO = this.checkArrive(ordShipItemPO.getOrderId(), ordShipItemPO.getOrdItemId())).getSupplementaryYn()) || Objects.isNull(ordShipItemPO2 = this.ordShipItemMapper.getModelById(ordShipItemPO.getShipItemId().longValue())) || (canAcc = ordShipItemPO2.getArriveCount().subtract(ordShipItemPO2.getReturnCount()).subtract(ordShipItemPO2.getAcceptanceCount())).compareTo(BigDecimal.ZERO) == 0)) continue;
            if (canAcc.compareTo(count) >= 0) {
                registerShipItemReqBO = new UocPebArrRegisterShipItemReqBO();
                registerShipItemReqBO.setArriveCount(count);
                registerShipItemReqBO.setShipItemId(ordShipItemPO.getShipItemId());
                registerShipItemReqBO.setShiId(ordShipItemPO.getShipVoucherId());
                registerShipItemReqBO.setRhId(String.valueOf(infoPO.getId()));
                registerShipItemReqBO.setRhNo(infoPO.getReceiptNum());
                uocPebArrRegisterShipItemReqBOList.add(registerShipItemReqBO);
                map.put(ordShipItemPO.getOrdItemId(), BigDecimal.ZERO);
                continue;
            }
            registerShipItemReqBO = new UocPebArrRegisterShipItemReqBO();
            registerShipItemReqBO.setArriveCount(canAcc);
            registerShipItemReqBO.setShipItemId(ordShipItemPO.getShipItemId());
            registerShipItemReqBO.setRhId(String.valueOf(infoPO.getId()));
            registerShipItemReqBO.setRhNo(infoPO.getReceiptNum());
            uocPebArrRegisterShipItemReqBOList.add(registerShipItemReqBO);
            registerShipItemReqBO.setShiId(ordShipItemPO.getShipVoucherId());
            map.put(ordShipItemPO.getOrdItemId(), count.subtract(canAcc));
        }
        boolean bl2 = true;
        for (Long id : map.keySet()) {
            if (((BigDecimal)map.get(id)).compareTo(BigDecimal.ZERO) <= 0) continue;
            bl = false;
            break;
        }
        if (!bl) {
            return;
        }
        if (uocPebArrRegisterShipItemReqBOList.size() == 0) {
            return;
        }
        UocPebOrderAcceptReqBO uocPebOrderAcceptReqBO = new UocPebOrderAcceptReqBO();
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(infoPO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        uocPebOrderAcceptReqBO.setOrderId(salePO.getOrderId());
        uocPebOrderAcceptReqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        uocPebOrderAcceptReqBO.setEntireFlag(PecConstant.EntireFlag.NO);
        uocPebOrderAcceptReqBO.setName(infoPO.getFullName());
        uocPebOrderAcceptReqBO.setUserId(Long.valueOf("99999999999"));
        uocPebOrderAcceptReqBO.setZid(zid);
        uocPebOrderAcceptReqBO.setUpdateId(updateIds);
        uocPebOrderAcceptReqBO.setCreationDate(infoPO.getCreationDate());
        ArrayList<UocPebArrRegisterShipIReqBO> arrInspectionList = new ArrayList<UocPebArrRegisterShipIReqBO>();
        Map<Long, List<UocPebArrRegisterShipItemReqBO>> listMap = uocPebArrRegisterShipItemReqBOList.stream().collect(Collectors.groupingBy(UocPebArrRegisterShipItemReqBO::getShiId));
        for (Long shipId : listMap.keySet()) {
            UocPebArrRegisterShipIReqBO registerShipIReqBO = new UocPebArrRegisterShipIReqBO();
            registerShipIReqBO.setShipVoucherId(shipId);
            registerShipIReqBO.setUocPebArrRegisterShipItemReqBOList(listMap.get(shipId));
            arrInspectionList.add(registerShipIReqBO);
        }
        uocPebOrderAcceptReqBO.setArrInspectionList(arrInspectionList);
        uocPebOrderAcceptReqBO.setIsSync(true);
        this.uocPebOrderAcceptCombService.dealPebOrderAccept(uocPebOrderAcceptReqBO);
    }

    @PostMapping(value={"dealHistoryOrder"})
    public PebInOrderRspBO dealHistoryOrder(@RequestBody PebInOrderReqBO reqBO) {
        List uocOrdZmInfoBOS = this.uocOrdZmInfoMapper.dealHistoryOrder();
        for (UocOrdZmInfoBO uocOrdZmInfoBO : uocOrdZmInfoBOS) {
            UocOrdZmInfoPO po = new UocOrdZmInfoPO();
            po.setOrderId(uocOrdZmInfoBO.getOrderId());
            po.setTimingPush(new Date());
            this.uocOrdZmInfoMapper.update(po);
            reqBO.setOrderNo(Arrays.asList(uocOrdZmInfoBO.getOrderCode()));
            this.dealInOrder(reqBO);
        }
        return new PebInOrderRspBO();
    }

    @PostMapping(value={"dealErrorOrder"})
    public PebInOrderRspBO dealErrorOrder(@RequestBody PebInOrderReqBO reqBO) {
        ConfirmPO confirmPO = new ConfirmPO();
        confirmPO.setStatus(Integer.valueOf(1));
        List confirmPOS = this.confirmMapper.selectByCondition(confirmPO);
        if (CollectionUtils.isEmpty((Collection)confirmPOS)) {
            return new PebInOrderRspBO();
        }
        for (ConfirmPO po : confirmPOS) {
            PebInOrderReqBO bo = new PebInOrderReqBO();
            bo.setOrderId(po.getConfirmId());
            this.pebInOrderBusiService.dealErrorOrder(bo);
        }
        this.dealErrorOrder(reqBO);
        return new PebInOrderRspBO();
    }

    @PostMapping(value={"dealYcAccZone"})
    public PebInOrderRspBO dealYcAccZone(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setLastUpdateDate(new Date(System.currentTimeMillis() - 300000L));
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        Integer count = this.uocOrdRhInfoMapper.getYcAccCount(uocOrdRhInfoPO);
        if (Objects.isNull(count) || 0 == count) {
            return rspBO;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        int total = (int)totalPage;
        for (int page = 1; page <= total; ++page) {
            pageBO.setPageNo(page);
            List rhInfoPOS = this.uocOrdRhInfoMapper.getYcAcc(uocOrdRhInfoPO, pageBO);
            if (CollectionUtils.isEmpty((Collection)rhInfoPOS)) {
                return rspBO;
            }
            for (UocOrdRhInfoPO infoPO : rhInfoPOS) {
                UocOrdRhItemPO rhItemPO = new UocOrdRhItemPO();
                rhItemPO.setExt2(infoPO.getId().toString());
                rhItemPO.setAccStatus(Integer.valueOf(0));
                List list = this.uocOrdRhItemMapper.selectByCondition(rhItemPO);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                OrdShipItemPO shipItemPO = new OrdShipItemPO();
                shipItemPO.setOrderId(infoPO.getOrderId());
                List shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
                if (CollectionUtils.isEmpty((Collection)shipItemPOS)) {
                    reqBO.setOrderId(infoPO.getOrderId());
                    this.ship(reqBO);
                    shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
                    if (CollectionUtils.isEmpty((Collection)shipItemPOS)) continue;
                }
                try {
                    this.accZone(list, shipItemPOS, infoPO);
                }
                catch (Exception e) {
                    log.error("\u4e91\u4ed3\u8ba2\u5355\u5165\u5e93\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff1a" + e);
                }
            }
        }
        return rspBO;
    }

    @PostMapping(value={"dealBhContractAccZone"})
    public PebInOrderRspBO dealBhContractAccZone(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setLastUpdateDate(new Date(System.currentTimeMillis() - 300000L));
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        Integer count = this.uocOrdRhInfoMapper.getBhContractAccCount(uocOrdRhInfoPO);
        if (Objects.isNull(count) || 0 == count) {
            return rspBO;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        int total = (int)totalPage;
        for (int page = 1; page <= total; ++page) {
            pageBO.setPageNo(page);
            List rhInfoPOS = this.uocOrdRhInfoMapper.getBhContractAcc(uocOrdRhInfoPO, pageBO);
            if (CollectionUtils.isEmpty((Collection)rhInfoPOS)) {
                return rspBO;
            }
            for (UocOrdRhInfoPO infoPO : rhInfoPOS) {
                UocOrdRhItemPO rhItemPO = new UocOrdRhItemPO();
                rhItemPO.setExt2(infoPO.getId().toString());
                rhItemPO.setAccStatus(Integer.valueOf(0));
                List list = this.uocOrdRhItemMapper.selectByCondition(rhItemPO);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                OrdShipItemPO shipItemPO = new OrdShipItemPO();
                shipItemPO.setOrderId(infoPO.getOrderId());
                List shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
                if (CollectionUtils.isEmpty((Collection)shipItemPOS)) {
                    reqBO.setOrderId(infoPO.getOrderId());
                    this.ship(reqBO);
                    shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
                    if (CollectionUtils.isEmpty((Collection)shipItemPOS)) continue;
                }
                try {
                    this.accZone(list, shipItemPOS, infoPO);
                }
                catch (Exception e) {
                    log.error("erp\u9886\u7528\u8ba2\u5355\u5165\u5e93\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff1a{}", (Throwable)e);
                }
            }
        }
        return rspBO;
    }

    private void syncHt(List<Long> ids) {
        try {
            PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
            atomReqBO.setConfirmIdList(ids);
            this.pebSyncHtArriveAtomService.syncHtArrive(atomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
        }
    }
}

