/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderShipUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderShipUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderShipUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.PebPushWmsShipAtomService;
import com.tydic.uoc.common.atom.bo.PebUocWmsStateQryRspBO;
import com.tydic.uoc.common.atom.bo.PedUocWmsStateqryReqBO;
import com.tydic.uoc.common.busi.api.PebOrderShipUpdateBusiService;
import com.tydic.uoc.common.busi.api.PebPushWmsShipBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderShipUpdateAbilityService"})
public class PebOrderShipUpdateAbilityServiceImpl
implements PebOrderShipUpdateAbilityService {
    @Value(value="${UOC_ZONE_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PebOrderShipUpdateBusiService pebOrderShipUpdateBusiService;
    @Autowired
    private PebPushWmsShipBusiService pebPushWmsShipBusiService;
    @Autowired
    private PebPushWmsShipAtomService pebPushWmsShipAtomService;
    private static final String WMS_STATE_CHECKED_IN = "checked_in";
    private static final String WMS_STATE_NOT_CHECKED_IN = "not_checked_in";

    @PostMapping(value={"dealPebOrderShipUpdate"})
    public PebOrderShipUpdateAbilityRspBO dealPebOrderShipUpdate(@RequestBody PebOrderShipUpdateAbilityReqBO reqBO) {
        this.validateReq(reqBO);
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setShipVoucherId(reqBO.getShipVoucherId());
        shipPO = this.ordShipMapper.getModelBy(shipPO);
        if (shipPO == null) {
            throw new UocProBusinessException("102033", "\u53d1\u8d27\u5355\u4e3a\u7a7a");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        OrdSalePO salePO1 = this.ordSaleMapper.getModelBy(salePO);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        UocOrdZmInfoPO zmInfoPO1 = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        int res = this.validateWms(reqBO, shipPO, salePO1, zmInfoPO1);
        PebOrderShipUpdateAbilityRspBO pebOrderDeliveryAbilityRspBO = this.pebOrderShipUpdateBusiService.dealUpdateShip(reqBO);
        if (!"0000".equals(pebOrderDeliveryAbilityRspBO.getRespCode())) {
            return pebOrderDeliveryAbilityRspBO;
        }
        UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
        syncReqBO.setObjId(reqBO.getSaleVoucherId());
        syncReqBO.setOrderId(reqBO.getOrderId());
        syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
        UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
        idxSyncReqBO.setObjId(reqBO.getShipVoucherId());
        idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        if (pebOrderDeliveryAbilityRspBO.getShipVoucherId() != null) {
            this.pushWmsShip(pebOrderDeliveryAbilityRspBO.getShipVoucherId(), reqBO.getOrderId(), salePO1, zmInfoPO1);
        }
        pebOrderDeliveryAbilityRspBO.setTipType(Integer.valueOf(res));
        if (res == 2) {
            pebOrderDeliveryAbilityRspBO.setRespDesc("\u8bf7\u6ce8\u610f\uff0c\u60a8\u7684\u53d1\u8d27\u5355\u6536\u8d27\u5730\u5740\u5df2\u66f4\u65b0\u3002\u4e3a\u786e\u4fdd\u8d27\u7269\u51c6\u786e\u9001\u8fbe\uff0c\u8bf7\u53ca\u65f6\u901a\u77e5\u627f\u8fd0\u4eba\u5458\u3002");
        }
        return pebOrderDeliveryAbilityRspBO;
    }

    private void validateReq(PebOrderShipUpdateAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getShipVoucherId())) {
            throw new BusinessException("8888", "\u5165\u53c2 shipVoucherId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new BusinessException("8888", "\u5165\u53c2 orderId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getTransportMode())) {
            throw new BusinessException("8888", "\u5165\u53c2 transportMode \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getTransportMode()) && StringUtils.isEmpty((CharSequence)reqBO.getDriverName())) {
            throw new BusinessException("8888", "\u5165\u53c2 driverName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getTransportMode()) && StringUtils.isEmpty((CharSequence)reqBO.getDriverPhone())) {
            throw new BusinessException("8888", "\u5165\u53c2 driverPhone \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProcessNum())) {
            throw new BusinessException("8888", "\u5165\u53c2 processNum \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProcessName())) {
            throw new BusinessException("8888", "\u5165\u53c2 processName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProcessPhone())) {
            throw new BusinessException("8888", "\u5165\u53c2 processPhone \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Integer validateWms(PebOrderShipUpdateAbilityReqBO reqBO, OrdShipPO shipPO, OrdSalePO salePO, UocOrdZmInfoPO zmInfoPO) {
        if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource()) || ObjectUtil.isNotNull((Object)zmInfoPO) && PecConstant.IsPushErp.YES.equals(zmInfoPO.getIsPushErp())) {
            if (!(StringUtils.isEmpty((CharSequence)reqBO.getDriverName()) || reqBO.getDriverName().equals(shipPO.getDriverName()) && reqBO.getDriverPhone().equals(shipPO.getDriverPhone()) && reqBO.getProcessNum().equals(shipPO.getShipId()))) {
                PedUocWmsStateqryReqBO stateQryReqBO = new PedUocWmsStateqryReqBO();
                stateQryReqBO.setShipVoucherCode(shipPO.getShipVoucherCode());
                stateQryReqBO.setShipVoucherId(shipPO.getShipVoucherId());
                PebUocWmsStateQryRspBO pebUocWmsStateQryRspBO = this.pebPushWmsShipAtomService.wmsStateQry(stateQryReqBO);
                if (!"0000".equals(pebUocWmsStateQryRspBO.getRespCode())) {
                    throw new BusinessException("8888", "wms\u67e5\u8be2\u9884\u7ea6\u5355\u4fe1\u606f\u8fd4\u56de\u5931\u8d25:" + pebUocWmsStateQryRspBO.getRespDesc());
                }
                if (!ObjectUtil.isEmpty((Object)pebUocWmsStateQryRspBO.getData()) && Objects.equals(pebUocWmsStateQryRspBO.getData().getCheckInStatus(), WMS_STATE_CHECKED_IN)) {
                    throw new BusinessException("8888", "\u60a8\u9009\u62e9\u7684\u53d1\u8d27\u5355\u5df2\u7b7e\u5230\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4");
                }
                return 1;
            }
            if (!ObjectUtil.isEmpty((Object)reqBO.getReceiverAddressId()) && !reqBO.getReceiverAddressId().equals(shipPO.getReceiverAddressId())) {
                return 2;
            }
        }
        return 0;
    }

    private void pushWmsShip(Long shipVoucherId, Long orderId, OrdSalePO salePO, UocOrdZmInfoPO zmInfoPO) {
        if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource()) || ObjectUtil.isNotNull((Object)zmInfoPO) && PecConstant.IsPushErp.YES.equals(zmInfoPO.getIsPushErp())) {
            PebPushWmsShipReqBO wmsShipReqBO = new PebPushWmsShipReqBO();
            wmsShipReqBO.setShipVoucherId(shipVoucherId);
            wmsShipReqBO.setUpdate(Integer.valueOf(1));
            this.pebPushWmsShipBusiService.dealPushWmsShip(wmsShipReqBO);
        }
    }
}

