/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebPushBigOrderErpAbilityService;
import com.tydic.uoc.common.ability.api.PebPushErpAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushContractLedgerAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdInterLogBO;
import com.tydic.uoc.common.busi.api.PebPushErpBusiService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdErpLogMapper;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.dao.UocBigConfigMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdInterLogPO;
import com.tydic.uoc.po.UocBigConfigPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebPushErpAbilityService"})
public class PebPushErpAbilityServiceImpl
implements PebPushErpAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebPushErpAbilityServiceImpl.class);
    @Autowired
    private PebPushErpBusiService pebPushErpBusiService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TOPIC:DEAL_PUSH_CONTRACT_ORDER_TOPIC}")
    private String pushContractOrderTopic;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TAG:DEAL_PUSH_CONTRACT_ORDER_TAG}")
    private String pushContractOrderTag;
    @Resource(name="dealPushContractOrderProvider")
    private ProxyMessageProducer pushContractOrderProvider;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private String operationOrgId;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private PebPushBigOrderErpAbilityService pebPushBigOrderErpAbilityService;
    @Autowired
    private OrdErpLogMapper ordErpLogMapper;
    @Autowired
    private UocBigConfigMapper uocBigConfigMapper;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;
    private static final List<Integer> ALLOWED_CONTRACT_TYPES = Arrays.asList(11, 12, 13, 20, 21);

    @PostMapping(value={"dealPushErp"})
    public PebPushErpRspBO dealPushErp(@RequestBody PebPushErpReqBO reqBO) {
        UocBigConfigPO uocBigConfigPO = new UocBigConfigPO();
        uocBigConfigPO.setOrderId(reqBO.getOrderId());
        uocBigConfigPO = this.uocBigConfigMapper.selectOne(uocBigConfigPO);
        if (uocBigConfigPO != null && (PebExtConstant.ER.toString().equals(uocBigConfigPO.getExt4()) || PebExtConstant.ER.toString().equals(uocBigConfigPO.getExt5()))) {
            return this.pebPushBigOrderErpAbilityService.dealOrderPushErpRhCh(reqBO);
        }
        PebPushErpRspBO rspBO = this.pebPushErpBusiService.dealPushErp(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            log.info("PebPushErpAbilityService\u540c\u6b65\u66f4\u65b0\u6570\u636e{}", (Object)JSON.toJSONString((Object)rspBO));
            rspBO.getList().forEach(obj -> {
                OrdAgreementPO agreementPO;
                PebExtOrdIdxSyncReqBO syncReqBO = new PebExtOrdIdxSyncReqBO();
                syncReqBO.setObjId(obj.getSaleVoucherId());
                syncReqBO.setOrderId(obj.getOrderId());
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
                OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
                cruxMapPO.setOrderId(obj.getOrderId());
                cruxMapPO.setObjId(obj.getOrderId());
                cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
                cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
                if (cruxMapPO != null && !StringUtils.isEmpty((Object)cruxMapPO.getFieldValue10()) && !cruxMapPO.getFieldValue10().equals("0")) {
                    PebExtPushContractLedgerAbilityReqBO abilityReqBO = new PebExtPushContractLedgerAbilityReqBO();
                    abilityReqBO.setOrderId(obj.getPushErpOrderId());
                    abilityReqBO.setPushType(cruxMapPO.getFieldValue10());
                    if (cruxMapPO.getFieldValue10().equals("2")) {
                        if (this.determineState(rspBO.getOrderSource(), obj.getOrderId(), rspBO.getModelSettle()).booleanValue()) {
                            this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                        }
                    } else {
                        this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                    }
                }
                if ("4".equals(rspBO.getOrderSource()) && Objects.nonNull(agreementPO = this.ordAgreementMapper.queryById(obj.getOrderId())) && ALLOWED_CONTRACT_TYPES.contains(Integer.valueOf(agreementPO.getContactType()))) {
                    PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
                    siKuOrderAbilityReqBO.setOrderType("ADD");
                    siKuOrderAbilityReqBO.setOrderId(obj.getOrderId());
                    log.info("\u63a8\u9001\u53f8\u5e93\u6d88\u606f{}", (Object)JSON.toJSONString((Object)siKuOrderAbilityReqBO));
                    this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
                }
            });
        }
        return rspBO;
    }

    @PostMapping(value={"dealPushScheme"})
    public PebPushErpRspBO dealPushScheme(@RequestBody PebPushErpReqBO reqBO) {
        return this.pebPushErpBusiService.dealPushScheme(reqBO);
    }

    @PostMapping(value={"getPushErpLog"})
    public PebPushErpRspBO getPushErpLog(@RequestBody PebPushErpReqBO reqBO) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (Objects.isNull(zmInfoPO)) {
            throw new UocProBusinessException("102044", "\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u4fe1\u606f\uff01");
        }
        OrdInterLogPO logPO = new OrdInterLogPO();
        logPO.setOrderId(reqBO.getOrderId());
        ArrayList result = new ArrayList();
        if (!PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            logPO.setInterCode("pushErp");
        } else {
            logPO.setInterCode("pushErpChange");
        }
        logPO.setOrderBy("callTime desc");
        List logPOS = this.ordInterLogMapper.getList(logPO);
        PebPushErpRspBO rspBO = new PebPushErpRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        logPO = new OrdInterLogPO();
        logPO.setOrderId(reqBO.getOrderId());
        logPO.setInterCode(reqBO.getQryFlag());
        logPO.setOrderBy("callTime desc");
        List ordInterLogPOS = this.ordErpLogMapper.getList(logPO);
        if (!CollectionUtils.isEmpty((Collection)ordInterLogPOS)) {
            result.addAll(ordInterLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)logPOS)) {
            result.addAll(logPOS);
        }
        if (CollectionUtils.isEmpty(result)) {
            return rspBO;
        }
        List list = JSONArray.parseArray((String)JSON.toJSONString(result), UocOrdInterLogBO.class);
        rspBO.setList(list);
        return rspBO;
    }

    private Boolean determineState(String orderSource, Long orderId, Integer modelSettle) {
        Boolean flag = false;
        if ("1".equals(orderSource) && modelSettle == 2) {
            OrdAgreementPO agreementPO = new OrdAgreementPO();
            agreementPO.setOrderId(orderId);
            List ordAgreementPOS = this.ordAgreementMapper.selectByCondition(agreementPO);
            if (!CollectionUtils.isEmpty((Collection)ordAgreementPOS) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(agreementPO = (OrdAgreementPO)ordAgreementPOS.get(0)).getContactNo())) {
                flag = true;
            }
        }
        if (("4".equals(orderSource) || "2".equals(orderSource)) && modelSettle == 2) {
            flag = true;
        }
        return flag;
    }
}

