/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.atom.impl.UocProRpcMockAtomService;
import com.tydic.uoc.common.ability.api.UocApprovalprocessListQryAbilityService;
import com.tydic.uoc.common.ability.bo.UocApprovalLogBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityRspBO;
import com.tydic.uoc.dao.OrdTaskMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdTaskPO;
import com.tydic.uoc.po.OrderPO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocApprovalprocessListQryAbilityService"})
public class UocApprovalprocessListQryAbilityServiceImpl
implements UocApprovalprocessListQryAbilityService {
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UocProRpcMockAtomService uocProRpcMockAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Resource
    private ApprovalOrderMapper approvalOrderMapper;

    @PostMapping(value={"getUccSkuApprovalprocessListQry"})
    public UocApprovalprocessListQryAbilityRspBO getUccSkuApprovalprocessListQry(@RequestBody UocApprovalprocessListQryAbilityReqBO reqBO) {
        List list;
        UocApprovalprocessListQryAbilityRspBO rspBO = new UocApprovalprocessListQryAbilityRspBO();
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (orderPO == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        if (orderPO.getUpperOrderId() != null) {
            reqBO.setOrderId(orderPO.getUpperOrderId());
        }
        ApprovalObjPO approvalObjPO = new ApprovalObjPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
        if (Objects.nonNull(reqBO.getTempId())) {
            approvalObjPO.setObjId(reqBO.getTempId() + "");
        }
        if ((list = this.approvalObjMapper.getList(approvalObjPO)) == null || list.size() < 1) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        ApprovalObjPO approvalObj = (ApprovalObjPO)list.get(0);
        for (ApprovalObjPO itemPO : list) {
            if (itemPO.getId() < approvalObj.getId()) continue;
            approvalObj = itemPO;
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setObjId(approvalObj.getObjId());
        uacQryAuditLogReqBO.setObjType(reqBO.getObjType());
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
            throw new UocProBusinessException(uacQryAuditLogRspBO.getRespCode(), uacQryAuditLogRspBO.getRespDesc());
        }
        ArrayList<UocApprovalLogBO> approvalLogBOS = new ArrayList<UocApprovalLogBO>();
        String currentStepId = "";
        String nextStationId = "";
        String taskId = "";
        Long auditOrderId = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List logRspBORows = uacQryAuditLogRspBO.getRows();
        if (logRspBORows != null && !logRspBORows.isEmpty()) {
            LocalDateTime lastDealTime = null;
            Date last = null;
            if (((ApprovalLogBO)logRspBORows.get(0)).getDealTime() != null) {
                lastDealTime = ((ApprovalLogBO)logRspBORows.get(0)).getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                last = ((ApprovalLogBO)logRspBORows.get(0)).getDealTime();
            }
            for (int i = logRspBORows.size() - 1; i >= 0; --i) {
                ApprovalOrderPO approvalOrderPO;
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)logRspBORows.get(i);
                UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
                BeanUtils.copyProperties((Object)approvalLogBO, (Object)uocApprovalLogBO);
                if (approvalLogBO.getAuditResult() == null) {
                    uocApprovalLogBO.setAuditAdvice("");
                }
                currentStepId = approvalLogBO.getStepId();
                nextStationId = approvalLogBO.getNextStationId();
                auditOrderId = approvalLogBO.getAuditOrderId();
                taskId = approvalLogBO.getBusiCode();
                uocApprovalLogBO.setUrgingFlag("0");
                LocalDateTime createTime = null;
                LocalDateTime dealTime = null;
                if (uocApprovalLogBO.getCreateTime() != null) {
                    createTime = uocApprovalLogBO.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setCreateTimeStr(df.format(createTime));
                }
                if (uocApprovalLogBO.getDealTime() != null) {
                    dealTime = uocApprovalLogBO.getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setDealTimeStr(df.format(dealTime));
                }
                if (createTime != null && dealTime != null) {
                    long l = uocApprovalLogBO.getDealTime().getTime() - uocApprovalLogBO.getCreateTime().getTime();
                    long hours = l / 3600000L;
                    long lestMinutes = l % 3600000L;
                    long minutes = lestMinutes / 60000L;
                    long lestS = lestMinutes % 60000L;
                    long s = lestS / 1000L;
                    String str = "";
                    if (hours > 0L) {
                        str = hours + "\u5c0f\u65f6";
                    }
                    if (minutes > 0L) {
                        str = str + minutes + "\u5206";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u5206";
                    }
                    if (s > 0L) {
                        str = str + s + "\u79d2";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u79d2";
                    }
                    approvalLogBO.setProcessTimeStr(str);
                    uocApprovalLogBO.setDurationTime(str);
                }
                if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(approvalLogBO.getAuditResult()) && Objects.nonNull(approvalLogBO.getAuditOrderId()) && Objects.nonNull(approvalOrderPO = this.approvalOrderMapper.getModelById(approvalLogBO.getAuditOrderId().longValue())) && UacCommConstant.STATUS.APPROVAL_WITHDRAWAL.equals(approvalOrderPO.getStatus())) {
                    uocApprovalLogBO.setAudit("\u64a4\u56de");
                }
                approvalLogBOS.add(uocApprovalLogBO);
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nextStationId)) {
            List<Object> userList = new ArrayList();
            ApprovalLogBO split = nextStationId.split(",");
            ArrayList<Long> stationIds = new ArrayList<Long>();
            for (ApprovalLogBO id : split) {
                stationIds.add(Long.valueOf((String)id));
            }
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationIds(stationIds);
            dycStationOrgSelectUserNameReqBO.setCommissionedUserIds(uacQryAuditLogRspBO.getCommissionedUserIds());
            dycStationOrgSelectUserNameReqBO.setEntrustUserIds(uacQryAuditLogRspBO.getEntrustUserIds());
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && !dycStationOrgSelectUserNameRspBO.getUserList().isEmpty()) {
                userList.addAll(dycStationOrgSelectUserNameRspBO.getUserList());
            }
            if (!CollectionUtils.isEmpty(userList)) {
                userList = userList.stream().distinct().collect(Collectors.toList());
            }
            StringBuilder ids = new StringBuilder();
            if (CollectionUtils.isNotEmpty(userList)) {
                for (UserBO userBO : userList) {
                    if (ids.toString().contains(userBO.getUserId() + "")) continue;
                    ids.append(userBO.getUserId());
                    UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
                    uocApprovalLogBO.setOperName(userBO.getName());
                    uocApprovalLogBO.setOperid(userBO.getUserId() + "");
                    uocApprovalLogBO.setOperDept(userBO.getCompanyFullName());
                    uocApprovalLogBO.setUrgingFlag("1");
                    approvalLogBOS.add(uocApprovalLogBO);
                }
            }
        }
        if (auditOrderId != null) {
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(reqBO.getOrderId());
            ordTaskPO.setObjId(auditOrderId.toString());
            List ordTaskPOS = this.ordTaskMapper.getList(ordTaskPO);
            if (ordTaskPOS != null && ordTaskPOS.size() > 0) {
                rspBO.setProcDefId(((OrdTaskPO)ordTaskPOS.get(0)).getProcInstId());
            }
        }
        rspBO.setCurrentStepId(currentStepId);
        rspBO.setRows(approvalLogBOS);
        rspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords().intValue());
        rspBO.setPageNo(uacQryAuditLogRspBO.getPageNo().intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

