/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocAuditSignatureInitAbilityService;
import com.tydic.uoc.common.ability.bo.UocAuditSignatureInitReqBo;
import com.tydic.uoc.common.ability.bo.UocAuditSignatureInitRspBo;
import com.tydic.uoc.common.ability.bo.UocSaveOrderSignatureInitMqBo;
import com.tydic.uoc.common.busi.api.UocAuditSignatureInitBusiService;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocAuditSignatureInitAbilityService"})
public class UocAuditSignatureInitAbilityServiceImpl
implements UocAuditSignatureInitAbilityService {
    @Autowired
    private UocAuditSignatureInitBusiService uocAuditSignatureInitBusiService;
    @Value(value="${SAVE_ORDER_SIGNATURE_INIT_TOPIC:SAVE_ORDER_SIGNATURE_INIT_TOPIC}")
    private String saveOrderSignatureInitTopic;
    @Value(value="${SAVE_ORDER_SIGNATURE_INIT_TAG:*}")
    private String saveOrderSignatureInitTag;
    @Resource(name="saveOrderSignatureInitProxyMessageConfigProvider")
    private ProxyMessageProducer saveOrderSignatureInitProxyMessageConfigProvider;

    @PostMapping(value={"auditSignatureInit"})
    public UocAuditSignatureInitRspBo auditSignatureInit(@RequestBody UocAuditSignatureInitReqBo reqBo) {
        this.validateParams(reqBo);
        UocAuditSignatureInitRspBo rspBo = this.uocAuditSignatureInitBusiService.dealAuditSignatureInit(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getCompleteSignatureInitIds())) {
            UocSaveOrderSignatureInitMqBo saveOrderSignatureInitMqBo = new UocSaveOrderSignatureInitMqBo();
            saveOrderSignatureInitMqBo.setCompleteSignatureInitIds(rspBo.getCompleteSignatureInitIds());
            this.saveOrderSignatureInitProxyMessageConfigProvider.send(new ProxyMessage(this.saveOrderSignatureInitTopic, this.saveOrderSignatureInitTag, JSONObject.toJSONString((Object)saveOrderSignatureInitMqBo)));
        }
        return rspBo;
    }

    private void validateParams(UocAuditSignatureInitReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuditInfo())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2auditInfo\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

