/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderPaymentCallbackAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentCallbackAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentCallbackAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocPushContractMergeAbilityReqBO;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncConsumerVO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.api.UocProOrderPaymentCallbackBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderPaymentCallbackAbilityService"})
public class UocProOrderPaymentCallbackAbilityServiceImpl
implements UocProOrderPaymentCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProOrderPaymentCallbackAbilityServiceImpl.class);
    @Autowired
    private UocProOrderPaymentCallbackBusiService uocProOrderPaymentCallbackBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_SYNC_ORDER_TOPIC:UOC_SYNC_ORDER_TOPIC}")
    private String syncTopic;
    @Value(value="${UOC_SYNC_ORDER_TAG:*}")
    private String syncTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;

    @PostMapping(value={"dealOrderPaymentCallback"})
    public UocProOrderPaymentCallbackAbilityRspBo dealOrderPaymentCallback(@RequestBody UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProOrderPaymentCallbackAbilityRspBo rspBo = this.uocProOrderPaymentCallbackBusiService.dealOrderPaymentCallback(reqBo);
        if (null != rspBo.getIsRunPay() && rspBo.getIsRunPay().booleanValue()) {
            if ("2".equals(rspBo.getOrderSource())) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setOrderId(reqBo.getOrderId());
                submitReqBO.setSaleVoucherId(rspBo.getSaleVoucherId());
                UocPebPreOrderSubmitRspBO submit = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                this.syncSale(rspBo, reqBo);
                if (!"0000".equals(submit.getRespCode())) {
                    throw new UocProBusinessException("104044", "\u7535\u5546\u8ba2\u5355\u5931\u8d25" + submit.getRespDesc());
                }
                OrderPO orderPO = this.orderMapper.getModelById(reqBo.getOrderId().longValue());
                List<Integer> orderTypeList = Arrays.asList(4, 5);
                if (orderPO != null && orderPO.getOrderType() != null && orderTypeList.contains(orderPO.getOrderType())) {
                    UocPushContractMergeAbilityReqBO tzAbilityReqBO = new UocPushContractMergeAbilityReqBO();
                    tzAbilityReqBO.setOrderId(reqBo.getOrderId());
                    this.pushContractTzHeadProvider.send(new ProxyMessage(this.pushContractTzTopic, this.pushContractTzTag, JSONObject.toJSONString((Object)tzAbilityReqBO)));
                }
            }
            this.syncSale(rspBo, reqBo);
        } else if (null != rspBo.getSaleVoucherId()) {
            this.syncSale(rspBo, reqBo);
        }
        try {
            if (this.uocESGConfig.getAbutmentESGYn().booleanValue() && Objects.nonNull(reqBo.getPayResult()) && reqBo.getPayResult().booleanValue()) {
                UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                uocOrdZmInfoPO.setOrderId(reqBo.getOrderId());
                uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
                if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                    UocESGOrderSyncConsumerVO syncConsumerVO = new UocESGOrderSyncConsumerVO();
                    syncConsumerVO.setOrderIds(Collections.singletonList(reqBo.getOrderId()));
                    this.uocESGSyncMsgProvider.send(new ProxyMessage(this.syncTopic, this.syncTag, JSONObject.toJSONString((Object)syncConsumerVO)));
                }
            }
        }
        catch (Exception exception) {
            log.error("\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
        }
        if (rspBo.getIsRunPay().booleanValue() && rspBo.getSendNotification().booleanValue()) {
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setUserId(1L);
            sendNotificationExtAtomReqBO.setOrderId(reqBo.getOrderId());
            sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_PAID);
            this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
        }
        try {
            OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
            ordInspectionPO.setOrderId(reqBo.getOrderId());
            List ordInspectionList = this.ordInspectionMapper.getList(ordInspectionPO);
            if (!CollectionUtils.isEmpty((Collection)ordInspectionList)) {
                for (OrdInspectionPO inspectionPO : ordInspectionList) {
                    this.syncInspection(reqBo.getOrderId(), inspectionPO.getInspectionVoucherId());
                }
            }
        }
        catch (Exception exception) {
            throw new UocProBusinessException("8888", "\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u9a8c\u6536\u5355es\u540c\u6b65\u5f02\u5e38:" + exception);
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getIsOrderCallback() || !reqBo.getIsOrderCallback().booleanValue()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getObjectId())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[objectId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getFscShouldPayId())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[fscShouldPayId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getShouldPayMoney())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getShouldPayMoney().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPayMod())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[payMod]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPayResult())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[payResult]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void syncSale(UocProOrderPaymentCallbackAbilityRspBo rspBo, UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(rspBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }

    private void syncInspection(Long orderId, Long inspectionVoucherId) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(inspectionVoucherId);
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        uocOrdSaleIdxSyncReqBO.setOrderId(orderId);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

