/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocPushContractPreMoneyFreedomPayAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPushContractPreMoneyFreedomPayAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPushContractPreMoneyFreedomPayAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPushContractPreMoneyFreedomPayBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzHeadChangeBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzPayLineChangeBO;
import com.tydic.uoc.common.busi.api.UocPushContractTzBusiService;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdProContractHeadMapper;
import com.tydic.uoc.dao.UocOrdProContractMapper;
import com.tydic.uoc.dao.UocPreMoneyTaskMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdProContractHeadPO;
import com.tydic.uoc.po.UocOrdProContractPO;
import com.tydic.uoc.po.UocPreMoneyTaskPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPushContractPreMoneyFreedomPayAbilityService"})
public class UocPushContractPreMoneyFreedomPayAbilityServiceImpl
implements UocPushContractPreMoneyFreedomPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPushContractPreMoneyFreedomPayAbilityServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdProContractHeadMapper uocOrdProContractHeadMapper;
    @Autowired
    private UocOrdProContractMapper uocOrdProContractMapper;
    @Value(value="${settle.stage:TWO}")
    private String settleStage;
    @Autowired
    private UocPushContractTzBusiService uocPushContractTzBusiService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private UocPreMoneyTaskMapper uocPreMoneyTaskMapper;

    @PostMapping(value={"dealPushFreedomPay"})
    public UocPushContractPreMoneyFreedomPayAbilityRspBO dealPushFreedomPay(@RequestBody UocPushContractPreMoneyFreedomPayAbilityReqBO reqBO) {
        this.val(reqBO);
        ArrayList<UocPushContractTzPayLineChangeBO> payLineBOS = new ArrayList<UocPushContractTzPayLineChangeBO>();
        UocOrdProContractHeadPO contractHeadPO = new UocOrdProContractHeadPO();
        HashMap<Long, String> orderMap = new HashMap<Long, String>();
        for (UocPushContractPreMoneyFreedomPayBO payBO : reqBO.getPayBOList()) {
            Long orderId = payBO.getOrderId();
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            Boolean canPush = this.valCanPush(ordSalePO);
            if (!canPush.booleanValue()) {
                throw new BusinessException("8888", "\u8ba2\u5355\u4e0d\u7b26\u5408\u63a8\u9001\u6761\u4ef6");
            }
            UocOrdProContractPO contractPO = new UocOrdProContractPO();
            contractPO.setOrderId(orderId);
            contractPO = this.uocOrdProContractMapper.getModelBy(contractPO);
            if (contractPO == null) {
                throw new BusinessException("8888", "\u8ba2\u5355\u67e5\u8be2\u9500\u552e\u5408\u540c\u5931\u8d25");
            }
            UocOrdProContractHeadPO headPO = new UocOrdProContractHeadPO();
            headPO.setEgContractId(contractPO.getContractId());
            headPO = this.uocOrdProContractHeadMapper.getModelBy(headPO);
            if (headPO == null) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5408\u540c\u5934\u8868\u5931\u8d25");
            }
            UocPreMoneyTaskPO uocPreMoneyTaskPO = new UocPreMoneyTaskPO();
            uocPreMoneyTaskPO.setOrderId(orderId);
            List taskList = this.uocPreMoneyTaskMapper.getList(uocPreMoneyTaskPO);
            if (!CollectionUtils.isEmpty((Collection)taskList)) {
                taskList = taskList.stream().filter(e -> Integer.valueOf(3).equals(e.getTaskStatus()) && !"del".equals(e.getExt5())).collect(Collectors.toList());
            }
            this.coverPayLineChange(taskList, payLineBOS, headPO, payBO);
            contractHeadPO = headPO;
            orderMap.put(orderId, ordSalePO.getSaleVoucherNo());
        }
        UocPushContractTzHeadChangeBO uocPushContractTzHeadChangeBO = this.buildHeadChange(contractHeadPO);
        PebExtUnifySettleTokenQryAbilityRspBO tokenRspBO = this.qryToken(contractHeadPO.getExt1());
        String token = tokenRspBO.getData();
        UocPushContractTzChangeBusiReqBO busiReqBO = new UocPushContractTzChangeBusiReqBO();
        busiReqBO.setToken(token);
        busiReqBO.setHeadChangeBO(uocPushContractTzHeadChangeBO);
        busiReqBO.setPayLineBOS(payLineBOS);
        busiReqBO.setOrderMap(orderMap);
        UocPushContractTzChangeBusiRspBO busiRspBO = this.uocPushContractTzBusiService.dealPushContractPreMoneyFreedomPay(busiReqBO);
        UocPushContractPreMoneyFreedomPayAbilityRspBO rspBO = new UocPushContractPreMoneyFreedomPayAbilityRspBO();
        if (busiRspBO.getSendFlag() != null && busiRspBO.getSendFlag().booleanValue()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(rspBO.getRespDesc());
        }
        return rspBO;
    }

    private Boolean valCanPush(OrdSalePO ordSalePO) {
        Boolean canPush = false;
        if ("2".equals(ordSalePO.getOrderSource())) {
            canPush = true;
        } else if ("1".equals(ordSalePO.getOrderSource()) && UocCoreConstant.ModelSettle.TRADING.equals(ordSalePO.getModelSettle())) {
            canPush = true;
        } else if ("3".equals(ordSalePO.getOrderSource()) && UocCoreConstant.ModelSettle.MATCH_UP.equals(ordSalePO.getModelSettle())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(ordSalePO.getOrderId());
            orderPO = this.orderMapper.getModelBy(orderPO);
            List<Integer> orderTypeList = Arrays.asList(3, 7);
            canPush = orderTypeList.contains(orderPO.getOrderType()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return canPush;
    }

    private void val(UocPushContractPreMoneyFreedomPayAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayBOList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[payBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UocPushContractPreMoneyFreedomPayBO uocPushContractPreMoneyFreedomPayBO : reqBO.getPayBOList()) {
            if (uocPushContractPreMoneyFreedomPayBO.getOrderId() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (uocPushContractPreMoneyFreedomPayBO.getPayScal() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[payScal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (uocPushContractPreMoneyFreedomPayBO.getPayAmount() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[payAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (uocPushContractPreMoneyFreedomPayBO.getEgPayTermsId() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[egPayTermsId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)uocPushContractPreMoneyFreedomPayBO.getPayDesc())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[payDesc]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isBlank((CharSequence)uocPushContractPreMoneyFreedomPayBO.getPayDate())) continue;
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[payDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void coverPayLineChange(List<UocPreMoneyTaskPO> taskList, List<UocPushContractTzPayLineChangeBO> payLineBOS, UocOrdProContractHeadPO headPO, UocPushContractPreMoneyFreedomPayBO payBO) {
        if (!CollectionUtils.isEmpty(taskList)) {
            for (UocPreMoneyTaskPO taskBO : taskList) {
                UocPushContractTzPayLineChangeBO payScheduleBO = new UocPushContractTzPayLineChangeBO();
                payScheduleBO.setPAY_TYPE("PRE");
                payScheduleBO.setPAY_TYPE_DIS("\u9884\u4ed8\u6b3e");
                payScheduleBO.setPAY_SCAL(taskBO.getPayScal());
                payScheduleBO.setPAY_AMOUNT(taskBO.getPayAmount());
                if (StringUtils.isNotBlank((CharSequence)taskBO.getExt3()) && taskBO.getPayScal() != null && StringUtils.isNotBlank((CharSequence)taskBO.getExt2())) {
                    payScheduleBO.setPAY_DESC(taskBO.getExt2() + taskBO.getExt3() + "\u5929\u4ed8" + taskBO.getPayScal().stripTrailingZeros().toPlainString() + "%");
                }
                payScheduleBO.setORG_ID(headPO.getOrgId());
                payScheduleBO.setUSER_ID(headPO.getUserId());
                payScheduleBO.setHANDLE_TYPE("DEL");
                payScheduleBO.setEG_PAY_TERMS_ID(taskBO.getEgPayTermsId());
                payScheduleBO.setORG_NAME(headPO.getOrgName());
                if (StringUtils.isNotBlank((CharSequence)taskBO.getExt4())) {
                    payScheduleBO.setPAY_DATE(taskBO.getExt4());
                }
                payLineBOS.add(payScheduleBO);
            }
        }
        UocPushContractTzPayLineChangeBO payScheduleBO = new UocPushContractTzPayLineChangeBO();
        payScheduleBO.setPAY_TYPE("PRE");
        payScheduleBO.setPAY_TYPE_DIS("\u9884\u4ed8\u6b3e");
        payScheduleBO.setPAY_SCAL(payBO.getPayScal());
        payScheduleBO.setPAY_AMOUNT(payBO.getPayAmount());
        payScheduleBO.setPAY_DESC(payBO.getPayDesc());
        payScheduleBO.setORG_ID(headPO.getOrgId());
        payScheduleBO.setUSER_ID(headPO.getUserId());
        payScheduleBO.setHANDLE_TYPE("ADD");
        payScheduleBO.setEG_PAY_TERMS_ID(payBO.getEgPayTermsId());
        payScheduleBO.setPAY_DATE(payBO.getPayDate());
        payScheduleBO.setORG_NAME(headPO.getOrgName());
        payLineBOS.add(payScheduleBO);
    }

    private UocPushContractTzHeadChangeBO buildHeadChange(UocOrdProContractHeadPO qryContract) {
        UocPushContractTzHeadChangeBO bo = new UocPushContractTzHeadChangeBO();
        bo.setCHG_TYPE("ORDER");
        bo.setCONTRACT_NUM(qryContract.getContractNum());
        bo.setN_PAY_TERMS("16");
        bo.setN_PAY_TERMS_DIS("\u6309\u5408\u540c\u7ea6\u5b9a");
        bo.setN_PERSON_ID(qryContract.getPersonId());
        bo.setN_PERSON_NAME(qryContract.getPersonName());
        bo.setN_DEPT_ID(qryContract.getDeptId());
        bo.setN_DEPT_NAME(qryContract.getDeptName());
        bo.setSTATUS("Y");
        bo.setORG_NAME(qryContract.getOrgName());
        bo.setORG_ID(qryContract.getOrgId());
        bo.setEG_CHANGE_ID(qryContract.getEgContractId() + "");
        bo.setSTAGE(this.settleStage);
        return bo;
    }

    private PebExtUnifySettleTokenQryAbilityRspBO qryToken(String agentAccount) {
        if (StringUtils.isEmpty((CharSequence)agentAccount)) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u4e0b\u5355\u4ebaERP\u8d26\u53f7\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAtomReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAtomReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAtomRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAtomReqBO);
        if (!tokenQryAtomRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(tokenQryAtomRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97token\u5931\u8d25\uff01" + tokenQryAtomRspBO.getRespDesc());
        }
        return tokenQryAtomRspBO;
    }
}

