/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.common.ability.api.UocPushContractMergeAbilityService;
import com.tydic.uoc.common.ability.bo.UocPushContractMergeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPushContractMergeAbilityRspBO;
import com.tydic.uoc.config.ApplicationContextProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UocPushContractThreadForBatchAbilityServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(UocPushContractThreadForBatchAbilityServiceImpl.class);
    private static List<Long> failureReqBO = new ArrayList<Long>();

    public synchronized Boolean handleList(List<Long> data, int threadNum) throws InterruptedException {
        boolean isFailure = false;
        int length = data.size();
        int maxThreadNum = Runtime.getRuntime().availableProcessors();
        log.error("-------\u591a\u7ebf\u7a0b\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u5f00\u59cb\uff0c\u6700\u591a\u542f\u52a8\u7ebf\u7a0b\u6570---------" + maxThreadNum);
        if (threadNum <= 0) {
            threadNum = maxThreadNum;
        } else if (threadNum > maxThreadNum) {
            threadNum = maxThreadNum;
        }
        if (length < threadNum) {
            threadNum = length;
        }
        log.error("-------\u591a\u7ebf\u7a0b\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b\u6570{}--------------", (Object)threadNum);
        failureReqBO = new ArrayList<Long>();
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        int baseNum = length / threadNum;
        int remainderNum = length % threadNum;
        int end = 0;
        for (int i = 0; i < threadNum; ++i) {
            int start = end;
            end = start + baseNum;
            if (i == threadNum - 1) {
                end = length;
            } else if (i < remainderNum) {
                ++end;
            }
            List<Long> threadData = data.subList(start, end);
            HandleThread thread = new HandleThread(threadData, countDownLatch);
            thread.start();
        }
        countDownLatch.await();
        if (!CollectionUtils.isEmpty(failureReqBO)) {
            log.error("---\u591a\u7ebf\u7a0b\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u5931\u8d25\u6761\u6570\uff1a{}\uff0c\u5931\u8d25\u6570\u636e\uff1a{}", (Object)failureReqBO.size(), (Object)JSON.toJSONString(failureReqBO));
            isFailure = true;
        }
        failureReqBO = null;
        log.error("-------\u591a\u7ebf\u7a0b\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u7ed3\u675f--------------");
        return isFailure;
    }

    static class HandleThread
    extends Thread {
        private final List<Long> pushData;
        private final CountDownLatch countDownLatch;
        private final UocPushContractMergeAbilityService uocPushContractMergeAbilityService;

        public HandleThread(List<Long> pushData, CountDownLatch countDownLatch) {
            this.pushData = pushData;
            this.countDownLatch = countDownLatch;
            this.uocPushContractMergeAbilityService = ApplicationContextProvider.getBean(UocPushContractMergeAbilityService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (CollectionUtils.isEmpty(this.pushData)) {
                log.error("\u6279\u91cf\u63a8\u9001\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            try {
                Iterator<Long> iterator = this.pushData.iterator();
                while (iterator.hasNext()) {
                    Long orderId = iterator.next();
                    UocPushContractMergeAbilityReqBO pushContractMergeAbilityReqBO = new UocPushContractMergeAbilityReqBO();
                    pushContractMergeAbilityReqBO.setOrderId(orderId);
                    UocPushContractMergeAbilityRspBO uocPushContractMergeAbilityRspBO = this.uocPushContractMergeAbilityService.dealPush(pushContractMergeAbilityReqBO);
                    if ("0000".equals(uocPushContractMergeAbilityRspBO.getRespCode())) continue;
                    Class<UocPushContractThreadForBatchAbilityServiceImpl> clazz = UocPushContractThreadForBatchAbilityServiceImpl.class;
                    // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPushContractThreadForBatchAbilityServiceImpl.class
                    failureReqBO.add(orderId);
                    // MONITOREXIT : clazz
                }
                return;
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u63a8\u9001\u65b0\u4e1a\u8d22\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
                return;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

