/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocQrySignatureInitListAbilityService;
import com.tydic.uoc.common.ability.bo.UocQrySignatureInitListReqBo;
import com.tydic.uoc.common.ability.bo.UocQrySignatureInitListRspBo;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.uoc.dao.UocSignatureInitMapper;
import com.tydic.uoc.po.ConfTabOrdStatePO;
import com.tydic.uoc.po.UocSignatureInitPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocQrySignatureInitListAbilityService"})
public class UocQrySignatureInitListAbilityServiceImpl
implements UocQrySignatureInitListAbilityService {
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;
    @Autowired
    private UocSignatureInitMapper uocSignatureInitMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    @PostMapping(value={"getSignatureInit"})
    public BasePageRspBo<UocQrySignatureInitListRspBo> getSignatureInit(@RequestBody UocQrySignatureInitListReqBo reqBo) {
        ArrayList<Integer> statueList;
        this.validateParams(reqBo);
        ConfTabOrdStatePO confTabOrdStatePO = new ConfTabOrdStatePO();
        confTabOrdStatePO.setTabId(reqBo.getTabId());
        confTabOrdStatePO = this.confTabOrdStateMapper.getModelBy(confTabOrdStatePO);
        if (null != confTabOrdStatePO && !StringUtils.isEmpty((CharSequence)confTabOrdStatePO.getOrderStatusCode())) {
            if (confTabOrdStatePO.getOrderStatusCode().contains(",")) {
                String[] statue = confTabOrdStatePO.getOrderStatusCode().split(",");
                statueList = new ArrayList(statue.length);
                for (String state : statue) {
                    statueList.add(Integer.valueOf(state));
                }
            } else {
                statueList = new ArrayList<Integer>(1);
                statueList.add(Integer.valueOf(confTabOrdStatePO.getOrderStatusCode()));
            }
        } else {
            statueList = null;
        }
        BasePageRspBo rspBo = new BasePageRspBo();
        UocSignatureInitPo uocSignatureInitPo = (UocSignatureInitPo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UocSignatureInitPo.class);
        uocSignatureInitPo.setSignatureApprovalStatusList(statueList);
        uocSignatureInitPo.setOrderBy("si.create_time desc");
        if (UocConstant.TabId.SIGNATURE_INIT_PENDING_APPROVAL.equals(reqBo.getTabId())) {
            uocSignatureInitPo.setIsApprovalQuery(UocConstant.VALID_FLAG.YES);
            uocSignatureInitPo.setDealOperId(reqBo.getUserIdIn());
            uocSignatureInitPo.setFinishTag(UocConstant.VALID_FLAG.NO);
        } else if (UocConstant.TabId.SIGNATURE_INIT_APPROVED.equals(reqBo.getTabId())) {
            uocSignatureInitPo.setIsApprovalQuery(UocConstant.VALID_FLAG.YES);
            uocSignatureInitPo.setDealOperId(reqBo.getUserIdIn());
            uocSignatureInitPo.setFinishTag(UocConstant.VALID_FLAG.YES);
        } else {
            List<String> dealAuth = this.dealAuth(reqBo.getIsAdmin(), reqBo.getUsername());
            if (null == dealAuth) {
                rspBo.setRows(new ArrayList());
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u65e0\u5355\u4f4d\u6743\u9650");
                return rspBo;
            }
            uocSignatureInitPo.setOrgCodeAuthList(dealAuth);
            uocSignatureInitPo.setDefaultCreateUserId(reqBo.getUserIdIn());
        }
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List signatureInitPoList = this.uocSignatureInitMapper.getListPageApproval(uocSignatureInitPo, page);
        ArrayList<UocQrySignatureInitListRspBo> rows = new ArrayList<UocQrySignatureInitListRspBo>(signatureInitPoList.size());
        if (!signatureInitPoList.isEmpty()) {
            Map<String, String> businessTypeDic = this.selectDicValByPcodeAndCode.getValueByPCode("business_type");
            Map<String, String> bothPartiesSignDic = this.selectDicValByPcodeAndCode.getValueByPCode("both_parties_sign");
            Map<String, String> signOrderDic = this.selectDicValByPcodeAndCode.getValueByPCode("sign_order");
            Map<String, String> partySignTypeDic = this.selectDicValByPcodeAndCode.getValueByPCode("party_sign_type");
            Map<String, String> signatureApprovalStatusDic = this.selectDicValByPcodeAndCode.getValueByPCode("signature_approval_status");
            Map<String, String> signatureStatusDic = this.selectDicValByPcodeAndCode.getValueByPCode("signature_status");
            Map<String, String> pushStateDic = this.selectDicValByPcodeAndCode.getValueByPCode("push_state");
            for (UocSignatureInitPo signatureInitPo : signatureInitPoList) {
                UocQrySignatureInitListRspBo signatureInitListRspBo = (UocQrySignatureInitListRspBo)JSON.parseObject((String)JSON.toJSONString((Object)signatureInitPo), UocQrySignatureInitListRspBo.class);
                signatureInitListRspBo.setBusinessTypeStr(businessTypeDic.get(String.valueOf(signatureInitListRspBo.getBusinessType())));
                signatureInitListRspBo.setBothPartiesSignStr(bothPartiesSignDic.get(String.valueOf(signatureInitListRspBo.getBothPartiesSign())));
                signatureInitListRspBo.setSignOrderStr(signOrderDic.get(String.valueOf(signatureInitListRspBo.getSignOrder())));
                signatureInitListRspBo.setFirstPartySignTypeStr(partySignTypeDic.get(String.valueOf(signatureInitListRspBo.getFirstPartySignType())));
                signatureInitListRspBo.setSecondPartySignTypeStr(partySignTypeDic.get(String.valueOf(signatureInitListRspBo.getSecondPartySignType())));
                signatureInitListRspBo.setThirdPartySignTypeStr(partySignTypeDic.get(String.valueOf(signatureInitListRspBo.getThirdPartySignType())));
                signatureInitListRspBo.setSignatureApprovalStatusStr(signatureApprovalStatusDic.get(String.valueOf(signatureInitListRspBo.getSignatureApprovalStatus())));
                signatureInitListRspBo.setSignatureStatusStr(signatureStatusDic.get(String.valueOf(signatureInitListRspBo.getSignatureStatus())));
                signatureInitListRspBo.setPushStateStr(pushStateDic.get(String.valueOf(signatureInitListRspBo.getPushState())));
                rows.add(signatureInitListRspBo);
            }
        }
        rspBo.setRows(rows);
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<String> dealAuth(Integer isAdmin, String erpCode) {
        List<String> orgCodeAuthList;
        if (!UocConstant.VALID_FLAG.YES.equals(isAdmin)) {
            DycUmcQueryOrgPermissionReqBo orgPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
            orgPermissionReqBo.setPageFlag(false);
            orgPermissionReqBo.setErpCode(erpCode);
            DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermissionCtFast(orgPermissionReqBo);
            if (!"0000".equals(permissionRspBo.getRespCode())) {
                throw new UocProBusinessException(permissionRspBo.getRespCode(), "\u5355\u4f4d\u6743\u9650\u67e5\u8be2\u5931\u8d25\uff1a" + permissionRspBo.getRespDesc());
            }
            if (CollectionUtil.isNotEmpty((Collection)permissionRspBo.getOrgInfos())) {
                orgCodeAuthList = permissionRspBo.getOrgInfos().stream().map(UmcEnterpriseOrgBO::getOrgCode).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList());
                List<String> finalOrgCodeAuthList = orgCodeAuthList;
                orgCodeAuthList = orgCodeAuthList.stream().filter(auth -> finalOrgCodeAuthList.stream().noneMatch(existing -> !existing.equals(auth) && auth.startsWith((String)existing))).collect(Collectors.toList());
            } else {
                orgCodeAuthList = null;
            }
        } else {
            orgCodeAuthList = new ArrayList<String>();
        }
        return orgCodeAuthList;
    }

    private void validateParams(UocQrySignatureInitListReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getTabId()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

