/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.extra.qrcode.QrCodeUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.UocWmsOrderShipExpAbilityService;
import com.tydic.uoc.common.ability.bo.UocWmsOrderShipExpReqBO;
import com.tydic.uoc.common.ability.bo.UocWmsrderShipExpRspBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocWmsOrderShipExpAbilityService"})
public class UocWmsOrderShipExpAbilityServiceImpl
implements UocWmsOrderShipExpAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocWmsOrderShipExpAbilityServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final int QR_CODE_SIZE = 200;

    @PostMapping(value={"extWmsOrderShip"})
    public UocWmsrderShipExpRspBO extWmsOrderShip(@RequestBody UocWmsOrderShipExpReqBO reqBO) {
        this.checkInput(reqBO);
        return this.expShipForm(reqBO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UocWmsrderShipExpRspBO expShipForm(UocWmsOrderShipExpReqBO reqBO) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String url = "";
        String outOrderNo = "";
        String shipDate = "";
        String supplierName = "";
        String supName = "";
        String psdh = "";
        String pscp = "";
        String estimatedArrivalTime = "";
        String shCompany = "";
        String receiverTime = "";
        OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBO.getShipVoucherId().longValue());
        if (Objects.isNull(ordShipPO)) {
            throw new UocProBusinessException("100200", "\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25");
        }
        OrderPO orderPO = this.orderMapper.getModelById(ordShipPO.getOrderId().longValue());
        if (Objects.isNull(orderPO)) {
            throw new UocProBusinessException("100200", "\u67e5\u8be2\u8ba2\u5355\u5931\u8d25,\u6570\u636e\u5f02\u5e38");
        }
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelById(ordShipPO.getSaleVoucherId().longValue());
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("100200", "\u67e5\u8be2\u9500\u552e\u5355\u5931\u8d25,\u6570\u636e\u5f02\u5e38");
        }
        OrdLogisticsRelaPO ordLogisticsRelaPO = this.ordLogisticsRelaMapper.getModelById(ordSalePO.getContactId().longValue());
        if (ordLogisticsRelaPO != null) {
            shCompany = ordLogisticsRelaPO.getContactCompany();
        }
        OrdQueryIndexPO ordQueryIndexPO = new OrdQueryIndexPO();
        ordQueryIndexPO.setOrderId(ordShipPO.getOrderId());
        ordQueryIndexPO.setObjType(Integer.valueOf(2));
        OrdQueryIndexPO ordQueryIndexRspPO = this.ordQueryIndexMapper.getModelBy(ordQueryIndexPO);
        UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
        uocOrdZmInfoPO.setOrderId(ordShipPO.getOrderId());
        UocOrdZmInfoPO uocOrdZmInfoRspPO = this.uocOrdZmInfoMapper.selectOne(uocOrdZmInfoPO);
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(ordShipPO.getOrderId().longValue());
        if ("4".equals(ordSalePO.getOrderSource())) {
            outOrderNo = ordShipPO.getExtOrderId();
        } else if (ordQueryIndexRspPO != null) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (uocOrdZmInfoRspPO != null) {
            supplierName = uocOrdZmInfoRspPO.getSupplierName();
        }
        if (ordStakeholderPO != null) {
            supName = ordStakeholderPO.getSupName();
        }
        if (ordShipPO.getShipTime() != null) {
            shipDate = sf.format(ordShipPO.getShipTime());
        }
        if ("1".equals(ordShipPO.getShipCompanyId())) {
            pscp = ordShipPO.getPackageId();
        } else if ("2".equals(ordShipPO.getShipCompanyId())) {
            psdh = ordShipPO.getPackageId();
        }
        if (ordShipPO.getEstimateArrivalTime() != null) {
            estimatedArrivalTime = sf.format(ordShipPO.getEstimateArrivalTime());
        }
        OrdShipItemPO queryOrdShipItemPO = new OrdShipItemPO();
        queryOrdShipItemPO.setShipVoucherId(ordShipPO.getShipVoucherId());
        List ordShipItemPOS = this.ordShipItemMapper.getList(queryOrdShipItemPO);
        int size = ordShipItemPOS.size();
        int initRowSize = 7 + size;
        int initColSize = 15;
        String fileName = "\u4e2d\u7164\u53d1\u8d27\u5355\u6253\u5370\u6a21\u677f.xls";
        String sheetName = "\u53d1\u8d27\u5355\u6253\u5370\u6a21\u677f";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle titleStyle = UocWmsOrderShipExpAbilityServiceImpl.getStyleInCommon(workbook, (short)12, "\u5b8b\u4f53", false);
        HSSFCellStyle contentStyle = UocWmsOrderShipExpAbilityServiceImpl.getStyleInCommonContent(workbook, (short)12, "\u5b8b\u4f53", true);
        HSSFCellStyle contentColorStyle = UocWmsOrderShipExpAbilityServiceImpl.getStyleInCommonContent(workbook, (short)12, "\u5b8b\u4f53", true);
        HSSFCellStyle dataStyle = UocWmsOrderShipExpAbilityServiceImpl.getDataStyle(workbook, true, "left");
        HSSFCellStyle dataColorStyle = UocWmsOrderShipExpAbilityServiceImpl.getDataStyle(workbook, true, "left");
        HSSFCellStyle dataStyleRight = UocWmsOrderShipExpAbilityServiceImpl.getDataStyle(workbook, true, "right");
        HSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(7);
        sheet.setDisplayGridlines(true);
        for (int rowIndex = 0; rowIndex <= initRowSize - 1; ++rowIndex) {
            HSSFRow titleRow = sheet.createRow(rowIndex);
            titleRow.setHeight((short)-1);
            for (int columnIndex = 0; columnIndex <= initColSize - 1; ++columnIndex) {
                titleRow.createCell(columnIndex);
            }
            if (rowIndex != 0) continue;
            titleRow.setHeightInPoints(60.0f);
        }
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 0, 0, 0, 14);
        HSSFRow titleRow = sheet.getRow(0);
        HSSFCell titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u4e2d\u7164\u6613\u8d2d\u5546\u57ce\u53d1\u8d27\u5355");
        titleCell.setCellStyle(titleStyle);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            QrCodeUtil.generate((String)ordShipPO.getShipVoucherCode(), (int)200, (int)200, (String)"png", (OutputStream)outputStream);
            byte[] qrCodeData = outputStream.toByteArray();
            HSSFPatriarch drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = drawing.createAnchor(300, 10, 0, 0, 13, 0, 15, 1);
            drawing.createPicture(anchor, workbook.addPicture(qrCodeData, 6));
        }
        catch (Exception e2) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38\uff1a", (Throwable)e2);
        }
        HSSFRow shipRow = sheet.getRow(1);
        HSSFCell shipCell = shipRow.getCell(0);
        shipCell.setCellValue("\u8ba2\u5355\u7f16\u53f7\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 1, 1, 1, 4);
        shipRow = sheet.getRow(1);
        shipCell = shipRow.getCell(1);
        shipCell.setCellValue(ordSalePO.getSaleVoucherNo());
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(1);
        shipCell = shipRow.getCell(5);
        shipCell.setCellValue("\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 1, 1, 6, 10);
        shipRow = sheet.getRow(1);
        shipCell = shipRow.getCell(6);
        shipCell.setCellValue(outOrderNo);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(1);
        shipCell = shipRow.getCell(10);
        shipCell.setCellValue("\u53d1\u8d27\u65e5\u671f\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 1, 1, 11, 14);
        shipRow = sheet.getRow(1);
        shipCell = shipRow.getCell(11);
        shipCell.setCellValue(shipDate);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(0);
        shipCell.setCellValue("\u6536\u8d27\u5355\u4f4d\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 2, 2, 1, 4);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(1);
        shipCell.setCellValue(shCompany);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(5);
        shipCell.setCellValue("\u4f9b\u5e94\u5546\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 2, 2, 6, 9);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(6);
        shipCell.setCellValue(supplierName);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(10);
        shipCell.setCellValue("\u4f9b\u8d27\u65b9\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 2, 2, 11, 14);
        shipRow = sheet.getRow(2);
        shipCell = shipRow.getCell(11);
        shipCell.setCellValue(supName);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(0);
        shipCell.setCellValue("\u53d1\u8d27\u8054\u7cfb\u4eba\uff1a");
        shipCell.setCellStyle(dataStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 3, 3, 1, 4);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(1);
        shipCell.setCellValue(ordShipPO.getShipName());
        shipCell.setCellStyle(dataStyle);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(5);
        shipCell.setCellValue("\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a");
        shipCell.setCellStyle(dataStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 3, 3, 6, 9);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(6);
        shipCell.setCellValue(ordShipPO.getShipPhone());
        shipCell.setCellStyle(dataStyle);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(10);
        shipCell.setCellValue("\u914d\u9001\u5355\u53f7\uff1a");
        shipCell.setCellStyle(contentColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 3, 3, 11, 14);
        shipRow = sheet.getRow(3);
        shipCell = shipRow.getCell(11);
        shipCell.setCellValue(psdh);
        shipCell.setCellStyle(contentStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(0);
        shipCell.setCellValue("\u5e8f\u53f7");
        shipCell.setCellStyle(dataStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 4, 4, 1, 2);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(1);
        shipCell.setCellValue("\u7269\u8d44\u63cf\u8ff0");
        shipCell.setCellStyle(dataColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 4, 4, 3, 4);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(3);
        shipCell.setCellValue("\u7269\u8d44\u7f16\u7801");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(5);
        shipCell.setCellValue("\u89c4\u683c");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(6);
        shipCell.setCellValue("\u578b\u53f7");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(7);
        shipCell.setCellValue("\u91c7\u8d2d\u6570\u91cf");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(8);
        shipCell.setCellValue("\u8ba1\u91cf\u5355\u4f4d");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(9);
        shipCell.setCellValue("\u53d1\u8d27\u6570\u91cf");
        shipCell.setCellStyle(dataColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 4, 4, 10, 11);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(10);
        shipCell.setCellValue("\u9884\u8ba1\u5230\u8d27\u65e5\u671f");
        shipCell.setCellStyle(dataColorStyle);
        UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, 4, 4, 12, 13);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(12);
        shipCell.setCellValue("\u53d1\u8d27\u91d1\u989d\uff08\u542b\u7a0e\uff09");
        shipCell.setCellStyle(dataColorStyle);
        shipRow = sheet.getRow(4);
        shipCell = shipRow.getCell(14);
        shipCell.setCellValue("\u5907\u6ce8");
        shipCell.setCellStyle(dataColorStyle);
        int index = 1;
        int rowIndex = 5;
        HashSet<Long> ordItemSet = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)ordShipItemPOS)) {
            for (OrdShipItemPO ordShipItemPO : ordShipItemPOS) {
                ordItemSet.add(ordShipItemPO.getOrdItemId());
            }
        }
        BigDecimal sumPrice = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(ordItemSet)) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(ordShipPO.getOrderId());
            ordItemPO.setOrdItemIdList(new ArrayList(ordItemSet));
            List orderItmeList = this.ordItemMapper.getList(ordItemPO);
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrderId(ordShipPO.getOrderId());
            ordGoodsPO.setOrdItemIdList(new ArrayList(ordItemSet));
            List orderGoodsList = this.ordGoodsMapper.getList(ordGoodsPO);
            Map<Object, Object> itemMap = new HashMap();
            Map<Object, Object> goodsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)orderItmeList)) {
                itemMap = orderItmeList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, e -> e, (k, v) -> k));
            }
            if (!CollectionUtils.isEmpty((Collection)orderGoodsList)) {
                goodsMap = orderGoodsList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, e -> e, (k, v) -> k));
            }
            for (OrdShipItemPO ordShipItemPO : ordShipItemPOS) {
                OrdItemPO itemPO = (OrdItemPO)itemMap.get(ordShipItemPO.getOrdItemId());
                OrdGoodsPO goodsPO = (OrdGoodsPO)goodsMap.get(ordShipItemPO.getOrdItemId());
                if (itemPO == null) {
                    throw new UocProBusinessException("100001", "\u660e\u7ec6:" + ordShipItemPO.getOrdItemId() + ",\u67e5\u8be2\u8ba2\u5355\u7269\u8d44\u660e\u7ec6\u5931\u8d25");
                }
                if (goodsPO == null) {
                    throw new UocProBusinessException("100001", "\u660e\u7ec6:" + ordShipItemPO.getOrdItemId() + ",\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u5931\u8d25");
                }
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(0);
                shipCell.setCellValue((double)index);
                shipCell.setCellStyle(dataStyle);
                UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 1, 2);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(1);
                shipCell.setCellValue(itemPO.getExtField2());
                shipCell.setCellStyle(dataStyle);
                UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 3, 4);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(3);
                shipCell.setCellValue(goodsPO.getSkuMaterialId());
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(5);
                shipCell.setCellValue(goodsPO.getSpec());
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(6);
                shipCell.setCellValue(goodsPO.getModel());
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(7);
                shipCell.setCellValue(this.convertZero(itemPO.getPurchaseCount()));
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(8);
                shipCell.setCellValue(ordShipItemPO.getUnitName());
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(9);
                shipCell.setCellValue(this.convertZero(ordShipItemPO.getSendCount()));
                shipCell.setCellStyle(dataStyle);
                UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 10, 11);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(10);
                shipCell.setCellValue(estimatedArrivalTime);
                shipCell.setCellStyle(dataStyle);
                BigDecimal price = BigDecimal.ZERO;
                price = reqBO.getType() == 1L ? itemPO.getSaleDecimalPrice().multiply(ordShipItemPO.getSendCount()) : itemPO.getPurchaseDecimalPrice().multiply(ordShipItemPO.getSendCount());
                UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 12, 13);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(12);
                shipCell.setCellValue("\uffe5" + MoneyUtil.b2b((BigDecimal)price) + "");
                shipCell.setCellStyle(dataStyle);
                shipRow = sheet.getRow(rowIndex);
                shipCell = shipRow.getCell(14);
                shipCell.setCellValue("");
                shipCell.setCellStyle(dataStyle);
                ++rowIndex;
                ++index;
                sumPrice = sumPrice.add(price);
            }
            UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 0, 14);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(0);
            shipCell.setCellValue("\u603b\u8ba1\uff1a\uffe5" + MoneyUtil.b2b((BigDecimal)sumPrice));
            shipCell.setCellStyle(dataStyleRight);
            UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, ++rowIndex, rowIndex, 1, 4);
            UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 6, 9);
            UocWmsOrderShipExpAbilityServiceImpl.merge(sheet, rowIndex, rowIndex, 11, 14);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(0);
            shipCell.setCellValue("\u7b7e\u6536\u4eba\uff1a");
            shipCell.setCellStyle(contentColorStyle);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(1);
            shipCell.setCellValue(ordShipPO.getReceiverUser());
            shipCell.setCellStyle(contentStyle);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(5);
            shipCell.setCellValue("\u7b7e\u6536\u65f6\u95f4\uff1a");
            shipCell.setCellStyle(contentColorStyle);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(6);
            if (ordShipPO.getReceiverTime() != null) {
                receiverTime = DateUtils.formatDate((Date)ordShipPO.getReceiverTime(), (String)"yyyy/MM/dd");
            }
            shipCell.setCellValue(receiverTime);
            shipCell.setCellStyle(contentStyle);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(10);
            shipCell.setCellValue("\u5907\u6ce8\uff1a");
            shipCell.setCellStyle(contentColorStyle);
            shipRow = sheet.getRow(rowIndex);
            shipCell = shipRow.getCell(11);
            shipCell.setCellValue("");
            shipCell.setCellStyle(contentStyle);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e3) {
            log.error("\u751f\u6210\u8868\u683c\u5f02\u5e38", (Throwable)e3);
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e4) {
                log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e4);
            }
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            url = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            url = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        UocWmsrderShipExpRspBO rspBO = new UocWmsrderShipExpRspBO();
        rspBO.setUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static void merge(HSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cra);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
    }

    private static HSSFCellStyle getStyleInCommon(HSSFWorkbook workbook, short fontHeightInPoints, String fontName, boolean wrapText) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setWrapText(wrapText);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBorderLeft(BorderStyle.THIN);
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleStyle.setFont(titleFont);
        return titleStyle;
    }

    private static HSSFCellStyle getStyleInCommonContent(HSSFWorkbook workbook, short fontHeightInPoints, String fontName, boolean wrapText) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setAlignment(HorizontalAlignment.LEFT);
        titleStyle.setWrapText(wrapText);
        HSSFFont titleFont = workbook.createFont();
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBorderLeft(BorderStyle.THIN);
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        titleStyle.setFont(titleFont);
        return titleStyle;
    }

    private static HSSFCellStyle getDataStyle(HSSFWorkbook workbook, boolean wrapText, String flag) {
        HSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        dataSetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataSetStyle.setWrapText(wrapText);
        dataSetStyle.setBorderBottom(BorderStyle.THIN);
        dataSetStyle.setBorderLeft(BorderStyle.THIN);
        dataSetStyle.setBorderRight(BorderStyle.THIN);
        dataSetStyle.setBorderTop(BorderStyle.THIN);
        if ("right".equals(flag)) {
            dataSetStyle.setAlignment(HorizontalAlignment.RIGHT);
        } else {
            dataSetStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        dataSetStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setFontHeightInPoints((short)12);
        dataSetFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        dataSetFont.setFontName("\u5b8b\u4f53");
        dataSetStyle.setFont(dataSetFont);
        return dataSetStyle;
    }

    private void checkInput(UocWmsOrderShipExpReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getShipVoucherId() == null) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    String convertZero(BigDecimal count) {
        if (count == null) {
            return BigDecimal.ZERO.toPlainString();
        }
        return count.stripTrailingZeros().toPlainString();
    }
}

