/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.atom.api.PebSyncESGAtomService;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebSyncESGAtomServiceImpl
implements PebSyncESGAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebSyncESGAtomServiceImpl.class);
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_UPDATE_ORDER_TOPIC:UOC_UPDATE_ORDER_TOPIC}")
    private String updateTopic;
    @Value(value="${UOC_UPDATE_ORDER_TAG:*}")
    private String updateTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Resource
    private OrdItemMapper ordItemMapper;

    @Override
    public void syncESG(Long orderId, Boolean partFlag) {
        try {
            if (!this.uocESGConfig.getAbutmentESGYn().booleanValue() || Objects.isNull(orderId)) {
                return;
            }
            UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
            uocOrdZmInfoPO.setOrderId(orderId);
            uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
            if (partFlag.booleanValue()) {
                OrdItemPO ordItemPO = new OrdItemPO();
                ordItemPO.setOrderId(orderId);
                List itemPOList = this.ordItemMapper.getList(ordItemPO);
                if (CollectionUtils.isEmpty((Collection)itemPOList)) {
                    return;
                }
                BigDecimal totalPurchaseCount = itemPOList.stream().map(OrdItemPO::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalRefuseCount = itemPOList.stream().map(OrdItemPO::getRefuseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalReturnCount = itemPOList.stream().map(OrdItemPO::getReturnCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalPurchaseCount.subtract(totalRefuseCount).subtract(totalReturnCount).compareTo(BigDecimal.ZERO) > 0) {
                    log.error("\u8ba2\u5355\u7f16\u53f7\uff1a{} \u672a\u5168\u90e8\u9000\u8d27\u6216\u62d2\u6536\uff0c\u4e0d\u63a8\u9001\u5e2e\u6276\u5e73\u53f0\uff01", (Object)orderId);
                    return;
                }
            }
            if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                UocESGOrderSyncUpdateConsumerVO updateConsumerVO = new UocESGOrderSyncUpdateConsumerVO();
                updateConsumerVO.setOrderId(orderId);
                updateConsumerVO.setOrderStatus(Integer.valueOf(4));
                this.uocESGSyncMsgProvider.send(new ProxyMessage(this.updateTopic, this.updateTag, JSONObject.toJSONString((Object)updateConsumerVO)));
            }
        }
        catch (Exception exception) {
            log.error("\u552e\u540e\u5b8c\u6210\u540e\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
        }
    }
}

