/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.UocCoreArriveRegistAtomService;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.bo.ArriveInfoBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdShipItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreArriveRegistAtomService")
public class UocCoreArriveRegistAtomServiceImpl
implements UocCoreArriveRegistAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreArriveRegistAtomServiceImpl.class);
    private static final Integer CHECK_FLAG = 1;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public UocCoreArriveRegistRspBO dealCoreArriveRegist(UocCoreArriveRegistReqBO atomReqBO) {
        UocCoreArriveRegistRspBO rsp = new UocCoreArriveRegistRspBO();
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u5b8c\u5de5\u539f\u5b50\u670d\u52a1-\u5165\u53c2\uff1a" + atomReqBO.toString());
        this.validateParam(atomReqBO);
        try {
            if (!CHECK_FLAG.equals(atomReqBO.getCheckFlag())) {
                this.validateCounts(atomReqBO.getShipVoucherId(), atomReqBO.getOrderId());
            }
            if (!PebExtConstant.YES.equals(atomReqBO.getNotUpdateCount())) {
                for (ArriveInfoBO bo : atomReqBO.getArriveInfoList()) {
                    int isUpdate3;
                    int isUpdate2;
                    int isUpdate;
                    OrdShipItemPO updateShipItemPo = new OrdShipItemPO();
                    updateShipItemPo.setShipItemId(bo.getShipItemId());
                    updateShipItemPo.setShipVoucherId(atomReqBO.getShipVoucherId());
                    updateShipItemPo.setOrderId(atomReqBO.getOrderId());
                    if (bo.getArriveCount() != null) {
                        updateShipItemPo.setArriveCount(bo.getArriveCount());
                    }
                    if (atomReqBO.getIsAbnormal() != null && atomReqBO.getIsAbnormal().booleanValue()) {
                        if (bo.getRejectCount() != null) {
                            updateShipItemPo.setReturnCount(bo.getRejectCount());
                        }
                    } else if (bo.getRejectCount() != null) {
                        updateShipItemPo.setRefuseCount(bo.getRejectCount());
                    }
                    if ((isUpdate = this.ordShipItemMapper.updateCounts(updateShipItemPo)) < 1) {
                        rsp.setRespCode("101010");
                        rsp.setRespDesc("\u53d1\u8d27\u660e\u7ec6\u8868\u5230\u8d27\u6570\u91cf\u548c\u62d2\u6536\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                        return rsp;
                    }
                    OrdShipItemPO queryOrdShipItemPo = new OrdShipItemPO();
                    queryOrdShipItemPo.setShipItemId(bo.getShipItemId());
                    queryOrdShipItemPo.setOrderId(atomReqBO.getOrderId());
                    OrdShipItemPO ordShipItemRspPo = this.ordShipItemMapper.getModelBy(queryOrdShipItemPo);
                    OrdItemPO updateOrdItemPo = new OrdItemPO();
                    updateOrdItemPo.setOrdItemId(ordShipItemRspPo.getOrdItemId());
                    updateOrdItemPo.setOrderId(atomReqBO.getOrderId());
                    if (bo.getArriveCount() != null) {
                        updateOrdItemPo.setArriveCount(bo.getArriveCount());
                    }
                    if (atomReqBO.getIsAbnormal() != null && atomReqBO.getIsAbnormal().booleanValue()) {
                        if (bo.getRejectCount() != null) {
                            updateOrdItemPo.setReturnCount(bo.getRejectCount());
                        }
                    } else if (bo.getRejectCount() != null) {
                        updateOrdItemPo.setRefuseCount(bo.getRejectCount());
                    }
                    if ((isUpdate2 = this.ordItemMapper.updateCounts(updateOrdItemPo)) < 1) {
                        rsp.setRespCode("101010");
                        rsp.setRespDesc("\u9500\u552e\u660e\u7ec6\u8868\u5230\u8d27\u6570\u91cf\u548c\u62d2\u6536\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                        return rsp;
                    }
                    OrdPurchaseItemPO updateOrdPurchaseItemPo = new OrdPurchaseItemPO();
                    updateOrdPurchaseItemPo.setOrderItemId(ordShipItemRspPo.getOrdItemId());
                    updateOrdPurchaseItemPo.setOrderId(atomReqBO.getOrderId());
                    if (bo.getArriveCount() != null) {
                        updateOrdPurchaseItemPo.setArriveCount(bo.getArriveCount());
                    }
                    if (bo.getRejectCount() != null) {
                        updateOrdPurchaseItemPo.setRefuseCount(bo.getRejectCount());
                    }
                    if ((isUpdate3 = this.ordPurchaseItemMapper.updateCounts(updateOrdPurchaseItemPo)) >= 1) continue;
                    rsp.setRespCode("101010");
                    rsp.setRespDesc("\u91c7\u8d2d\u5355\u660e\u7ec6\u8868\u5230\u8d27\u6570\u91cf\u548c\u62d2\u6536\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                    return rsp;
                }
            }
            if (atomReqBO.getShipStatus() != null) {
                UocCoreChgVoucherStateReqBO uocCoreChgVoucherStateReqBO = new UocCoreChgVoucherStateReqBO();
                ArrayList<VoucherStateBO> voucherStateList = new ArrayList<VoucherStateBO>();
                VoucherStateBO voucherState = new VoucherStateBO();
                voucherState.setObjId(atomReqBO.getShipVoucherId());
                voucherState.setObjType(UocConstant.OBJ_TYPE.SHIP);
                voucherState.setAfterState(atomReqBO.getShipStatus());
                voucherStateList.add(voucherState);
                uocCoreChgVoucherStateReqBO.setVoucherStateList(voucherStateList);
                uocCoreChgVoucherStateReqBO.setOrderId(atomReqBO.getOrderId());
                uocCoreChgVoucherStateReqBO.setOperId(atomReqBO.getCreateOperId());
                uocCoreChgVoucherStateReqBO.setDealDesc("\u5230\u8d27\u767b\u8bb0\u66f4\u65b0\u53d1\u8d27\u5355\u72b6\u6001");
                UocCoreChgVoucherStateRspBO uocCoreChgVoucherStateRspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(uocCoreChgVoucherStateReqBO);
                if (!"0000".equals(uocCoreChgVoucherStateRspBO.getRespCode())) {
                    rsp.setRespCode("101010");
                    rsp.setRespDesc("\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + uocCoreChgVoucherStateRspBO.getRespDesc());
                    return rsp;
                }
            }
            OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setObjId(atomReqBO.getShipVoucherId());
            ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            ordExtMapPO.setOrderId(atomReqBO.getOrderId());
            ordExtMapPO.setFieldCode("createOperId");
            ordExtMapPO.setFieldName("\u5230\u8d27\u767b\u8bb0\u4eba ");
            ordExtMapPO.setFieldValue(atomReqBO.getCreateOperId());
            ordExtMapPO.setId(Long.valueOf(this.sequence.nextId()));
            int isInsert = this.ordExtMapMapper.insert(ordExtMapPO);
            if (isInsert < 1) {
                rsp.setRespCode("101010");
                rsp.setRespDesc("\u8ba2\u5355\u5355\u636e\u62d3\u5c55\u5c5e\u6027\u8868\u63d2\u5165\u5931\u8d25\uff01");
                return rsp;
            }
            OrdExtMapPO ordExtMapPO2 = new OrdExtMapPO();
            ordExtMapPO2.setObjId(atomReqBO.getShipVoucherId());
            ordExtMapPO2.setObjType(UocConstant.OBJ_TYPE.SHIP);
            ordExtMapPO2.setOrderId(atomReqBO.getOrderId());
            ordExtMapPO2.setFieldCode("arriveRemark");
            ordExtMapPO2.setFieldName("\u5230\u8d27\u5907\u6ce8 ");
            ordExtMapPO2.setFieldValue(atomReqBO.getArriveRemark());
            ordExtMapPO2.setId(Long.valueOf(this.sequence.nextId()));
            int isInsert2 = this.ordExtMapMapper.insert(ordExtMapPO2);
            if (isInsert2 < 1) {
                rsp.setRespCode("101010");
                rsp.setRespDesc("\u8ba2\u5355\u5355\u636e\u62d3\u5c55\u5c5e\u6027\u8868\u63d2\u5165\u5931\u8d25\uff01");
                return rsp;
            }
            OrdExtMapPO ordExtMapPO3 = new OrdExtMapPO();
            ordExtMapPO3.setObjId(atomReqBO.getShipVoucherId());
            ordExtMapPO3.setObjType(UocConstant.OBJ_TYPE.SHIP);
            ordExtMapPO3.setOrderId(atomReqBO.getOrderId());
            ordExtMapPO3.setFieldCode("checkFlag");
            ordExtMapPO3.setFieldName("\u6570\u91cf\u6821\u9a8c\u6807\u8bc6 ");
            ordExtMapPO3.setId(Long.valueOf(this.sequence.nextId()));
            ordExtMapPO3.setFieldValue(atomReqBO.getArriveRemark());
            int isInsert3 = this.ordExtMapMapper.insert(ordExtMapPO3);
            if (isInsert3 < 1) {
                rsp.setRespCode("101010");
                rsp.setRespDesc("\u8ba2\u5355\u5355\u636e\u62d3\u5c55\u5c5e\u6027\u8868\u63d2\u5165\u5931\u8d25\uff01");
                return rsp;
            }
            if (atomReqBO.getFlag() != null && 1 == atomReqBO.getFlag()) {
                if (this.addOrdExtMapField(atomReqBO, rsp, "consignee", "\u63d0\u8d27\u4eba", atomReqBO.getConsignee())) {
                    return rsp;
                }
                if (this.addOrdExtMapField(atomReqBO, rsp, "consigneePhone", "\u63d0\u8d27\u4eba\u7535\u8bdd", atomReqBO.getConsigneePhone())) {
                    return rsp;
                }
                if (this.addOrdExtMapField(atomReqBO, rsp, "consigneeTime", "\u63d0\u8d27\u65e5\u671f", atomReqBO.getConsigneeTime())) {
                    return rsp;
                }
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rsp.setRespCode("101010");
            rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff01");
            return rsp;
        }
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setShipVoucherId(atomReqBO.getShipVoucherId());
        ordShipItemPO.setOrderId(atomReqBO.getOrderId());
        List list = this.ordShipItemMapper.getList(ordShipItemPO);
        for (OrdShipItemPO itemPO : list) {
            if (itemPO.getArriveCount().compareTo(itemPO.getSendCount()) <= 0) continue;
            throw new UocProBusinessException("8888", "\u5df2\u7ecf\u5b8c\u6210\u5230\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u5230\u8d27");
        }
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u5b8c\u5de5\u539f\u5b50\u670d\u52a1-\u51fa\u53c2\uff1a" + rsp.toString());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private boolean addOrdExtMapField(UocCoreArriveRegistReqBO atomReqBO, UocCoreArriveRegistRspBO rsp, String fieldCode2, String fieldName, String fieldValue) {
        OrdExtMapPO ordExtMap = new OrdExtMapPO();
        ordExtMap.setObjId(atomReqBO.getShipVoucherId());
        ordExtMap.setObjType(UocConstant.OBJ_TYPE.SHIP);
        ordExtMap.setOrderId(atomReqBO.getOrderId());
        ordExtMap.setFieldCode(fieldCode2);
        ordExtMap.setFieldName(fieldName);
        ordExtMap.setFieldValue(fieldValue);
        ordExtMap.setId(Long.valueOf(this.sequence.nextId()));
        int isInsert = this.ordExtMapMapper.insert(ordExtMap);
        if (isInsert < 1) {
            rsp.setRespCode("101010");
            rsp.setRespDesc("\u8ba2\u5355\u5355\u636e\u62d3\u5c55\u5c5e\u6027\u8868\u63d2\u5165\u5931\u8d25\uff01");
            return true;
        }
        return false;
    }

    private void validateCounts(Long shipOrderId, Long orderId) {
        try {
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipVoucherId(shipOrderId);
            ordShipItemPO.setOrderId(orderId);
            List ordShipItemList = this.ordShipItemMapper.getList(ordShipItemPO);
            if (null == ordShipItemList || ordShipItemList.size() <= 0) {
                throw new UocProBusinessException("101010", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1->\u6570\u91cf\u6821\u9a8c->\u53d1\u8d27\u5355\u91cc\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            for (OrdShipItemPO po : ordShipItemList) {
                BigDecimal totalCount = new BigDecimal(0);
                if ((totalCount = totalCount.add(po.getArriveCount()).add(po.getRefuseCount())).compareTo(po.getSendCount()) <= 0) continue;
                throw new UocProBusinessException("101010", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u660e\u7ec6\u3010\u5230\u8d27\u6570\u91cf+\u62d2\u6536\u6570\u91cf>\u53d1\u8d27\u6570\u91cf\u3011\uff01");
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("101010", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u6570\u91cf\u6821\u9a8c\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void validateParam(UocCoreArriveRegistReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getShipVoucherId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ShipOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)atomReqBO.getCreateOperId())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010CreateOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getArriveInfoList() == null || atomReqBO.getArriveInfoList().size() <= 0) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ArriveInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ArriveInfoBO BO : atomReqBO.getArriveInfoList()) {
            if (BO.getShipItemId() != null) continue;
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ArriveInfoList.ShipItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

