/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uoc.common.atom.api.UocInterFaceSignManagerQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocInterFaceSignManagerQueryAtomBo;
import com.tydic.uoc.common.atom.bo.UocInterFaceSignManagerQueryAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocInterFaceSignManagerQueryAtomRspBo;
import com.tydic.uoc.common.utils.HttpUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UocInterFaceSignManagerQueryAtomServiceImpl
implements UocInterFaceSignManagerQueryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocInterFaceSignManagerQueryAtomServiceImpl.class);
    @Value(value="${CONTRACT_SIGN_MANAGER_QUERY_URL}")
    private String contractSignManagerQueryUrl;

    @Override
    public UocInterFaceSignManagerQueryAtomRspBo signManagerQuery(UocInterFaceSignManagerQueryAtomReqBo reqBo) {
        UocInterFaceSignManagerQueryAtomRspBo rspBO = new UocInterFaceSignManagerQueryAtomRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String reqStr = JSONObject.toJSONString((Object)reqBo);
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("ESB-Authorization", reqBo.getAccessToken());
            String rspStr = HttpUtil.post(this.contractSignManagerQueryUrl, reqStr, headerMap);
            log.info("\u7535\u5b50\u7b7e\u7ae0\u67e5\u8be2\u516c\u53f8\u662f\u5426\u6ce8\u518c\u63a5\u53e3\u51fa\u53c2" + rspStr);
            rspBO = this.resolveRsp(rspStr);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u67e5\u8be2\u516c\u53f8\u662f\u5426\u6ce8\u518c\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private UocInterFaceSignManagerQueryAtomRspBo resolveRsp(String rspStr) {
        JSONObject jsonObject;
        UocInterFaceSignManagerQueryAtomRspBo rspBO = new UocInterFaceSignManagerQueryAtomRspBo();
        try {
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new ZTBusinessException("\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a");
            }
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u67e5\u8be2\u516c\u53f8\u662f\u5426\u6ce8\u518c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"code") == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u67e5\u8be2\u516c\u53f8\u662f\u5426\u6ce8\u518c\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            if (StringUtils.isEmpty((Object)jsonObject.getString("message")) || "null".equals(jsonObject.getString("message"))) {
                String resultMessage;
                int i;
                jsonObject.getString("resultMessage");
                if (!StringUtils.isEmpty((Object)jsonObject.getString("resultMessage")) && (i = (resultMessage = jsonObject.getString("resultMessage")).indexOf("{")) != -1) {
                    JSONObject jsonObject1 = JSONObject.parseObject((String)resultMessage.substring(i));
                    rspBO.setRespDesc(jsonObject1.getString("message"));
                }
            }
            return rspBO;
        }
        if ("200".equals(jsonObject.getString("code"))) {
            String content = jsonObject.getString("content");
            UocInterFaceSignManagerQueryAtomBo queryAtomBO = (UocInterFaceSignManagerQueryAtomBo)JSONObject.parseObject((String)content, UocInterFaceSignManagerQueryAtomBo.class);
            rspBO.setContent(queryAtomBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException(jsonObject.getString("message"));
    }
}

