/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebBigOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebBigOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebBigOrderBusiService;
import com.tydic.uoc.dao.UocBigConfigMapper;
import com.tydic.uoc.dao.UocBigOrderMapper;
import com.tydic.uoc.po.UocBigConfigPO;
import com.tydic.uoc.po.UocBigOrderPO;
import com.tydic.uoc.po.UocOrdPayConfPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebBigOrderBusiServiceImpl
implements PebBigOrderBusiService {
    @Autowired
    private UocBigConfigMapper uocBigConfigMapper;
    @Autowired
    private UocBigOrderMapper uocBigOrderMapper;
    @Value(value="${uoc.big.max:2000}")
    private Integer maxSize;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebBigOrderRspBO dealCreateBigOrder(PebBigOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderInfo())) {
            throw new UocProBusinessException("8888", "\u5fc5\u987b\u9009\u62e9\u8ba2\u5355");
        }
        List orderIds = reqBO.getOrderInfo().stream().map(UocPebDealOrderBO::getOrderId).collect(Collectors.toList());
        UocBigConfigPO configPO = new UocBigConfigPO();
        configPO.setOrderIds(orderIds);
        int count = this.uocBigConfigMapper.getItemCount(configPO);
        if (count > this.maxSize) {
            throw new UocProBusinessException("8888", "\u60a8\u52fe\u9009\u7684\u8ba2\u5355\u660e\u7ec6\u884c\u6570\u5df2\u8d85\u51fa" + this.maxSize + "\u884c\uff0c\u8bf7\u79fb\u9664\u90e8\u5206\u8ba2\u5355\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        List salePOS = this.uocBigConfigMapper.getSaleInfo(configPO);
        List zmInfoPOS = this.uocBigConfigMapper.getZmInfo(configPO);
        List uocBigConfigPOS = this.uocBigConfigMapper.selectByCondition(configPO);
        List payConfPOS = this.uocBigConfigMapper.getPay(configPO);
        Map<Long, UocOrdZmInfoPO> zmMap = zmInfoPOS.stream().collect(Collectors.toMap(UocOrdZmInfoPO::getOrderId, i -> i));
        Map<Long, UocBigConfigPO> configMap = uocBigConfigPOS.stream().collect(Collectors.toMap(UocBigConfigPO::getOrderId, i -> i));
        HashSet<String> buy = new HashSet<String>();
        HashSet<String> cb = new HashSet<String>();
        HashSet<Long> jc = new HashSet<Long>();
        for (Object salePO : salePOS) {
            if (UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(salePO.getSaleState()) && UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState()) && UocConstant.SALE_ORDER_STATUS.DS_TT.equals(salePO.getSaleState())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\uff1a" + salePO.getSaleVoucherNo() + "\u72b6\u6001\u4e0d\u80fd\u6253\u5305");
            }
            UocBigConfigPO bigConfigPO = configMap.get(salePO.getOrderId());
            if (PebExtConstant.YES.equals(bigConfigPO.getMergePushType())) {
                throw new UocProBusinessException("8888", "\u81ea\u52a8\u6253\u5305\u8ba2\u5355\uff1a" + salePO.getSaleVoucherNo() + "\u4e0d\u80fd\u6253\u5305");
            }
            if (null != bigConfigPO.getBigOrderId()) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\uff1a" + salePO.getSaleVoucherNo() + "\u5df2\u7ecf\u6253\u5305\uff0c\u4e0d\u80fd\u518d\u6b21\u6253\u5305");
            }
            UocOrdZmInfoPO zmInfoPO = zmMap.get(salePO.getOrderId());
            buy.add(zmInfoPO.getBuynerNo());
            cb.add(bigConfigPO.getExt1());
            jc.add(zmInfoPO.getVendorSiteId());
        }
        if (jc.size() > 1) {
            throw new UocProBusinessException("8888", "\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u5730\u5740\u7b80\u79f0\u4e0b\u7684\u8ba2\u5355");
        }
        if (cb.size() > 1) {
            throw new UocProBusinessException("8888", "\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u6210\u672c\u4e2d\u5fc3\u4e0b\u7684\u8ba2\u5355");
        }
        if (buy.size() > 1) {
            throw new UocProBusinessException("8888", "\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u4e70\u53d7\u4eba\u4e0b\u7684\u8ba2\u5355");
        }
        HashSet<Integer> types = new HashSet<Integer>();
        for (UocOrdPayConfPO payConfPO : payConfPOS) {
            if ("2".equals(payConfPO.getPayType().toString())) {
                types.add(2);
                continue;
            }
            types.add(3);
        }
        if (types.size() > 1) {
            throw new UocProBusinessException("8888", "\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u79cd\u652f\u4ed8\u65b9\u5f0f\u7684\u8ba2\u5355");
        }
        UocBigOrderPO uocBigOrderPO = new UocBigOrderPO();
        uocBigOrderPO.setId(Long.valueOf(this.idUtil.nextId()));
        uocBigOrderPO.setBuynerErpNo(((UocOrdZmInfoPO)zmInfoPOS.get(0)).getBuynerErpNo());
        uocBigOrderPO.setBuynerNo(((UocOrdZmInfoPO)zmInfoPOS.get(0)).getBuynerNo());
        uocBigOrderPO.setBuynerName(((UocOrdZmInfoPO)zmInfoPOS.get(0)).getBuynerName());
        uocBigOrderPO.setCreateName(reqBO.getName());
        uocBigOrderPO.setCreateUserId(reqBO.getUserId() + "");
        uocBigOrderPO.setCreateUserName(reqBO.getUsername());
        uocBigOrderPO.setCreateTime(new Date());
        uocBigOrderPO.setRemark(reqBO.getRemark());
        if (PebExtConstant.YES.equals(((UocBigConfigPO)uocBigConfigPOS.get(0)).getIsAutoStorage())) {
            uocBigOrderPO.setExt1(PebExtConstant.NO.toString());
            uocBigOrderPO.setExt2(PebExtConstant.NO.toString());
        }
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey("SALE_ORDER_NO");
        getBo.setBuynerNo(((UocOrdZmInfoPO)zmInfoPOS.get(0)).getBuynerNo());
        getBo.setOrderSource("99");
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102107", voucherNoRsp.getRespDesc());
        }
        uocBigOrderPO.setOrderNo(voucherNoRsp.getVoucherNo());
        uocBigOrderPO.setOrderCount(Integer.valueOf(salePOS.size()));
        uocBigOrderPO.setPushStatus(PebExtConstant.NO);
        this.uocBigOrderMapper.insert(uocBigOrderPO);
        PebBigOrderRspBO rspBO = new PebBigOrderRspBO();
        rspBO.setBigOrderId(uocBigOrderPO.getId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        for (UocBigConfigPO bigConfigPO : uocBigConfigPOS) {
            bigConfigPO.setBigOrderId(uocBigOrderPO.getId());
            bigConfigPO.setBigOrderNo(uocBigOrderPO.getOrderNo());
        }
        this.uocBigConfigMapper.updateBatch(uocBigConfigPOS);
        return rspBO;
    }
}

