/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipBo;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipReqBO;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebCancelConsignmentShipBusiService;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebCancelConsignmentShipBusiServiceImpl
implements PebCancelConsignmentShipBusiService {
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;

    @Override
    public PebCancelConsignmentShipRspBO dealCancelConsignmentShip(PebCancelConsignmentShipReqBO reqBO) {
        for (PebCancelConsignmentShipBo shipBo : reqBO.getShipBos()) {
            OrdShipPO qryShipPo = new OrdShipPO();
            qryShipPo.setOrderId(shipBo.getOrderId());
            qryShipPo.setSaleVoucherId(shipBo.getSaleVourcherId());
            qryShipPo.setShipVoucherId(shipBo.getShipVoucherId());
            OrdShipPO shipRspBo = this.ordShipMapper.getModelBy(qryShipPo);
            if (shipRspBo == null) {
                throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u4fe1\u606f\uff1a" + shipBo.getShipVoucherId());
            }
            if (!"2202".equals(shipRspBo.getShipStatus())) {
                throw new UocProBusinessException("100001", "\u8be5\u53d1\u8d27\u5355(" + shipRspBo.getShipVoucherCode() + ")\u4e0d\u80fd\u53d6\u6d88\u4e86\uff01");
            }
            OrdSalePO qrySalePo = new OrdSalePO();
            qrySalePo.setOrderId(shipBo.getOrderId());
            OrdSalePO salePO = this.ordSaleMapper.getModelBy(qrySalePo);
            if (salePO == null) {
                throw new UocProBusinessException("100001", "\u8be5\u53d1\u8d27\u5355(" + shipRspBo.getShipVoucherCode() + ")\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\u672a\u67e5\u8be2\u5230");
            }
            if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(salePO.getSaleState())) {
                throw new UocProBusinessException("100001", "\u8be5\u53d1\u8d27\u5355(" + shipRspBo.getShipVoucherCode() + ")\u5bf9\u5e94\u7684\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u53d1\u8d27\u4e2d\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            OrdShipItemPO shipItemPo = new OrdShipItemPO();
            shipItemPo.setShipVoucherId(shipRspBo.getShipVoucherId());
            shipItemPo.setOrderId(shipRspBo.getOrderId());
            List shipItemPoS = this.ordShipItemMapper.getList(shipItemPo);
            if (CollectionUtils.isEmpty((Collection)shipItemPoS)) {
                throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\uff1a" + shipRspBo.getShipVoucherCode());
            }
            for (OrdShipItemPO ordShipItemPo : shipItemPoS) {
                OrdItemPO updateItemPo = new OrdItemPO();
                updateItemPo.setOrderId(ordShipItemPo.getOrderId());
                updateItemPo.setOrdItemId(ordShipItemPo.getOrdItemId());
                updateItemPo.setSendCount(ordShipItemPo.getSendCount().negate());
                int i = this.ordItemMapper.updateCounts(updateItemPo);
                if (i == 1) continue;
                throw new UocProBusinessException("100001", "\u4fee\u6539\u660e\u7ec6\u5931\u8d25");
            }
            OrdShipPO updateOrdShipPo = new OrdShipPO();
            updateOrdShipPo.setShipVoucherId(shipRspBo.getShipVoucherId());
            updateOrdShipPo.setCancelRemark(reqBO.getCancelRemark());
            updateOrdShipPo.setOrderId(shipRspBo.getOrderId());
            int i = this.ordShipMapper.updateById(updateOrdShipPo);
            if (i != 1) {
                throw new UocProBusinessException("100001", "\u4fdd\u5b58\u53d6\u6d88\u539f\u56e0\u5931\u8d25");
            }
            this.run(reqBO, UocConstant.OBJ_TYPE.SHIP, shipRspBo, shipRspBo.getShipVoucherId());
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, shipRspBo, shipRspBo.getSaleVoucherId());
        }
        PebCancelConsignmentShipRspBO rspBO = new PebCancelConsignmentShipRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void run(PebCancelConsignmentShipReqBO reqBO, Integer objType, OrdShipPO shipRspBo, Long objId) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(shipRspBo.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (objType.equals(UocConstant.OBJ_TYPE.SHIP)) {
            map.put("isCancel", true);
        } else {
            map.put("dj", 3);
        }
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102095", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

