/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseAfsOrderAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseAfsOrderReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseAfsOrderRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseAfsOrderBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseAfsOrderBusiRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushWarehouseAfsOrderBusiServiceImpl
implements PebExtPushWarehouseAfsOrderBusiService {
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private PebExtPushWarehouseAfsOrderAtomService pebExtPushWarehouseAfsOrderAtomService;

    @Override
    public PebExtPushWarehouseAfsOrderBusiRspBO dealPushWarehouseAfsOrder(PebExtPushWarehouseAfsOrderBusiReqBO reqBO) {
        UocOrdWarehouseLogPO warehouseLogPO = new UocOrdWarehouseLogPO();
        warehouseLogPO.setCreateTime(new Date());
        warehouseLogPO.setId(Long.valueOf(this.sequence.nextId()));
        warehouseLogPO.setType(UocConstant.WarehousePushType.AFTER_ORDER);
        warehouseLogPO.setOrderId(reqBO.getOrderId());
        warehouseLogPO.setShipVoucherId(reqBO.getAfterServId());
        warehouseLogPO.setReqData(JSONObject.toJSONString((Object)reqBO.getWarehouseAfsOrderBO()));
        PebExtPushWarehouseAfsOrderReqBO afsOrderReqBO = new PebExtPushWarehouseAfsOrderReqBO();
        afsOrderReqBO.setSupplierId(reqBO.getSupplierId());
        afsOrderReqBO.setWarehouseAfsOrderBO(reqBO.getWarehouseAfsOrderBO());
        PebExtPushWarehouseAfsOrderRspBO afsOrderRspBO = this.pebExtPushWarehouseAfsOrderAtomService.dealPushWarehouseAfsOrder(afsOrderReqBO);
        warehouseLogPO.setRespData(afsOrderRspBO.getRespData());
        if (StringUtils.isEmpty((CharSequence)afsOrderRspBO.getRespData())) {
            warehouseLogPO.setRespData(afsOrderRspBO.getMessage());
        }
        OrdAfterServicePO afterServicePO = new OrdAfterServicePO();
        afterServicePO.setAfterServId(reqBO.getAfterServId());
        afterServicePO.setOrderId(reqBO.getOrderId());
        PebExtPushWarehouseAfsOrderBusiRspBO rspBO = new PebExtPushWarehouseAfsOrderBusiRspBO();
        if (afsOrderRspBO.getCode().equals("0")) {
            afterServicePO.setWarehouseServState(UocConstant.WarehouseServState.WAREHOUSE_TO_DELIVERY);
            warehouseLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            afterServicePO.setWarehouseServState(UocConstant.WarehouseServState.PUSH_FAIL);
            warehouseLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(afsOrderRspBO.getMessage());
        }
        this.uocOrdWarehouseLogMapper.insert(warehouseLogPO);
        this.ordAfterServiceMapper.updateById(afterServicePO);
        return rspBO;
    }
}

