/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractOrderedAmountSynAbilityService;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityReqBO;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoInstanceAuditInfo;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalRspBO;
import com.tydic.uoc.common.ability.bo.PebTodoPushWaitBO;
import com.tydic.uoc.common.ability.bo.UocNoTaskAuditOrderAuditNoticeBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.ability.enums.TodoWaitTypeEnum;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateConfigRemindAtomService;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateConfigRemindAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebOrderApprovalBusiService;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancellationBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationReqBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationRspBO;
import com.tydic.uoc.common.busi.impl.PebOrderToRemindBusiServiceImpl;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.dao.PecOrdSaleMapper;
import com.tydic.uoc.dao.UocOrdHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PayConfDetailPO;
import com.tydic.uoc.po.UocOrdHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="pebOrderApprovalBusiService")
public class PebOrderApprovalBusiServiceImpl
implements PebOrderApprovalBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebOrderToRemindBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private PecOrdSaleMapper pecOrdSaleMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private UocCoreStateConfigRemindAtomService uocCoreStateConfigRemindAtomService;
    @Autowired
    private UocPebOrderCancellationBusiService uocPebOrderCancellationBusiService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdHistoryMapper uocOrdHistoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private ContractOrderedAmountSynAbilityService contractOrderedAmountSynAbilityService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @Override
    public PebOrderApprovalRspBO dealPebOrderApproval(PebOrderApprovalReqBO reqBO) {
        PebOrderApprovalRspBO rspBO = new PebOrderApprovalRspBO();
        List orderApprovalList = reqBO.getOrderApprovalList();
        for (PebDealOrderBO pebDealOrderBO : orderApprovalList) {
            UocCoreStateCheckAtomRspBO uocCoreStateCheckAtomRspBO;
            UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
            uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
            uocCoreStateCheckAtomReqBO.setOrderId(pebDealOrderBO.getOrderId());
            uocCoreStateCheckAtomReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
            uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u5165\u53c2:" + uocCoreStateCheckAtomReqBO.toString());
            }
            if (!(uocCoreStateCheckAtomRspBO = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO)).getRespCode().equals("0000")) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355id:" + pebDealOrderBO.getOrderId() + "\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            pebDealOrderBO.setOrderSource(ordSalePO.getOrderSource());
            pebDealOrderBO.setSaleFee(ordSalePO.getSaleFee());
            if (!StringUtils.isBlank((CharSequence)pebDealOrderBO.getStepId())) continue;
            pebDealOrderBO.setStepId(ordSalePO.getTbOrderId());
        }
        this.audit(reqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void audit(PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO) {
        Integer objType = null;
        List orderApprovalList = reqBO.getOrderApprovalList();
        if (reqBO.getActionCode().equals("ACTPEB007")) {
            objType = UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007;
        }
        if (reqBO.getActionCode().equals("ACTPEB008")) {
            objType = UocConstant.APPROVAL_OBJ_TYPE.ACTPEB008;
        }
        Map<String, List<PebDealOrderBO>> map = orderApprovalList.stream().collect(Collectors.groupingBy(PebDealOrderBO::getStepId));
        for (String key : map.keySet()) {
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(key);
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
            uacNoTaskAuditOrderAuditReqBO.setOperId(reqBO.getOperId());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOrgName());
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getOperName());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOperDept());
            uacNoTaskAuditOrderAuditReqBO.setObjType(objType);
            uacNoTaskAuditOrderAuditReqBO.setLoginName(reqBO.getLoginName());
            uacNoTaskAuditOrderAuditReqBO.setOrgCode(reqBO.getOrgCodeIn());
            ArrayList<Long> objIds = new ArrayList<Long>();
            for (PebDealOrderBO id : map.get(key)) {
                objIds.add(id.getSaleVoucherId());
            }
            HashMap<Long, String> stationMap = new HashMap<Long, String>();
            try {
                Integer type = objType;
                objIds.forEach(x -> stationMap.put((Long)x, this.uocTodoCombService.getNextStationId((Long)x, type)));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u5f53\u524d\u5ba1\u6279\u4eba\u5c97\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            }
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            HashMap<String, Object> ows = new HashMap<String, Object>();
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(map.get(key).get(0).getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (zmInfoPO != null) {
                ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoPO.getMaterialCategory()));
                try {
                    ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)map.get(key).get(0).getSaleFee()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(ows, map.get(key).get(0).getOrderId());
            uacNoTaskAuditOrderAuditReqBO.setVariables(ows);
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException("102044", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditOrderAuditRspBO.getAuditNoticeList())) {
                List auditNoticeList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO.getAuditNoticeList()), UocNoTaskAuditOrderAuditNoticeBO.class);
                if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
                    rspBO.getAuditNoticeList().addAll(auditNoticeList);
                } else {
                    rspBO.setAuditNoticeList(auditNoticeList);
                }
            }
            this.dealSuccess(map.get(key), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish(), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), reqBO, rspBO, stationMap, uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO());
        }
    }

    private void dealSuccess(List<PebDealOrderBO> list, boolean finish, String stepId, PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO, Map<Long, String> stationMap, UacNoneInstanceBO noneInstanceBO) {
        ArrayList<PebDealOrderBO> result = new ArrayList<PebDealOrderBO>();
        ArrayList<PebDealOrderBO> approvalList = new ArrayList<PebDealOrderBO>();
        for (PebDealOrderBO pebDealOrderBO : list) {
            if (finish) {
                if (!reqBO.getActionCode().equals("ACTPEB008")) {
                    this.reasonForBackFillCancellation(pebDealOrderBO, reqBO);
                }
                if (!UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult()) || reqBO.getActionCode().equals("ACTPEB008")) {
                    boolean auto = this.run(pebDealOrderBO, reqBO.getAuditResult(), reqBO);
                    pebDealOrderBO.setAuto(Boolean.valueOf(auto));
                    if (reqBO.getActionCode().equals("ACTPEB007")) {
                        OrdSalePO ordSalePO = this.ordSaleMapper.getModelById(pebDealOrderBO.getSaleVoucherId().longValue());
                        if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(ordSalePO.getOrderSource())) {
                            ArrayList<OrdItemPO> updateItemList = new ArrayList<OrdItemPO>();
                            if (ordSalePO.getOrderId() != null) {
                                OrdItemPO ordItemPO = new OrdItemPO();
                                ordItemPO.setOrderId(ordSalePO.getOrderId());
                                List orderItemPOs = this.ordItemMapper.getList(ordItemPO);
                                Date date = new Date();
                                if (!CollectionUtils.isEmpty((Collection)orderItemPOs)) {
                                    for (OrdItemPO orderItemPO : orderItemPOs) {
                                        if (!StringUtils.isNumeric((CharSequence)orderItemPO.getArrivalTime())) continue;
                                        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                                        String arrivalTime = sf.format(new Date(date.getTime() + (long)(Integer.parseInt(orderItemPO.getArrivalTime()) * 24 * 60 * 60 * 1000)));
                                        OrdItemPO updateItem = new OrdItemPO();
                                        updateItem.setOrderId(orderItemPO.getOrderId());
                                        updateItem.setOrdItemId(orderItemPO.getOrdItemId());
                                        updateItem.setArrivalTime(arrivalTime);
                                        updateItemList.add(updateItem);
                                    }
                                }
                            }
                            if (!CollectionUtils.isEmpty(updateItemList)) {
                                this.ordItemMapper.updateArrivalTimeBatch(updateItemList);
                            }
                        }
                        OrderPO orderPO = new OrderPO();
                        orderPO.setOrderId(ordSalePO.getOrderId());
                        orderPO.setAuditTime(((UacNoInstanceAuditInfo)noneInstanceBO.getAuditInfos().get(0)).getFinishTime());
                        this.orderMapper.updateById(orderPO);
                    }
                } else {
                    pebDealOrderBO.setAuto(Boolean.valueOf(false));
                }
                pebDealOrderBO.setFinish(Boolean.valueOf(true));
                UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
                zmInfoPO.setOrderId(pebDealOrderBO.getOrderId());
                zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
                if (zmInfoPO != null) {
                    pebDealOrderBO.setIsPushErp(zmInfoPO.getIsPushErp());
                    pebDealOrderBO.setPurCompanyId(zmInfoPO.getPurCompanyId());
                }
                pebDealOrderBO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                result.add(pebDealOrderBO);
            } else {
                OrdSalePO salePo = new OrdSalePO();
                salePo.setOrderId(pebDealOrderBO.getOrderId());
                salePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                salePo.setTbOrderId(stepId);
                this.ordSaleMapper.updateById(salePo);
                approvalList.add(pebDealOrderBO);
            }
            rspBO.setOrderApprovalList(result);
            rspBO.setApprovalList(approvalList);
            if ("ACTPEB008".equals(reqBO.getActionCode())) {
                if ("0".equals(reqBO.getAuditResult().toString())) {
                    this.saveAdjustInfo(pebDealOrderBO);
                    this.sendMsg(pebDealOrderBO);
                } else {
                    OrdSaleMtLogPO ordSaleMtLogPo = new OrdSaleMtLogPO();
                    ordSaleMtLogPo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                    ordSaleMtLogPo.setOrderId(pebDealOrderBO.getOrderId());
                    this.ordSaleMtLogMapper.deleteBy(ordSaleMtLogPo);
                    OrdItemWtLogPO logPo = new OrdItemWtLogPO();
                    logPo.setOrderId(pebDealOrderBO.getOrderId());
                    this.ordItemWtLogMapper.deleteBy(logPo);
                }
            }
            this.pushTodoWait(pebDealOrderBO, finish, reqBO, stationMap, rspBO);
        }
    }

    private void saveLog(PebOrderApprovalReqBO reqBO, PebDealOrderBO pebDealOrderBO) {
        UocCoreBusiOperRecordReqBO uocCoreBusiOperRecordReqBO = new UocCoreBusiOperRecordReqBO();
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(reqBO.getActionCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            uocCoreBusiOperRecordReqBO.setDealName(describe);
            uocCoreBusiOperRecordReqBO.setDealTypeName(describe);
            uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            uocCoreBusiOperRecordReqBO.setTaskId(describe);
            uocCoreBusiOperRecordReqBO.setTaskName(describe);
            uocCoreBusiOperRecordReqBO.setDealReason(describe);
        }
        uocCoreBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD);
        uocCoreBusiOperRecordReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocCoreBusiOperRecordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreBusiOperRecordReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocCoreBusiOperRecordReqBO.setCreateTime(new Date());
        uocCoreBusiOperRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        uocCoreBusiOperRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealPostName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealCode(reqBO.getActionCode());
        UocCoreBusiOperRecordRspBO busiOperRecord = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(uocCoreBusiOperRecordReqBO);
        if (!"0000".equals(busiOperRecord.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + busiOperRecord.getRespDesc());
        }
    }

    private void sendMsg(PebDealOrderBO pebDealOrderBO) {
        UocCoreStateConfigRemindAtomReqBO reqBO = new UocCoreStateConfigRemindAtomReqBO();
        reqBO.setOrderId(pebDealOrderBO.getOrderId());
        this.uocCoreStateConfigRemindAtomService.dealStateConfigRemind(reqBO);
    }

    private void saveAdjustInfo(PebDealOrderBO pebDealOrderBO) {
        OrdSaleMtLogPO ordSaleMtLogPO = new OrdSaleMtLogPO();
        ordSaleMtLogPO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
        ordSaleMtLogPO.setOrderId(pebDealOrderBO.getOrderId());
        ordSaleMtLogPO.setIsNew(UocConstant.IS_NEW.NEW);
        ordSaleMtLogPO = this.ordSaleMtLogMapper.getModelBy(ordSaleMtLogPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
        salePO.setOrderId(pebDealOrderBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSalePO updateSale = new OrdSalePO();
        updateSale.setOrderId(salePO.getOrderId());
        updateSale.setSaleVoucherId(salePO.getSaleVoucherId());
        updateSale.setSaleFee(ordSaleMtLogPO.getAdjustSaleFee());
        updateSale.setPurchaseFee(ordSaleMtLogPO.getAdjustPurchaseFee());
        this.ordSaleMapper.updateById(updateSale);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(pebDealOrderBO.getOrderId());
        ordPayPO.setTotalFee(ordSaleMtLogPO.getAdjustSaleFee());
        ordPayPO.setPayFee(ordSaleMtLogPO.getAdjustSaleFee());
        this.ordPayMapper.updateById(ordPayPO);
        this.updateItem(pebDealOrderBO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(salePO.getOrderId());
        orderPO.setTotalSaleFee(ordSaleMtLogPO.getAdjustSaleFee());
        orderPO.setTotalPurchaseFee(ordSaleMtLogPO.getAdjustPurchaseFee());
        this.orderMapper.updateById(orderPO);
    }

    private void updateItem(PebDealOrderBO pebDealOrderBO) {
        OrdItemWtLogPO ordItemWtLogPO = new OrdItemWtLogPO();
        ordItemWtLogPO.setOrderId(pebDealOrderBO.getOrderId());
        List wtLogMapperList = this.ordItemWtLogMapper.getList(ordItemWtLogPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(pebDealOrderBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, itemPO -> itemPO));
        for (OrdItemWtLogPO wtLogPO : wtLogMapperList) {
            OrdItemPO itemPO2 = map.get(wtLogPO.getOrdItemId());
            if (itemPO2 == null) continue;
            OrdItemPO updateItem = new OrdItemPO();
            updateItem.setOrderId(itemPO2.getOrderId());
            updateItem.setOrdItemId(itemPO2.getOrdItemId());
            updateItem.setSalePrice(wtLogPO.getAdjustSalePrice());
            updateItem.setPurchasePrice(wtLogPO.getAdjustPurchasePrice());
            updateItem.setTotalSaleFee(wtLogPO.getAdjustTotalSaleFee());
            updateItem.setTotalPurchaseFee(wtLogPO.getAdjustTotalPurchaseFee());
            updateItem.setMarkUpRate(itemPO2.getMarkUpRate());
            updateItem.setSaleDecimalPrice(wtLogPO.getAfSaleDecimalPrice());
            updateItem.setPurchaseDecimalPrice(wtLogPO.getAfPurchaseDecimalPrice());
            updateItem.setTotalPurchaseDecimalPrice(wtLogPO.getAfTotalPurchaseDecimalPrice());
            updateItem.setTotalSaleDecimalPrice(wtLogPO.getAfTotalSaleDecimalPrice());
            this.ordItemMapper.updateById(updateItem);
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            payItemPO.setTotalFee(wtLogPO.getAdjustTotalSaleFee());
            payItemPO.setOrderId(pebDealOrderBO.getOrderId());
            payItemPO.setSalePrice(wtLogPO.getAdjustSalePrice());
            payItemPO.setPurchasePrice(wtLogPO.getAdjustPurchasePrice());
            payItemPO.setOrdItemId(itemPO2.getOrdItemId());
            payItemPO.setSaleDecimalPrice(wtLogPO.getAfSaleDecimalPrice());
            payItemPO.setPurchaseDecimalPrice(wtLogPO.getAfPurchaseDecimalPrice());
            payItemPO.setTotalPurchaseDecimalPrice(wtLogPO.getAfTotalPurchaseDecimalPrice());
            payItemPO.setTotalSaleDecimalPrice(wtLogPO.getAfTotalSaleDecimalPrice());
            this.ordPayItemMapper.updateById(payItemPO);
        }
    }

    private void saveLog(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO) {
        UocCoreBusiOperRecordRspBO recordRspBO;
        UocCoreBusiOperRecordReqBO uocCoreBusiOperRecordReqBO = new UocCoreBusiOperRecordReqBO();
        uocCoreBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        uocCoreBusiOperRecordReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocCoreBusiOperRecordReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocCoreBusiOperRecordReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOperId())) {
            uocCoreBusiOperRecordReqBO.setDealOperId(reqBO.getOperId());
        } else {
            uocCoreBusiOperRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOperName())) {
            uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getOperName());
        } else {
            uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        }
        uocCoreBusiOperRecordReqBO.setCreateTime(new Date());
        uocCoreBusiOperRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealPostName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealDesc(reqBO.getApprovalRemark());
        uocCoreBusiOperRecordReqBO.setDealCode(reqBO.getActionCode());
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(uocCoreBusiOperRecordReqBO.getDealCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            uocCoreBusiOperRecordReqBO.setDealName(describe);
            uocCoreBusiOperRecordReqBO.setDealTypeName(describe);
            uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            uocCoreBusiOperRecordReqBO.setTaskId(describe);
            uocCoreBusiOperRecordReqBO.setTaskName(describe);
            if (StringUtils.isBlank((CharSequence)reqBO.getApprovalRemark())) {
                uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            }
        }
        if (!(recordRspBO = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(uocCoreBusiOperRecordReqBO)).getRespCode().equals("0000")) {
            throw new UocProBusinessException("102044", "\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private Boolean run(PebDealOrderBO pebDealOrderBO, Integer flag, PebOrderApprovalReqBO reqBO) {
        HashMap<String, Object> variables = new HashMap<String, Object>(1);
        if (reqBO.getActionCode().equals("ACTPEB007")) {
            UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
            historyPO.setAuditTime(new Date());
            historyPO.setOrderId(pebDealOrderBO.getOrderId());
            this.uocOrdHistoryMapper.update(historyPO);
            OrdPayConfPO confPO = new OrdPayConfPO();
            confPO.setOrderId(pebDealOrderBO.getOrderId());
            confPO.setUserType(Integer.valueOf(1));
            List list = this.ordPayConfMapper.selectByCondition(confPO);
            variables.put("payFlag", "1");
            confPO = (OrdPayConfPO)list.get(0);
            if ("2".equals(confPO.getPayType().toString())) {
                variables.put("payFlag", "2");
                UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
                uocProShouldPayOrDeductDealAtomReqBo.setOrderId(pebDealOrderBO.getOrderId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProShouldPayOrDeductDealAtomReqBo.setIsToBePaid(true);
                uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW);
                UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
                if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                    throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
                }
            } else {
                if ("1".equals(confPO.getPayType().toString())) {
                    PayConfDetailPO payConfDetailPO = new PayConfDetailPO();
                    payConfDetailPO.setPayConfId(confPO.getId());
                    List detailPOS = this.payConfDetailMapper.selectByCondition(payConfDetailPO);
                    if (!detailPOS.stream().anyMatch(x -> UocCoreConstant.PayNode.CREATE.equals(x.getPayNode()))) {
                        variables.put("payFlag", "2");
                    }
                }
                UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
                uocProShouldPayOrDeductDealAtomReqBo.setOrderId(pebDealOrderBO.getOrderId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW);
                uocProShouldPayOrDeductDealAtomReqBo.setObjDate(this.orderMapper.getModelById(pebDealOrderBO.getOrderId().longValue()).getCreateTime());
                UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
                if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                    throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
                }
            }
            if (("" + PecConstant.ORDER_SOURCE.ELEC_AREA).equals(pebDealOrderBO.getOrderSource())) {
                variables.put("payFlag", "2");
            }
            pebDealOrderBO.setPushOrderId(pebDealOrderBO.getOrderId());
        } else if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            if (reqBO.getActionCode().equals("ACTPEB008")) {
                variables.put("auditFlag", "2");
            } else {
                variables.put("auditFlag", flag);
            }
        } else {
            variables.put("auditFlag", flag);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(pebDealOrderBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState())) {
            return false;
        }
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            return false;
        }
        UocProcessRunReqBO uocProcessStartReqBO = new UocProcessRunReqBO();
        uocProcessStartReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocProcessStartReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocProcessStartReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocProcessStartReqBO.setOperId(reqBO.getOperId());
        uocProcessStartReqBO.setOperName(reqBO.getOperName());
        this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(variables, pebDealOrderBO.getOrderId());
        uocProcessStartReqBO.setVariables(variables);
        LOGGER.error("\u8ba2\u5355\u5ba1\u6279\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)uocProcessStartReqBO)));
        UocProcessRunRspBO uocProcessStartRspBO = this.uocRunProcessAtomService.start(uocProcessStartReqBO);
        if (!uocProcessStartRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("100001", uocProcessStartRspBO.getRespDesc());
        }
        return uocProcessStartRspBO.getAuto();
    }

    private void reasonForBackFillCancellation(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO) {
        if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(pebDealOrderBO.getOrderSource())) {
                UocProcessRunReqBO uocProcessStartReqBO = new UocProcessRunReqBO();
                uocProcessStartReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProcessStartReqBO.setOrderId(pebDealOrderBO.getOrderId());
                uocProcessStartReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProcessStartReqBO.setOperId(reqBO.getOperId());
                uocProcessStartReqBO.setOperName(reqBO.getOperName());
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("payFlag", "4");
                this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(variables, pebDealOrderBO.getOrderId());
                uocProcessStartReqBO.setVariables(variables);
                UocProcessRunRspBO uocProcessStartRspBO = this.uocRunProcessAtomService.start(uocProcessStartReqBO);
                if (!uocProcessStartRspBO.getRespCode().equals("0000")) {
                    throw new UocProBusinessException("100001", uocProcessStartRspBO.getRespDesc());
                }
            } else {
                UocPebOrderCancellationReqBO cancellationReqBO = new UocPebOrderCancellationReqBO();
                cancellationReqBO.setUserId(reqBO.getUserId());
                cancellationReqBO.setUsername(reqBO.getUsername());
                cancellationReqBO.setDealName(reqBO.getOperName());
                cancellationReqBO.setDealCode(reqBO.getActionCode());
                cancellationReqBO.setCancelDesc("\u8ba2\u5355\u5ba1\u6279\u9a73\u56de");
                cancellationReqBO.setCancelReson("\u8ba2\u5355\u5ba1\u6279\u9a73\u56de");
                cancellationReqBO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                cancellationReqBO.setOrderId(pebDealOrderBO.getOrderId());
                if (reqBO.getUserId() != null) {
                    cancellationReqBO.setCancelOperId(reqBO.getUserId().toString());
                } else {
                    cancellationReqBO.setCancelOperId(reqBO.getOperId());
                }
                cancellationReqBO.setIsVal(false);
                UocPebOrderCancellationRspBO rspBO = this.uocPebOrderCancellationBusiService.dealPebOrderCancellation(cancellationReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException("102044", rspBO.getRespDesc());
                }
            }
            OrdSalePO ordSalePo = new OrdSalePO();
            ordSalePo.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePo.setExt3("\u5ba1\u6279\u62d2\u7edd");
            this.ordSaleMapper.updateById(ordSalePo);
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setOrderId(pebDealOrderBO.getOrderId());
            extMapPO.setObjId(pebDealOrderBO.getOrderId());
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO.setFieldCode("contractFee");
            OrdExtMapPO qry = this.ordExtMapMapper.getModelBy(extMapPO);
            if (qry != null && PebExtConstant.YES.toString().equals(qry.getFieldValue())) {
                OrdAgreementPO agreementPO = new OrdAgreementPO();
                agreementPO.setOrderId(pebDealOrderBO.getOrderId());
                agreementPO = (OrdAgreementPO)this.ordAgreementMapper.selectByCondition(agreementPO).get(0);
                ContractOrderedAmountSynAbilityReqBO abilityReqBO = new ContractOrderedAmountSynAbilityReqBO();
                BigDecimal fee = BigDecimal.ZERO;
                if (PebExtConstant.YES.equals(agreementPO.getAssignStatus())) {
                    abilityReqBO.setOrderAmount(MoneyUtil.l4B((Long)pebDealOrderBO.getSaleFee()));
                } else {
                    OrdItemPO ordItemPo = new OrdItemPO();
                    ordItemPo.setOrderId(pebDealOrderBO.getOrderId());
                    List ordItemList = this.ordItemMapper.getList(ordItemPo);
                    for (OrdItemPO itemPO : ordItemList) {
                        try {
                            BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f + "");
                            BigDecimal djs = MoneyUtil.l4B((Long)itemPO.getTotalSaleFee());
                            BigDecimal taxA = price.add(BigDecimal.ONE);
                            BigDecimal bud = djs.multiply(price).divide(taxA, 2, 4);
                            fee = fee.add(djs.subtract(bud));
                        }
                        catch (Exception exception) {}
                    }
                    abilityReqBO.setOrderAmount(fee);
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(Long.valueOf(agreementPO.getAgreementId()));
                abilityReqBO.setContractIds(ids);
                abilityReqBO.setOperType("1");
                ContractOrderedAmountSynAbilityRspBO rspBO = this.contractOrderedAmountSynAbilityService.orderedAmountSyn(abilityReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
                }
                extMapPO.setId(qry.getId());
                extMapPO.setFieldValue(PebExtConstant.NO.toString());
                this.ordExtMapMapper.updateById(extMapPO);
            }
        } else {
            OrdSalePO ordSalePo = new OrdSalePO();
            ordSalePo.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePo.setExt3("\u5ba1\u6279\u901a\u8fc7");
            this.ordSaleMapper.updateById(ordSalePo);
        }
    }

    private void pushTodoWait(PebDealOrderBO orderBO, Boolean finsh, PebOrderApprovalReqBO reqBO, Map<Long, String> stationMap, PebOrderApprovalRspBO rspBO) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(orderBO.getOrderId());
            uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
            uocTodoBO.setOperatorId(reqBO.getUserId() + "");
            uocTodoBO.setOperatorNo(reqBO.getUsername());
            uocTodoBO.setOperatorName(reqBO.getName());
            uocTodoBO.setOrgId(reqBO.getOrgId());
            uocTodoBO.setFinishTime(new Date());
            uocTodoBO.setFinishYn(finsh);
            uocTodoBO.setAuditRemark(reqBO.getApprovalRemark());
            uocTodoBO.setAuditStatus("0".equals(reqBO.getAuditResult().toString()));
            uocTodoBO.setStationId(stationMap.get(orderBO.getSaleVoucherId()));
            if ("ACTPEB008".equals(reqBO.getActionCode())) {
                uocTodoBO.setBusiCode(TodoWaitTypeEnum.ADJUST_TYPE.getCode());
            }
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            LOGGER.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            rspBO.getPushTodoList().add(JSON.parseObject((String)JSON.toJSONString((Object)uocTodoBO), PebTodoPushWaitBO.class));
        }
        catch (Exception e) {
            LOGGER.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }
}

